/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Action;
import com.bmc.arsys.api.ActiveLink;
import com.bmc.arsys.api.ActiveLinkCriteria;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.AlertMessageInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.Association;
import com.bmc.arsys.api.AssociationCriteria;
import com.bmc.arsys.api.BulkEntryReturn;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerCriteria;
import com.bmc.arsys.api.ContainerListInfo;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.EntryPointInfo;
import com.bmc.arsys.api.Escalation;
import com.bmc.arsys.api.EscalationCriteria;
import com.bmc.arsys.api.ExtFieldCandidatesInfo;
import com.bmc.arsys.api.ExtFormCandidatesInfo;
import com.bmc.arsys.api.ExtendedClassRegistry;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldCriteria;
import com.bmc.arsys.api.Filter;
import com.bmc.arsys.api.FilterCriteria;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormAliasInfo;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.GroupInfo;
import com.bmc.arsys.api.LicenseInfo;
import com.bmc.arsys.api.LicenseValidInfo;
import com.bmc.arsys.api.LocalizedRequestInfo;
import com.bmc.arsys.api.LocalizedValueCriteria;
import com.bmc.arsys.api.LocalizedValueInfo;
import com.bmc.arsys.api.LoggingInfo;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuCriteria;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.NativeLibraryLoader;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.ProcessResult;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RoleInfo;
import com.bmc.arsys.api.SQLResult;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SignalType;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.SupportFile;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.UserInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewCriteria;
import com.bmc.arsys.api.WorkflowLockInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.apitransport.ApiProxyBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.ApiValueBase;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Proxy
extends ApiProxyBase {
    private long m_sessionId;
    private long m_lastUsedTime;
    private boolean scbInitialized = false;
    private static Logger logger = Logger.getLogger(Proxy.class);
    private static volatile boolean nativeLibraryExists = false;
    private static volatile boolean nativeLibraryIsLoading = false;
    private static final int JNI_LOAD_MODE_NOLOAD = 0;
    private static final int JNI_LOAD_MODE_LAZY = 1;
    protected static final int JNI_LOAD_MODE_MANDATORY = 2;
    private static String apiSourceId = null;

    private static synchronized void ensureNativeLibraryLoaded() {
        if (nativeLibraryIsLoading) {
            return;
        }
        boolean jrpcMode = Config.getInstance().getJrpcMode();
        int jniLoadMode = Config.getInstance().getJniLoadMode();
        if (jrpcMode && jniLoadMode == 0) {
            return;
        }
        if (!nativeLibraryExists) {
            String lib = "arjni90_build002" + Proxy.shl_plat();
            nativeLibraryIsLoading = true;
            nativeLibraryExists = NativeLibraryLoader.load(Proxy.class, lib);
        }
    }

    public static void IsNativeMethodAccessible() {
        Proxy proxy = new Proxy(true);
        proxy.getSessionId();
    }

    protected Proxy() {
        this(false);
    }

    public Proxy(boolean isLegacyServer) {
        boolean jrpcMode = Config.getInstance().getJrpcMode();
        int jniLoadMode = Config.getInstance().getJniLoadMode();
        if (!jrpcMode || jniLoadMode == 2 || jniLoadMode == 1 && isLegacyServer) {
            try {
                Proxy.ensureNativeLibraryLoaded();
                logger.debug("called native ARInitialization");
                this.ARInitialization();
            }
            catch (ARException err) {
                logger.error("Could not load the native library.", err);
            }
        }
        this.m_lastUsedTime = 0L;
    }

    @Override
    public void setProxyProperties(ApiUserContextI context) throws ARException {
        if (context == null) {
            return;
        }
        this.ARSetSessionConfiguration(context, 1, new ApiValueBase(context.getChunkResponseSize()));
        this.ARSetSessionConfiguration(context, 2, new ApiValueBase(context.getTimeoutNormal()));
        this.ARSetSessionConfiguration(context, 3, new ApiValueBase(context.getTimeoutLong()));
        this.ARSetSessionConfiguration(context, 4, new ApiValueBase(context.getTimeoutXLong()));
        this.ARSetSessionConfiguration(context, 5, new ApiValueBase((long)context.getServerRpcQueueNumber()));
        this.ARSetSessionConfiguration(context, 7, new ApiValueBase(context.getClientType()));
        this.ARSetSessionConfiguration(context, 8, new ApiValueBase(context.getVUIType()));
        this.ARSetSessionConfiguration(context, 9, new ApiValueBase(context.getOverridePrevIP() ? 1 : 0));
        this.ARSetSessionConfiguration(context, 1960, new ApiValueBase(context.getReservedParam1() != null ? context.getReservedParam1() : this.ARInitApiSourceGuid(context)));
        if (context.getPort() != 0 || context.getServerRpcQueueNumber() != 0) {
            this.ARSetServerPort(context, context.getPort(), context.getServerRpcQueueNumber());
        }
        this.ARSetLogging(context, (Object)context.getLogging());
    }

    @Override
    protected long getSessionId() {
        return this.m_sessionId;
    }

    @Override
    protected void setSessionId(long sessionId) {
        this.m_sessionId = sessionId;
    }

    protected void setLastUsedTime(long tm) {
        this.m_lastUsedTime = tm;
    }

    protected long getLastUsedTime() {
        return this.m_lastUsedTime;
    }

    protected void releaseARServerUser(ARServerUser ctx) throws ARException {
        if (nativeLibraryExists && ctx != null) {
            logger.debug("called native ARTermination");
            this.ARTermination(ctx);
        }
    }

    protected String ARCreateEntry(ARServerUser ctx, String formName, Entry entry) throws ARException {
        Object[] in = new Object[]{"ARCreateEntry", ctx, formName, ARTypeMgr.getInstance().ObjectToVariant(entry, ctx)};
        Object[] out = this.invokeNativeCall(in);
        String entryId = ConversionUtil.getStringValue(out[5]);
        entry.setEntryId(entryId);
        return entryId;
    }

    protected Entry ARGetEntry(ARServerUser ctx, String formName, String entryId, int[] entryListFields) throws ARException {
        Object[] in = new Object[]{"ARGetEntry", ctx, formName, Entry.splitEntryId(entryId), entryListFields};
        Object[] out = this.invokeNativeCall(in);
        Entry object = ARTypeMgr.getInstance().ObjectFromVariant(Entry.class, out[6], ctx);
        object.setEntryId(entryId);
        return object;
    }

    protected List<EntryListInfo> ARGetListEntry(ARServerUser ctx, String formName, QualifierInfo qualification, int firstRetrieve, int maxRetrieve, List<EntryListFieldInfo> entryListFields, List<SortInfo> sortList, boolean useLocale, OutputInteger nMatches) throws ARException {
        Object[] in = new Object[]{"ARGetListEntry", ctx, formName, ARTypeMgr.getInstance().ObjectToVariant(qualification, ctx), ARTypeMgr.getInstance().ObjectToVariant(entryListFields, ctx), ARTypeMgr.getInstance().ObjectToVariant(sortList, ctx), firstRetrieve, maxRetrieve, useLocale};
        Object[] out = this.invokeNativeCall(in);
        if (nMatches != null) {
            nMatches.setValue(ConversionUtil.getIntValue(out[11]));
        }
        return ARTypeMgr.getInstance().ObjectListFromVariant(EntryListInfo.class, out[10], ctx);
    }

    protected List<Entry> ARGetMultipleEntries(ARServerUser ctx, String formName, List<String> entryIds, int[] entryListFields) throws ARException {
        Object[] splitEntryIds = new Object[entryIds.size()];
        int i = 0;
        for (String entryId : entryIds) {
            splitEntryIds[i++] = Entry.splitEntryId(entryId);
        }
        Object[] in = new Object[]{"ARGetMultipleEntries", ctx, formName, splitEntryIds, entryListFields};
        Object[] out = this.invokeNativeCall(in);
        List<Entry> entryList = Entry.buildGMEResponse(out, entryIds, ctx);
        return entryList;
    }

    protected List<Entry> ARGetListEntryWithFields(ARServerUser ctx, String formName, QualifierInfo qualification, int firstRetrieve, int maxRetrieve, List<SortInfo> sortList, int[] fieldIds, boolean useLocale, OutputInteger nMatches) throws ARException {
        ArrayList<EntryListFieldInfo> entryListFields = new ArrayList<EntryListFieldInfo>();
        if (fieldIds != null && fieldIds.length > 0) {
            for (int fieldId : fieldIds) {
                entryListFields.add(new EntryListFieldInfo(fieldId));
            }
        }
        Object[] in = new Object[]{"ARGetListEntryWithFields", ctx, formName, ARTypeMgr.getInstance().ObjectToVariant(qualification, ctx), ARTypeMgr.getInstance().ObjectToVariant(entryListFields, ctx), ARTypeMgr.getInstance().ObjectToVariant(sortList, ctx), firstRetrieve, maxRetrieve, useLocale};
        Object[] out = this.invokeNativeCall(in);
        if (nMatches != null) {
            nMatches.setValue(ConversionUtil.getIntValue(out[11]));
        }
        List<Entry> entryList = ARTypeMgr.buildGLEWFResponse((Object[])out[10], ctx);
        return entryList;
    }

    protected int ARGetListEntryBlocks(ARServerUser ctx, String formName, QualifierInfo qualification, int numEntriesPerBlock, int firstRetrieve, int maxRetrieve, List<SortInfo> sortList, int[] fieldIds, boolean useLocale, OutputInteger numReturnedBlocks, OutputInteger numReturnedRows, OutputInteger numTotalMatches) throws ARException {
        ArrayList<EntryListFieldInfo> entryListFields = new ArrayList<EntryListFieldInfo>();
        if (fieldIds != null && fieldIds.length > 0) {
            for (int fieldId : fieldIds) {
                entryListFields.add(new EntryListFieldInfo(fieldId));
            }
        }
        Object[] in = new Object[]{"ARGetListEntryBlocks", ctx, formName, ARTypeMgr.getInstance().ObjectToVariant(qualification, ctx), ARTypeMgr.getInstance().ObjectToVariant(entryListFields, ctx), ARTypeMgr.getInstance().ObjectToVariant(sortList, ctx), numEntriesPerBlock, firstRetrieve, maxRetrieve, useLocale};
        Object[] out = this.invokeNativeCall(in);
        numReturnedRows.setValue(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)out, 12)));
        if (numTotalMatches != null) {
            numTotalMatches.setValue(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)out, 13)));
        }
        numReturnedBlocks.setValue(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)out, 14)));
        return ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)out, 11));
    }

    protected List<Entry> ARGetEntryBlock(ARServerUser ctx, int handle, int blockNumber) throws ARException {
        Object[] in = new Object[]{"ARGetEntryBlock", ctx, handle, blockNumber};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.buildGLEWFResponse((Object[])out[5], null);
    }

    protected void ARFreeEntryBlock(ARServerUser ctx, int handle) throws ARException {
        Object[] in = new Object[]{"ARFreeEntryBlock", ctx, handle};
        this.invokeNativeCall(in);
    }

    protected void ARDeleteEntry(ARServerUser ctx, String formName, String entryId, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteEntry", ctx, formName, Entry.splitEntryId(entryId), deleteOption};
        this.invokeNativeCall(in);
    }

    protected void ARSetEntry(ARServerUser ctx, String formName, String entryId, Entry entry, Timestamp ts, int option) throws ARException {
        Object[] in = new Object[]{"ARSetEntry", ctx, formName, Entry.splitEntryId(entryId != null ? entryId : entry.getEntryId()), ARTypeMgr.getInstance().ObjectToVariant(entry, ctx), ConversionUtil.getARTimestamp(ts), option};
        this.invokeNativeCall(in);
    }

    protected Entry ARSetGetEntry(ARServerUser ctx, String formName, String entryId, Entry entry, Timestamp ts, int option, int[] entryListFields) throws ARException {
        Object[] in = new Object[]{"ARSetGetEntry", ctx, formName, Entry.splitEntryId(entryId != null ? entryId : entry.getEntryId()), ARTypeMgr.getInstance().ObjectToVariant(entry, ctx), ConversionUtil.getARTimestamp(ts), option, entryListFields};
        Object[] out = this.invokeNativeCall(in);
        Entry object = ARTypeMgr.getInstance().ObjectFromVariant(Entry.class, out[6], ctx);
        object.setEntryId(entryId);
        return object;
    }

    protected Entry ARServiceEntry(ARServerUser ctx, String formName, String entryId, Entry entry, int[] entryListFields) throws ARException {
        Object[] in = new Object[]{"ARServiceEntry", ctx, formName, Entry.splitEntryId(entryId != null ? entryId : (entry != null ? entry.getEntryId() : null)), ARTypeMgr.getInstance().ObjectToVariant(entry, ctx), entryListFields};
        Object[] out = this.invokeNativeCall(in);
        Entry object = ARTypeMgr.getInstance().ObjectFromVariant(Entry.class, out[7], ctx);
        return object;
    }

    protected String ARXMLServiceEntry(ARServerUser ctx, String queryMapping, String queryDoc, String inputMapping, String inputDoc, String outputMapping, String optionDoc) throws ARException {
        Object[] in = new Object[]{"ARXMLServiceEntry", ctx, queryMapping, queryDoc, inputMapping, inputDoc, outputMapping, optionDoc};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[9]);
    }

    protected String ARMergeEntry(ARServerUser ctx, String formName, Entry entry, int mergeType) throws ARException {
        Object[] in = new Object[]{"ARMergeEntry", ctx, formName, ARTypeMgr.getInstance().ObjectToVariant(entry, ctx), mergeType};
        this.invokeNativeCall(in);
        return entry.getEntryId();
    }

    protected void ARCreateForm(ARServerUser ctx, Form object) throws ARException {
        ctx.setCurrentOp("ARCreateSchema");
        Object[] in = (Object[])object.toVariant(ctx);
        this.invokeNativeCall(in);
    }

    protected Form ARGetForm(ARServerUser ctx, String name, FormCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetSchema", ctx, criteria == null ? FormCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), name};
        Object[] out = this.invokeNativeCall(in);
        Form object = Form.createInstance(out, ctx);
        return object;
    }

    protected void ARSetForm(ARServerUser ctx, Form object) throws ARException {
        ctx.setCurrentOp("ARSetSchema");
        Object[] in = (Object[])object.toVariant(ctx);
        this.invokeNativeCall(in);
    }

    protected List<FormAliasInfo> ARGetListFormWithAlias(ARServerUser ctx, long changedSince, int formType, String formName, int[] fieldIds, String vuiLabel) throws ARException {
        Object[] in = new Object[]{"ARGetListSchemaWithAlias", ctx, changedSince, formType, formName, fieldIds, vuiLabel, null};
        Object[] out = this.invokeNativeCall(in);
        List<FormAliasInfo> objList = FormAliasInfo.buildGLSWAResponse((Object[])out[9], (Object[])out[10]);
        return objList;
    }

    protected List<String> ARGetListForm(ARServerUser ctx, long changedSince, int formType, String formName, int[] fieldIds, ObjectPropertyMap propsToSearch) throws ARException {
        Object[] in = new Object[]{"ARGetListSchema", ctx, changedSince, formType, formName, fieldIds, ARTypeMgr.getInstance().ObjectToVariant(propsToSearch, ctx)};
        Object[] out = this.invokeNativeCall(in);
        ArrayList<String> objList = ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[8], ctx);
        return objList;
    }

    protected List<Form> ARGetListFormObjects(ARServerUser ctx, long changedSince, int formType, String formName, int[] fieldIds, FormCriteria criteria) throws ARException {
        List<String> names = this.ARGetListForm(ctx, changedSince, formType, formName, fieldIds, null);
        ArrayList<Form> objs = new ArrayList<Form>(names.size());
        for (String name : names) {
            Form obj = this.ARGetForm(ctx, name, criteria);
            objs.add(obj);
        }
        return objs;
    }

    protected void ARDeleteForm(ARServerUser ctx, String name, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteSchema", ctx, name, deleteOption};
        this.invokeNativeCall(in);
    }

    protected int ARCreateField(ARServerUser ctx, Field object, boolean isReservedRangeIdOK) throws ARException {
        Object object2;
        Object object3;
        Object varDispInstances = ARTypeMgr.getInstance().ObjectToVariant(object.getDisplayInstance(), ctx);
        Object[] objectArray = new Object[18];
        objectArray[0] = "ARCreateField";
        objectArray[1] = ctx;
        objectArray[2] = object.getForm();
        objectArray[3] = object.getFieldID();
        objectArray[4] = isReservedRangeIdOK;
        objectArray[5] = object.getName();
        if (object.getFieldMap() == null) {
            Object[] objectArray2 = new Object[1];
            object3 = objectArray2;
            objectArray2[0] = 0;
        } else {
            object3 = ARTypeMgr.getInstance().ObjectToVariant(object.getFieldMap(), ctx);
        }
        objectArray[6] = object3;
        objectArray[7] = object.getDataType();
        objectArray[8] = object.getFieldOption();
        objectArray[9] = object.getCreateMode();
        objectArray[10] = object.getAuditOption();
        objectArray[11] = ARTypeMgr.getInstance().ObjectToVariant(object.getDefaultValue(), ctx);
        objectArray[12] = ARTypeMgr.getInstance().ObjectToVariant(object.getPermissions(), ctx);
        if (object.getFieldLimit() == null) {
            Object[] objectArray3 = new Object[1];
            object2 = objectArray3;
            objectArray3[0] = 0;
        } else {
            object2 = ARTypeMgr.getInstance().ObjectToVariant(object.getFieldLimit(), ctx);
        }
        objectArray[13] = object2;
        objectArray[14] = new Object[]{varDispInstances};
        objectArray[15] = object.getHelpText();
        objectArray[16] = object.getOwner();
        objectArray[17] = object.getDiary().getAppendedText();
        Object[] in = objectArray;
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getIntValue(out[4]);
    }

    protected void ARSetField(ARServerUser ctx, Field object) throws ARException {
        Object object2;
        Object object3;
        Object varDispInstances = ARTypeMgr.getInstance().ObjectToVariant(object.getDisplayInstance(), ctx);
        Object[] objectArray = new Object[17];
        objectArray[0] = "ARSetField";
        objectArray[1] = ctx;
        objectArray[2] = object.getChangeFlags().getPropertiesToRetrieve();
        objectArray[3] = object.getForm();
        objectArray[4] = object.getFieldID();
        objectArray[5] = object.getNewName();
        if (object.getFieldMap() == null) {
            Object[] objectArray2 = new Object[1];
            object3 = objectArray2;
            objectArray2[0] = 0;
        } else {
            object3 = ARTypeMgr.getInstance().ObjectToVariant(object.getFieldMap(), ctx);
        }
        objectArray[6] = object3;
        objectArray[7] = object.getFieldOption();
        objectArray[8] = object.getCreateMode();
        objectArray[9] = object.getAuditOption();
        objectArray[10] = ARTypeMgr.getInstance().ObjectToVariant(object.getDefaultValue(), ctx);
        objectArray[11] = ARTypeMgr.getInstance().ObjectToVariant(object.getPermissions(), ctx);
        if (object.getFieldLimit() == null) {
            Object[] objectArray3 = new Object[1];
            object2 = objectArray3;
            objectArray3[0] = 0;
        } else {
            object2 = ARTypeMgr.getInstance().ObjectToVariant(object.getFieldLimit(), ctx);
        }
        objectArray[12] = object2;
        objectArray[13] = new Object[]{varDispInstances};
        objectArray[14] = object.getHelpText();
        objectArray[15] = object.getOwner();
        objectArray[16] = object.getDiary().getAppendedText();
        Object[] in = objectArray;
        this.invokeNativeCall(in);
    }

    protected List<Integer> ARCreateMultipleFields(ARServerUser ctx, List<Field> fields) throws ARException {
        if (fields == null || fields.size() <= 0) {
            return null;
        }
        int count = fields.size();
        ArrayList<Integer> fieldIds = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            int fieldId = this.ARCreateField(ctx, fields.get(i), true);
            fieldIds.add(fieldId);
        }
        return fieldIds;
    }

    protected void ARSetMultipleFields(ARServerUser ctx, List<Field> fields) throws ARException {
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                this.ARSetField(ctx, fields.get(i));
            }
        }
    }

    protected List<Integer> ARGetListField(ARServerUser ctx, String formName, int fieldTypeMask, long changedSince) throws ARException {
        Object[] in = new Object[]{"ARGetListField", ctx, formName, fieldTypeMask, changedSince};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, out[6], ctx);
    }

    protected Field ARGetField(ARServerUser ctx, String form, int fieldId, FieldCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetField", ctx, criteria == null ? FieldCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), form, fieldId};
        Object[] out = this.invokeNativeCall(in);
        Field object = Field.createInstance(out, ctx);
        return object;
    }

    protected List<Field> ARGetListFieldObjects(ARServerUser ctx, String formName, int fieldTypeMask, long changedSince, FieldCriteria criteria) throws ARException {
        List<Integer> fieldIds = this.ARGetListField(ctx, formName, fieldTypeMask, changedSince);
        if (fieldIds != null && fieldIds.size() > 0) {
            int[] ids = new int[fieldIds.size()];
            int i = 0;
            for (Integer id : fieldIds) {
                ids[i++] = id;
            }
            return this.ARGetMultipleFields(ctx, formName, ids, criteria);
        }
        return new ArrayList<Field>();
    }

    protected List<Field> ARGetMultipleFields(ARServerUser ctx, String formName, int[] fieldIds, FieldCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleFields", ctx, criteria == null ? FieldCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), formName, fieldIds};
        Object[] out = this.invokeNativeCall(in);
        List<Field> objs = Field.buildGMFResponse(out, ctx);
        return objs;
    }

    protected void ARDeleteField(ARServerUser ctx, String form, int fieldId, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteField", ctx, form, fieldId, deleteOption};
        this.invokeNativeCall(in);
    }

    protected void ARDeleteMultipleFields(ARServerUser ctx, String form, int[] ids, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteMultipleFields", ctx, form, ids, deleteOption};
        this.invokeNativeCall(in);
    }

    protected void ARCreateFilter(ARServerUser ctx, Filter object) throws ARException {
        Object[] varFormList = new Object[]{1, ARTypeMgr.getInstance().ObjectListToVariant(object.getFormList(), ctx)};
        Object varQualifier = ARTypeMgr.getInstance().ObjectToVariant(object.getQualifier(), ctx);
        Object varIfList = Action.ConvertActionListToVariant(object.getActionList(), false, ctx);
        Object varElseList = Action.ConvertActionListToVariant(object.getElseList(), false, ctx);
        String varChangeDiary = object.getDiary().getAppendedText();
        Object varProperties = ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx);
        Object[] in = new Object[]{"ARCreateFilter", ctx, object.getName(), new Integer(object.getOrder()), varFormList, new Integer(object.getOpSet()), object.isEnable() ? 1 : 0, varQualifier, varIfList, varElseList, object.getHelpText(), object.getOwner(), varChangeDiary, varProperties, object.getErrorFilterOptions(), object.getErrorHandlingFilter()};
        this.invokeNativeCall(in);
    }

    protected Filter ARGetFilter(ARServerUser ctx, String key, FilterCriteria criteria, Filter object) throws ARException {
        Object[] in = new Object[]{"ARGetFilter", ctx, criteria == null ? FilterCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), key};
        Object[] out = this.invokeNativeCall(in);
        if (object == null) {
            object = ExtendedClassRegistry.newInstance(ctx == null ? null : ctx.getExtendedClassRegistry(), Filter.class);
        }
        object.fromVariant(out, ctx);
        return object;
    }

    protected void ARSetFilter(ARServerUser ctx, Filter object) throws ARException {
        Object[] varFormList = new Object[]{1, ARTypeMgr.getInstance().ObjectListToVariant(object.getFormList(), ctx)};
        Object varQualifier = ARTypeMgr.getInstance().ObjectToVariant(object.getQualifier(), ctx);
        Object varIfList = Action.ConvertActionListToVariant(object.getActionList(), true, ctx);
        Object varElseList = Action.ConvertActionListToVariant(object.getElseList(), true, ctx);
        String varChangeDiary = object.getDiary().getAppendedText();
        Object varProperties = ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx);
        Object[] in = new Object[]{"ARSetFilter", ctx, new Integer(object.getChangeFlags().getPropertiesToRetrieve()), object.getName(), object.getNewName(), new Integer(object.getOrder()), varFormList, new Integer(object.getOpSet()), object.isEnable() ? 1 : 0, varQualifier, varIfList, varElseList, object.getHelpText(), object.getOwner(), varChangeDiary, varProperties, object.getErrorFilterOptions(), object.getErrorHandlingFilter()};
        this.invokeNativeCall(in);
    }

    protected List<String> ARGetListFilter(ARServerUser ctx, String formName, long changedSince, ObjectPropertyMap propsToSearch) throws ARException {
        Object[] in = new Object[]{"ARGetListFilter", ctx, formName, changedSince, ARTypeMgr.getInstance().ObjectToVariant(propsToSearch, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[6], ctx);
    }

    protected List<Filter> ARGetListFilterObjects(ARServerUser ctx, String formName, long changedSince, FilterCriteria criteria) throws ARException {
        List<String> names = this.ARGetListFilter(ctx, formName, changedSince, null);
        ArrayList<Filter> objs = new ArrayList<Filter>(names.size());
        for (String name : names) {
            Filter obj = ExtendedClassRegistry.newInstance(ctx == null ? null : ctx.getExtendedClassRegistry(), Filter.class);
            this.ARGetFilter(ctx, name, criteria, obj);
            objs.add(obj);
        }
        return objs;
    }

    protected List<Filter> ARGetMultipleFilters(ARServerUser ctx, long changedSince, List<String> names, FilterCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleFilters", ctx, changedSince, ARTypeMgr.getInstance().ObjectToVariant(names, ctx)};
        Object[] out = this.invokeNativeCall(in);
        List<Filter> objs = Filter.buildGMFResponse(out, ctx);
        return objs;
    }

    protected void ARDeleteFilter(ARServerUser ctx, String name, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteFilter", ctx, name, deleteOption};
        this.invokeNativeCall(in);
    }

    protected void ARCreateEscalation(ARServerUser ctx, Escalation object) throws ARException {
        Object varTime = ARTypeMgr.getInstance().ObjectToVariant(object.getEscalationTm(), ctx);
        Object[] varFormList = new Object[]{1, ARTypeMgr.getInstance().ObjectListToVariant(object.getFormList(), ctx)};
        Object varQualifier = ARTypeMgr.getInstance().ObjectToVariant(object.getQualifier(), ctx);
        Object varIfList = Action.ConvertActionListToVariant(object.getActionList(), false, ctx);
        Object varElseList = Action.ConvertActionListToVariant(object.getElseList(), false, ctx);
        String varChangeDiary = object.getDiary().getAppendedText();
        Object varProperties = ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx);
        Object[] in = new Object[]{"ARCreateEscalation", ctx, object.getName(), varTime, varFormList, object.isEnable() ? 1 : 0, varQualifier, varIfList, varElseList, object.getHelpText(), object.getOwner(), varChangeDiary, varProperties};
        this.invokeNativeCall(in);
    }

    protected Escalation ARGetEscalation(ARServerUser ctx, String key, EscalationCriteria criteria, Escalation object) throws ARException {
        Object[] in = new Object[]{"ARGetEscalation", ctx, criteria == null ? EscalationCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), key};
        Object[] out = this.invokeNativeCall(in);
        if (object == null) {
            object = ExtendedClassRegistry.newInstance(ctx == null ? null : ctx.getExtendedClassRegistry(), Escalation.class);
        }
        object.fromVariant(out, ctx);
        return object;
    }

    protected void ARSetEscalation(ARServerUser ctx, Escalation object) throws ARException {
        Object varTime = ARTypeMgr.getInstance().ObjectToVariant(object.getEscalationTm(), ctx);
        Object[] varFormList = new Object[]{1, ARTypeMgr.getInstance().ObjectListToVariant(object.getFormList(), ctx)};
        Object varQualifier = ARTypeMgr.getInstance().ObjectToVariant(object.getQualifier(), ctx);
        Object varIfList = Action.ConvertActionListToVariant(object.getActionList(), true, ctx);
        Object varElseList = Action.ConvertActionListToVariant(object.getElseList(), true, ctx);
        String varChangeDiary = object.getDiary().getAppendedText();
        Object varProperties = ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx);
        Object[] in = new Object[]{"ARSetEscalation", ctx, new Integer(object.getChangeFlags().getPropertiesToRetrieve()), object.getName(), object.getNewName(), varTime, varFormList, object.isEnable() ? 1 : 0, varQualifier, varIfList, varElseList, object.getHelpText(), object.getOwner(), varChangeDiary, varProperties};
        this.invokeNativeCall(in);
    }

    protected List<String> ARGetListEscalation(ARServerUser ctx, String formName, long changedSince, ObjectPropertyMap propsToSearch) throws ARException {
        Object[] in = new Object[]{"ARGetListEscalation", ctx, formName, changedSince, ARTypeMgr.getInstance().ObjectToVariant(propsToSearch, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[6], ctx);
    }

    protected List<Escalation> ARGetListEscalationObjects(ARServerUser ctx, String formName, long changedSince, EscalationCriteria criteria) throws ARException {
        List<String> names = this.ARGetListEscalation(ctx, formName, changedSince, null);
        ArrayList<Escalation> objs = new ArrayList<Escalation>(names.size());
        for (String name : names) {
            Escalation obj = ExtendedClassRegistry.newInstance(ctx == null ? null : ctx.getExtendedClassRegistry(), Escalation.class);
            this.ARGetEscalation(ctx, name, criteria, obj);
            objs.add(obj);
        }
        return objs;
    }

    protected List<Escalation> ARGetMultipleEscalations(ARServerUser ctx, long changedSince, List<String> names, EscalationCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleEscalations", ctx, changedSince, ARTypeMgr.getInstance().ObjectToVariant(names, ctx)};
        Object[] out = this.invokeNativeCall(in);
        List<Escalation> objs = Escalation.buildGMESResponse(out, ctx);
        return objs;
    }

    protected void ARDeleteEscalation(ARServerUser ctx, String name, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteEscalation", ctx, name, deleteOption};
        this.invokeNativeCall(in);
    }

    protected void ARCreateActiveLink(ARServerUser ctx, ActiveLink object) throws ARException {
        Object[] varFormList = new Object[]{1, ARTypeMgr.getInstance().ObjectListToVariant(object.getFormList(), ctx)};
        Object varPermissions = ARTypeMgr.getInstance().ObjectToVariant(object.getGroupList(), ctx);
        Object var10 = ARTypeMgr.getInstance().ObjectToVariant(object.getQualifier(), ctx);
        Object var11 = Action.ConvertActionListToVariant(object.getActionList(), true, ctx);
        Object var12 = Action.ConvertActionListToVariant(object.getElseList(), true, ctx);
        String var15 = object.getDiary().getAppendedText();
        Object var16 = ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx);
        Object[] in = new Object[]{"ARCreateActiveLink", ctx, object.getName(), new Integer(object.getOrder()), varFormList, varPermissions, new Integer(object.getExecuteMask()), new Integer(object.getControlField()), new Integer(object.getFocusField()), object.isEnable() ? 1 : 0, var10, var11, var12, object.getHelpText(), object.getOwner(), var15, var16, object.getErrorActlinkOptions(), object.getErrorActlinkName()};
        this.invokeNativeCall(in);
    }

    protected ActiveLink ARGetActiveLink(ARServerUser ctx, String key, ActiveLinkCriteria criteria, ActiveLink object) throws ARException {
        Object[] in = new Object[]{"ARGetActiveLink", ctx, criteria == null ? ActiveLinkCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), key};
        Object[] out = this.invokeNativeCall(in);
        if (object == null) {
            object = ExtendedClassRegistry.newInstance(ctx == null ? null : ctx.getExtendedClassRegistry(), ActiveLink.class);
        }
        object.fromVariant(out, ctx);
        return object;
    }

    protected void ARSetActiveLink(ARServerUser ctx, ActiveLink object) throws ARException {
        Object[] varFormList = new Object[]{1, ARTypeMgr.getInstance().ObjectListToVariant(object.getFormList(), ctx)};
        Object varPermissions = ARTypeMgr.getInstance().ObjectToVariant(object.getGroupList(), ctx);
        Object var10 = ARTypeMgr.getInstance().ObjectToVariant(object.getQualifier(), ctx);
        Object var11 = Action.ConvertActionListToVariant(object.getActionList(), true, ctx);
        Object var12 = Action.ConvertActionListToVariant(object.getElseList(), true, ctx);
        String var15 = (object.getChangeFlags().getPropertiesToRetrieve() & ActiveLinkCriteria.CHANGE_DIARY) == 0 ? object.getDiary().getAppendedText() : null;
        Object var16 = ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx);
        Object[] in = new Object[]{"ARSetActiveLink", ctx, new Integer(object.getChangeFlags().getPropertiesToRetrieve()), object.getName(), object.getNewName(), new Integer(object.getOrder()), varFormList, varPermissions, new Integer(object.getExecuteMask()), new Integer(object.getControlField()), new Integer(object.getFocusField()), object.isEnable() ? 1 : 0, var10, var11, var12, object.getHelpText(), object.getOwner(), var15, var16, object.getErrorActlinkOptions(), object.getErrorActlinkName()};
        this.invokeNativeCall(in);
    }

    protected List<String> ARGetListActiveLink(ARServerUser ctx, String formName, long changedSince, ObjectPropertyMap propsToSearch) throws ARException {
        Object[] in = new Object[]{"ARGetListActiveLink", ctx, formName, changedSince, ARTypeMgr.getInstance().ObjectToVariant(propsToSearch, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[6], ctx);
    }

    protected List<ActiveLink> ARGetListActiveLinkObjects(ARServerUser ctx, String formName, long changedSince, ActiveLinkCriteria criteria) throws ARException {
        List<String> names = this.ARGetListActiveLink(ctx, formName, changedSince, null);
        if (names.size() != 0) {
            return this.ARGetMultipleActiveLinks(ctx, changedSince, names, criteria);
        }
        return new ArrayList<ActiveLink>();
    }

    protected List<ActiveLink> ARGetMultipleActiveLinks(ARServerUser ctx, long changedSince, List<String> names, ActiveLinkCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleActiveLinks", ctx, changedSince, ARTypeMgr.getInstance().ObjectToVariant(names, ctx)};
        Object[] out = this.invokeNativeCall(in);
        List<ActiveLink> objs = ActiveLink.buildGMALResponse(out, ctx);
        return objs;
    }

    protected void ARDeleteActiveLink(ARServerUser ctx, String name, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteActiveLink", ctx, name, deleteOption};
        this.invokeNativeCall(in);
    }

    private Object[] invokeNativeCall(Object[] args) throws ARException {
        if (!nativeLibraryExists) {
            logger.error("Did not load the native library.");
            throw new ARException(2, 1, "Did not load the native library.");
        }
        ((ARServerUser)args[1]).setCurrentOp((String)args[0]);
        ((ARServerUser)args[1]).setLastStatus(null);
        Object[] out = (Object[])this.eval(args);
        if (out != null && out.length > 1) {
            ArrayList<StatusInfo> lastStatus = ARTypeMgr.getInstance().ObjectListFromVariant(StatusInfo.class, (Object[])out[1], (ARServerUser)args[1]);
            ((ARServerUser)args[1]).setLastStatus(lastStatus);
            if (ConversionUtil.getIntValue(out[0]) > 1) {
                throw new ARException(lastStatus);
            }
        }
        return out;
    }

    protected void initializeSCB(ARServerUser context) throws ARException {
        int jniLoadMode = Config.getInstance().getJniLoadMode();
        if (jniLoadMode == 2 && !this.scbInitialized) {
            try {
                this.ARGetServerCharSet(context);
            }
            catch (ARException err) {
                logger.debug("called native gscs", err);
            }
            this.scbInitialized = true;
        }
    }

    protected View ARGetView(ARServerUser ctx, String formName, int vuiId, ViewCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetVUI", ctx, criteria == null ? ViewCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), formName, new Integer(vuiId)};
        Object[] out = this.invokeNativeCall(in);
        View object = ARTypeMgr.getInstance().ObjectFromVariant(View.class, out, ctx);
        return object;
    }

    protected List<Integer> ARGetListView(ARServerUser ctx, String formName, long changedSince) throws ARException {
        Object[] in = new Object[]{"ARGetListVUI", ctx, formName, changedSince, null};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, out[5], ctx);
    }

    protected List<View> ARGetListViewObjects(ARServerUser ctx, String formName, long changedSince, ViewCriteria criteria) throws ARException {
        List<Integer> vuiIds = this.ARGetListView(ctx, formName, changedSince);
        ArrayList<View> objs = new ArrayList<View>(vuiIds.size());
        for (Integer id : vuiIds) {
            View obj = this.ARGetView(ctx, formName, id, criteria);
            objs.add(obj);
        }
        return objs;
    }

    protected int ARCreateView(ARServerUser ctx, View object) throws ARException {
        Object varPropList = ARTypeMgr.getInstance().ObjectToVariant(object.getDisplayProperties(), ctx);
        String varChangeDiary = object.getDiary().getAppendedText();
        Object[] in = new Object[]{"ARCreateVUI", ctx, object.getFormName(), new Integer(object.getVUIId()), object.getName(), object.getLocale(), new Integer(object.getVUIType()), varPropList, object.getHelpText(), object.getOwner(), varChangeDiary};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getIntValue(out[4]);
    }

    protected void ARSetView(ARServerUser ctx, View object) throws ARException {
        Object varPropList = ARTypeMgr.getInstance().ObjectToVariant(object.getDisplayProperties(), ctx);
        String varChangeDiary = object.getDiary().getAppendedText();
        Object[] in = new Object[]{"ARSetVUI", ctx, new Integer(object.getChangeFlags().getPropertiesToRetrieve()), object.getFormName(), new Integer(object.getVUIId()), object.getName(), object.getLocale(), new Integer(object.getVUIType()), varPropList, object.getHelpText(), object.getOwner(), varChangeDiary};
        this.invokeNativeCall(in);
    }

    protected void ARDeleteView(ARServerUser ctx, String form, int vuiId) throws ARException {
        Object[] in = new Object[]{"ARDeleteVUI", ctx, form, vuiId};
        this.invokeNativeCall(in);
    }

    protected List<ContainerListInfo> ARGetListContainer(ARServerUser ctx, long changedSince, int[] containerTypes, boolean hiddenFlag, List<ContainerOwner> ownerList, ObjectPropertyMap propsToSearch) throws ARException {
        Object[] in = new Object[]{"ARGetListContainer", ctx, changedSince, ARTypeMgr.getInstance().ObjectToVariant(containerTypes, ctx), hiddenFlag ? 1 : 0, ARTypeMgr.getInstance().ObjectListToVariant(ownerList, ctx), ARTypeMgr.getInstance().ObjectToVariant(propsToSearch, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(ContainerListInfo.class, out[8], ctx);
    }

    protected List<Container> ARGetListContainerObjects(ARServerUser ctx, long changedSince, int[] containerTypes, boolean hiddenFlag, List<ContainerOwner> ownerList, ObjectPropertyMap propsToSearch, ContainerCriteria criteria) throws ARException {
        List<ContainerListInfo> names = this.ARGetListContainer(ctx, changedSince, containerTypes, hiddenFlag, ownerList, propsToSearch);
        ArrayList<Container> objs = new ArrayList<Container>(names.size());
        for (ContainerListInfo container : names) {
            Container obj = this.ARGetContainer(ctx, container.getKey(), criteria);
            objs.add(obj);
        }
        return objs;
    }

    protected List<Container> ARGetMultipleContainerObjects(ARServerUser ctx, long changedSince, List<String> containers, boolean hiddenFlag, int[] containerTypes, List<ContainerOwner> ownerList, int[] refTypes, ContainerCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleContainers", ctx, changedSince, ARTypeMgr.getInstance().ObjectToVariant(containers, ctx), containerTypes, hiddenFlag ? 1 : 0, ARTypeMgr.getInstance().ObjectListToVariant(ownerList, ctx), refTypes};
        Object[] out = this.invokeNativeCall(in);
        List<Container> objs = Container.buildGMCOResponse(out, ctx);
        return objs;
    }

    protected void ARSetContainer(ARServerUser ctx, Container object, boolean removeInvalidReference) throws ARException {
        Object[] in = new Object[]{"ARSetContainer", ctx, object.getChangeFlags().getPropertiesToRetrieve(), object.getName(), object.getNewName(), ARTypeMgr.getInstance().ObjectToVariant(object.getPermissions(), ctx), ARTypeMgr.getInstance().ObjectToVariant(object.getAdminGroupList(), ctx), ARTypeMgr.getInstance().ObjectToVariant(object.getContainerOwner(), ctx), object.getLabel(), object.getDescription(), object.getType(), ARTypeMgr.getInstance().ObjectToVariant(object.getReferences(), ctx), removeInvalidReference, object.getHelpText(), object.getOwner(), object.getDiary().getAppendedText(), ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx)};
        this.invokeNativeCall(in);
    }

    protected void ARCreateContainer(ARServerUser ctx, Container object, boolean removeInvalidReference) throws ARException {
        Object[] in = new Object[]{"ARCreateContainer", ctx, object.getName(), ARTypeMgr.getInstance().ObjectToVariant(object.getPermissions(), ctx), ARTypeMgr.getInstance().ObjectToVariant(object.getAdminGroupList(), ctx), ARTypeMgr.getInstance().ObjectToVariant(object.getContainerOwner(), ctx), object.getLabel(), object.getDescription(), object.getType(), ARTypeMgr.getInstance().ObjectToVariant(object.getReferences(), ctx), removeInvalidReference, object.getHelpText(), object.getOwner(), object.getDiary().getAppendedText(), ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx)};
        this.invokeNativeCall(in);
    }

    protected void ARDeleteContainer(ARServerUser ctx, String name, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteContainer", ctx, name, deleteOption};
        this.invokeNativeCall(in);
    }

    protected Container ARGetContainer(ARServerUser ctx, String name, ContainerCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetContainer", ctx, criteria == null ? ContainerCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), name};
        Object[] out = this.invokeNativeCall(in);
        Container object = Container.createInstance(out, ctx);
        return object;
    }

    protected Menu ARGetMenu(ARServerUser ctx, String name, MenuCriteria criteria) throws ARException {
        Object[] in = new Object[]{"ARGetCharMenu", ctx, criteria == null ? MenuCriteria.DEFAULT_CRITERIA : criteria.getPropertiesToRetrieve(), name};
        Object[] out = this.invokeNativeCall(in);
        Menu object = Menu.createInstance(out, ctx);
        return object;
    }

    protected List<String> ARGetListMenu(ARServerUser ctx, long changedSince, List<String> forms, List<String> activeLinks, ObjectPropertyMap propsToSearch) throws ARException {
        Object[] in = new Object[]{"ARGetListCharMenu", ctx, changedSince, ARTypeMgr.getInstance().ObjectToVariant(forms, ctx), ARTypeMgr.getInstance().ObjectToVariant(activeLinks, ctx), ARTypeMgr.getInstance().ObjectToVariant(propsToSearch, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[7], ctx);
    }

    protected List<Menu> ARGetListMenuObjects(ARServerUser ctx, long changedSince, List<String> forms, List<String> activeLinks, MenuCriteria criteria) throws ARException {
        List<String> names = this.ARGetListMenu(ctx, changedSince, forms, activeLinks, null);
        ArrayList<Menu> objs = new ArrayList<Menu>(names.size());
        for (String name : names) {
            Menu obj = this.ARGetMenu(ctx, name, criteria);
            objs.add(obj);
        }
        return objs;
    }

    protected List<Menu> ARGetListMenuObjects(ARServerUser ctx, long changedSince, List<String> menus, MenuCriteria criteria) throws ARException {
        throw new ARException(2, 98);
    }

    protected void ARCreateMenu(ARServerUser ctx, Menu object) throws ARException {
        ctx.setCurrentOp("ARCreateCharMenu");
        Object[] in = new Object[]{"ARCreateCharMenu", ctx, object.getName(), object.getRefreshCode(), object.menuDefnToVariant(ctx, null, null), object.getHelpText(), object.getOwner(), object.getDiary().getAppendedText(), ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx)};
        this.invokeNativeCall(in);
    }

    protected void ARSetMenu(ARServerUser ctx, Menu object) throws ARException {
        ctx.setCurrentOp("ARSetCharMenu");
        Object[] in = new Object[]{"ARSetCharMenu", ctx, object.getChangeFlags().getPropertiesToRetrieve(), object.getName(), object.getNewName(), object.getRefreshCode(), object.menuDefnToVariant(ctx, null, null), object.getHelpText(), object.getOwner(), object.getDiary().getAppendedText(), ARTypeMgr.getInstance().ObjectToVariant(object.getProperties(), ctx)};
        this.invokeNativeCall(in);
    }

    protected void ARDeleteMenu(ARServerUser ctx, String name, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteCharMenu", ctx, name, deleteOption};
        this.invokeNativeCall(in);
    }

    protected List<MenuItem> ARExpandMenu(ARServerUser ctx, Menu object, Entry keywordList, Entry parameterList) throws ARException {
        Object[] in = new Object[]{"ARExpandCharMenu", ctx, object.menuDefnToVariant(ctx, keywordList, parameterList)};
        Object[] out = this.invokeNativeCall(in);
        List<MenuItem> ret = Menu.BuildExpMenuResponse(out[4]);
        return ret;
    }

    protected int ARCreateSupportFile(ARServerUser ctx, SupportFile supportFile) throws ARException, IOException {
        Object[] in = new Object[]{"ARCreateSupportFile", ctx, supportFile.getKey().getFileType(), supportFile.getKey().getName(), supportFile.getKey().getFieldId(), supportFile.getKey().getFileId(), supportFile.getFilePath()};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getIntValue(out[6]);
    }

    protected SupportFile ARGetSupportFile(ARServerUser ctx, String associatedObjName, int fileId, int fileType, int supportingId, String filePath) throws ARException {
        filePath = SupportFile.checkAndFillFilePath(ctx, fileId, filePath);
        Object[] in = new Object[]{"ARGetSupportFile", ctx, fileType, associatedObjName, supportingId, fileId, filePath};
        Object[] out = this.invokeNativeCall(in);
        SupportFile object = ExtendedClassRegistry.newInstance(ctx == null ? null : ctx.getExtendedClassRegistry(), SupportFile.class);
        object.fromVariant(out, ctx);
        object.setFilePath(filePath);
        return object;
    }

    protected void ARSetSupportFile(ARServerUser ctx, SupportFile supportFile) throws ARException {
        Object[] in = new Object[]{"ARSetSupportFile", ctx, supportFile.getKey().getFileType(), supportFile.getKey().getName(), supportFile.getKey().getFieldId(), supportFile.getKey().getFileId(), supportFile.getFilePath()};
        this.invokeNativeCall(in);
    }

    protected List<Integer> ARGetListSupportFile(ARServerUser ctx, int fileType, String name, int fieldId, long changedSince) throws ARException {
        Object[] in = new Object[]{"ARGetListSupportFile", ctx, fileType, name, fieldId, changedSince};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, out[7], ctx);
    }

    protected List<SupportFile> ARGetListSupportFileObjects(ARServerUser ctx, int fileType, String associatedObjName, int supportingId, long changedSince) throws ARException {
        List<Integer> fileIds = this.ARGetListSupportFile(ctx, fileType, associatedObjName, supportingId, changedSince);
        ArrayList<SupportFile> objs = new ArrayList<SupportFile>(fileIds.size());
        for (Integer fileId : fileIds) {
            SupportFile obj = this.ARGetSupportFile(ctx, associatedObjName, fileId, fileType, supportingId, null);
            objs.add(obj);
        }
        return objs;
    }

    protected void ARDeleteSupportFile(ARServerUser ctx, SupportFileKey key) throws ARException {
        Object[] in = new Object[]{"ARDeleteSupportFile", ctx, key.getFileType(), key.getName(), key.getFieldId(), key.getFileId()};
        this.invokeNativeCall(in);
    }

    protected void ARGetEntryBlob(ARServerUser ctx, String formName, String entryId, int fieldId, String filePath) throws ARException {
        Object[] in = new Object[]{"ARGetEntryBLOB", ctx, formName, Entry.splitEntryId(entryId), fieldId, new Object[]{1, filePath}};
        this.invokeNativeCall(in);
    }

    protected byte[] ARGetEntryBlob(ARServerUser ctx, String formName, String entryId, int fieldId) throws ARException {
        Object[] in = new Object[]{"ARGetEntryBLOB", ctx, formName, Entry.splitEntryId(entryId), fieldId, new Object[]{2}};
        Object[] out = this.invokeNativeCall(in);
        return (byte[])ARTypeMgr.GetAt((Object)out, new int[]{6, 1, 1});
    }

    protected String ARGetServerCharSet(ARServerUser ctx) throws ARException {
        Object[] in = new Object[]{"ARGetServerCharSet", ctx};
        Object[] out = this.invokeNativeCall(in);
        return (String)out[3];
    }

    protected String ARGetClientCharSet(ARServerUser ctx) throws ARException {
        Object[] in = new Object[]{"ARGetClientCharSet", ctx};
        Object[] out = this.invokeNativeCall(in);
        return (String)out[3];
    }

    protected void ARSetImpersonatedUser(ARServerUser ctx, String impersonatedUser) throws ARException {
        Object[] in = new Object[]{"ARSetImpersonatedUser", ctx, impersonatedUser};
        this.invokeNativeCall(in);
    }

    protected ServerInfoMap ARGetServerInfo(ARServerUser ctx, int[] requestList) throws ARException {
        Object[] in = new Object[]{"ARGetServerInfo", ctx, requestList};
        Object[] out = this.invokeNativeCall(in);
        ServerInfoMap obj = ARTypeMgr.getInstance().ObjectFromVariant(ServerInfoMap.class, out[4], ctx);
        return obj;
    }

    protected void ARSetServerInfo(ARServerUser ctx, ServerInfoMap serverInfoMap) throws ARException {
        Object[] in = new Object[]{"ARSetServerInfo", ctx, ARTypeMgr.getInstance().ObjectToVariant(serverInfoMap, ctx)};
        this.invokeNativeCall(in);
    }

    protected ServerInfoMap ARGetServerStatistics(ARServerUser ctx, int[] requestList) throws ARException {
        Object[] in = new Object[]{"ARGetServerStatistics", ctx, requestList};
        Object[] out = this.invokeNativeCall(in);
        ServerInfoMap obj = ARTypeMgr.getInstance().ObjectFromVariant(ServerInfoMap.class, out[4], ctx);
        return obj;
    }

    @Override
    public void ARSetServerPort(ApiUserContextI ctx, int port, int progNum) throws ARException {
        Object[] in = new Object[]{"ARSetServerPort", ctx, ctx.getServer(), port, progNum};
        this.invokeNativeCall(in);
    }

    protected String ARExport(ARServerUser ctx, List<StructItemInfo> items, String displayTag, int vuiType, WorkflowLockInfo lockInfo) throws ARException {
        Object[] in = new Object[]{"ARExport", ctx, ARTypeMgr.getInstance().ObjectToVariant(items, ctx), displayTag, vuiType, ARTypeMgr.getInstance().ObjectToVariant(lockInfo, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[7]);
    }

    protected void ARExport(ARServerUser ctx, List<StructItemInfo> items, String displayTag, int vuiType, WorkflowLockInfo lockInfo, String filePath, boolean overwrite) throws ARException, IOException {
        String definitionText = this.ARExport(ctx, items, displayTag, vuiType, lockInfo);
        if (definitionText != null) {
            FileWriter fp = new FileWriter(filePath);
            fp.write(definitionText);
            fp.flush();
            fp.close();
        }
    }

    protected String ARExportFile(ARServerUser context, String arg1) throws ARException {
        return new String();
    }

    protected void ARImport(ARServerUser ctx, List<StructItemInfo> items, String importBuffer, int importOption) throws ARException {
        Object[] in = new Object[]{"ARImport", ctx, ARTypeMgr.getInstance().ObjectToVariant(items, ctx), importBuffer, importOption};
        this.invokeNativeCall(in);
    }

    protected String ARGetTextForErrorMessage(ARServerUser ctx, int msgId) throws ARException {
        Object[] in = new Object[]{"ARGetTextForErrorMessage", ctx, msgId};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[3]);
    }

    protected List<StatisticsResultInfo> ARGetEntryStatistics(ARServerUser ctx, String schemaKey, QualifierInfo qual, ArithmeticOrRelationalOperand target, int statistic, int[] groupByList) throws ARException {
        Object[] in = new Object[]{"ARGetEntryStatistics", ctx, schemaKey, ARTypeMgr.getInstance().ObjectToVariant(qual, ctx), ARTypeMgr.getInstance().ObjectToVariant(target, ctx), statistic, groupByList};
        Object[] out = this.invokeNativeCall(in);
        List<StatisticsResultInfo> objList = StatisticsResultInfo.buildGESResponse((Object[])out[8], ctx);
        return objList;
    }

    protected SQLResult ARGetListSQL(ARServerUser ctx, String sqlCommand, int maxRetrieve, boolean retrieveTotalMatches) throws ARException {
        Object[] in = new Object[]{"ARGetListSQL", ctx, sqlCommand, maxRetrieve, null, retrieveTotalMatches ? 1 : 0};
        Object[] out = this.invokeNativeCall(in);
        SQLResult object = SQLResult.buildGLSQLResponse((Object[])out[5], ConversionUtil.getIntValue(out[6]), null, ctx);
        return object;
    }

    protected ProcessResult ARExecuteProcess(ARServerUser ctx, String command, boolean waitFlag) throws ARException {
        Object[] in = new Object[]{"ARExecuteProcess", ctx, command, waitFlag ? 1 : 0};
        Object[] out = this.invokeNativeCall(in);
        return new ProcessResult(ConversionUtil.getIntValue(out[4]), ConversionUtil.getStringValue(out[5]));
    }

    protected void ARVerifyUser(ARServerUser ctx) throws ARException {
        Object[] in = new Object[]{"ARVerifyUser", ctx};
        Object[] out = this.invokeNativeCall(in);
        ctx.setAdminFlag(ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)out, 3)));
        ctx.setSubAdminFlag(ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)out, 4)));
        ctx.setCustomFlag(ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)out, 5)));
    }

    protected List<GroupInfo> ARGetListGroup(ARServerUser ctx, String user, String password) throws ARException {
        Object[] in = new Object[]{"ARGetListGroup", ctx, user, password};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(GroupInfo.class, out[5], ctx);
    }

    protected List<RoleInfo> ARGetListRole(ARServerUser ctx, String application, String user, String password) throws ARException {
        Object[] in = new Object[]{"ARGetListRole", ctx, application, user, password};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(RoleInfo.class, out[6], ctx);
    }

    protected List<UserInfo> ARGetListUser(ARServerUser ctx, int option, long changedSince) throws ARException {
        Object[] in = new Object[]{"ARGetListUser", ctx, option, changedSince};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(UserInfo.class, out[5], ctx);
    }

    protected void ARSetSessionConfiguration(ARServerUser ctx, int tag, ApiValueBase value) throws ARException {
        Object[] in = new Object[]{"ARSetSessionConfiguration", ctx, tag, ARTypeMgr.getInstance().ObjectToVariant(new Value(value), ctx)};
        this.invokeNativeCall(in);
    }

    protected Value ARGetSessionConfiguration(ARServerUser ctx, int tag) throws ARException {
        Object[] in = new Object[]{"ARGetSessionConfiguration", ctx, tag};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectFromVariant(Value.class, out[4], ctx);
    }

    protected void ARSetLogging(ARServerUser ctx, LoggingInfo info) throws ARException {
        if (info != null && info.isEnabled()) {
            Object[] in = new Object[]{"ARSetLogging", ctx, info.getType(), info.getWriteToFileOrStatus(), new Object[]{info.getPath(), "a", ctx.getLogFilePtr()}};
            Object[] out = this.invokeNativeCall(in);
            ctx.setLogFilePtr(ARTypeMgr.getInstance().ObjectFromVariant(Integer.class, out[3], ctx).intValue());
        }
    }

    private native long ARInitialization() throws ARException;

    protected native long ARTermination(ARServerUser var1) throws ARException;

    protected QualifierInfo ARGetQualifier(ARServerUser ctx, String queryString, List<Field> remoteFieldList, List<Field> fieldList, int queryContext) throws ARException {
        Object[] in = new Object[]{"ARGetQualifier", ctx, queryString, ARTypeMgr.getInstance().ObjectListToVariant(remoteFieldList, ctx), ARTypeMgr.getInstance().ObjectListToVariant(fieldList, ctx), queryContext};
        Object[] out = this.invokeNativeCall(in);
        QualifierInfo qualiferInfo = ARTypeMgr.getInstance().ObjectFromVariant(QualifierInfo.class, out[3], ctx);
        return qualiferInfo;
    }

    protected AssignInfo ARGetAssignment(ARServerUser ctx, String assignString, String qualString, Field assignfield, List<Field> remoteFieldList, List<Field> fieldList, String schema, String server, int currentScreen, boolean anyIdOk, boolean fromSQL, boolean fromFilterAPI, int queryContext) throws ARException {
        Object[] in = new Object[]{"ARGetAssignment", ctx, assignString, qualString, assignfield, ARTypeMgr.getInstance().ObjectListToVariant(remoteFieldList, ctx), ARTypeMgr.getInstance().ObjectListToVariant(fieldList, ctx), schema, server, currentScreen, anyIdOk, fromSQL, fromFilterAPI, queryContext};
        Object[] out = this.invokeNativeCall(in);
        AssignInfo assignInfo = ARTypeMgr.getInstance().ObjectFromVariant(AssignInfo.class, out[3], ctx);
        return assignInfo;
    }

    protected String ARGetAssignmentString(ARServerUser ctx, AssignInfo assignInfo, Field assignfield, List<Field> fieldList, boolean isTopLevel) throws ARException {
        Object[] in = new Object[]{"ARGetAssignmentString", ctx, ARTypeMgr.getInstance().ObjectToVariant(assignInfo, ctx), ARTypeMgr.getInstance().ObjectListToVariant(fieldList, ctx), ARTypeMgr.getInstance().ObjectToVariant(assignfield, ctx), isTopLevel};
        Object[] out = this.invokeNativeCall(in);
        String assignLine = ARTypeMgr.getInstance().ObjectFromVariant(String.class, out[3], ctx);
        return assignLine;
    }

    protected String ARGetQualifierString(ARServerUser ctx, QualifierInfo qual, List<Field> remoteFieldList, List<Field> fieldList, int queryContext, boolean isEscalation) throws ARException {
        Object[] in = new Object[]{"ARGetQualifierString", ctx, ARTypeMgr.getInstance().ObjectToVariant(qual, ctx), ARTypeMgr.getInstance().ObjectListToVariant(remoteFieldList, ctx), ARTypeMgr.getInstance().ObjectListToVariant(fieldList, ctx), queryContext, isEscalation};
        Object[] out = this.invokeNativeCall(in);
        return (String)out[3];
    }

    protected String AREncodeARQualifierStruct(ARServerUser ctx, QualifierInfo qual) throws ARException {
        Object[] in = new Object[]{"AREncodeARQualifierStruct", ctx, ARTypeMgr.getInstance().ObjectToVariant(qual, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return (String)out[4];
    }

    protected QualifierInfo ARDecodeARQualifierStruct(ARServerUser ctx, String queryString) throws ARException {
        Object[] in = new Object[]{"ARDecodeARQualifierStruct", ctx, queryString};
        Object[] out = this.invokeNativeCall(in);
        QualifierInfo qualiferInfo = ARTypeMgr.getInstance().ObjectFromVariant(QualifierInfo.class, out[4], ctx);
        return qualiferInfo;
    }

    protected String AREncodeARAssignStruct(ARServerUser ctx, AssignInfo assignment) throws ARException {
        Object[] in = new Object[]{"AREncodeARAssignStruct", ctx, ARTypeMgr.getInstance().ObjectToVariant(assignment, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return (String)out[4];
    }

    protected AssignInfo ARDecodeARAssignStruct(ARServerUser ctx, String assignment) throws ARException {
        Object[] in = new Object[]{"ARDecodeARAssignStruct", ctx, assignment};
        Object[] out = this.invokeNativeCall(in);
        AssignInfo obj = ARTypeMgr.getInstance().ObjectFromVariant(AssignInfo.class, out[4], ctx);
        return obj;
    }

    protected void ARRegisterForAlerts(ARServerUser ctx, int clientPort, int registrationFlags) throws ARException {
        Object[] in = new Object[]{"ARRegisterForAlerts", ctx, clientPort, registrationFlags};
        this.invokeNativeCall(in);
    }

    protected void ARDeregisterForAlerts(ARServerUser ctx, int clientPort) throws ARException {
        Object[] in = new Object[]{"ARDeregisterForAlerts", ctx, clientPort};
        this.invokeNativeCall(in);
    }

    protected String ARCreateAlertEvent(ARServerUser ctx, String user, String alertText, int priority, String sourceTag, String server, String formName, String objectId) throws ARException {
        Object[] in = new Object[]{"ARCreateAlertEvent", ctx, user, alertText, priority, sourceTag, server, formName, objectId};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[10]);
    }

    protected List<String> ARGetListAlertUser(ARServerUser ctx) throws ARException {
        Object[] in = new Object[]{"ARGetListAlertUser", ctx};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[2], ctx);
    }

    protected int ARGetAlertCount(ARServerUser ctx, QualifierInfo qual) throws ARException {
        Object[] in = new Object[]{"ARGetAlertCount", ctx, ARTypeMgr.getInstance().ObjectToVariant(qual, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getIntValue(out[4]);
    }

    protected AlertMessageInfo ARDecodeAlertMessage(ARServerUser ctx, AlertMessageCriteria criteria, Object message, int len) throws ARException {
        Object[] in = new Object[]{"ARDecodeAlertMessage", ctx, message, len};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectFromVariant(AlertMessageInfo.class, out, ctx);
    }

    protected LocalizedValueInfo ARGetLocalizedValue(ARServerUser ctx, LocalizedValueCriteria criteria, LocalizedRequestInfo request) throws ARException {
        Object[] in = new Object[]{"ARGetLocalizedValue", ctx, ARTypeMgr.getInstance().ObjectToVariant(request, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectFromVariant(LocalizedValueInfo.class, out, ctx);
    }

    protected List<LocalizedValueInfo> ARGetMultipleLocalizedValues(ARServerUser ctx, LocalizedValueCriteria criteria, List<LocalizedRequestInfo> requests) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleLocalizedValues", ctx, ARTypeMgr.getInstance().ObjectToVariant(requests, ctx)};
        Object[] out = this.invokeNativeCall(in);
        List<LocalizedValueInfo> objectList = LocalizedValueInfo.buildGMLVResponse(out, ctx);
        return objectList;
    }

    protected SQLResult ARGetListSQLForActiveLink(ARServerUser ctx, String actlinkName, int actionIndex, int actionType, Timestamp timestamp, Entry keywordList, Entry parameterList, int maxRetrieve, boolean retrieveTotalMatches) throws ARException {
        throw new ARException(2, 233, "For future use, not implemented yet! Prefer to use the overload that accepts keyword and parameter values as List<Value>");
    }

    protected SQLResult ARGetListSQLForActiveLink(ARServerUser ctx, String actlinkName, int actionIndex, int actionType, Timestamp timestamp, List<Value> keywordList, List<Value> parameterList, int maxRetrieve, boolean retrieveTotalMatches) throws ARException {
        Object varKeywordList = Proxy.FieldValueListFromValueList(keywordList, ctx);
        Object varParmeterList = Proxy.FieldValueListFromValueList(parameterList, ctx);
        Object[] in = new Object[]{"ARGetListSQLForActiveLink", ctx, actlinkName, actionIndex, actionType, ConversionUtil.getARTimestamp(timestamp), varKeywordList, varParmeterList, maxRetrieve, null, retrieveTotalMatches ? 1 : 0};
        Object[] out = this.invokeNativeCall(in);
        SQLResult object = SQLResult.buildGLSQLResponse((Object[])out[10], ConversionUtil.getIntValue(out[11]), ConversionUtil.getStringValue(out[12]), ctx);
        return object;
    }

    static Object FieldValueListFromValueList(List<Value> valueList, ARServerUser ctx) {
        int count;
        int n = count = valueList != null ? valueList.size() : 0;
        if (count <= 0) {
            return null;
        }
        Object[] var = new Object[count];
        for (int i = 0; i < count; ++i) {
            var[i] = new Object[]{i, ARTypeMgr.getInstance().ObjectToVariant(valueList.get(i), ctx)};
        }
        return var;
    }

    protected ProcessResult ARExecuteProcessForActiveLink(ARServerUser ctx, String actlinkName, int actionIndex, int actionType, int fieldId, Timestamp timestamp, Entry keywordList, Entry parameterList, boolean asyncMode) throws ARException {
        throw new ARException(2, 233, "For future use, not implemented yet! Prefer to use the overload that accepts keyword and parameter values as List<Value>");
    }

    protected ProcessResult ARExecuteProcessForActiveLink(ARServerUser ctx, String actlinkName, int actionIndex, int actionType, int fieldId, Timestamp timestamp, List<Value> keywordList, List<Value> parameterList, boolean asyncMode) throws ARException {
        Object varKeywordList = Proxy.FieldValueListFromValueList(keywordList, ctx);
        Object varParmeterList = Proxy.FieldValueListFromValueList(parameterList, ctx);
        Object[] in = new Object[]{"ARExecuteProcessForActiveLink", ctx, actlinkName, actionIndex, actionType, fieldId, timestamp, varKeywordList, varParmeterList, asyncMode, null, null};
        Object[] out = this.invokeNativeCall(in);
        return new ProcessResult(ConversionUtil.getIntValue(out[10]), ConversionUtil.getStringValue(out[11]));
    }

    protected List<ExtFieldCandidatesInfo> ARGetMultipleExtFieldCandidates(ARServerUser ctx, Object[] compoundSchemaInfo) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleExtFieldCandidates", ctx, compoundSchemaInfo};
        Object[] out = this.invokeNativeCall(in);
        List<ExtFieldCandidatesInfo> objs = ExtFieldCandidatesInfo.buildGMEFCResponse(out, ctx);
        return objs;
    }

    protected List<ExtFormCandidatesInfo> ARGetListExtFormCandidates(ARServerUser ctx, int formType) throws ARException {
        Object[] in = new Object[]{"ARGetListExtSchemaCandidates", ctx, formType};
        Object[] out = this.invokeNativeCall(in);
        List<ExtFormCandidatesInfo> objs = ExtFormCandidatesInfo.buildGLESCResponse(out, ctx);
        return objs;
    }

    protected String ARGetLocalHostID(ARServerUser ctx) throws ARException {
        Object[] in = new Object[]{"ARGetLocalHostID", ctx};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[3]);
    }

    protected List<String> ARGetAllLocalHostIDs(ARServerUser ctx) throws ARException {
        Object[] in = new Object[]{"ARGetAllLocalHostIDs", ctx};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[4], ctx);
    }

    protected LicenseValidInfo ARValidateLicense(ARServerUser ctx, String licenseType) throws ARException {
        Object[] in = new Object[]{"ARValidateLicense", ctx, licenseType};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectFromVariant(LicenseValidInfo.class, out[4], ctx);
    }

    protected List<LicenseValidInfo> ARValidateMultipleLicenses(ARServerUser ctx, List<String> licenseTypes) throws ARException {
        Object[] in = new Object[]{"ARValidateMultipleLicenses", ctx, ARTypeMgr.getInstance().ObjectToVariant(licenseTypes, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(LicenseValidInfo.class, out[4], ctx);
    }

    protected List<LicenseInfo> ARGetListLicense(ARServerUser ctx, String licenseType) throws ARException {
        Object[] in = new Object[]{"ARGetListLicense", ctx, licenseType};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(LicenseInfo.class, out[4], ctx);
    }

    protected String ARXMLCreateEntry(ARServerUser ctx, String inputMapping, String inputDoc, String outputMapping, String optionDoc) throws ARException {
        Object[] in = new Object[]{"ARXMLCreateEntry", ctx, inputMapping, inputDoc, outputMapping, optionDoc};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[7]);
    }

    protected String ARXMLSetEntry(ARServerUser ctx, String queryMapping, String queryDoc, String inputMapping, String inputDoc, String outputMapping, String optionDoc) throws ARException {
        Object[] in = new Object[]{"ARXMLSetEntry", ctx, queryMapping, queryDoc, inputMapping, inputDoc, outputMapping, optionDoc};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[9]);
    }

    protected String ARXMLGetEntry(ARServerUser ctx, String queryMapping, String queryDoc, String outputMapping, String optionDoc) throws ARException {
        Object[] in = new Object[]{"ARXMLGetEntry", ctx, queryMapping, queryDoc, outputMapping, optionDoc};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[7]);
    }

    protected List<String> ARGetMultipleCurrencyRatioSets(ARServerUser ctx, List<Timestamp> ratioTimestamps) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleCurrencyRatioSets", ctx, ARTypeMgr.getInstance().ObjectListToVariant(ratioTimestamps, ctx)};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[4], ctx);
    }

    protected List<EntryPointInfo> ARGetMultipleEntryPoints(ARServerUser ctx, long changedSince, List<String> applicationKeys, int[] refTypes, int vuiType, String displayTag, boolean hiddenFlag) throws ARException {
        Object[] in = new Object[]{"ARGetMultipleEntryPoints", ctx, changedSince, ARTypeMgr.getInstance().ObjectToVariant(applicationKeys, ctx), refTypes, displayTag, vuiType, hiddenFlag ? 1 : 0};
        Object[] out = this.invokeNativeCall(in);
        List<EntryPointInfo> objectList = EntryPointInfo.buildGMEPResponse(out, ctx);
        return objectList;
    }

    protected void ARBeginBulkEntryTransaction(ARServerUser ctx) throws ARException {
        Object[] in = new Object[]{"ARBeginBulkEntryTransaction", ctx};
        this.invokeNativeCall(in);
    }

    protected List<BulkEntryReturn> AREndBulkEntryTransaction(ARServerUser ctx, int actionType) throws ARException {
        Object[] in = new Object[]{"AREndBulkEntryTransaction", ctx, actionType};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(BulkEntryReturn.class, out[4], ctx);
    }

    protected List<String> ARGetListApplicationState(ARServerUser ctx) throws ARException {
        Object[] in = new Object[]{"ARGetListApplicationState", ctx};
        Object[] out = this.invokeNativeCall(in);
        return ARTypeMgr.getInstance().ObjectListFromVariant(String.class, out[3], ctx);
    }

    protected String ARGetApplicationState(ARServerUser ctx, String applicationName) throws ARException {
        Object[] in = new Object[]{"ARGetApplicationState", ctx, applicationName};
        Object[] out = this.invokeNativeCall(in);
        return ConversionUtil.getStringValue(out[4]);
    }

    protected void ARSetApplicationState(ARServerUser ctx, String applicationName, String newState) throws ARException {
        Object[] in = new Object[]{"ARSetApplicationState", ctx, applicationName, newState};
        this.invokeNativeCall(in);
    }

    protected void ARSignal(ARServerUser context, Map<SignalType, String> signals) throws ARException {
    }

    protected String ARInitApiSourceGuid(ARServerUser ctx) throws ARException {
        if (apiSourceId == null) {
            Object[] in = new Object[]{"ARInitApiSourceGuid", ctx};
            Object[] out = this.invokeNativeCall(in);
            apiSourceId = ConversionUtil.getStringValue(out[3]);
            logger.info("Api source is identified as: " + apiSourceId);
        }
        return apiSourceId;
    }

    protected native Object eval(Object var1) throws ARException;

    private static String shl_plat() {
        String osarch = System.getProperty("os.arch");
        if ("IA64N".equals(osarch)) {
            return "_hpia32";
        }
        if ("IA64W".equals(osarch)) {
            return "_hpia64";
        }
        return "";
    }

    @Override
    protected String ARInitApiSourceGuid(ApiUserContextI ctx) throws ARException {
        return null;
    }

    @Override
    public void ARSetSessionConfiguration(ApiUserContextI ctx, int tag, ApiValueBase value) throws ARException {
        this.ARSetSessionConfiguration((ARServerUser)ctx, tag, value);
    }

    @Override
    public long ARTermination(ApiUserContextI ctx) throws ARException {
        return 0L;
    }

    @Override
    public void ARVerifyUser(ApiUserContextI ctx) throws ARException {
    }

    public void ARCreateAssociation(ARServerUser ctx, Association object) throws ARException {
        ctx.setCurrentOp("ARCreateAssociation");
        Object[] in = (Object[])object.toVariant(ctx);
        this.invokeNativeCall(in);
    }

    public void ARSetAssociation(ARServerUser arServerUser, Association object) {
    }

    public Association ARGetAssociation(ARServerUser arServerUser, String key, AssociationCriteria criteria, Object object) {
        return null;
    }

    public void ARDeleteAssociation(ARServerUser ctx, String name, int deleteOption) throws ARException {
        Object[] in = new Object[]{"ARDeleteAssociation", ctx, name, deleteOption};
        this.invokeNativeCall(in);
    }

    public List<String> ARGetListAssociation(ARServerUser arServerUser, String formName, long changedSince, ObjectPropertyMap propsToSearch, int enforcement, int cardinality, int type) {
        return null;
    }

    public List<Association> ARGetMultipleAssociations(ARServerUser arServerUser, long changedSince, List<String> names, AssociationCriteria criteria) {
        return null;
    }

    static {
        try {
            ARTypeMgr.getInstance().loadAll();
        }
        catch (Throwable e) {
            logger.error("Could not load the Type Manager", e);
        }
    }
}

