/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class FileMenu
extends Menu
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2906076780489180128L;
    private int m_location;
    private String m_fileName;

    public FileMenu() {
    }

    public FileMenu(int location, String name) {
        this.m_location = location;
        this.m_fileName = name;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FileMenu menu = null;
        menu = (FileMenu)super.clone();
        return menu;
    }

    public int getLocation() {
        return this.m_location;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String name) {
        this.m_fileName = name;
        this.m_changeFlags.setParameter(9L, true);
    }

    public void setLocation(int location) {
        this.m_location = location;
        this.m_changeFlags.setParameter(9L, true);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileMenu)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FileMenu rhs = (FileMenu)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_location, rhs.m_location).append(this.m_fileName, rhs.m_fileName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_location).append(this.m_fileName).toHashCode();
    }

    @Override
    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        super.fromVariant(rawData, ctx);
        rawData = (Object[])ARTypeMgr.GetAt((Object)rawData, new int[]{5, 1});
        this.m_location = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.m_fileName = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 1));
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Location", this.m_location).append("File Name", this.m_fileName).toString();
    }

    protected List<MenuItem> expandMenu(ARServerUser context, boolean isLocalizedServerFlag) throws ARException {
        List<MenuItem> menuItemList = new ArrayList<MenuItem>();
        Scanner scanBuffer = null;
        List<String> fileNames = this.buildLocalizedFileNames(context, isLocalizedServerFlag);
        if (this.getLocation() == 2) {
            for (String fileName : fileNames) {
                try {
                    scanBuffer = new Scanner(new File(fileName));
                    break;
                }
                catch (Exception e) {
                    if (!fileName.equals(this.getFileName())) continue;
                    String appendMsg = e.getMessage();
                    throw new ARException(2, 67, appendMsg);
                }
            }
        } else {
            for (String fileName : fileNames) {
                try {
                    String fileBuffer = context.exportFile(fileName);
                    if (fileBuffer == null) break;
                    scanBuffer = new Scanner(fileBuffer);
                    break;
                }
                catch (ARException e) {
                    if (!fileName.equals(this.getFileName())) continue;
                    throw e;
                }
            }
        }
        if (scanBuffer != null) {
            menuItemList = MenuItem.bufferToMenuItemList(scanBuffer);
            scanBuffer.close();
        }
        return menuItemList;
    }

    private List<String> buildLocalizedFileNames(ARServerUser context, boolean isLocalizedServerFlag) {
        ArrayList<String> fileNames = new ArrayList<String>(3);
        if (isLocalizedServerFlag) {
            fileNames.add(this.getFileName() + "." + context.getLocale());
            Scanner scan = new Scanner(context.getLocale()).useDelimiter("_");
            if (scan.hasNext()) {
                fileNames.add(this.getFileName() + "." + scan.next());
            }
            scan.close();
        }
        fileNames.add(this.getFileName());
        return fileNames;
    }
}

