/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.FuncCurrencyInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

@ARStructTypeInfo(Name="ARCurrencyStruct", NumberOfMembers=4)
public class CurrencyValue
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8546908808563168015L;
    @ARStructMemTypeInfo(Name="value", Offset=0)
    private BigDecimal m_value;
    @ARStructMemTypeInfo(Name="currencyCode", Offset=1)
    private String m_currencyCode;
    @ARStructMemTypeInfo(Name="conversionDate", Offset=2)
    private Timestamp m_conversionDate;
    @ARStructMemTypeInfo(Name="funcCurrencyList", Offset=3)
    private List<FuncCurrencyInfo> m_funcCurrencyList;

    public CurrencyValue() {
        this.m_value = null;
        this.m_currencyCode = null;
        this.m_conversionDate = null;
    }

    public CurrencyValue(String value, String currencyCode, Timestamp conversionDate, List<FuncCurrencyInfo> funcCurrencyList) {
        if (".".equals(value)) {
            value = "0";
        }
        this.m_value = new BigDecimal(value);
        this.m_currencyCode = currencyCode;
        this.m_conversionDate = conversionDate;
        this.m_funcCurrencyList = funcCurrencyList;
    }

    public CurrencyValue(BigDecimal value, String currencyCode, Timestamp conversionDate, List<FuncCurrencyInfo> funcCurrencyList) {
        this.m_value = value;
        this.m_currencyCode = currencyCode;
        this.m_conversionDate = conversionDate;
        this.m_funcCurrencyList = funcCurrencyList;
    }

    public CurrencyValue(String currencyInfoString) {
        this(currencyInfoString, Locale.getDefault());
    }

    public CurrencyValue(String currencyInfoString, Locale locale) {
        int i = 0;
        this.m_value = null;
        this.m_currencyCode = null;
        this.m_conversionDate = new Timestamp(0L);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        StringTokenizer input = new StringTokenizer(currencyInfoString);
        while (input.hasMoreTokens()) {
            switch (i++) {
                case 0: {
                    try {
                        Number number = NumberFormat.getInstance(locale).parse(input.nextToken());
                        this.m_value = new BigDecimal(number.toString());
                    }
                    catch (ParseException number) {}
                    break;
                }
                case 1: {
                    this.m_currencyCode = input.nextToken();
                    break;
                }
                case 2: {
                    String nextToken = input.nextToken();
                    Long newLong = new Long(nextToken);
                    long newLong2 = newLong;
                    this.m_conversionDate = new Timestamp(newLong2);
                    break;
                }
            }
            if (i != 3) continue;
            break;
        }
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Value", this.m_value).append("Currency Code", this.m_currencyCode).append("Conversion Date", this.m_conversionDate).append("Func Currency List", this.m_funcCurrencyList).toString();
    }

    public BigDecimal getValue() {
        return this.m_value;
    }

    public String getValueString() {
        return ConversionUtil.getStringValue(this.m_value);
    }

    public void setValue(BigDecimal value) {
        this.m_value = value;
    }

    public String getCurrencyCode() {
        return this.m_currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.m_currencyCode = currencyCode;
    }

    public Timestamp getConversionDate() {
        return this.m_conversionDate;
    }

    public void setConversionDate(long ConversionDate) {
        this.m_conversionDate = new Timestamp(ConversionDate);
    }

    public List<FuncCurrencyInfo> getFuncCurrencyList() {
        return this.m_funcCurrencyList;
    }

    public void setFuncCurrencyList(List<FuncCurrencyInfo> funcCurrencyList) {
        this.m_funcCurrencyList = funcCurrencyList;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CurrencyValue)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CurrencyValue rhs = (CurrencyValue)obj;
        return new EqualsBuilder().append(this.m_value, rhs.m_value).append(this.m_currencyCode, rhs.m_currencyCode).append(this.m_conversionDate, rhs.m_conversionDate).append(this.m_funcCurrencyList, rhs.m_funcCurrencyList).isEquals();
    }

    public Object clone() throws CloneNotSupportedException {
        CurrencyValue obj = (CurrencyValue)super.clone();
        if (this.m_conversionDate != null) {
            obj.m_conversionDate = (Timestamp)this.m_conversionDate.clone();
        }
        if (this.m_funcCurrencyList != null) {
            int nLen = this.m_funcCurrencyList.size();
            obj.m_funcCurrencyList = new ArrayList<FuncCurrencyInfo>(nLen);
            for (int i = 0; i < nLen; ++i) {
                obj.m_funcCurrencyList.add((FuncCurrencyInfo)this.m_funcCurrencyList.get(i).clone());
            }
        }
        return obj;
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.m_value = ConversionUtil.getBigDecimalValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.m_currencyCode = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 1));
        this.m_conversionDate = new Timestamp(ConversionUtil.getLongValue(ARTypeMgr.GetAt((Object)rawData, 2)));
        this.m_funcCurrencyList = ARTypeMgr.getInstance().ObjectListFromVariant(FuncCurrencyInfo.class, ARTypeMgr.GetAt((Object)rawData, 3), ctx);
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[]{ConversionUtil.getStringValue(this.m_value), this.m_currencyCode, ConversionUtil.getARTimestamp(this.m_conversionDate), ARTypeMgr.getInstance().ObjectListToVariant(this.m_funcCurrencyList, ctx)};
        return var;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_value).append(this.m_currencyCode).append(this.m_conversionDate).append(this.m_funcCurrencyList).toHashCode();
    }

    static CurrencyValue deserializeFromObjectStr(String bufStr) {
        int len;
        BigDecimal value = null;
        String correncyCode = null;
        Timestamp date = null;
        StringTokenizer t = new StringTokenizer(bufStr, "\\");
        if (t.hasMoreTokens() && (len = new Integer(t.nextToken()).intValue()) > 0 && t.hasMoreTokens()) {
            value = new BigDecimal(t.nextToken());
        }
        if (t.hasMoreTokens() && (len = new Integer(t.nextToken()).intValue()) > 0 && t.hasMoreTokens()) {
            correncyCode = t.nextToken();
        }
        if (t.hasMoreTokens()) {
            date = new Timestamp(new Long(t.nextToken()));
        }
        ArrayList<FuncCurrencyInfo> funcList = new ArrayList<FuncCurrencyInfo>();
        if (t.hasMoreTokens()) {
            int listLen = new Integer(t.nextToken());
            int l = 0;
            String str = null;
            for (int i = 0; i < listLen; ++i) {
                BigDecimal funcValue = null;
                String funcCode = null;
                if (t.hasMoreTokens()) {
                    l = new Integer(t.nextToken());
                }
                if (l > 0 && t.hasMoreTokens()) {
                    str = t.nextToken();
                    if (str == null) {
                        str = "";
                    }
                    funcValue = new BigDecimal(str);
                }
                if (t.hasMoreTokens()) {
                    l = new Integer(t.nextToken());
                }
                if (l > 0 && t.hasMoreTokens()) {
                    str = t.nextToken();
                    if (str == null) {
                        str = "";
                    }
                    funcCode = str;
                }
                funcList.add(new FuncCurrencyInfo(funcValue, funcCode));
            }
        }
        return new CurrencyValue(value, correncyCode, date, funcList);
    }

    public static String checkDecimalFormat(String value) throws ARException {
        String newValue = value;
        if (".".equals(value) || "".equals(value) || value == null) {
            newValue = "0";
        }
        try {
            new BigDecimal(newValue);
        }
        catch (NumberFormatException e) {
            throw new ARException(2, 8735, value);
        }
        return newValue;
    }

    public BigDecimal toFunctionalValue(String currencyCode) {
        List<FuncCurrencyInfo> functionalList;
        if (currencyCode != null && (functionalList = this.getFuncCurrencyList()) != null) {
            for (FuncCurrencyInfo info : functionalList) {
                if (info == null || !currencyCode.equals(info.getCurrencyCode())) continue;
                return info.getValue();
            }
        }
        return null;
    }
}

