/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Action;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ActiveLinkCriteria;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.IARPersistentObject;
import com.bmc.arsys.api.ObjectBase;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OpenWindowAction;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.Session;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActiveLink
extends ObjectBase
implements IARPersistentObject,
Cloneable,
Serializable {
    private static final long serialVersionUID = -730472647827038630L;
    private int m_order;
    private List<String> m_formList;
    private List<Integer> m_groupList;
    private int m_executeMask;
    private int m_controlField;
    private int m_focusField;
    private boolean m_enable;
    private QualifierInfo m_query;
    private List<ActiveLinkAction> m_actionList;
    private List<ActiveLinkAction> m_elseList;
    private ObjectPropertyMap m_objPropList;
    private int m_errorActlinkOptions;
    private String m_errorActlinkName;
    private List<Integer> m_AssignedGroup;
    private static Logger logger = Logger.getLogger(ActiveLink.class);

    public ActiveLink() {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.hashValues = new Integer[21];
    }

    public ActiveLink(int order, List<String> formList, List<Integer> groupList, int executeMask, int controlField, int focusField, boolean enable, QualifierInfo query, List<ActiveLinkAction> actionList, List<ActiveLinkAction> elseList, ObjectPropertyMap objPropList, String name, String helpText, int lastUpdateTime, String owner, String lastChangedBy, String diaryStr) {
        super(name, null, helpText, lastUpdateTime, owner, lastChangedBy, diaryStr);
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        if (order == 0) {
            this.m_order = order;
        } else {
            this.setOrder(order);
        }
        if (formList == null || formList.isEmpty()) {
            this.m_formList = formList;
        } else {
            this.setFormList(formList);
        }
        if (this.m_groupList == null || this.m_groupList.isEmpty()) {
            this.m_groupList = groupList;
        } else {
            this.setGroupList(groupList);
        }
        if (executeMask == 0) {
            this.m_executeMask = executeMask;
        } else {
            this.setExecuteMask(executeMask);
        }
        if (controlField == 0) {
            this.m_controlField = controlField;
        } else {
            this.setControlField(controlField);
        }
        if (focusField == 0) {
            this.m_focusField = focusField;
        } else {
            this.setFocusField(focusField);
        }
        if (!enable) {
            this.m_enable = enable;
        } else {
            this.setEnable(enable);
        }
        if (query == null) {
            this.m_query = query;
        } else {
            this.setQualifier(query);
        }
        if (actionList == null || actionList.isEmpty()) {
            this.m_actionList = actionList;
        } else {
            this.setActionList(actionList);
        }
        if (elseList == null || elseList.isEmpty()) {
            this.m_elseList = elseList;
        } else {
            this.setElseList(elseList);
        }
        if (objPropList == null || objPropList.isEmpty()) {
            this.m_objPropList = objPropList;
        } else {
            this.setProperties(objPropList);
        }
        this.hashValues = new Integer[21];
        this.calculateHashCode();
    }

    @Override
    protected void createChangeFlags() {
        this.m_changeFlags = new ActiveLinkCriteria();
    }

    private void fromVariantDuringGet(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.setName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 3)));
        this.setOrder(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 4)));
        this.setFormList(ARTypeMgr.getInstance().ObjectListFromVariant(String.class, ARTypeMgr.GetAt((Object)rawData, new int[]{5, 1}), ctx));
        Session session = ctx.getSession();
        session.setCurrentObjectType(6);
        session.setSecondaryServerName(Session.makeServerName(ctx.getServer(), ctx.getPort()));
        session.setCurrentLocalForm(this.getPrimaryForm());
        session.setCurrentRemoteForm(this.getPrimaryForm());
        session.setCurrentFieldId(8);
        this.setGroupList(ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, ARTypeMgr.GetAt((Object)rawData, 6), ctx));
        this.setExecuteMask(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 7)));
        this.setControlField(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 8)));
        this.setFocusField(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 9)));
        this.setEnable(ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)rawData, 10)));
        this.setQualifier(ARTypeMgr.getInstance().ObjectFromVariant(QualifierInfo.class, ARTypeMgr.GetAt((Object)rawData, 11), ctx));
        this.setActionList(ARTypeMgr.getInstance().ObjectListFromVariant(Action.class, ARTypeMgr.GetAt((Object)rawData, 12), ctx));
        this.setElseList(ARTypeMgr.getInstance().ObjectListFromVariant(Action.class, ARTypeMgr.GetAt((Object)rawData, 13), ctx));
        this.setHelpText(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 14)));
        this.setLastUpdateTime(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 15)));
        this.setOwner(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 16)));
        this.setLastChangedBy(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 17)));
        this.setDiary(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 18)));
        this.setProperties(ARTypeMgr.getInstance().ObjectFromVariant(ObjectPropertyMap.class, ARTypeMgr.GetAt((Object)rawData, 19), ctx));
        if (this.m_actionList != null) {
            this.parseOpenWindowSampleInfo(60016);
        }
        if (this.m_elseList != null) {
            this.parseOpenWindowSampleInfo(60017);
        }
        this.setErrorActlinkOptions(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 20)));
        this.setErrorActlinkName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 21)));
    }

    void fromVariantDuringSet(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.setName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 3)));
        this.setOrder(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 4)));
        this.setFormList(ARTypeMgr.getInstance().ObjectListFromVariant(String.class, ARTypeMgr.GetAt((Object)rawData, new int[]{5, 1}), ctx));
        this.setGroupList(ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, ARTypeMgr.GetAt((Object)rawData, 6), ctx));
        this.setExecuteMask(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 7)));
        this.setControlField(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 8)));
        this.setFocusField(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 9)));
        this.setEnable(ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)rawData, 10)));
        this.setQualifier(ARTypeMgr.getInstance().ObjectFromVariant(QualifierInfo.class, ARTypeMgr.GetAt((Object)rawData, 11), ctx));
        this.setActionList(ARTypeMgr.getInstance().ObjectListFromVariant(Action.class, ARTypeMgr.GetAt((Object)rawData, 12), ctx));
        this.setElseList(ARTypeMgr.getInstance().ObjectListFromVariant(Action.class, ARTypeMgr.GetAt((Object)rawData, 13), ctx));
        this.setHelpText(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 14)));
        this.setLastUpdateTime(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 15)));
        this.setOwner(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 16)));
        this.setLastChangedBy(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 17)));
        this.setDiary(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 18)));
        this.setProperties(ARTypeMgr.getInstance().ObjectFromVariant(ObjectPropertyMap.class, ARTypeMgr.GetAt((Object)rawData, 19), ctx));
        this.setErrorActlinkOptions(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 20)));
        this.setErrorActlinkName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 21)));
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.fromVariantDuringGet(rawData, ctx);
    }

    static ActiveLink createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        ActiveLink obj = new ActiveLink();
        obj.fromVariant(rawData, ctx);
        return obj;
    }

    static List<ActiveLink> buildGMALResponse(Object[] rawData, ARServerUser ctx) {
        int count;
        ArrayList<ActiveLink> objectList = new ArrayList<ActiveLink>();
        assert (rawData != null && rawData.length == 25);
        int n = count = rawData[5] != null ? ARTypeMgr.GetArrayLength(rawData[5]) : 0;
        assert (count == ARTypeMgr.GetArrayLength(rawData[6]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[7]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[8]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[9]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[10]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[11]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[12]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[13]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[14]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[15]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[16]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[17]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[18]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[19]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[20]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[21]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[22]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[21]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[22]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[23]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[24]));
        for (int i = 0; i < count; ++i) {
            ActiveLink obj = null;
            if (!ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)rawData, new int[]{5, i}))) continue;
            Object[] curRawData = new Object[]{0, null, ctx, ARTypeMgr.GetAt((Object)rawData, new int[]{6, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{7, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{8, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{9, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{10, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{11, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{12, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{13, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{14, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{15, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{16, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{17, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{18, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{19, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{20, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{21, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{22, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{21, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{22, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{23, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{24, i})};
            obj = ActiveLink.createInstance(curRawData, ctx);
            objectList.add(obj);
        }
        return objectList;
    }

    @Override
    public void clear() {
    }

    public int getOrder() {
        return this.m_order;
    }

    public void setOrder(int order) {
        this.m_order = order;
        this.m_changeFlags.setParameter(8L, true);
    }

    public int getExecuteMask() {
        return this.m_executeMask;
    }

    public void setExecuteMask(int executeMask) {
        this.m_executeMask = executeMask;
        this.m_changeFlags.setParameter(10L, true);
    }

    public int getControlField() {
        return this.m_controlField;
    }

    public void setControlField(int controlField) {
        this.m_controlField = controlField;
        this.m_changeFlags.setParameter(11L, true);
    }

    public int getFocusField() {
        return this.m_focusField;
    }

    public void setFocusField(int focusField) {
        this.m_focusField = focusField;
        this.m_changeFlags.setParameter(12L, true);
    }

    public boolean isEnable() {
        return this.m_enable;
    }

    public void setEnable(boolean enable) {
        this.m_enable = enable;
        this.m_changeFlags.setParameter(13L, true);
    }

    public List<String> getFormList() {
        if (this.m_formList == null) {
            this.m_formList = new ArrayList<String>();
        }
        return this.m_formList;
    }

    public void setFormList(List<String> formList) {
        if (this.m_formList == formList) {
            return;
        }
        this.m_formList = new ArrayList<String>();
        this.m_formList.addAll(formList);
        this.m_changeFlags.setParameter(9L, true);
    }

    public String getPrimaryForm() {
        List<String> formList = this.getFormList();
        if (formList != null && formList.size() > 0) {
            return formList.get(0);
        }
        return null;
    }

    public void setPrimaryForm(String primaryForm) {
        List<String> formList = this.getFormList();
        formList.remove(primaryForm);
        formList.add(0, primaryForm);
    }

    public List<Integer> getGroupList() {
        return this.m_groupList;
    }

    public void setGroupList(List<Integer> groupList) {
        this.m_groupList = groupList;
        if (this.m_groupList != null) {
            this.m_groupList = new ArrayList<Integer>(groupList);
        }
        this.m_AssignedGroup = new ArrayList<Integer>(groupList);
        ArrayList<PermissionInfo> permissions = new ArrayList<PermissionInfo>();
        PermissionInfo permission = null;
        for (Integer grpId : this.m_groupList) {
            permission = new PermissionInfo(grpId);
            permissions.add(permission);
        }
        this.m_permissionList = permissions;
        this.m_changeFlags.setParameter(1L, true);
    }

    public QualifierInfo getQualifier() {
        return this.m_query;
    }

    public void setQualifier(QualifierInfo query) {
        this.m_query = query;
        this.m_changeFlags.setParameter(14L, true);
    }

    public ObjectPropertyMap getProperties() {
        return this.m_objPropList;
    }

    public void setProperties(ObjectPropertyMap objPropList) {
        this.m_objPropList = objPropList;
        this.m_changeFlags.setParameter(7L, true);
    }

    public List<ActiveLinkAction> getActionList() {
        return this.m_actionList;
    }

    public void setActionList(List<ActiveLinkAction> actionList) {
        this.m_actionList = actionList;
        this.m_changeFlags.setParameter(15L, true);
    }

    public List<ActiveLinkAction> getElseList() {
        return this.m_elseList;
    }

    public void setElseList(List<ActiveLinkAction> elseList) {
        this.m_elseList = elseList;
        this.m_changeFlags.setParameter(16L, true);
    }

    public String getKey() {
        return this.getName();
    }

    public void setKey(String key) {
        this.setName(key);
    }

    public int getErrorActlinkOptions() {
        return this.m_errorActlinkOptions;
    }

    public void setErrorActlinkOptions(int errorActlinkOptions) {
        this.m_errorActlinkOptions = errorActlinkOptions;
        this.m_changeFlags.setParameter(17L, true);
    }

    public String getErrorActlinkName() {
        return this.m_errorActlinkName;
    }

    public void setErrorActlinkName(String errorActlinkName) {
        this.m_errorActlinkName = errorActlinkName;
        this.m_changeFlags.setParameter(18L, true);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        int nLen;
        ActiveLink obj = (ActiveLink)super.clone();
        this.m_permissionList = new ArrayList();
        if (this.m_formList != null) {
            obj.m_formList = null;
            obj.setFormList(this.m_formList);
        }
        if (this.m_groupList != null) {
            nLen = this.m_groupList.size();
            obj.m_groupList = new ArrayList<Integer>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_groupList.add(i, new Integer(this.m_groupList.get(i)));
                this.m_permissionList.add(new PermissionInfo(this.m_groupList.get(i)));
            }
        }
        if (this.m_query != null) {
            obj.setQualifier((QualifierInfo)this.m_query.clone());
        }
        if (this.m_actionList != null) {
            nLen = this.m_actionList.size();
            obj.m_actionList = new ArrayList<ActiveLinkAction>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_actionList.add(i, (ActiveLinkAction)((Action)((Object)this.m_actionList.get(i))).clone());
            }
        }
        if (this.m_elseList != null) {
            nLen = this.m_elseList.size();
            obj.m_elseList = new ArrayList<ActiveLinkAction>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_elseList.add(i, (ActiveLinkAction)((Action)((Object)this.m_elseList.get(i))).clone());
            }
        }
        if (this.m_objPropList != null) {
            obj.m_objPropList = new ObjectPropertyMap();
            Set keys = this.m_objPropList.keySet();
            for (Integer key : keys) {
                obj.m_objPropList.put(key, (Value)((Value)this.m_objPropList.get(key)).clone());
            }
        }
        if (this.m_changeFlags != null) {
            obj.m_changeFlags = (ActiveLinkCriteria)this.m_changeFlags.clone();
        }
        this.calculateHashCode();
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ActiveLink)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ActiveLink rhs = (ActiveLink)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_order, rhs.m_order).append(this.m_formList, rhs.m_formList).append(this.m_groupList, rhs.m_groupList).append(this.m_executeMask, rhs.m_executeMask).append(this.m_controlField, rhs.m_controlField).append(this.m_focusField, rhs.m_focusField).append(this.m_enable, rhs.m_enable).append(this.m_query, rhs.m_query).append(this.m_actionList, rhs.m_actionList).append(this.m_elseList, rhs.m_elseList).append(this.m_objPropList, rhs.m_objPropList).append(this.m_errorActlinkOptions, rhs.m_errorActlinkOptions).append(this.m_errorActlinkName, rhs.m_errorActlinkName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_order).append(this.m_formList).append(this.m_groupList).append(this.m_executeMask).append(this.m_controlField).append(this.m_focusField).append(this.m_enable).append(this.m_query).append(this.m_actionList).append(this.m_elseList).append(this.m_objPropList).append(this.m_errorActlinkOptions).append(this.m_errorActlinkName).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Order", this.m_order).append("Workflow Connect", this.m_formList).append("Group List", this.m_groupList).append("Execute Mask", this.m_executeMask).append("Control Field", this.m_controlField).append("Focus Field", this.m_focusField).append("Enable", this.m_enable).append("Query", this.m_query).append("Action List", this.m_actionList).append("Else List", this.m_elseList).append("Obj Prop List", this.m_objPropList).append("Error Actlink Option", this.m_errorActlinkOptions).append("Error Actlink Name", this.m_errorActlinkName).toString();
    }

    final void preprocessInActiveLink() {
        ObjectBaseCriteria savedChangeFlag = null;
        try {
            savedChangeFlag = (ObjectBaseCriteria)this.m_changeFlags.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error(e);
        }
        this.encodeOpenWindowSampleInfoInObjProps(this.m_actionList, 60016);
        this.fixOpenWindowReportString(this.m_actionList);
        this.encodeOpenWindowSampleInfoInObjProps(this.m_elseList, 60017);
        this.fixOpenWindowReportString(this.m_elseList);
        this.setChangeFlags(savedChangeFlag);
    }

    final void postprocessInActiveLink(ARServerUser context) throws ARException {
        this.updateOpenWinRptFilesInServer(context, this.m_actionList);
        this.updateOpenWinRptFilesInServer(context, this.m_elseList);
    }

    final void postprocessGroupListInActiveLink(ARServerUser context) throws ARException {
        List<StatusInfo> statusList = null;
        if (this.m_groupList == null || this.m_groupList.size() == 0) {
            statusList = context.getLastStatus();
            if (statusList == null) {
                statusList = new ArrayList<StatusInfo>();
            }
            statusList.add(new StatusInfo(1, 71L, ""));
        }
    }

    private void updateOpenWinRptFilesInServer(ARServerUser context, List<ActiveLinkAction> actionList) throws ARException {
        if (actionList == null) {
            return;
        }
        ArrayList<StatusInfo> statusList = null;
        for (ActiveLinkAction action : actionList) {
            if (!(action instanceof OpenWindowAction)) continue;
            try {
                ((OpenWindowAction)action).updateReportFileInServer(context, this.getName());
            }
            catch (ARException ex) {
                List<StatusInfo> lastStatus = ex.getLastStatus();
                for (StatusInfo status : lastStatus) {
                    if (status.getMessageType() < 2) continue;
                    status.setMessageType(1);
                }
                if (statusList == null) {
                    statusList = new ArrayList<StatusInfo>();
                }
                statusList.addAll(lastStatus);
            }
        }
        if (statusList != null) {
            List<StatusInfo> lastState = context.getLastStatus();
            if (lastState != null && !lastState.isEmpty()) {
                for (StatusInfo status : lastState) {
                    if (status.getMessageType() < 2) continue;
                    status.setMessageType(1);
                }
            }
            statusList.add(new StatusInfo(1, 451L, ""));
            throw new ARException((List<StatusInfo>)statusList);
        }
    }

    private void fixOpenWindowReportString(List<ActiveLinkAction> actionList) {
        OpenWindowAction openWin;
        if (actionList == null) {
            return;
        }
        int nextFileId = 0;
        for (ActiveLinkAction action : actionList) {
            if (!(action instanceof OpenWindowAction) || (openWin = (OpenWindowAction)action).getReportInfo() == null || openWin.getReportInfo().getReportFileId() < nextFileId) continue;
            nextFileId = openWin.getReportInfo().getReportFileId() + 1;
        }
        for (ActiveLinkAction action : actionList) {
            if (!(action instanceof OpenWindowAction) || (openWin = (OpenWindowAction)action).getReportInfo() == null) continue;
            nextFileId = openWin.getReportInfo().selfRepair(nextFileId);
        }
    }

    private void encodeOpenWindowSampleInfoInObjProps(List<ActiveLinkAction> actionList, int objPropId) {
        if (actionList == null) {
            return;
        }
        int index = 0;
        ArrayList<String> infoList = new ArrayList<String>();
        for (ActiveLinkAction action : actionList) {
            if (action instanceof OpenWindowAction) {
                String server = ((OpenWindowAction)action).getSampleServer();
                String form = ((OpenWindowAction)action).getSampleForm();
                if (server != null && server.length() > 0 || form != null && form.length() > 0) {
                    StringBuffer info = new StringBuffer();
                    info.append(index).append("\\");
                    if (server == null) {
                        info.append("");
                    } else {
                        info.append(server);
                    }
                    info.append("\\");
                    if (form == null) {
                        info.append("");
                    } else {
                        info.append(form);
                    }
                    infoList.add(info.toString());
                }
            }
            ++index;
        }
        String propValue = null;
        if (infoList != null && !infoList.isEmpty()) {
            int numberOfItems = infoList.size();
            StringBuffer result = new StringBuffer();
            result.append(infoList.size()).append("\\");
            for (String infoItem : infoList) {
                result.append(infoItem);
                if (numberOfItems > 1) {
                    result.append("\\");
                }
                --numberOfItems;
            }
            propValue = result.toString();
        }
        if (propValue != null && propValue.length() > 0) {
            if (this.m_objPropList == null) {
                this.m_objPropList = new ObjectPropertyMap();
            }
            this.m_objPropList.put(objPropId, new Value(propValue));
            this.m_changeFlags.setParameter(7L, true);
        }
    }

    final void parseOpenWindowSampleInfo(int property) {
        if (property != 60016 && property != 60017) {
            return;
        }
        if ((this.m_actionList == null || this.m_actionList != null && this.m_actionList.isEmpty()) && (this.m_elseList == null || this.m_elseList != null && this.m_elseList.isEmpty())) {
            return;
        }
        if (this.m_objPropList != null && this.m_objPropList.containsKey(property)) {
            String[] info;
            Value val = (Value)this.m_objPropList.get(property);
            if (val == null) {
                return;
            }
            String stringValue = (String)val.getValue();
            int firstIndex = stringValue.indexOf("\\");
            if (firstIndex < 1) {
                return;
            }
            int numItems = Integer.parseInt(stringValue.substring(0, firstIndex));
            StringBuffer buffer = new StringBuffer(stringValue);
            buffer.delete(0, buffer.indexOf("\\") + 1);
            HashMap<Integer, String[]> actionInfo = new HashMap<Integer, String[]>(numItems);
            for (int valLoop = 0; valLoop < numItems; ++valLoop) {
                String form;
                int key = Integer.parseInt(buffer.substring(0, buffer.indexOf("\\")));
                buffer.delete(0, buffer.indexOf("\\") + 1);
                String server = buffer.substring(0, buffer.indexOf("\\"));
                buffer.delete(0, buffer.indexOf("\\") + 1);
                if (valLoop == numItems - 1) {
                    form = buffer.toString();
                } else {
                    form = buffer.substring(0, buffer.indexOf("\\"));
                    buffer.delete(0, buffer.indexOf("\\") + 1);
                }
                info = new String[]{server, form};
                actionInfo.put(key, info);
            }
            for (Integer actionIndex : actionInfo.keySet()) {
                int key = actionIndex;
                ActiveLinkAction action = null;
                switch (property) {
                    case 60016: {
                        if (this.m_actionList == null) break;
                        action = this.m_actionList.get(key);
                        break;
                    }
                    case 60017: {
                        if (this.m_elseList == null) break;
                        action = this.m_elseList.get(key);
                        break;
                    }
                    default: {
                        action = null;
                    }
                }
                if (action == null || !(action instanceof OpenWindowAction)) continue;
                info = (String[])actionInfo.get(actionIndex);
                ((OpenWindowAction)action).setSampleServer(info[0]);
                ((OpenWindowAction)action).setSampleForm(info[1]);
            }
        }
    }

    @Override
    void calculateHashCode() {
        if (this.hashValues == null) {
            this.hashValues = new Integer[21];
        }
        super.calculateHashCode();
        this.hashValues[1] = this.m_permissionList != null && !this.m_permissionList.isEmpty() ? Integer.valueOf(this.m_permissionList.hashCode()) : null;
        this.hashValues[7] = this.m_objPropList != null && !this.m_objPropList.isEmpty() ? Integer.valueOf(this.m_objPropList.hashCode()) : null;
        this.hashValues[9] = this.m_formList != null && !this.m_formList.isEmpty() ? Integer.valueOf(this.m_formList.hashCode()) : null;
        this.hashValues[14] = this.m_query != null ? Integer.valueOf(this.m_query.hashCode()) : null;
        this.hashValues[15] = this.m_actionList != null && !this.m_actionList.isEmpty() ? Integer.valueOf(this.m_actionList.hashCode()) : null;
        this.hashValues[16] = this.m_elseList != null && !this.m_elseList.isEmpty() ? Integer.valueOf(this.m_elseList.hashCode()) : null;
    }

    @Override
    void calculateHashCodeOnGet(ObjectBaseCriteria criteria) {
        super.calculateHashCodeOnGet(criteria == null ? new ActiveLinkCriteria() : criteria);
    }

    @Override
    void calculateChangeFlagsOnSet() {
        int hashCode;
        if (this.hashValues == null) {
            this.hashValues = new Integer[21];
        }
        super.calculateChangeFlagsOnSet();
        boolean[] changeFlags = this.m_changeFlags.getParameters();
        if (!changeFlags[7]) {
            if (this.m_objPropList != null && !this.m_objPropList.isEmpty()) {
                hashCode = this.m_objPropList.hashCode();
                if (this.hashValues[7] == null || hashCode != this.hashValues[7]) {
                    this.m_changeFlags.setParameter(7L, true);
                }
                this.hashValues[7] = this.m_objPropList != null && !this.m_objPropList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[7] != null) {
                this.m_changeFlags.setParameter(7L, true);
                this.hashValues[7] = null;
            }
        }
        if (!changeFlags[9]) {
            if (this.m_formList != null && !this.m_formList.isEmpty()) {
                hashCode = this.m_formList.hashCode();
                if (this.hashValues[9] == null || hashCode != this.hashValues[9]) {
                    this.m_changeFlags.setParameter(9L, true);
                }
                this.hashValues[9] = this.m_formList != null && !this.m_formList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[9] != null) {
                this.m_changeFlags.setParameter(9L, true);
                this.hashValues[9] = null;
            }
        }
        if (!changeFlags[14]) {
            if (this.m_query != null) {
                hashCode = this.m_query.hashCode();
                if (this.hashValues[14] == null || hashCode != this.hashValues[14]) {
                    this.m_changeFlags.setParameter(14L, true);
                }
                this.hashValues[14] = this.m_query != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[14] != null) {
                this.m_changeFlags.setParameter(14L, true);
                this.hashValues[14] = null;
            }
        }
        if (!changeFlags[16]) {
            if (this.m_elseList != null && !this.m_elseList.isEmpty()) {
                hashCode = this.m_elseList.hashCode();
                if (this.hashValues[16] == null || hashCode != this.hashValues[16]) {
                    this.m_changeFlags.setParameter(16L, true);
                }
                this.hashValues[16] = this.m_elseList != null && !this.m_elseList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[16] != null) {
                this.m_changeFlags.setParameter(16L, true);
                this.hashValues[16] = null;
            }
        }
        if (!changeFlags[15]) {
            if (this.m_actionList != null && !this.m_actionList.isEmpty()) {
                hashCode = this.m_actionList.hashCode();
                if (this.hashValues[15] == null || hashCode != this.hashValues[15]) {
                    this.m_changeFlags.setParameter(15L, true);
                }
                this.hashValues[15] = this.m_actionList != null && !this.m_actionList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[15] != null) {
                this.m_changeFlags.setParameter(15L, true);
                this.hashValues[15] = null;
            }
        }
    }

    public List<Integer> getAssignedGroup() {
        return this.m_AssignedGroup;
    }

    void setAssignedGroup(List<Integer> assignedGroup) {
        this.m_AssignedGroup = assignedGroup;
    }
}

