/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wseb;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.DecoderInput;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedDecoder;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedDecoderListener;
import com.kaazing.gateway.client.html5.util.HexUtil;
import java.util.Arrays;
import java.util.logging.Logger;

public class WebSocketEmulatedDecoderImpl<C>
implements WebSocketEmulatedDecoder<C> {
    private static final String CLASS_NAME = WebSocketEmulatedDecoderImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final byte NOOP_COMMAND = 0;
    private static final byte RECONNECT_COMMAND = 1;
    private static final byte WSF_COMMAND_FRAME_START = 1;
    private static final byte WS_TEXT_FRAME_START = 0;
    private static final byte WS_TEXT_FRAME_END = -1;
    private static final byte WS_BINARY_FRAME_START = -128;
    private DecodingState processingState = DecodingState.START_OF_FRAME;
    private ByteBuffer readBuffer = null;
    private ByteBuffer messageBuffer = null;
    private int binaryFrameLength = 0;

    @Override
    public void decode(C channel, DecoderInput<C> in, WebSocketEmulatedDecoderListener<C> listener) {
        LOG.fine("process() START");
        block4: while (true) {
            if (this.readBuffer == null) {
                this.readBuffer = in.read(channel);
                if (this.readBuffer == null) break;
            }
            if (!this.readBuffer.hasRemaining()) {
                this.readBuffer = null;
                continue;
            }
            if (this.processingState == DecodingState.START_OF_FRAME) {
                byte type = this.readBuffer.get();
                if (type == 0) {
                    this.processingState = DecodingState.READING_TEXT_FRAME;
                    this.messageBuffer = ByteBuffer.allocate(512);
                    continue;
                }
                if (type == 1) {
                    this.processingState = DecodingState.READING_COMMAND_FRAME;
                    this.messageBuffer = ByteBuffer.allocate(512);
                    continue;
                }
                if (type != -128) continue;
                this.processingState = DecodingState.READING_BINARY_FRAME_HEADER;
                this.binaryFrameLength = 0;
                continue;
            }
            if (this.processingState == DecodingState.READING_TEXT_FRAME || this.processingState == DecodingState.READING_COMMAND_FRAME) {
                int endOfFrameAt = this.readBuffer.indexOf((byte)-1);
                if (endOfFrameAt == -1) {
                    int numBytes = this.readBuffer.remaining();
                    this.messageBuffer.putBuffer(this.readBuffer);
                    continue;
                }
                int dataLength = endOfFrameAt - this.readBuffer.position();
                this.messageBuffer.putBytes(this.readBuffer.getBytes(dataLength));
                this.readBuffer.skip(1);
                boolean isCommandFrame = this.processingState == DecodingState.READING_COMMAND_FRAME;
                this.processingState = DecodingState.START_OF_FRAME;
                if (isCommandFrame) {
                    int fromIndex = this.messageBuffer.arrayOffset();
                    int toIndex = fromIndex + this.messageBuffer.remaining();
                    byte[] array = Arrays.copyOfRange(this.messageBuffer.array(), fromIndex, toIndex);
                    byte[] commands = HexUtil.decode(array);
                    int i = 0;
                    while (true) {
                        if (i >= commands.length) continue block4;
                        byte command = commands[i];
                        switch (command) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                listener.commandDecoded(channel, ByteBuffer.wrap(new byte[]{command}));
                            }
                        }
                        ++i;
                    }
                }
                this.messageBuffer.flip();
                listener.messageDecoded(channel, this.messageBuffer.duplicate());
                continue;
            }
            if (this.processingState == DecodingState.READING_BINARY_FRAME_HEADER) {
                byte b;
                do {
                    if (!this.readBuffer.hasRemaining()) continue block4;
                    b = this.readBuffer.get();
                    this.binaryFrameLength <<= 7;
                    this.binaryFrameLength |= b & 0x7F;
                } while ((b & 0x80) == 128);
                this.processingState = DecodingState.READING_BINARY_FRAME;
                this.messageBuffer = ByteBuffer.allocate(this.binaryFrameLength);
                continue;
            }
            if (this.processingState != DecodingState.READING_BINARY_FRAME) continue;
            if (this.readBuffer.remaining() < this.binaryFrameLength) {
                int numbytes = this.readBuffer.remaining();
                this.messageBuffer.putBuffer(this.readBuffer);
                this.binaryFrameLength -= numbytes;
                continue;
            }
            this.messageBuffer.putBytes(this.readBuffer.getBytes(this.binaryFrameLength));
            this.processingState = DecodingState.START_OF_FRAME;
            this.messageBuffer.flip();
            listener.messageDecoded(channel, this.messageBuffer);
        }
    }

    static enum DecodingState {
        START_OF_FRAME,
        READING_TEXT_FRAME,
        READING_COMMAND_FRAME,
        READING_BINARY_FRAME_HEADER,
        READING_BINARY_FRAME;

    }
}

