/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wseb;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.bridge.HttpRequestBridgeHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequest;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestAuthenticationHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestListener;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestRedirectHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpResponse;
import com.kaazing.gateway.client.html5.impl.wseb.CreateChannel;
import com.kaazing.gateway.client.html5.impl.wseb.CreateHandler;
import com.kaazing.gateway.client.html5.impl.wseb.CreateHandlerFactory;
import com.kaazing.gateway.client.html5.impl.wseb.CreateHandlerListener;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedHandler;
import com.kaazing.gateway.client.html5.util.HttpURI;
import java.util.logging.Level;
import java.util.logging.Logger;

class CreateHandlerImpl
implements CreateHandler {
    private static final String CLASS_NAME = CreateHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static CreateHandlerFactory FACTORY = new CreateHandlerFactory(){

        @Override
        public CreateHandler createCreateHandler() {
            return new CreateHandlerImpl();
        }
    };
    private static final String HEADER_SEC_EXTENSIONS = "X-WebSocket-Extensions";
    HttpRequestHandler nextHandler;
    CreateHandlerListener listener;
    HttpRequestAuthenticationHandler authHandler = new HttpRequestAuthenticationHandler();
    HttpRequestRedirectHandler redirectHandler = new HttpRequestRedirectHandler();
    HttpRequestBridgeHandler bridgeHandler = new HttpRequestBridgeHandler();

    public CreateHandlerImpl() {
        this.setNextHandler(this.authHandler);
        this.authHandler.setNextHandler(this.redirectHandler);
        this.redirectHandler.setNextHandler(this.bridgeHandler);
    }

    @Override
    public void processOpen(CreateChannel channel, HttpURI location) {
        HttpRequest request = HttpRequest.HTTP_REQUEST_FACTORY.createHttpRequest(HttpRequest.Method.GET, location, false);
        request.getHeaders().put(HEADER_SEC_EXTENSIONS, "x-kaazing-http-revalidate");
        request.parent = channel;
        this.nextHandler.processOpen(request);
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
            }

            @Override
            public void requestOpened(HttpRequest request) {
            }

            @Override
            public void requestProgressed(HttpRequest request, ByteBuffer data) {
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                WebSocketEmulatedHandler.LOG.entering(WebSocketEmulatedHandler.CLASS_NAME, "requestLoaded");
                CreateChannel channel = (CreateChannel)request.parent;
                try {
                    channel.cookie = response.getHeader("Set-Cookie");
                    String extensionsHeader = response.getHeader(CreateHandlerImpl.HEADER_SEC_EXTENSIONS);
                    if (extensionsHeader != null && extensionsHeader.length() > 0) {
                        String[] extensions;
                        for (String extension : extensions = extensionsHeader.split(",")) {
                            String[] tmp = extension.split(";");
                            if (tmp.length <= 1) continue;
                            String escape = tmp[1].trim();
                            channel.controlFrames.put(Integer.parseInt(escape, 16), tmp[0].trim());
                        }
                    }
                    ByteBuffer responseBody = response.getBody();
                    String urls = responseBody.getString(WebSocketEmulatedHandler.UTF_8);
                    String[] parts = urls.split("\n");
                    HttpURI upstreamUri = new HttpURI(parts[0]);
                    HttpURI downstreamUri = new HttpURI(parts.length == 2 ? parts[1] : parts[0]);
                    CreateHandlerImpl.this.listener.createCompleted(channel, upstreamUri, downstreamUri);
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                    CreateHandlerImpl.this.listener.createFailed(channel);
                    throw new IllegalStateException("WebSocketEmulation failed", e);
                }
            }

            @Override
            public void requestAborted(HttpRequest request) {
            }

            @Override
            public void requestClosed(HttpRequest request) {
            }

            @Override
            public void errorOccurred(HttpRequest request) {
                CreateChannel createChannel = (CreateChannel)request.parent;
                CreateHandlerImpl.this.listener.createFailed(createChannel);
            }
        });
    }

    @Override
    public void setListener(CreateHandlerListener listener) {
        this.listener = listener;
    }
}

