/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl;

import com.kaazing.gateway.client.html5.ByteBuffer;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;

public class WebSocketUtil {
    private static final String CLASS_NAME = WebSocketUtil.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    public static void encodeLength(ByteArrayOutputStream out, int length) {
        LOG.entering(CLASS_NAME, "encodeLength", new Object[]{out, length});
        int byteCount = 0;
        int encodedLength = 0;
        do {
            encodedLength <<= 8;
            encodedLength |= (byte)(length & 0x7F);
            ++byteCount;
        } while ((length >>= 7) > 0);
        do {
            byte encodedByte = (byte)(encodedLength & 0xFF);
            encodedLength >>= 8;
            if (byteCount != 1) {
                encodedByte = (byte)(encodedByte | 0xFFFFFF80);
            }
            out.write(encodedByte);
        } while (--byteCount > 0);
    }

    public static void encodeLength(ByteBuffer buf, int length) {
        LOG.entering(CLASS_NAME, "encodeLength", new Object[]{buf, length});
        int byteCount = 0;
        int encodedLength = 0;
        do {
            encodedLength <<= 8;
            encodedLength |= (byte)(length & 0x7F);
            ++byteCount;
        } while ((length >>= 7) > 0);
        do {
            byte encodedByte = (byte)(encodedLength & 0xFF);
            encodedLength >>= 8;
            if (byteCount != 1) {
                encodedByte = (byte)(encodedByte | 0xFFFFFF80);
            }
            buf.put(encodedByte);
        } while (--byteCount > 0);
    }
}

