/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARKeyMask;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class ARSecretKeyFactory {
    private transient Map<String, SecretKey> secretKeyInstanceMap = new ConcurrentHashMap<String, SecretKey>();
    private static final transient ARSecretKeyFactory instance = new ARSecretKeyFactory();

    private ARSecretKeyFactory() {
    }

    static ARSecretKeyFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecretKey getSecretKeyInstance(String encType, AREncKeyBase encKey) throws AREncryptionException {
        SecretKey key;
        String instStr = encKey.toString();
        if (this.isKeyCacheEnabled(encKey)) {
            Map<String, SecretKey> map = this.secretKeyInstanceMap;
            synchronized (map) {
                if (!this.secretKeyInstanceMap.containsKey(instStr)) {
                    key = this.generateSecretKeyInstance(encType, encKey);
                    this.secretKeyInstanceMap.put(instStr, key);
                }
                key = this.secretKeyInstanceMap.get(instStr);
            }
        } else {
            key = this.generateSecretKeyInstance(encType, encKey);
        }
        return key;
    }

    private boolean isKeyCacheEnabled(AREncKeyBase encKey) {
        return false;
    }

    private SecretKey generateSecretKeyInstance(String encType, AREncKeyBase encKey) throws AREncryptionException {
        SecretKey key;
        if (encType.equals("Salt") && encKey.getKey() != null && encKey.getKey().length == 8) {
            key = new SecretKeySpec(ARKeyMask.getUnMaskedKeyBytes(encKey, ARKeyMask.Idx.K), encKey.getEncAlgorithmStr());
        } else if (encType.equals("MacGen") && encKey instanceof ARDataKey) {
            key = new SecretKeySpec(ARKeyMask.getUnMaskedKeyBytes(encKey, ARKeyMask.Idx.M), encKey.getEncAlgorithmStr());
        } else if (encType.equals("MD")) {
            key = null;
        } else if (encType.equals("Enc") && encKey.getKey() != null) {
            key = new SecretKeySpec(ARKeyMask.getUnMaskedKeyBytes(encKey, ARKeyMask.Idx.K), encKey.getEncAlgorithmStr());
        } else {
            try {
                KeyGenerator kg = KeyGenerator.getInstance(encKey.getEncAlgorithmStr());
                kg.init(encKey.getKeySize());
                key = kg.generateKey();
            }
            catch (NoSuchAlgorithmException e) {
                throw new AREncryptionException(e, 9007);
            }
        }
        return key;
    }
}

