/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncEnginePool;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.utils.LogBytes;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ARPublicKey
extends ARPPKey {
    @Override
    protected Key getRsaKey() throws AREncryptionException {
        RSAPublicKeySpec PubKey = new RSAPublicKeySpec(this.getBigModulus(), this.getBigExponent());
        try {
            String provider = this.getProvider();
            KeyFactory keyFactory = provider != null ? KeyFactory.getInstance(this.getEncAlgorithmStr(), provider) : KeyFactory.getInstance(this.getEncAlgorithmStr());
            this.encKey = (RSAPublicKey)keyFactory.generatePublic(PubKey);
            if (this.debug) {
                LogBytes.printByteArrayAsHex(((RSAPublicKey)this.encKey).getModulus().toByteArray(), "RSA public Modulus: \n");
                LogBytes.printByteArrayAsHex(((RSAPublicKey)this.encKey).getPublicExponent().toByteArray(), "RSA public Exponent: \n");
            }
        }
        catch (Exception e) {
            throw new AREncryptionException(e, 9006);
        }
        return this.encKey;
    }

    @Override
    protected void setKeyID() {
        this.keyID = "PubKey";
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.keyID).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AREncEnginePool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ARPublicKey rhs = (ARPublicKey)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.keyID, (Object)rhs.keyID).isEquals();
    }
}

