/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wsn;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandler;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.util.HexUtil;
import java.nio.charset.Charset;

public class WebSocketNativeControlFrameHandler
extends WebSocketHandlerAdapter {
    @Override
    public void processBinaryMessage(WebSocketChannel channel, ByteBuffer message) {
        this.nextHandler.processBinaryMessage(channel, message);
    }

    @Override
    public void processTextMessage(WebSocketChannel channel, String message) {
        this.nextHandler.processTextMessage(channel, message);
    }

    @Override
    public void setNextHandler(WebSocketHandler handler) {
        super.setNextHandler(handler);
        this.nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketNativeControlFrameHandler.this.listener.connectionOpened(channel, protocol);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                WebSocketNativeControlFrameHandler.this.listener.redirected(channel, location);
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeControlFrameHandler.this.listener.authenticationRequested(channel, location, challenge);
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer buf) {
                if (channel.isEscape.compareAndSet(true, false)) {
                    WebSocketNativeControlFrameHandler.this.listener.messageReceived(channel, buf);
                } else {
                    int position = buf.position();
                    byte[] escape = WebSocketNativeControlFrameHandler.this.getMessageFrameType(channel, buf);
                    if (escape == null) {
                        buf.position(position);
                        WebSocketNativeControlFrameHandler.this.listener.messageReceived(channel, buf);
                    } else if (!buf.hasRemaining()) {
                        channel.isEscape.compareAndSet(false, true);
                    } else {
                        int key = HexUtil.byteArrayToInt(escape, 0);
                        String controlMessage = buf.getString(Charset.forName("UTF-8")).trim();
                        if ("x-kaazing-http-revalidate".equals(channel.controlFrames.get(key))) {
                            WebSocketNativeControlFrameHandler.this.listener.authenticationRequested(channel, controlMessage, "x-kaazing-http-revalidate");
                        }
                    }
                }
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                WebSocketNativeControlFrameHandler.this.listener.connectionClosed(channel);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
                WebSocketNativeControlFrameHandler.this.listener.connectionClosed(channel);
            }
        });
    }

    private byte[] getMessageFrameType(WebSocketChannel channel, ByteBuffer message) {
        byte[] result = null;
        if (message.remaining() < 4) {
            return result;
        }
        byte[] prefix = new byte[4];
        message.get(prefix);
        if (channel.controlFrames.containsKey(HexUtil.byteArrayToInt(prefix, 0))) {
            result = prefix;
        }
        return result;
    }
}

