/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.auth;

import com.kaazing.gateway.client.security.ChallengeHandler;
import com.kaazing.gateway.client.security.ChallengeHandlers;
import com.kaazing.gateway.client.security.ChallengeRequest;
import com.kaazing.gateway.client.security.ChallengeResponse;
import java.util.logging.Logger;

public final class AuthenticationUtil {
    private static final String CLASS_NAME = AuthenticationUtil.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    private AuthenticationUtil() {
    }

    public static ChallengeResponse getChallengeResponse(ChallengeRequest challengeRequest, ChallengeResponse challengeResponse) {
        LOG.entering(CLASS_NAME, "getChallengeResponse");
        ChallengeHandler challengeHandler = challengeResponse.getNextChallengeHandler() == null ? ChallengeHandlers.getDefault() : challengeResponse.getNextChallengeHandler();
        if (challengeHandler == null) {
            throw new IllegalStateException("No challenge handler available for challenge " + challengeRequest);
        }
        try {
            challengeResponse = challengeHandler.handle(challengeRequest);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error processing challenge: " + challengeRequest, e);
        }
        if (challengeResponse == null) {
            throw new IllegalStateException("Unsupported challenge " + challengeRequest);
        }
        return challengeResponse;
    }
}

