/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.instrument.classloading.weblogic;

import com.bmc.thirdparty.org.springframework.instrument.classloading.LoadTimeWeaver;
import com.bmc.thirdparty.org.springframework.instrument.classloading.weblogic.WebLogicClassLoaderAdapter;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;

public class WebLogicLoadTimeWeaver
implements LoadTimeWeaver {
    private final WebLogicClassLoaderAdapter classLoader;

    public WebLogicLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public WebLogicLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = new WebLogicClassLoaderAdapter(classLoader);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader.getClassLoader();
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return this.classLoader.getThrowawayClassLoader();
    }
}

