/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.cache.interceptor;

import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.lang.reflect.Method;

public final class MethodCacheKey {
    private final Method method;
    private final Class<?> targetClass;

    public MethodCacheKey(Method method, Class<?> targetClass) {
        Assert.notNull(method, "method must be set.");
        this.method = method;
        this.targetClass = targetClass;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodCacheKey)) {
            return false;
        }
        MethodCacheKey otherKey = (MethodCacheKey)other;
        return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass);
    }

    public int hashCode() {
        return this.method.hashCode() * 29 + (this.targetClass != null ? this.targetClass.hashCode() : 0);
    }
}

