/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.utils.ARCommonConfig;
import com.bmc.arsys.utils.LocaleUtil;
import com.bmc.thirdparty.org.springframework.context.support.ReloadableResourceBundleMessageSource;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public final class CatalogReader {
    private static Logger log = Logger.getLogger(CatalogReader.class);
    private static final CatalogReader INSTANCE = new CatalogReader();
    private HashMap<String, ReloadableResourceBundleMessageSource> resources;
    private static final String DEF_MESSAGE = "Message not in catalog; Message number = ";
    private static final Locale DEF_LOCALE = Locale.getDefault();

    public static CatalogReader getInstance() {
        return INSTANCE;
    }

    private CatalogReader() {
        this.initialize();
    }

    private void initialize() {
        this.resources = new HashMap();
        List<String> msgSets = ARCommonConfig.getInstance().getMessageSetIds();
        for (String msgSet : msgSets) {
            String catalogFileName = ARCommonConfig.getInstance().getCatalogFileName(msgSet);
            try {
                this.register(msgSet, catalogFileName);
            }
            catch (RuntimeException e) {
                log.debug(e.getMessage());
            }
        }
    }

    public String getMessageKey(int id) {
        Integer intVal = new Integer(id);
        return intVal.toString();
    }

    public String getMessage(int id) {
        String key = this.getMessageKey(id);
        return this.getMessage(key, (Object[])null, DEF_MESSAGE + key, DEF_LOCALE);
    }

    public String getMessage(int id, String localeStr) {
        String key = this.getMessageKey(id);
        Locale locale = LocaleUtil.parseLocale(localeStr);
        if (locale == null) {
            locale = DEF_LOCALE;
        }
        return this.getMessage(key, (Object[])null, DEF_MESSAGE + key, locale);
    }

    public String getMessage(int id, Locale locale) {
        String key = this.getMessageKey(id);
        return this.getMessage(key, (Object[])null, DEF_MESSAGE + key, locale);
    }

    public String getMessage(int id, String defaultMessage, Locale locale) {
        String key = this.getMessageKey(id);
        return this.getMessage(key, (Object[])null, defaultMessage, locale);
    }

    public String getMessage(int id, Object[] args, String defaultMessage, Locale locale) {
        String key = this.getMessageKey(id);
        return this.getMessage(key, args, defaultMessage, locale);
    }

    public String getMessage(String key, Object[] args, String defaultMessage, Locale locale) {
        log.debug("getMessage(" + key + "," + args + "," + defaultMessage + "," + locale + ")");
        return this.getMessage("1", key, args, defaultMessage, locale);
    }

    public String getMessage(String msgSetName, String key, Object[] args, String defaultMessage, Locale locale) {
        log.debug("getMessage(" + msgSetName + "," + key + "," + args + "," + defaultMessage + "," + locale + ")");
        ReloadableResourceBundleMessageSource resource = this.resources.get(msgSetName);
        if (resource != null) {
            return this.resources.get(msgSetName).getMessage(key, args, defaultMessage, locale);
        }
        throw new RuntimeException("Message Set : " + msgSetName + "not registered.");
    }

    public String getMessage(String msgSetName, int key, Object[] args, String defaultMessage, Locale locale) {
        log.debug("getMessage(" + msgSetName + "," + key + "," + args + "," + defaultMessage + "," + locale + ")");
        ReloadableResourceBundleMessageSource resource = this.resources.get(msgSetName);
        String strKey = this.getMessageKey(key);
        if (resource != null) {
            return this.resources.get(msgSetName).getMessage(strKey, args, defaultMessage, locale);
        }
        throw new RuntimeException("Message Set : " + msgSetName + "not registered.");
    }

    public void register(String msgSetName, String fileName) {
        this.register(msgSetName, fileName, false);
    }

    public void register(String msgSetName, String fileName, boolean overWrite) {
        if (msgSetName == null || msgSetName.trim().equals("")) {
            throw new NullPointerException("Message Set Name is'null'");
        }
        if (fileName == null || fileName.trim().equals("")) {
            throw new NullPointerException("Catalog base file name is 'null'");
        }
        if (!overWrite && this.resources.containsKey(msgSetName)) {
            throw new RuntimeException("Message Set '" + msgSetName + "' already exists.");
        }
        ReloadableResourceBundleMessageSource resource = null;
        if (this.resources.containsKey(msgSetName)) {
            resource = this.resources.remove(msgSetName);
            resource = null;
        }
        resource = new ReloadableResourceBundleMessageSource();
        resource.setBasename(fileName);
        this.resources.put(msgSetName, resource);
    }

    public void deregister(String msgSetName) {
        if (this.resources.containsKey(msgSetName)) {
            this.resources.remove(msgSetName);
        }
        throw new RuntimeException("Message Set doesn't exists");
    }
}

