/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext;

import com.bmc.arsys.arrpc.rpcext.ArOncRpcSocketClient;
import com.bmc.arsys.arrpc.rpcext.ArSoftByteArrayManager;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.apache.log4j.Logger;

public class ArOncRpcTcpClient
extends ArOncRpcSocketClient {
    private static Logger log = Logger.getLogger(ArOncRpcTcpClient.class);
    protected static final int ARENC_NONE = 1;
    protected static final int ARENC_DEFAULT = 5;
    protected static final int AR_ENCRYPTED_CALL = 32768;
    private int _arEncType = 5;
    private transient Object _rpcCallContext;

    public ArOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port, int bufferSize, int timeout) throws OncRpcException, IOException {
        super(host, program, version, port, bufferSize, timeout);
        this.changeToArXdrStream(arEncType, callContext, bufferSize);
    }

    public ArOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port, int bufferSize) throws OncRpcException, IOException {
        super(host, program, version, port, bufferSize);
        this.changeToArXdrStream(arEncType, callContext, bufferSize);
    }

    public ArOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version) throws OncRpcException, IOException {
        super(host, program, version);
        this.changeToArXdrStream(arEncType, callContext, 0);
    }

    public ArOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port) throws OncRpcException, IOException {
        super(host, program, version, port);
        this.changeToArXdrStream(arEncType, callContext, 0);
    }

    public ArOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port, int bufferSize, Map<Object, Object> networkSessionInfo) throws OncRpcException, IOException {
        super(host, program, version, port, bufferSize, networkSessionInfo);
        this.changeToArXdrStream(arEncType, callContext, bufferSize);
    }

    public ArOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port, int bufferSize, int timeout, Map<Object, Object> networkSessionInfo) throws OncRpcException, IOException {
        super(host, program, version, port, bufferSize, timeout, networkSessionInfo);
        this.changeToArXdrStream(arEncType, callContext, bufferSize);
    }

    protected void changeToArXdrStream(int arEncType, Object callContext, int arXdrSize) throws IOException, OncRpcException {
        this.setArEncType(arEncType);
        this._rpcCallContext = callContext;
    }

    @Override
    protected XdrTcpDecodingStream aNewXdrTcpDecodingStream(Object obj, ArNetworkSocket socketWrapper, int senderLen) throws IOException {
        int len = ArSoftByteArrayManager.toMultipleOfFourBufferSize(senderLen);
        return new ArXdrTcpDecodingStream(socketWrapper, ArSoftByteArrayManager.get(len, true));
    }

    @Override
    protected XdrTcpEncodingStream aNewXdrTcpEncodingStream(Object obj, ArNetworkSocket socketWrapper, int senderLen) throws IOException {
        int len = ArSoftByteArrayManager.toMultipleOfFourBufferSize(senderLen);
        return new ArXdrTcpEncodingStream(socketWrapper, ArSoftByteArrayManager.get(len, true));
    }

    protected int getArEncType() {
        return this._arEncType;
    }

    protected void setArEncType(int arEncType) {
        this._arEncType = arEncType;
    }

    @Override
    public void encodeParams(XdrAble params) throws OncRpcException, IOException {
        try {
            if (this.sendingXdr instanceof ArXdrTcpEncodingStream) {
                ((ArXdrTcpEncodingStream)this.sendingXdr).arExcBeforeXdrEncodeParams();
            }
            super.encodeParams(params);
        }
        catch (OutOfMemoryError e) {
            String msg = "Rpc encoding parameter unknown mapping for encoding ";
            log.error(msg, e);
            throw new OncRpcException(1, msg);
        }
    }

    @Override
    public void decodeResult(XdrAble result) throws OncRpcException, IOException {
        try {
            if (this.receivingXdr instanceof ArXdrTcpDecodingStream) {
                ((ArXdrTcpDecodingStream)this.receivingXdr).resetArFlags();
                ((ArXdrTcpDecodingStream)this.receivingXdr).arExcBeforeUnXdrDecodeParams(result);
                if (!((ArXdrTcpDecodingStream)this.receivingXdr).isXdrDecodeDone()) {
                    super.decodeResult(result);
                }
            } else {
                super.decodeResult(result);
            }
        }
        catch (OutOfMemoryError e) {
            String msg = "Rpc decoding parameter error ";
            log.error(msg, e);
            throw new OncRpcException(2, e.getLocalizedMessage());
        }
    }

    protected Object getRpcCallContext() {
        return this._rpcCallContext;
    }

    public void setRpcVersion(int version) {
        this.version = version;
    }
}

