/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARMdCrypto;
import com.bmc.arsys.arencrypt.NetWorkDateEncTransferObject;
import com.bmc.arsys.utils.ARCommonConfig;
import com.bmc.arsys.utils.LogBytes;
import com.bmc.arsys.utils.StringByteUtil;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class NetWorkDataKeyInfo {
    private ARDataKey svrDataKey = new ARDataKey();
    private ARDataKey cntDataKey = new ARDataKey();
    private transient int sessionId;
    private static Logger logger = Logger.getLogger(NetWorkDataKeyInfo.class);
    private static boolean _DEBUG_CONFIG_ON = NetWorkDataKeyInfo.isDebugEnabled();
    private boolean logFlag = _DEBUG_CONFIG_ON;

    private static boolean isDebugEnabled() {
        return logger.isDebugEnabled() && ARCommonConfig.getInstance().getLogBytes();
    }

    public ARDataKey getCntDataKey() {
        return this.cntDataKey;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public ARDataKey getSvrDataKey() {
        return this.svrDataKey;
    }

    public void setEncAlgorithmParam(int encAlgorithm) throws AREncryptionException {
        this.svrDataKey.setEncAlgorithm(encAlgorithm);
        this.svrDataKey.setEncAlgorithmStr(ARCryptoConstants.AR_DATA_ENC_ALG_STR[encAlgorithm - 1]);
        this.svrDataKey.setEncType(ARCryptoConstants.AR_DATA_ENC_TYPE[encAlgorithm - 1]);
        this.svrDataKey.setEncXForm(ARCryptoConstants.AR_DATA_ENC_XFORM[encAlgorithm - 1]);
        this.svrDataKey.setEncMode(2);
        this.svrDataKey.setKeySize(ARCryptoConstants.AR_DATA_ENC_ENC_BITS[encAlgorithm - 1]);
        this.svrDataKey.setProvider(ARCryptoConstants.ENC_CIPHER_PROVIDERS[ARCryptoConstants.JCE_PROVIDER_IDX][encAlgorithm - 1]);
        this.cntDataKey.setEncAlgorithm(encAlgorithm);
        this.cntDataKey.setEncAlgorithmStr(ARCryptoConstants.AR_DATA_ENC_ALG_STR[encAlgorithm - 1]);
        this.cntDataKey.setEncType(ARCryptoConstants.AR_DATA_ENC_TYPE[encAlgorithm - 1]);
        this.cntDataKey.setEncXForm(ARCryptoConstants.AR_DATA_ENC_XFORM[encAlgorithm - 1]);
        this.cntDataKey.setEncMode(1);
        this.cntDataKey.setKeySize(ARCryptoConstants.AR_DATA_ENC_ENC_BITS[encAlgorithm - 1]);
        this.cntDataKey.setProvider(ARCryptoConstants.ENC_CIPHER_PROVIDERS[ARCryptoConstants.JCE_PROVIDER_IDX][encAlgorithm - 1]);
    }

    public void genDataEncKeys(NetWorkDateEncTransferObject tempObj) throws AREncryptionException {
        int numOctetKeys = 2;
        int encAlgorithm = tempObj.getAlg();
        int ivLen = 0;
        int keyLen = 0;
        int hashSize = 0;
        switch (encAlgorithm) {
            case 1: {
                numOctetKeys = 2;
                keyLen = 8;
                ivLen = 8;
                hashSize = 16;
                break;
            }
            case 2: {
                numOctetKeys = 2;
                keyLen = 16;
                ivLen = 0;
                hashSize = 16;
                break;
            }
            case 3: {
                numOctetKeys = 32;
                keyLen = 256;
                ivLen = 0;
                hashSize = 16;
                break;
            }
            case 6: 
            case 8: {
                numOctetKeys = 4;
                keyLen = 16;
                ivLen = 16;
                hashSize = 20;
                break;
            }
            case 7: 
            case 9: {
                numOctetKeys = 6;
                keyLen = 32;
                ivLen = 16;
                hashSize = 20;
                break;
            }
            default: {
                throw new AREncryptionException(9007);
            }
        }
        ByteBuffer keyMaterialBuf = ByteBuffer.allocate(528);
        this.populateKeyMaterial(keyMaterialBuf, tempObj, numOctetKeys, hashSize);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(keyMaterialBuf.array(), "keyMaterial ");
        }
        ByteBuffer svrBytesBuf = ByteBuffer.allocate(numOctetKeys * 8);
        ByteBuffer cntBytesBuf = ByteBuffer.allocate(numOctetKeys * 8);
        byte[] svrMacBytes = new byte[8];
        byte[] cntMacBytes = new byte[8];
        byte[] temp = new byte[8];
        int i = 0;
        for (i = 0; i < numOctetKeys; ++i) {
            keyMaterialBuf.position(i * hashSize);
            keyMaterialBuf.get(temp, 0, 8);
            svrBytesBuf.position(i * 8);
            svrBytesBuf.put(temp);
            keyMaterialBuf.position(i * hashSize + 8);
            keyMaterialBuf.get(temp, 0, 8);
            cntBytesBuf.position(i * 8);
            cntBytesBuf.put(temp);
        }
        keyMaterialBuf.position(i * hashSize);
        keyMaterialBuf.get(svrMacBytes, 0, 8);
        keyMaterialBuf.position(i * hashSize + 8);
        keyMaterialBuf.get(cntMacBytes, 0, 8);
        if (keyLen > 0 && svrBytesBuf.capacity() == keyLen) {
            this.getSvrDataKey().setKey(svrBytesBuf.array());
            this.getCntDataKey().setKey(cntBytesBuf.array());
        } else {
            byte[] desSvrBytes = new byte[keyLen];
            byte[] desCntBytes = new byte[keyLen];
            svrBytesBuf.position(0);
            svrBytesBuf.get(desSvrBytes, 0, keyLen);
            cntBytesBuf.position(0);
            cntBytesBuf.get(desCntBytes, 0, keyLen);
            this.getSvrDataKey().setKey(desSvrBytes);
            this.getCntDataKey().setKey(desCntBytes);
        }
        if (ivLen > 0) {
            byte[] svrIv = new byte[ivLen];
            byte[] cntIv = new byte[ivLen];
            svrBytesBuf.position(keyLen);
            svrBytesBuf.get(svrIv, 0, ivLen);
            this.getSvrDataKey().setIv(svrIv);
            cntBytesBuf.position(keyLen);
            cntBytesBuf.get(cntIv, 0, ivLen);
            this.getCntDataKey().setIv(cntIv);
        }
        this.getSvrDataKey().setMacKey(svrMacBytes);
        this.getCntDataKey().setMacKey(cntMacBytes);
        this.setEncAlgorithmParam(encAlgorithm);
        if (this.logFlag) {
            logger.debug("For Data encAlgorithm = " + encAlgorithm);
            LogBytes.printByteArrayAsHex(svrBytesBuf.array(), "ClntDataInfo.serverBytes ");
            LogBytes.printByteArrayAsHex(svrMacBytes, "ClntDataInfo.serverMacBytes ");
            LogBytes.printByteArrayAsHex(cntBytesBuf.array(), "ClntDataInfo.cntBytes ");
            LogBytes.printByteArrayAsHex(cntMacBytes, "ClntDataInfo.CntMacBytes ");
        }
    }

    private void populateKeyMaterial(ByteBuffer keyMaterialBuf, NetWorkDateEncTransferObject tempObj, int numOctetKeys, int mac_verifier_len) throws AREncryptionException {
        ARMdCrypto mdCrypto = new ARMdCrypto();
        ByteBuffer sha1InputBuf = ByteBuffer.allocate(mac_verifier_len + 40 + 40);
        sha1InputBuf.position(mac_verifier_len);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHexArray(tempObj.getPreMasterKey(), "PreMasterKey");
            LogBytes.printByteArrayAsHexArray(tempObj.getServerRandBytes(), "ServerRandBytes");
            LogBytes.printByteArrayAsHexArray(tempObj.getClntRandBytes(), "ClntRandBytes");
        }
        sha1InputBuf.put(tempObj.getPreMasterKey());
        sha1InputBuf.put(tempObj.getServerRandBytes());
        sha1InputBuf.put(tempObj.getClntRandBytes());
        String provider = ARCryptoConstants.ENC_CIPHER_PROVIDERS[ARCryptoConstants.JCE_PROVIDER_IDX][tempObj.getAlg() - 1];
        int ci = 82;
        for (int i = 0; i < numOctetKeys + 1; ++i) {
            sha1InputBuf.position(0);
            for (int j = 0; j < 1 + i % 16; ++j) {
                sha1InputBuf.put((byte)(ci + i));
            }
            byte[] md5InputBufferTmp = mdCrypto.SHA1(sha1InputBuf.array(), provider);
            if (this.logFlag) {
                LogBytes.printByteArrayAsHex(md5InputBufferTmp, "md5InputBufferTmp last " + md5InputBufferTmp.length + " bytes from SHA");
            }
            byte[] md5InputBuffer = StringByteUtil.concatenateByteArrays(tempObj.getPreMasterKey(), md5InputBufferTmp);
            byte[] md = null;
            if (ARDataKey.checkValidFipsDataEncAlgorithm(tempObj.getAlg())) {
                md = mdCrypto.SHA1(md5InputBuffer, provider);
                if (this.logFlag) {
                    LogBytes.printByteArrayAsHex(md, "2nd SHA1 " + md.length + " bytes :");
                }
            } else {
                md = mdCrypto.MD5(md5InputBuffer);
                if (this.logFlag) {
                    LogBytes.printByteArrayAsHex(md, "MD5 " + md.length + " bytes :");
                }
            }
            keyMaterialBuf.put(md);
        }
    }
}

