/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.chunking;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.chunking.ARChunkReceiveProcessor;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.utils.StringByteUtil;
import org.apache.log4j.Logger;

public abstract class ARChunkArrayBuffer
extends ARChunkReceiveProcessor {
    private static Logger logger = Logger.getLogger(ARChunkArrayBuffer.class);
    protected byte[] bytesBuffer;
    private int headerLen;

    @Override
    public void retrieveChunkingData(ArRpcXdrOut out) throws ARException {
        super.retrieveChunkingData(out);
        byte[] outBytes = this.getOutPutByteBuffer(out);
        if (outBytes == null) {
            return;
        }
        logger.debug("retrieveChunkingData: received data len= " + outBytes.length);
        if (this.bytesBuffer == null) {
            int headerLen = this.getHeaderLen();
            this.bytesBuffer = StringByteUtil.getByteArrays(outBytes, headerLen, outBytes.length - headerLen);
            logger.debug("retrieveChunkingData: headerLen=" + headerLen + " buffer len=" + this.bytesBuffer.length);
        } else {
            this.bytesBuffer = StringByteUtil.concatenateByteArrays(this.bytesBuffer, outBytes);
            logger.debug("retrieveChunkingData: concatenated buffer len=" + this.bytesBuffer.length);
        }
    }

    @Override
    public void postProcess(ArRpcXdrOut out) throws ARException {
        if (this.isCompressed()) {
            if (this.bytesBuffer != null) {
                logger.debug("postProcess: compressed data, len=" + this.bytesBuffer.length);
            }
            this.bytesBuffer = this.inflateBytes(this.bytesBuffer);
            if (this.bytesBuffer != null) {
                logger.debug("postProcess: decompressed data, len=" + this.bytesBuffer.length);
            }
        }
        this.setBackOutPutByteBuffer(out);
    }

    int getHeaderLen() {
        return this.headerLen;
    }

    protected void setHeaderLen(int headerLen) {
        this.headerLen = headerLen;
    }

    protected abstract byte[] getOutPutByteBuffer(ArRpcXdrOut var1);

    protected abstract void setBackOutPutByteBuffer(ArRpcXdrOut var1);
}

