/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.arxdrenc;

import com.bmc.arsys.apitransport.arxdrenc.ArUnXdrDecryptDecode;
import com.bmc.arsys.apitransport.arxdrenc.ArXdrEncryptEncode;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.arrpc.ArControlStruct12;
import com.bmc.arsys.arrpc.rpcext.ArFlexOncRpcTcpClient;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.apache.log4j.Logger;

public class ArApiRpcTcpClient
extends ArFlexOncRpcTcpClient {
    private static Logger logger = Logger.getLogger(ArApiRpcTcpClient.class);
    private static final boolean OLD_APPROACH = false;
    private static final boolean MIN_RETAIN_BUFFER = true;

    public ArApiRpcTcpClient(ArRpcCallContext apiCxt, InetAddress host, int program, int version, int port) throws OncRpcException, IOException {
        super(32768, apiCxt, host, program, version, port, 500000);
    }

    public ArApiRpcTcpClient(ArRpcCallContext apiCxt, InetAddress host, int program, int version, int port, int xdrSize) throws OncRpcException, IOException {
        super(32768, (Object)apiCxt, host, program, version, port, xdrSize, ApiThreadLocalStorageBlock.getTLB().getApiThreadInfo());
    }

    @Override
    protected void changeToArXdrStream(int arEncType, Object callContext, int arXdrSize) throws IOException, OncRpcException {
        super.changeToArXdrStream(arEncType, callContext, 0);
        if (this instanceof ArFlexOncRpcTcpClient) {
            this.setUseFlexXdrStreamBuffer(true);
        }
        this.sendingXdr = this.aNewXdrTcpEncodingStream(callContext, this.getSocketHelper(), arXdrSize);
        this.receivingXdr = this.aNewXdrTcpDecodingStream(callContext, this.getSocketHelper(), arXdrSize);
    }

    @Override
    public void call(int procedureNumber, int versionNumber, XdrAble params, XdrAble result) throws OncRpcException {
        super.setCharacterEncoding(this.getArRpcCallContext().getServerCharSetName());
        int timeOut = this.getArRpcCallContext().getSessionVariable(12).getIntValue();
        super.setTimeout(timeOut * 1000);
        ArRpcControlStruct control = ((ArRpcXdrIn)params).getControl();
        if (control instanceof ArControlStruct12) {
            ((ArControlStruct12)control).setTimeout(timeOut);
        }
        this.changeRpcProgramIfNeeded(procedureNumber);
        if (this.getArRpcCallContext().isAnEncryptedAPICall()) {
            procedureNumber |= 0x8000;
            this.setArProcessOn(true);
            this.setArEncryptionOn(true);
            this.setUseFlexXdrStreamBuffer(true);
            this.reiterateSocketBuffersSize();
        } else {
            this.setArEncryptionOn(false);
            this.setArProcessOn(true);
            this.setUseFlexXdrStreamBuffer(true);
            this.reiterateSocketBuffersSize();
        }
        super.call(procedureNumber, versionNumber, params, result);
    }

    protected void changeRpcProgramIfNeeded(int procedureNumber) {
        int rpcNumInSession = (Integer)this.getArRpcCallContext().getSessionVariable(5).getValue();
        if (rpcNumInSession == 0) {
            if (390620 != this.getProgram()) {
                this.program = 390620;
                if (logger.isDebugEnabled()) {
                    logger.debug("call " + procedureNumber + " changes to queue " + this.program);
                }
            }
        } else if (rpcNumInSession != this.getProgram()) {
            this.program = rpcNumInSession;
            if (logger.isDebugEnabled()) {
                logger.debug("call " + procedureNumber + " changes to queue " + this.program);
            }
        }
    }

    protected void setArProcessOn(boolean flag) {
        if (this.sendingXdr instanceof ArXdrTcpEncodingStream) {
            ((ArXdrTcpEncodingStream)this.sendingXdr).setArProcessOn(flag);
        }
        if (this.receivingXdr instanceof ArXdrTcpDecodingStream) {
            ((ArXdrTcpDecodingStream)this.receivingXdr).setArProcessOn(flag);
        }
    }

    protected void setArEncryptionOn(boolean flag) {
        if (this.sendingXdr instanceof ArXdrTcpEncodingStream) {
            ((ArXdrTcpEncodingStream)this.sendingXdr).setArEncryptionOn(flag);
        }
        if (this.receivingXdr instanceof ArXdrTcpDecodingStream) {
            ((ArXdrTcpDecodingStream)this.receivingXdr).setArEncryptionOn(flag);
        }
    }

    public ArRpcCallContext getArRpcCallContext() {
        return (ArRpcCallContext)super.getRpcCallContext();
    }

    public void adjustXdrSize(int xdrSize) throws IOException, OncRpcException {
        super.changeToArXdrStream(32768, this.getArRpcCallContext(), xdrSize);
    }

    @Override
    protected XdrTcpDecodingStream aNewXdrTcpDecodingStream(Object sessionEncNode, ArNetworkSocket streamingSocket, int senderLen) throws IOException {
        return new ArUnXdrDecryptDecode(sessionEncNode, streamingSocket, senderLen);
    }

    @Override
    protected XdrTcpEncodingStream aNewXdrTcpEncodingStream(Object sessionEncNode, ArNetworkSocket streamingSocket, int senderLen) throws IOException {
        return new ArXdrEncryptEncode(sessionEncNode, streamingSocket, senderLen);
    }
}

