/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.Config;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;

public final class OperandType
implements Serializable {
    private static final long serialVersionUID = -3964401280982522339L;
    public static final OperandType FIELDID = new OperandType(1);
    public static final OperandType VALUE = new OperandType(2);
    public static final OperandType ARITHMETIC_OP = new OperandType(3);
    public static final OperandType STATUS_HISTORY = new OperandType(4);
    public static final OperandType FUNCTION = new OperandType(9);
    public static final OperandType CASE = new OperandType(10);
    public static final OperandType VALUE_SET = new OperandType(5);
    public static final OperandType CURRENCY_FLD = new OperandType(6);
    public static final OperandType FIELDID_TRANSACTION = new OperandType(50);
    public static final OperandType FIELDID_DB = new OperandType(51);
    public static final OperandType LOCAL_VARIABLE = new OperandType(52);
    public static final OperandType QUERY_INFO = new OperandType(53);
    public static final OperandType CURRENCY_FLD_TRAN = new OperandType(54);
    public static final OperandType CURRENCY_FLD_DB = new OperandType(55);
    public static final OperandType CURRENCY_FLD_CURRENT = new OperandType(56);
    public static final OperandType FIELDID_CURRENT = new OperandType(99);
    public static final OperandType VALUE_SET_QUERY = new OperandType(7);
    private final int type;

    public int toInt() {
        return this.type;
    }

    private OperandType(int i) {
        this.type = i;
    }

    public static OperandType getOperandType(int operation) {
        OperandType opType;
        switch (operation) {
            case 1: {
                opType = FIELDID;
                break;
            }
            case 2: {
                opType = VALUE;
                break;
            }
            case 3: {
                opType = ARITHMETIC_OP;
                break;
            }
            case 4: {
                opType = STATUS_HISTORY;
                break;
            }
            case 5: {
                opType = VALUE_SET;
                break;
            }
            case 6: {
                opType = CURRENCY_FLD;
                break;
            }
            case 50: {
                opType = FIELDID_TRANSACTION;
                break;
            }
            case 51: {
                opType = FIELDID_DB;
                break;
            }
            case 52: {
                opType = LOCAL_VARIABLE;
                break;
            }
            case 53: {
                opType = QUERY_INFO;
                break;
            }
            case 54: {
                opType = CURRENCY_FLD_TRAN;
                break;
            }
            case 55: {
                opType = CURRENCY_FLD_DB;
                break;
            }
            case 56: {
                opType = CURRENCY_FLD_CURRENT;
                break;
            }
            case 99: {
                opType = FIELDID_CURRENT;
                break;
            }
            case 7: {
                opType = VALUE_SET_QUERY;
                break;
            }
            case 9: {
                opType = FUNCTION;
                break;
            }
            case 10: {
                opType = CASE;
                break;
            }
            default: {
                opType = operation >= 12 && operation <= 26 ? new OperandType(operation) : null;
            }
        }
        return opType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OperandType)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OperandType rhs = (OperandType)obj;
        return new EqualsBuilder().append(this.type, rhs.type).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.type).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("type", this.type).toString();
    }
}

