/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.ProcessResult;
import com.bmc.arsys.api.Util;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;

public class AssignInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -811819494407985607L;
    private int m_assignType;
    private Value m_value;
    private AssignFieldInfo m_field;
    private String m_process;
    private ArithOpAssignInfo m_arithOp;
    private FunctionAssignInfo m_function;
    private DDEAction m_dde;
    private AssignSQLInfo m_sql;
    private AssignFilterApiInfo m_filterApi;
    private String assignmentAsString;
    public static final int AR_ASSIGN_TYPE_NONE = 0;
    public static final int AR_ASSIGN_TYPE_VALUE = 1;
    public static final int AR_ASSIGN_TYPE_FIELD = 2;
    public static final int AR_ASSIGN_TYPE_PROCESS = 3;
    public static final int AR_ASSIGN_TYPE_ARITH = 4;
    public static final int AR_ASSIGN_TYPE_FUNCTION = 5;
    public static final int AR_ASSIGN_TYPE_DDE = 6;
    public static final int AR_ASSIGN_TYPE_SQL = 7;
    public static final int AR_ASSIGN_TYPE_FILTER_API = 8;

    public Value getValue() {
        return this.m_value;
    }

    public void setValue(Value value) {
        this.m_value = value;
    }

    public AssignFieldInfo getField() {
        return this.m_field;
    }

    public void setField(AssignFieldInfo field) {
        this.m_field = field;
    }

    public String getProcess() {
        return this.m_process;
    }

    public void setProcess(String process) {
        this.m_process = process;
    }

    public ArithOpAssignInfo getArithOp() {
        return this.m_arithOp;
    }

    public void setArithOp(ArithOpAssignInfo arithOp) {
        this.m_arithOp = arithOp;
    }

    public FunctionAssignInfo getFunction() {
        return this.m_function;
    }

    public void setFunction(FunctionAssignInfo function) {
        this.m_function = function;
    }

    public DDEAction getDde() {
        return this.m_dde;
    }

    public void setDde(DDEAction dde) {
        this.m_dde = dde;
    }

    public AssignSQLInfo getSql() {
        return this.m_sql;
    }

    public void setSql(AssignSQLInfo sql) {
        this.m_sql = sql;
    }

    public AssignFilterApiInfo getFilterApi() {
        return this.m_filterApi;
    }

    public void setFilterApi(AssignFilterApiInfo filterApi) {
        this.m_filterApi = filterApi;
    }

    public AssignInfo() {
    }

    public AssignInfo(DDEAction ddeInfo) {
        this.setAssignType(6);
        try {
            this.m_dde = (DDEAction)ddeInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public int getAssignType() {
        return this.m_assignType;
    }

    public void setAssignType(int assignType) {
        this.m_assignType = assignType;
    }

    public Object clone() throws CloneNotSupportedException {
        AssignInfo obj = (AssignInfo)super.clone();
        obj.m_value = null;
        obj.m_field = null;
        obj.m_process = null;
        obj.m_arithOp = null;
        obj.m_function = null;
        obj.m_dde = null;
        obj.m_sql = null;
        obj.m_filterApi = null;
        switch (this.m_assignType) {
            case 0: {
                break;
            }
            case 1: {
                if (this.m_value == null) break;
                obj.m_value = (Value)this.m_value.clone();
                break;
            }
            case 2: {
                if (this.m_field == null) break;
                obj.m_field = (AssignFieldInfo)this.m_field.clone();
                break;
            }
            case 3: {
                obj.m_process = this.m_process;
                break;
            }
            case 4: {
                if (this.m_arithOp == null) break;
                obj.m_arithOp = (ArithOpAssignInfo)this.m_arithOp.clone();
                break;
            }
            case 5: {
                if (this.m_function == null) break;
                obj.m_function = (FunctionAssignInfo)this.m_function.clone();
                break;
            }
            case 6: {
                if (this.m_dde == null) break;
                obj.m_dde = (DDEAction)this.m_dde.clone();
                break;
            }
            case 7: {
                if (this.m_sql == null) break;
                obj.m_sql = (AssignSQLInfo)this.m_sql.clone();
                break;
            }
            case 8: {
                if (this.m_filterApi == null) break;
                obj.m_filterApi = (AssignFilterApiInfo)this.m_filterApi.clone();
                break;
            }
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AssignInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AssignInfo rhs = (AssignInfo)obj;
        return new EqualsBuilder().append(this.m_assignType, rhs.m_assignType).append(this.m_value, rhs.m_value).append(this.m_field, rhs.m_field).append(this.m_process, rhs.m_process).append(this.m_arithOp, rhs.m_arithOp).append(this.m_function, rhs.m_function).append(this.m_dde, rhs.m_dde).append(this.m_sql, rhs.m_sql).append(this.m_filterApi, rhs.m_filterApi).isEquals();
    }

    public boolean equals(Object anObject, String lhsServer, String lhsForm, String rhsServer, String rhsForm) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || !(anObject instanceof AssignInfo)) {
            return false;
        }
        AssignInfo rhs = (AssignInfo)anObject;
        return this.m_assignType == rhs.m_assignType && (this.m_value == null ? rhs.m_value == null : this.m_value.equals(rhs.m_value)) && (this.m_field == null ? rhs.m_field == null : this.m_field.equals(rhs.m_field, lhsServer, lhsForm, rhsServer, rhsForm)) && (this.m_process == null ? rhs.m_process == null : this.m_process.equals(rhs.m_process)) && (this.m_arithOp == null ? rhs.m_arithOp == null : this.m_arithOp.equals(rhs.m_arithOp, lhsServer, lhsForm, rhsServer, rhsForm)) && (this.m_function == null ? rhs.m_function == null : this.m_function.equals(rhs.m_function)) && (this.m_dde == null ? rhs.m_dde == null : this.m_dde.equals(rhs.m_dde)) && (this.m_sql == null ? rhs.m_sql == null : this.m_sql.equals(rhs.m_sql)) && (this.m_filterApi == null ? rhs.m_filterApi == null : this.m_filterApi.equals(rhs.m_filterApi));
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_assignType).append(this.m_value).append(this.m_field).append(this.m_process).append(this.m_arithOp).append(this.m_function).append(this.m_dde).append(this.m_sql).append(this.m_filterApi).toHashCode();
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        int typ = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.setAssignType(typ);
        Object val = ARTypeMgr.GetAt((Object)rawData, 1);
        switch (typ) {
            case 0: {
                break;
            }
            case 1: {
                this.m_value = ARTypeMgr.getInstance().ObjectFromVariant(Value.class, val, ctx);
                break;
            }
            case 2: {
                this.m_field = ARTypeMgr.getInstance().ObjectFromVariant(AssignFieldInfo.class, val, ctx);
                break;
            }
            case 3: {
                this.m_process = (String)val;
                break;
            }
            case 4: {
                this.m_arithOp = ARTypeMgr.getInstance().ObjectFromVariant(ArithOpAssignInfo.class, val, ctx);
                break;
            }
            case 5: {
                this.m_function = ARTypeMgr.getInstance().ObjectFromVariant(FunctionAssignInfo.class, val, ctx);
                break;
            }
            case 6: {
                this.m_dde = ARTypeMgr.getInstance().ObjectFromVariant(DDEAction.class, val, ctx);
                break;
            }
            case 7: {
                this.m_sql = ARTypeMgr.getInstance().ObjectFromVariant(AssignSQLInfo.class, val, ctx);
                break;
            }
            case 8: {
                this.m_filterApi = ARTypeMgr.getInstance().ObjectFromVariant(AssignFilterApiInfo.class, val, ctx);
                break;
            }
            default: {
                throw new IllegalArgumentException("assigntype not supported by this method");
            }
        }
    }

    static AssignInfo createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        AssignInfo obj = new AssignInfo();
        if (rawData.length == 2 && rawData[0] != null) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[2];
        int typ = this.getAssignType();
        var[0] = new Integer(typ);
        switch (typ) {
            case 0: {
                break;
            }
            case 1: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_value, ctx);
                break;
            }
            case 2: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_field, ctx);
                break;
            }
            case 3: {
                var[1] = this.m_process;
                break;
            }
            case 4: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_arithOp, ctx);
                break;
            }
            case 5: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_function, ctx);
                break;
            }
            case 6: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_dde, ctx);
                break;
            }
            case 7: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_sql, ctx);
                break;
            }
            case 8: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_filterApi, ctx);
                break;
            }
            default: {
                throw new IllegalArgumentException("assigntype not supported by this method");
            }
        }
        return var;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Assign Type", this.m_assignType).append("Value", this.m_value).append("Field", this.m_field).append("Process", this.m_process).append("Arith Op", this.m_arithOp).append("Function", this.m_function).append("Dde", this.m_dde).append("Sql", this.m_sql).append("Filter Api", this.m_filterApi).toString();
    }

    void prepareAssignmentString(ARServerUser ctx, String localForm, int fieldId, String remoteForm) throws ARException {
        String expression = "";
        int assignType = this.getAssignType();
        switch (assignType) {
            case 0: {
                break;
            }
            case 1: {
                expression = this.getValue().toString();
                break;
            }
            case 3: {
                expression = String.format("$PROCESS$ %s", this.getProcess());
                break;
            }
            case 6: {
                DDEAction dde = this.getDde();
                String serviceName = dde.getServiceName();
                String topic = dde.getTopic();
                String item = dde.getItem();
                String pathToProgram = dde.getPathToProgram();
                expression = String.format("$DDE$ %s;%s;%s%s%s", serviceName, topic, pathToProgram, item.length() > 0 ? ";" : "", item);
                break;
            }
            case 8: {
                expression = "$" + Long.toString(this.getFilterApi().getValueIndex()) + "$";
                break;
            }
            case 2: {
                break;
            }
            case 4: 
            case 5: {
                expression = ctx.encodeAssignment(this);
                expression = ctx.formatAssignment(localForm, fieldId, remoteForm, expression);
                if (!Util.isFieldIdPresent(expression) || remoteForm == null || remoteForm.length() <= 0) break;
                try {
                    ProcessResult pr2 = ctx.executeSpecialCommand("Application-Map-Ids-To-Names", remoteForm, expression);
                    expression = pr2.getOutput();
                }
                catch (ARException e) {}
                break;
            }
            case 7: {
                expression = "$" + Long.toString(this.getSql().getValueIndex()) + "$";
            }
        }
        if (expression == null) {
            expression = new Value(Keyword.AR_KEYWORD_NO).toString();
        }
        this.setAssignmentAsString(expression);
    }

    public String getAssignmentAsString() {
        return this.assignmentAsString;
    }

    public void setAssignmentAsString(String assignmentAsString) {
        this.assignmentAsString = assignmentAsString;
    }
}

