/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.Util;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.qual.ARParseFormatInfoImpl;
import com.bmc.arsys.qual.ARQualificationHelper;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ARQualifierHelper
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2625307522910422744L;
    private HashMap<String, Field> m_localFieldLabelMap = null;
    private HashMap<String, Field> m_localFieldIdMap = null;
    private int m_vuiId = 0;
    private HashMap<String, Field> m_remoteFieldNameMap = null;
    private HashMap<String, Field> m_remoteFieldIdMap = null;

    private native QualifierInfo parseQualification(String var1, String var2, int var3) throws ARException;

    public QualifierInfo parseQualification(String localeString, String queryString) throws ARException {
        return this.parseQualification(localeString, queryString, null);
    }

    public QualifierInfo parseQualification(String localeString, String queryString, String timezone) throws ARException {
        if (this.m_localFieldLabelMap == null) {
            return null;
        }
        QualifierInfo object = null;
        if (Config.getInstance().getUseLegacyQualParser()) {
            object = this.parseQualification(localeString, queryString, this.m_vuiId);
        } else {
            ArrayList<Field> localFields = null;
            ArrayList<Field> remoteFields = null;
            if (this.m_localFieldIdMap != null) {
                localFields = new ArrayList<Field>(this.m_localFieldIdMap.values());
            }
            if (this.m_remoteFieldNameMap != null) {
                remoteFields = new ArrayList<Field>(this.m_remoteFieldNameMap.values());
            }
            ArrayList<String> statusHistoryLabel = new ArrayList<String>();
            Field statusHistory = this.getLocalField(String.valueOf(15));
            if (statusHistory != null) {
                for (String o : this.m_localFieldLabelMap.keySet()) {
                    if (!this.m_localFieldLabelMap.get(o).equals(statusHistory)) continue;
                    statusHistoryLabel.add(o);
                }
            }
            ARParseFormatInfoImpl info = new ARParseFormatInfoImpl(localFields, this.m_vuiId, "", remoteFields, localeString, statusHistoryLabel);
            info.setTimeZone(timezone);
            object = ARQualificationHelper.parseQualification(queryString, info);
        }
        return object;
    }

    public void generateFieldMaps(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList) {
        int i;
        String fldlabel = null;
        DisplayInstanceMap dil = null;
        DataType dt = null;
        Field tempHistoryField = null;
        String tempHistory = null;
        this.m_localFieldLabelMap = new HashMap();
        this.m_localFieldIdMap = new HashMap();
        if (remoteFieldList != null && remoteFieldList.size() > 0) {
            this.m_remoteFieldNameMap = new HashMap();
            this.m_remoteFieldIdMap = new HashMap();
        }
        this.m_vuiId = vuiId;
        for (i = 0; i < localFieldList.size(); ++i) {
            Value val;
            fldlabel = null;
            dt = DataType.toDataType(localFieldList.get(i).getDataType());
            if (DataType.COLUMN.equals(dt) || DataType.PAGE_HOLDER.equals(dt) || DataType.PAGE.equals(dt) || DataType.TABLE.equals(dt) || DataType.TRIM.equals(dt)) continue;
            dil = localFieldList.get(i).getDisplayInstance();
            fldlabel = vuiId == 0 ? localFieldList.get(i).getName() : ((val = dil.getProperty(vuiId, new Integer(20))) != null ? val.toString() : localFieldList.get(i).getName());
            if (localFieldList.get(i).getFieldID() == 7 && fldlabel != null) {
                tempHistory = historyTag != null && historyTag.length() > 0 ? fldlabel + historyTag : fldlabel + "-History";
                this.m_localFieldIdMap.put(Integer.valueOf(localFieldList.get(i).getFieldID()).toString(), localFieldList.get(i));
                this.m_localFieldLabelMap.put(fldlabel, localFieldList.get(i));
                continue;
            }
            if (localFieldList.get(i).getFieldID() == 15 && fldlabel != null) {
                tempHistoryField = localFieldList.get(i);
                this.m_localFieldIdMap.put(Integer.valueOf(localFieldList.get(i).getFieldID()).toString(), localFieldList.get(i));
                continue;
            }
            if (fldlabel == null) continue;
            this.m_localFieldIdMap.put(Integer.valueOf(localFieldList.get(i).getFieldID()).toString(), localFieldList.get(i));
            this.m_localFieldLabelMap.put(fldlabel, localFieldList.get(i));
        }
        if (tempHistory != null && tempHistoryField != null) {
            this.m_localFieldLabelMap.put(tempHistory, tempHistoryField);
        }
        if (remoteFieldList == null) {
            return;
        }
        for (i = 0; i < remoteFieldList.size(); ++i) {
            fldlabel = null;
            dt = DataType.toDataType(remoteFieldList.get(i).getDataType());
            if (DataType.COLUMN.equals(dt) || DataType.PAGE_HOLDER.equals(dt) || DataType.PAGE.equals(dt) || DataType.TABLE.equals(dt) || DataType.TRIM.equals(dt)) continue;
            dil = remoteFieldList.get(i).getDisplayInstance();
            fldlabel = remoteFieldList.get(i).getName();
            if (remoteFieldList.get(i).getFieldID() == 7 && fldlabel != null) {
                tempHistory = fldlabel + "-History";
                this.m_remoteFieldIdMap.put(Integer.valueOf(remoteFieldList.get(i).getFieldID()).toString(), remoteFieldList.get(i));
                this.m_remoteFieldNameMap.put(fldlabel, remoteFieldList.get(i));
                continue;
            }
            if (remoteFieldList.get(i).getFieldID() == 15 && fldlabel != null) {
                tempHistoryField = remoteFieldList.get(i);
                this.m_remoteFieldIdMap.put(Integer.valueOf(remoteFieldList.get(i).getFieldID()).toString(), remoteFieldList.get(i));
                continue;
            }
            if (fldlabel == null) continue;
            this.m_remoteFieldIdMap.put(Integer.valueOf(remoteFieldList.get(i).getFieldID()).toString(), remoteFieldList.get(i));
            this.m_remoteFieldNameMap.put(fldlabel, remoteFieldList.get(i));
        }
        if (tempHistory != null && tempHistoryField != null) {
            this.m_remoteFieldNameMap.put(tempHistory, tempHistoryField);
        }
    }

    public int getVuiId() {
        return this.m_vuiId;
    }

    public HashMap<String, Field> getLocalFieldLabelMap() {
        return this.m_localFieldLabelMap;
    }

    public void setLocalFieldLabelMap(Map<String, Field> fldmap, int vuiId) {
        this.m_localFieldLabelMap = (HashMap)fldmap;
        this.m_vuiId = vuiId;
    }

    public HashMap<String, Field> getRemoteFieldNameMap() {
        return this.m_remoteFieldNameMap;
    }

    public void setRemoteFieldNameMap(Map<String, Field> fldmap) {
        this.m_remoteFieldNameMap = (HashMap)fldmap;
    }

    public HashMap<String, Field> getLocalFieldIdMap() {
        return this.m_localFieldIdMap;
    }

    public void setLocalFieldIdMap(Map<String, Field> fldidmap) {
        this.m_localFieldIdMap = (HashMap)fldidmap;
    }

    public HashMap<String, Field> getRemoteFieldIdMap() {
        return this.m_remoteFieldIdMap;
    }

    public void setRemoteFieldIdMap(Map<String, Field> fldidmap) {
        this.m_remoteFieldIdMap = (HashMap)fldidmap;
    }

    public Field getLocalField(String token) {
        Field fld = null;
        if (this.m_localFieldLabelMap != null && this.m_vuiId == 0 && this.m_remoteFieldNameMap != null) {
            int id;
            if (fld == null && this.m_remoteFieldIdMap != null && (fld = this.m_remoteFieldIdMap.get(token)) == null && (id = ConversionUtil.getIntValue(token)) != 0) {
                fld = this.m_remoteFieldIdMap.get(id);
            }
            if (fld == null && this.m_remoteFieldNameMap != null) {
                fld = this.m_remoteFieldNameMap.get(token);
            }
        } else {
            int id;
            if (fld == null && this.m_localFieldIdMap != null && (fld = this.m_localFieldIdMap.get(token)) == null && (id = ConversionUtil.getIntValue(token)) != 0) {
                fld = this.m_localFieldIdMap.get(id);
            }
            if (fld == null && this.m_localFieldLabelMap != null) {
                fld = this.m_localFieldLabelMap.get(token);
            }
        }
        return fld;
    }

    public Field getRemoteField(String token) {
        Field fld = null;
        if (this.m_localFieldLabelMap != null && this.m_vuiId == 0 && this.m_remoteFieldNameMap != null) {
            int id;
            if (fld == null && this.m_localFieldIdMap != null && (fld = this.m_localFieldIdMap.get(token)) == null && (id = ConversionUtil.getIntValue(token)) != 0) {
                fld = this.m_localFieldIdMap.get(id);
            }
            if (fld == null && this.m_localFieldLabelMap != null) {
                fld = this.m_localFieldLabelMap.get(token);
            }
        } else {
            int id;
            if (fld == null && this.m_remoteFieldIdMap != null && (fld = this.m_remoteFieldIdMap.get(token)) == null && (id = ConversionUtil.getIntValue(token)) != 0) {
                fld = this.m_remoteFieldIdMap.get(id);
            }
            if (fld == null && this.m_remoteFieldNameMap != null) {
                fld = this.m_remoteFieldNameMap.get(token);
            }
        }
        return fld;
    }

    public Object clone() throws CloneNotSupportedException {
        ARQualifierHelper obj = (ARQualifierHelper)super.clone();
        obj.m_localFieldLabelMap = this.m_localFieldLabelMap;
        obj.m_localFieldIdMap = this.m_localFieldIdMap;
        obj.m_vuiId = this.m_vuiId;
        obj.m_remoteFieldNameMap = this.m_remoteFieldNameMap;
        obj.m_remoteFieldIdMap = this.m_remoteFieldNameMap;
        return obj;
    }

    public String getEnumValueFromAlias(String fldid, String alias) {
        int id;
        Field fld;
        if (fldid.equals(new Integer(15).toString())) {
            fldid = new Integer(7).toString();
        }
        if ((fld = this.m_localFieldIdMap.get(fldid)) == null && (id = ConversionUtil.getIntValue(fldid)) != 0) {
            fld = this.m_localFieldIdMap.get(id);
        }
        if (fld instanceof SelectionField) {
            return ((SelectionField)fld).getEnumValueFromAlias(this.m_vuiId, alias);
        }
        return null;
    }

    public String getEnumAliasFromValue(String fldid, int enumValue) {
        int id;
        Field fld = this.m_localFieldIdMap.get(fldid);
        if (fld == null && (id = ConversionUtil.getIntValue(fldid)) != 0) {
            fld = this.m_localFieldIdMap.get(id);
        }
        if (fld instanceof SelectionField) {
            return ((SelectionField)fld).getEnumAliasFromValue(this.m_vuiId, enumValue);
        }
        return null;
    }

    public void clear() {
        Util.clearMap(this.m_localFieldLabelMap);
        Util.clearMap(this.m_localFieldIdMap);
        Util.clearMap(this.m_remoteFieldNameMap);
        Util.clearMap(this.m_remoteFieldIdMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Local Field Label Map", this.m_localFieldLabelMap).append("Local Field Id Map", this.m_localFieldIdMap).append("Vui Id", this.m_vuiId).append("Remote Field Name Map", this.m_remoteFieldNameMap).append("Remote Field Id Map", this.m_remoteFieldIdMap).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_localFieldLabelMap).append(this.m_localFieldIdMap).append(this.m_vuiId).append(this.m_remoteFieldNameMap).append(this.m_remoteFieldIdMap).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ARQualifierHelper)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ARQualifierHelper rhs = (ARQualifierHelper)obj;
        return new EqualsBuilder().append(this.m_localFieldLabelMap, rhs.m_localFieldLabelMap).append(this.m_localFieldIdMap, rhs.m_localFieldIdMap).append(this.m_vuiId, rhs.m_vuiId).append(this.m_remoteFieldNameMap, rhs.m_remoteFieldNameMap).append(this.m_remoteFieldIdMap, rhs.m_remoteFieldIdMap).isEquals();
    }

    public Field getField(String fieldStr) {
        Field fld = null;
        if (this.m_localFieldLabelMap != null) {
            int id;
            fld = this.m_remoteFieldIdMap.get(fieldStr);
            if (fld == null && (id = ConversionUtil.getIntValue(fieldStr)) != 0) {
                fld = this.m_remoteFieldIdMap.get(id);
            }
            if (fld == null && this.m_remoteFieldNameMap != null) {
                fld = this.m_remoteFieldNameMap.get(fieldStr);
                id = ConversionUtil.getIntValue(fieldStr);
                if (id != 0) {
                    fld = this.m_remoteFieldIdMap.get(id);
                }
            }
        }
        return fld;
    }
}

