/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.transform;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class STRTransform
extends TransformSpi {
    public static final String implementedTransformURI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private static Log log = LogFactory.getLog((class$org$apache$ws$security$transform$STRTransform == null ? (class$org$apache$ws$security$transform$STRTransform = STRTransform.class$("org.apache.ws.security.transform.STRTransform")) : class$org$apache$ws$security$transform$STRTransform).getName());
    private static boolean doDebug = false;
    private static String XMLNS = "xmlns=";
    private WSDocInfo wsDocInfo = null;
    static /* synthetic */ Class class$org$apache$ws$security$transform$STRTransform;

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, Transform transformObject) throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug("Beginning STRTransform..." + input.toString());
        }
        try {
            Document thisDoc = transformObject.getDocument();
            this.wsDocInfo = WSDocInfoStore.lookup(thisDoc);
            if (this.wsDocInfo == null) {
                throw new CanonicalizationException("no WSDocInfo found");
            }
            String canonAlgo = null;
            if (transformObject.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters") == 1) {
                Element tmpE = XMLUtils.selectNode((Node)transformObject.getElement().getFirstChild(), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"TransformationParameters", (int)0);
                Element canonElem = (Element)WSSecurityUtil.getDirectChild(tmpE, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#");
                canonAlgo = canonElem.getAttribute("Algorithm");
                if (doDebug) {
                    log.debug("CanonAlgo: " + canonAlgo);
                }
            }
            Canonicalizer canon = Canonicalizer.getInstance(canonAlgo);
            ByteArrayOutputStream bos = null;
            byte[] buf = null;
            if (doDebug) {
                buf = input.getBytes();
                bos = new ByteArrayOutputStream(buf.length);
                bos.write(buf, 0, buf.length);
                log.debug("canon bos: " + bos.toString());
            }
            Element str = null;
            if (!input.isElement()) {
                throw new CanonicalizationException("Wrong input format - only element input supported");
            }
            str = (Element)input.getSubNode();
            if (doDebug) {
                log.debug("STR: " + str.toString());
            }
            SecurityTokenReference secRef = new SecurityTokenReference(str);
            Element dereferencedToken = this.dereferenceSTR(thisDoc, secRef);
            buf = canon.canonicalizeSubtree((Node)dereferencedToken, "#default");
            if (doDebug) {
                bos = new ByteArrayOutputStream(buf.length);
                bos.write(buf, 0, buf.length);
                log.debug("after c14n: " + bos.toString());
            }
            StringBuffer bf = new StringBuffer(new String(buf));
            String bf1 = bf.toString();
            int gt = bf1.indexOf(">");
            int idx = bf1.indexOf(XMLNS);
            if (idx < 0 || idx > gt) {
                idx = bf1.indexOf(" ");
                bf.insert(idx + 1, "xmlns=\"\" ");
                bf1 = bf.toString();
            }
            if (doDebug) {
                log.debug("last result: ");
                log.debug(bf1);
            }
            return new XMLSignatureInput(bf1.getBytes());
        }
        catch (WSSecurityException ex) {
            log.debug(ex.getMessage(), ex);
            throw new CanonicalizationException("c14n.Canonicalizer.Exception", (Exception)ex);
        }
    }

    private Element dereferenceSTR(Document doc, SecurityTokenReference secRef) throws WSSecurityException {
        Element tokElement = null;
        if (secRef.containsReference()) {
            if (doDebug) {
                log.debug("STR: Reference");
            }
            tokElement = secRef.getTokenElement(doc, this.wsDocInfo, null);
        } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
            if (doDebug) {
                log.debug("STR: IssuerSerial");
            }
            X509Certificate cert = null;
            X509Certificate[] certs = secRef.getX509IssuerSerial(this.wsDocInfo.getCrypto());
            if (certs == null || certs.length == 0 || certs[0] == null) {
                throw new WSSecurityException(6);
            }
            cert = certs[0];
            tokElement = this.createBSTX509(doc, cert, secRef.getElement());
        } else if (secRef.containsKeyIdentifier()) {
            if (doDebug) {
                log.debug("STR: KeyIdentifier");
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType())) {
                tokElement = secRef.getKeyIdentifierTokenElement(doc, this.wsDocInfo, null);
            } else {
                X509Certificate cert = null;
                X509Certificate[] certs = secRef.getKeyIdentifier(this.wsDocInfo.getCrypto());
                if (certs == null || certs.length == 0 || certs[0] == null) {
                    throw new WSSecurityException(6);
                }
                cert = certs[0];
                tokElement = this.createBSTX509(doc, cert, secRef.getElement());
            }
        }
        return tokElement;
    }

    private Element createBSTX509(Document doc, X509Certificate cert, Element secRefE) throws WSSecurityException {
        byte[] data;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError", null, e);
        }
        String prefix = WSSecurityUtil.getPrefixNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", secRefE);
        Element elem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", prefix + ":BinarySecurityToken");
        WSSecurityUtil.setNamespace(elem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", prefix);
        elem.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        Text certText = doc.createTextNode(Base64.encode(data));
        elem.appendChild(certText);
        return elem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

