/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSSecSignature
extends WSSecBase {
    private static Log log = LogFactory.getLog((class$org$apache$ws$security$message$WSSecSignature == null ? (class$org$apache$ws$security$message$WSSecSignature = WSSecSignature.class$("org.apache.ws.security.message.WSSecSignature")) : class$org$apache$ws$security$message$WSSecSignature).getName());
    protected boolean useSingleCert = true;
    protected String sigAlgo = null;
    protected String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected WSSecUsernameToken usernameToken = null;
    protected byte[] signatureValue = null;
    protected Document document = null;
    private Crypto crypto = null;
    protected WSDocInfo wsDocInfo = null;
    protected String certUri = null;
    protected XMLSignature sig = null;
    protected KeyInfo keyInfo = null;
    protected String keyInfoUri = null;
    protected SecurityTokenReference secRef = null;
    protected String strUri = null;
    private byte[] secretKey = null;
    private String encrKeySha1value = null;
    protected BinarySecurity bstToken = null;
    private String customTokenValueType;
    private String customTokenId;
    private String digestAlgo = "http://www.w3.org/2000/09/xmldsig#sha1";
    private X509Certificate useThisCert = null;
    static /* synthetic */ Class class$org$apache$ws$security$message$WSSecSignature;

    public void setUseSingleCertificate(boolean useSingleCert) {
        this.useSingleCert = useSingleCert;
    }

    public boolean isUseSingleCertificate() {
        return this.useSingleCert;
    }

    public void setSignatureAlgorithm(String algo) {
        this.sigAlgo = algo;
    }

    public String getSignatureAlgorithm() {
        return this.sigAlgo;
    }

    public void setSigCanonicalization(String algo) {
        this.canonAlgo = algo;
    }

    public String getSigCanonicalization() {
        return this.canonAlgo;
    }

    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    public void setDigestAlgo(String digestAlgo) {
        this.digestAlgo = digestAlgo;
    }

    public void setUsernameToken(WSSecUsernameToken usernameToken) {
        this.usernameToken = usernameToken;
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    public String getId() {
        if (this.sig == null) {
            return null;
        }
        return this.sig.getId();
    }

    public String getBSTTokenId() {
        if (this.bstToken == null) {
            return null;
        }
        return this.bstToken.getID();
    }

    public void prepare(Document doc, Crypto cr, WSSecHeader secHeader) throws WSSecurityException {
        this.crypto = cr;
        this.document = doc;
        this.wsDocInfo = new WSDocInfo(doc);
        this.wsDocInfo.setCrypto(cr);
        X509Certificate[] certs = null;
        if (this.keyIdentifierType != 7 && this.keyIdentifierType != 9 && this.keyIdentifierType != 11 && this.keyIdentifierType != 10 && this.keyIdentifierType != 12) {
            certs = this.useThisCert == null ? this.crypto.getCertificates(this.user) : new X509Certificate[]{this.useThisCert};
            if (certs == null || certs.length <= 0) {
                throw new WSSecurityException(0, "noUserCertsFound", new Object[]{this.user, "signature"});
            }
            this.certUri = this.wssConfig.getIdAllocator().createSecureId("CertId-", certs[0]);
            if (this.sigAlgo == null) {
                String pubKeyAlgo = certs[0].getPublicKey().getAlgorithm();
                log.debug("automatic sig algo detection: " + pubKeyAlgo);
                if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                } else {
                    throw new WSSecurityException(0, "unknownSignatureAlgorithm", new Object[]{pubKeyAlgo});
                }
            }
        }
        if (this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            Element canonElem = XMLUtils.createElementInSignatureSpace((Document)doc, (String)"CanonicalizationMethod");
            canonElem.setAttributeNS(null, "Algorithm", this.canonAlgo);
            if (this.wssConfig.isWsiBSPCompliant()) {
                Set prefixes = this.getInclusivePrefixes(secHeader.getSecurityHeader(), false);
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(doc, prefixes);
                canonElem.appendChild(inclusiveNamespaces.getElement());
            }
            try {
                SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(doc, this.sigAlgo);
                this.sig = new XMLSignature(doc, null, signatureAlgorithm.getElement(), canonElem);
            }
            catch (XMLSecurityException e) {
                log.error("", e);
                throw new WSSecurityException(10, "noXMLSig", null, e);
            }
        }
        try {
            this.sig = new XMLSignature(doc, null, this.sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            log.error("", e);
            throw new WSSecurityException(10, "noXMLSig", null, e);
        }
        this.sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        this.sig.setId(this.wssConfig.getIdAllocator().createId("Signature-", this.sig));
        this.keyInfo = this.sig.getKeyInfo();
        this.keyInfoUri = this.wssConfig.getIdAllocator().createSecureId("KeyId-", this.keyInfo);
        this.keyInfo.setId(this.keyInfoUri);
        this.secRef = new SecurityTokenReference(doc);
        this.strUri = this.wssConfig.getIdAllocator().createSecureId("STRId-", this.secRef);
        this.secRef.setID(this.strUri);
        switch (this.keyIdentifierType) {
            case 1: {
                Reference ref = new Reference(this.document);
                ref.setURI("#" + this.certUri);
                if (!this.useSingleCert) {
                    this.bstToken = new PKIPathSecurity(this.document);
                    ((PKIPathSecurity)this.bstToken).setX509Certificates(certs, false, this.crypto);
                } else {
                    this.bstToken = new X509Security(this.document);
                    ((X509Security)this.bstToken).setX509Certificate(certs[0]);
                }
                ref.setValueType(this.bstToken.getValueType());
                this.secRef.setReference(ref);
                this.bstToken.setID(this.certUri);
                this.wsDocInfo.setBst(this.bstToken.getElement());
                break;
            }
            case 2: {
                XMLX509IssuerSerial data = new XMLX509IssuerSerial(this.document, certs[0]);
                X509Data x509Data = new X509Data(this.document);
                x509Data.add(data);
                this.secRef.setX509IssuerSerial(x509Data);
                break;
            }
            case 3: {
                this.secRef.setKeyIdentifier(certs[0]);
                break;
            }
            case 4: {
                this.secRef.setKeyIdentifierSKI(certs[0], this.crypto);
                break;
            }
            case 7: {
                Reference refUt = new Reference(this.document);
                refUt.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
                String utId = this.usernameToken.getId();
                refUt.setURI("#" + utId);
                this.secRef.setReference(refUt);
                this.secretKey = this.usernameToken.getSecretKey();
                break;
            }
            case 8: {
                this.secRef.setKeyIdentifierThumb(certs[0]);
                break;
            }
            case 10: {
                if (this.encrKeySha1value != null) {
                    this.secRef.setKeyIdentifierEncKeySHA1(this.encrKeySha1value);
                    break;
                }
                this.secRef.setKeyIdentifierEncKeySHA1(this.getSHA1(this.secretKey));
                break;
            }
            case 9: {
                Reference refCust = new Reference(this.document);
                refCust.setValueType(this.customTokenValueType);
                refCust.setURI("#" + this.customTokenId);
                this.secRef.setReference(refCust);
                break;
            }
            case 11: {
                Reference refCustd = new Reference(this.document);
                refCustd.setValueType(this.customTokenValueType);
                refCustd.setURI(this.customTokenId);
                this.secRef.setReference(refCustd);
                break;
            }
            case 12: {
                this.secRef.setKeyIdentifier(this.customTokenValueType, this.customTokenId);
                break;
            }
            case 13: {
                PublicKey publicKey = certs[0].getPublicKey();
                String pubKeyAlgo = publicKey.getAlgorithm();
                if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                    DSAKeyValue dsaKeyValue = new DSAKeyValue(this.document, (Key)publicKey);
                    this.keyInfo.add(dsaKeyValue);
                    break;
                }
                if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                    RSAKeyValue rsaKeyValue = new RSAKeyValue(this.document, (Key)publicKey);
                    this.keyInfo.add(rsaKeyValue);
                    break;
                }
                throw new WSSecurityException(0, "unknownSignatureAlgorithm", new Object[]{pubKeyAlgo});
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        if (this.keyIdentifierType != 13) {
            this.keyInfo.addUnknownElement(this.secRef.getElement());
        }
    }

    public void addReferencesToSign(Vector references, WSSecHeader secHeader) throws WSSecurityException {
        Element envelope = this.document.getDocumentElement();
        for (int part = 0; part < references.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)references.get(part);
            String idToSign = encPart.getId();
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            Transforms transforms = new Transforms(this.document);
            try {
                if (idToSign != null) {
                    Element toSignById = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToSign, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                    if (toSignById == null) {
                        toSignById = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToSign, null);
                    }
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(toSignById)).getElement());
                    }
                    this.sig.addDocument("#" + idToSign, transforms, this.digestAlgo);
                    continue;
                }
                if (elemName.equals("Token")) {
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.keyIdentifierType == 1) {
                        if (this.wssConfig.isWsiBSPCompliant()) {
                            transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(secHeader.getSecurityHeader())).getElement());
                        }
                        this.sig.addDocument("#" + this.certUri, transforms, this.digestAlgo);
                        continue;
                    }
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(this.keyInfo.getElement())).getElement());
                    }
                    this.sig.addDocument("#" + this.keyInfoUri, transforms, this.digestAlgo);
                    continue;
                }
                if (elemName.equals("STRTransform")) {
                    Element ctx = this.createSTRParameter(this.document);
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                    this.sig.addDocument("#" + this.strUri, transforms, this.digestAlgo);
                    continue;
                }
                if (elemName.equals("Assertion")) {
                    String id = null;
                    id = SAMLUtil.getAssertionId(envelope, elemName, nmSpace);
                    Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                    if (body == null) {
                        throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                    }
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(body)).getElement());
                    }
                    String prefix = WSSecurityUtil.setNamespace(body, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                    body.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
                    this.sig.addDocument("#" + id, transforms, this.digestAlgo);
                    continue;
                }
                Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                if (body == null) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                if (this.wssConfig.isWsiBSPCompliant()) {
                    transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(body)).getElement());
                }
                this.sig.addDocument("#" + this.setWsuId(body), transforms, this.digestAlgo);
                continue;
            }
            catch (TransformationException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, e1);
            }
            catch (XMLSignatureException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, e1);
            }
        }
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.sig.getElement());
    }

    public void appendToHeader(WSSecHeader secHeader) {
        Element secHeaderElement = secHeader.getSecurityHeader();
        secHeaderElement.appendChild(this.sig.getElement());
    }

    public void prependBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.bstToken.getElement());
        }
        this.bstToken = null;
    }

    public Element getSignatureElement() {
        return this.sig.getElement();
    }

    public Element getBinarySecurityTokenElement() {
        if (this.bstToken != null) {
            return this.bstToken.getElement();
        }
        return null;
    }

    public void appendBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            Element secHeaderElement = secHeader.getSecurityHeader();
            secHeaderElement.appendChild(this.bstToken.getElement());
        }
        this.bstToken = null;
    }

    public void computeSignature() throws WSSecurityException {
        boolean remove = WSDocInfoStore.store(this.wsDocInfo);
        try {
            if (this.keyIdentifierType == 7 || this.keyIdentifierType == 9 || this.keyIdentifierType == 11 || this.keyIdentifierType == 12 || this.keyIdentifierType == 10) {
                if (this.secretKey == null) {
                    this.sig.sign((Key)this.crypto.getPrivateKey(this.user, this.password));
                } else {
                    this.sig.sign((Key)this.sig.createSecretKey(this.secretKey));
                }
            } else {
                this.sig.sign((Key)this.crypto.getPrivateKey(this.user, this.password));
            }
            this.signatureValue = this.sig.getSignatureValue();
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        catch (Exception e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        finally {
            if (remove) {
                WSDocInfoStore.delete(this.wsDocInfo);
            }
        }
    }

    public Document build(Document doc, Crypto cr, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug("Beginning signing...");
        }
        this.prepare(doc, cr, secHeader);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        this.addReferencesToSign(this.parts, secHeader);
        this.prependToHeader(secHeader);
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        this.computeSignature();
        return doc;
    }

    protected Element createSTRParameter(Document doc) {
        Element transformParam = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
        WSSecurityUtil.setNamespace(transformParam, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        Element canonElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        WSSecurityUtil.setNamespace(canonElem, "http://www.w3.org/2000/09/xmldsig#", "ds");
        canonElem.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        transformParam.appendChild(canonElem);
        return transformParam;
    }

    protected Set getInclusivePrefixes(Element target) {
        return this.getInclusivePrefixes(target, true);
    }

    protected Set getInclusivePrefixes(Element target, boolean excludeVisible) {
        Node attribute;
        int i;
        NamedNodeMap attributes;
        HashSet<String> result = new HashSet<String>();
        Node parent = target;
        while (!(parent.getParentNode() instanceof Document)) {
            parent = parent.getParentNode();
            attributes = parent.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (attribute.getNamespaceURI() == null || !attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                if (attribute.getNodeName().equals("xmlns")) {
                    result.add("#default");
                    continue;
                }
                result.add(attribute.getLocalName());
            }
        }
        if (excludeVisible) {
            attributes = target.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                    if (attribute.getNodeName().equals("xmlns")) {
                        result.remove("#default");
                    } else {
                        result.remove(attribute.getLocalName());
                    }
                }
                if (attribute.getPrefix() == null) continue;
                result.remove(attribute.getPrefix());
            }
            if (target.getPrefix() == null) {
                result.remove("#default");
            } else {
                result.remove(target.getPrefix());
            }
        }
        return result;
    }

    public void setSecretKey(byte[] secretKey) {
        this.secretKey = secretKey;
    }

    public void setCustomTokenValueType(String customTokenValueType) {
        this.customTokenValueType = customTokenValueType;
    }

    public void setCustomTokenId(String customTokenId) {
        this.customTokenId = customTokenId;
    }

    public void setEncrKeySha1value(String encrKeySha1value) {
        this.encrKeySha1value = encrKeySha1value;
    }

    public void setX509Certificate(X509Certificate cer) {
        this.useThisCert = cer;
    }

    private String getSHA1(byte[] input) throws WSSecurityException {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            sha.reset();
            sha.update(input);
            byte[] data = sha.digest();
            return Base64.encode(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(2, null, null, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

