/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdlgen;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.mapping.ARSOperation;
import com.bmc.arsys.ws.mapping.ARSPort;
import com.bmc.arsys.ws.mapping.ARSWebService;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.CustomXmlSchemaParser;
import com.bmc.arsys.ws.wsdlgen.LiteralTypesGenerator;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsdlGenerator {
    protected ArrayList<ARSWebService> listWebServices = null;
    protected Definition def = null;
    protected HashMap<String, String> namespaces = new HashMap();
    protected Document outputDoc = null;
    protected LiteralTypesGenerator typesGenerator = null;
    protected CustomXmlSchemaParser schemaParser = null;
    protected boolean isLinked = false;
    protected StringBuffer warnings = new StringBuffer();
    public static final String URI_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static String AUTH_MESSAGE_NAME = "ARAuthenticate";
    public static String AUTH_ELEMENT_NAME = "AuthenticationInfo";
    public static String AUTH_TYPE_NAME = "AuthenticationInfo";

    public WsdlGenerator(ARSWebService ws, String schemaInfo, StringBuffer warnings) {
        this.listWebServices = new ArrayList();
        this.listWebServices.add(ws);
        this.warnings = warnings;
        this.schemaParser = new CustomXmlSchemaParser(warnings);
        this.schemaParser.parseSchema(ws.getTargetNamespace(), schemaInfo);
        this.isLinked = this.schemaParser.getIsLinked();
    }

    public WsdlGenerator(ArrayList<ARSWebService> ws, String schemaInfo, StringBuffer warnings) {
        this.listWebServices = ws;
        if (this.listWebServices.size() > 0) {
            this.warnings = warnings;
            this.schemaParser = new CustomXmlSchemaParser(warnings);
            this.schemaParser.parseSchema(this.listWebServices.get(0).getTargetNamespace(), schemaInfo);
            this.isLinked = this.schemaParser.getIsLinked();
        }
    }

    public Document generateWsdl() {
        if (this.listWebServices.size() > 0) {
            try {
                this.def = WSDLFactory.newInstance().newDefinition();
            }
            catch (WSDLException e) {
                throw new ARWSException(e);
            }
            this.typesGenerator = new LiteralTypesGenerator(this.listWebServices.get(0).getTargetNamespace(), "s0");
            this.writeNamespaces();
            this.writeWebServices();
            for (String namespace : this.schemaParser.getNsPrefixMap().keySet()) {
                String nsPrefix = (String)this.schemaParser.getNsPrefixMap().get(namespace);
                this.def.addNamespace(nsPrefix, namespace);
                this.namespaces.put(namespace, nsPrefix);
            }
            try {
                this.outputDoc = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.def);
            }
            catch (WSDLException e) {
                throw new ARWSException(e);
            }
            Element typesElement = this.typesGenerator.getTypesElement();
            if (typesElement != null) {
                if (!this.isLinked) {
                    this.schemaParser.emdedSchemas(typesElement);
                }
                this.typesGenerator.createImports(this.schemaParser.getExternalNamespaces(), this.isLinked);
                this.outputDoc.getDocumentElement().insertBefore(this.outputDoc.importNode(typesElement, true), this.outputDoc.getDocumentElement().getFirstChild());
            }
        }
        return this.outputDoc;
    }

    protected void writeNamespaces() {
        for (int i = 0; i < this.listWebServices.size(); ++i) {
            ARSWebService ws = this.listWebServices.get(i);
            String prefix = "s" + i;
            if (!this.namespaces.containsKey(ws.getTargetNamespace())) {
                this.def.addNamespace(prefix, ws.getTargetNamespace());
                this.namespaces.put(ws.getTargetNamespace(), prefix);
            }
            Collection ports = ws.getPorts();
            Iterator iter = ports.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ARSPort port = (ARSPort)iter.next();
                String nspace = port.getTargetNamespace();
                String nsprefix = "s" + i + "" + count;
                if (this.namespaces.containsKey(nspace)) continue;
                this.def.addNamespace(nsprefix, nspace);
                this.namespaces.put(nspace, nsprefix);
                ++count;
            }
        }
        this.def.setTargetNamespace(this.listWebServices.get(0).getTargetNamespace());
        this.def.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.def.addNamespace("wsdl", URI_WSDL);
        this.namespaces.put("wsdl", URI_WSDL);
        this.def.addNamespace("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
        this.namespaces.put(Constants.URI_DEFAULT_SOAP_ENC, "soapenc");
        this.def.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.put("http://www.w3.org/2001/XMLSchema", "xsd");
    }

    protected void writeWebServices() {
        for (int i = 0; i < this.listWebServices.size(); ++i) {
            ARSWebService ws = this.listWebServices.get(i);
            this.writeService(ws);
        }
    }

    protected Binding writeBinding(ARSPort arsPort) {
        Binding binding = this.def.createBinding();
        binding.setUndefined(false);
        binding.setQName(new QName(arsPort.getTargetNamespace(), arsPort.getName() + "SoapBinding"));
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        soapBinding.setStyle(arsPort.getBindingStyle());
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement(soapBinding);
        this.def.addBinding(binding);
        return binding;
    }

    protected void writePortType(Binding binding, ARSPort arsPort) {
        PortType portType = this.def.createPortType();
        portType.setUndefined(false);
        portType.setQName(new QName(arsPort.getTargetNamespace(), arsPort.getName() + "PortType"));
        for (ARSOperation op : arsPort.getOperations()) {
            Operation oper = this.writeOperation(binding, op.getName(), arsPort);
            this.writeMessages(oper, op, arsPort);
            portType.addOperation(oper);
        }
        this.writeAuthenticationMessage(arsPort);
        this.def.addPortType(portType);
        binding.setPortType(portType);
    }

    protected Operation writeOperation(Binding binding, String operName, ARSPort arsPort) {
        Operation oper = this.def.createOperation();
        oper.setName(operName);
        oper.setUndefined(false);
        this.writeBindingOperation(binding, oper, arsPort);
        return oper;
    }

    protected void writeAuthenticationHeaderInfo(BindingInput bindingInput, ARSPort arsPort) {
        QName qName = new QName(arsPort.getTargetNamespace(), AUTH_MESSAGE_NAME);
        SOAPHeaderImpl soapHeader = new SOAPHeaderImpl();
        soapHeader.setMessage(qName);
        if (arsPort.getUseStyle().equals("literal")) {
            soapHeader.setUse("literal");
            soapHeader.setPart("parameters");
        } else if (arsPort.getUseStyle().equals("encoded")) {
            soapHeader.setPart(AUTH_ELEMENT_NAME);
            soapHeader.setUse("encoded");
            LinkedList<String> encodingList = new LinkedList<String>();
            encodingList.add(Constants.URI_DEFAULT_SOAP_ENC);
            soapHeader.setEncodingStyles(encodingList);
        }
        bindingInput.addExtensibilityElement(soapHeader);
    }

    protected void writeBindingOperation(Binding binding, Operation oper, ARSPort arsPort) {
        BindingOperation bindingOper = this.def.createBindingOperation();
        BindingInput bindingInput = this.def.createBindingInput();
        BindingOutput bindingOutput = this.def.createBindingOutput();
        bindingOper.setName(oper.getName());
        SOAPOperationImpl soapOper = new SOAPOperationImpl();
        soapOper.setSoapActionURI(arsPort.getTargetNamespace() + "/" + oper.getName());
        soapOper.setStyle(arsPort.getBindingStyle());
        bindingOper.addExtensibilityElement(soapOper);
        this.writeAuthenticationHeaderInfo(bindingInput, arsPort);
        SOAPBodyImpl soapBody = new SOAPBodyImpl();
        soapBody.setUse(arsPort.getUseStyle());
        if (arsPort.getUseStyle().equals("encoded")) {
            Element rootElement;
            ARSMapping map;
            soapBody.setNamespaceURI(arsPort.getTargetNamespace());
            ARSOperation op = arsPort.getOperation(oper.getName());
            if (op != null && (map = arsPort.getMapping(op.getInputMappingName())) != null && (rootElement = map.getRootElement()) != null) {
                soapBody.setNamespaceURI(rootElement.getAttribute("targetNamespace"));
            }
            LinkedList<String> encodingList = new LinkedList<String>();
            encodingList.add(Constants.URI_DEFAULT_SOAP_ENC);
            soapBody.setEncodingStyles(encodingList);
        }
        bindingInput.addExtensibilityElement(soapBody);
        bindingOutput.addExtensibilityElement(soapBody);
        bindingOper.setBindingInput(bindingInput);
        bindingOper.setBindingOutput(bindingOutput);
        binding.addBindingOperation(bindingOper);
    }

    protected void writeService(ARSWebService ws) {
        Service service = this.def.createService();
        service.setQName(new QName(ws.getTargetNamespace(), ws.getName() + "Service"));
        this.def.addService(service);
        Collection ports = ws.getPorts();
        if (ports != null && ports.size() > 0) {
            for (ARSPort port : ports) {
                Binding binding = this.writeBinding(port);
                this.writePortType(binding, port);
                Port wsdlport = this.writePort(binding, port);
                service.addPort(wsdlport);
            }
        }
        if (ws.getDescription() != null && !ws.getDescription().equals("")) {
            Document doc = WsdlUtil.newDocument();
            Element docElement = doc.createElement("wsdl:documentation");
            docElement.appendChild(doc.createTextNode(ws.getDescription()));
            service.setDocumentationElement(docElement);
        }
    }

    protected Port writePort(Binding binding, ARSPort arsPort) {
        Port port = this.def.createPort();
        port.setBinding(binding);
        port.setName(arsPort.getName() + "Soap");
        SOAPAddressImpl addr = new SOAPAddressImpl();
        if (arsPort.getLocationURI() != null && !arsPort.getLocationURI().equals("")) {
            addr.setLocationURI(arsPort.getLocationURI());
        } else {
            addr.setLocationURI("@LOCATION@");
        }
        port.addExtensibilityElement(addr);
        return port;
    }

    protected void writeMessages(Operation oper, ARSOperation arOp, ARSPort arsPort) {
        Input input = this.def.createInput();
        Message msg = this.writeMessage(arOp.getName() + "SoapIn", arOp.getInputTopElement(), arsPort.getMapping(arOp.getInputMappingName()), arsPort);
        input.setMessage(msg);
        oper.setInput(input);
        this.def.addMessage(msg);
        msg = this.writeMessage(arOp.getName() + "SoapOut", arOp.getOutputTopElement(), arsPort.getMapping(arOp.getOutputMappingName()), arsPort);
        Output output = this.def.createOutput();
        output.setMessage(msg);
        oper.setOutput(output);
        this.def.addMessage(msg);
    }

    protected Message writeMessage(String messageName, String topElement, ARSMapping mapping, ARSPort arsPort) {
        if (mapping.getExternalSchema() != null) {
            this.schemaParser.parseSchema(arsPort.getTargetNamespace(), mapping.getExternalSchema());
            if (mapping.isXmlSchemaLinked()) {
                this.isLinked = true;
            }
        }
        Message msg = this.def.createMessage();
        QName qName = new QName(arsPort.getTargetNamespace(), messageName);
        msg.setQName(qName);
        msg.setUndefined(false);
        if (arsPort.getBindingStyle().equals("document") && arsPort.getUseStyle().equals("literal")) {
            Part part = this.def.createPart();
            QName typeQName = new QName(arsPort.getTargetNamespace(), topElement);
            part.setElementName(typeQName);
            part.setName("parameters");
            msg.addPart(part);
            if (mapping.getMappingMode() == 3 || mapping.getMappingMode() == 2) {
                this.typesGenerator.writeLinkedTopLevelElement(topElement, mapping, this.schemaParser.getNsPrefixMap());
            } else {
                this.typesGenerator.writeTopLevelElement(topElement, mapping);
            }
        } else {
            for (Node node = ARSMapping.skipToFirstMappingElement(mapping.getMappingElement(), true); node != null; node = node.getNextSibling()) {
                Element childElem;
                if (node.getNodeType() != 1 || !(childElem = node).getLocalName().equals("element")) continue;
                Part part = this.def.createPart();
                String elemName = childElem.getAttribute("name");
                String elemType = childElem.getAttribute("dataType");
                String elemComplexType = childElem.getAttribute("complexType");
                String elemEnumValues = childElem.getAttribute("enumValues");
                String elemNamespace = childElem.getAttribute("targetNamespace");
                if (elemNamespace == null) {
                    elemNamespace = arsPort.getTargetNamespace();
                }
                if (elemComplexType != null && !elemComplexType.equals("")) {
                    part.setTypeName(new QName(elemNamespace, elemComplexType));
                    if (elemNamespace.equals(arsPort.getTargetNamespace())) {
                        this.typesGenerator.writeMappingGlobalComplexType(childElem, elemComplexType);
                    }
                } else if (elemType == null || elemType.equals("")) {
                    part.setTypeName(new QName(arsPort.getTargetNamespace(), elemName + "Type"));
                    this.typesGenerator.writeMappingGlobalComplexType(childElem, elemName + "Type");
                } else if (elemEnumValues != null && !elemEnumValues.equals("")) {
                    Element simpleType = this.typesGenerator.writeMappingGlobalEnumType(childElem);
                    part.setTypeName(new QName(arsPort.getTargetNamespace(), simpleType.getAttribute("name")));
                } else {
                    part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", elemType));
                }
                part.setName(elemName);
                msg.addPart(part);
            }
        }
        return msg;
    }

    protected void writeAuthenticationMessage(ARSPort arsPort) {
        Message msg = this.def.createMessage();
        QName qName = new QName(arsPort.getTargetNamespace(), AUTH_MESSAGE_NAME);
        msg.setQName(qName);
        msg.setUndefined(false);
        Part part = this.def.createPart();
        msg.addPart(part);
        if (arsPort.getBindingStyle().equals("document") && arsPort.getUseStyle().equals("literal")) {
            QName typeQName = new QName(arsPort.getTargetNamespace(), AUTH_ELEMENT_NAME);
            part.setElementName(typeQName);
            part.setName("parameters");
            this.typesGenerator.writeAuthenticationElem();
        } else {
            QName typeQName = new QName(arsPort.getTargetNamespace(), AUTH_TYPE_NAME);
            part.setTypeName(typeQName);
            part.setName(AUTH_ELEMENT_NAME);
            this.typesGenerator.writeAuthenticationType();
        }
        this.def.addMessage(msg);
    }
}

