/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import java.io.File;
import java.net.URI;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class XMLSchemaParser
implements DOMErrorHandler {
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    public static final int BIG_PRIME = 2039;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected XMLGrammarPoolImpl grammarPool;
    protected XMLParserConfiguration parserConfiguration = null;
    protected Document mapDom = null;
    protected String currentTargetNamespace = null;
    protected XSModel model;
    protected XSNamedMap elementMap;
    protected XSNamedMap attributeMap;
    protected XSNamedMap typeDefMap;
    protected XSNamedMap notationMap;
    protected String tempDir = null;
    protected HashMap<Object, Object> schemaLocationMap = new HashMap();
    protected StringBuffer warnings = new StringBuffer();
    public static final int SEVERITY_NONE = -1;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_ERROR = 2;
    public static final int SEVERITY_FATAL_ERROR = 3;
    private Stack<String> complexNameStack;
    private HashMap<String, String> attrFormDefaultMap;
    private HashMap<String, String> eleFormDefaultMap;
    public String baseUri = null;
    protected Grammar g = null;

    public XMLSchemaParser(String uri, StringBuffer warnings) {
        this.warnings = warnings;
        this.complexNameStack = new Stack();
        this.attrFormDefaultMap = new HashMap();
        this.eleFormDefaultMap = new HashMap();
        this.parseXMLSchema(uri);
    }

    public XMLSchemaParser(String baseUri, String uri, StringBuffer warnings) {
        this.warnings = warnings;
        this.complexNameStack = new Stack();
        this.attrFormDefaultMap = new HashMap();
        this.eleFormDefaultMap = new HashMap();
        this.setBaseUri(baseUri);
        this.parseXMLSchema(uri);
    }

    public XMLSchemaParser(String baseUri, String tempDir, String uri, StringBuffer warnings) {
        this.warnings = warnings;
        this.complexNameStack = new Stack();
        this.attrFormDefaultMap = new HashMap();
        this.eleFormDefaultMap = new HashMap();
        this.tempDir = tempDir + System.getProperty("file.separator");
        this.setBaseUri(baseUri);
        this.parseXMLSchema(uri);
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getElementFormDefault(String nspc) {
        String value = this.eleFormDefaultMap.get(nspc);
        if (value == null || value.equals("")) {
            value = "unqualified";
        }
        return value;
    }

    public String getAttributeFormDefault(String nspc) {
        String value = this.attrFormDefaultMap.get(nspc);
        if (value == null || value.equals("")) {
            value = "unqualified";
        }
        return value;
    }

    @Override
    public boolean handleError(DOMError error) {
        if (error.getSeverity() >= 3 && error.getRelatedException() instanceof RuntimeException) {
            throw (RuntimeException)error.getRelatedException();
        }
        this.warnings.append("WARNING:");
        if (error.getRelatedException() instanceof XMLParseException) {
            XMLParseException ex = (XMLParseException)error.getRelatedException();
            String systemId = ex.getExpandedSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                this.warnings.append(systemId);
            }
            this.warnings.append(":" + ex.getLineNumber() + ":" + ex.getColumnNumber() + ": " + ex.getMessage());
        } else {
            this.warnings.append(error.getMessage());
        }
        this.warnings.append(System.getProperty("line.separator"));
        return true;
    }

    private boolean isRelativePath(String uri) {
        try {
            return !new URI(uri).isAbsolute();
        }
        catch (Exception e) {
            return !new File(uri).isAbsolute();
        }
    }

    private void extractFormDefaultValues(String uri) {
        if (uri != null) {
            NodeList imports;
            if (uri.equals(Constants.URI_DEFAULT_SOAP_ENC)) {
                return;
            }
            this.schemaLocationMap.put(uri, uri);
            Document schemaDom = WsdlUtil.newDocument(uri, false);
            Element schemaElem = schemaDom.getDocumentElement();
            String elementFormDefault = "unqualified";
            String attributeFormDefault = "unqualified";
            if (!schemaElem.getLocalName().equals("schema")) {
                throw new ARWSException("INVALID_XSD", "Schema " + uri + " does not have root element as schema");
            }
            String value = schemaElem.getAttribute("elementFormDefault");
            elementFormDefault = value != null && value.equals("qualified") ? "qualified" : "unqualified";
            value = schemaElem.getAttribute("attributeFormDefault");
            attributeFormDefault = value != null && value.equals("qualified") ? "qualified" : "unqualified";
            value = schemaElem.getAttribute("targetNamespace");
            if (value != null) {
                this.attrFormDefaultMap.put(value, attributeFormDefault);
                this.eleFormDefaultMap.put(value, elementFormDefault);
            }
            if ((imports = schemaElem.getChildNodes()) != null) {
                for (int i = 0; i < imports.getLength(); ++i) {
                    Object loc;
                    String location;
                    Element el;
                    Node node = imports.item(i);
                    if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("import") || (location = el.getAttribute("schemaLocation")) == null || location.length() <= 0) continue;
                    if (this.isRelativePath(location)) {
                        location = this.tempDir + location;
                    }
                    if ((loc = this.schemaLocationMap.get(location)) != null) continue;
                    this.extractFormDefaultValues(location);
                }
            }
        }
    }

    private static XMLInputSource stringToXIS(String uri) {
        return new XMLInputSource(null, uri, null);
    }

    protected void buildGrammarForValidation(String schema) {
        SymbolTable sym2 = new SymbolTable(2039);
        XMLGrammarPreparser preparser = new XMLGrammarPreparser(sym2);
        this.grammarPool = new XMLGrammarPoolImpl();
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        preparser.setProperty(GRAMMAR_POOL, this.grammarPool);
        preparser.setFeature(NAMESPACES_FEATURE_ID, true);
        preparser.setFeature(VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        boolean schemaFullChecking = false;
        boolean honourAllSchemaLocations = false;
        preparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, schemaFullChecking);
        preparser.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, honourAllSchemaLocations);
        try {
            this.g = preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", XMLSchemaParser.stringToXIS(schema));
        }
        catch (Exception e) {
            throw new ARWSException("INVALID_XSD", "Could not load schema " + e.toString() + " " + schema);
        }
        if (this.parserConfiguration == null) {
            this.parserConfiguration = new XIncludeAwareParserConfiguration(sym2, this.grammarPool);
        } else {
            this.parserConfiguration.setProperty(SYMBOL_TABLE, sym2);
            this.parserConfiguration.setProperty(GRAMMAR_POOL, this.grammarPool);
        }
        this.parserConfiguration.setFeature(NAMESPACES_FEATURE_ID, true);
        this.parserConfiguration.setFeature(VALIDATION_FEATURE_ID, true);
        this.parserConfiguration.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        this.parserConfiguration.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, schemaFullChecking);
        this.parserConfiguration.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, honourAllSchemaLocations);
    }

    protected void validateInputDoc(String inputDoc) {
        try {
            if (this.parserConfiguration != null) {
                this.parserConfiguration.parse(XMLSchemaParser.stringToXIS(inputDoc));
            }
        }
        catch (Exception e) {
            throw new ARWSException("OTHER_ERROR", "Input doc not found " + e.toString());
        }
    }

    protected void parseXMLSchema(String uri) {
        DOMImplementationRegistry registry;
        this.extractFormDefaultValues(uri);
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new ARWSException("OTHER_ERROR", "Error trying to get Registry: " + e.toString());
        }
        XSImplementation impl = (XSImplementation)((Object)registry.getDOMImplementation("XS-Loader"));
        XSLoader schemaLoader = impl.createXSLoader(null);
        DOMConfiguration config = schemaLoader.getConfig();
        config.setParameter("error-handler", this);
        config.setParameter("validate", Boolean.TRUE);
        System.out.println("Parsing " + uri + "...");
        this.model = schemaLoader.loadURI(uri);
        if (this.model != null) {
            this.elementMap = this.model.getComponents((short)2);
            this.attributeMap = this.model.getComponents((short)1);
            this.typeDefMap = this.model.getComponents((short)3);
            this.notationMap = this.model.getComponents((short)11);
        }
    }

    public Element parseSchemaForElement(Document outputDom, QName elementName) {
        XSElementDecl decl = (XSElementDecl)this.elementMap.itemByName(elementName.getNamespaceURI(), elementName.getLocalPart());
        if (decl == null) {
            throw new ARWSException("INVALID_XSD", "Cannot find element " + elementName.getLocalPart());
        }
        this.currentTargetNamespace = elementName.getNamespaceURI();
        this.mapDom = outputDom;
        DocumentFragment fragment = this.mapDom.createDocumentFragment();
        this.parseElement(fragment, decl);
        return (Element)fragment.getFirstChild();
    }

    public void parseSchemaForType(Element partElem, QName typeName) {
        XSTypeDefinition tdecl = (XSTypeDefinition)this.typeDefMap.itemByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        if (tdecl == null) {
            throw new ARWSException("INVALID_XSD", "Cannot find type " + typeName.getLocalPart());
        }
        this.currentTargetNamespace = typeName.getNamespaceURI();
        this.mapDom = partElem.getOwnerDocument();
        if (tdecl.getTypeCategory() == 16) {
            this.parseSimpleType(partElem, (XSSimpleType)tdecl);
        } else if (tdecl.getTypeCategory() == 15) {
            this.parseComplexType(partElem, (XSComplexTypeDecl)tdecl);
        }
    }

    public Element parseElement(Node node, XSElementDecl decl) {
        Element newNode = this.mapDom.createElementNS(null, "element");
        newNode.setAttributeNS(null, "name", decl.fName);
        String currentXSElementNamespace = decl.fTargetNamespace;
        if (currentXSElementNamespace != null) {
            this.currentTargetNamespace = currentXSElementNamespace;
        }
        newNode.setAttributeNS(null, "targetNamespace", this.currentTargetNamespace);
        newNode.setAttributeNS(null, "form", decl.getScope() == 1 ? "qualified" : this.getElementFormDefault(currentXSElementNamespace));
        node.appendChild(newNode);
        XSTypeDefinition fType = decl.fType;
        if (fType != null) {
            short xsType = fType.getTypeCategory();
            String typeName = fType.getName();
            String targetns = fType.getNamespace();
            if (typeName != null && typeName.equals("anyType") && targetns != null && targetns.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA)) {
                this.parseAnyType(newNode, fType);
            } else if (xsType == 15) {
                this.parseComplexType(newNode, (XSComplexTypeDecl)fType);
            } else if (xsType == 16) {
                this.parseSimpleType(newNode, (XSSimpleType)fType);
                if (decl.getConstraintType() == 1) {
                    newNode.setAttributeNS(null, "default", decl.fDefault.normalizedValue);
                }
            } else {
                newNode.setAttributeNS(null, "xmlType", "true");
                newNode.setAttributeNS(null, "dataType", "string");
                this.warnings.append("WARNING: Unsupported type in parseElement, treating as xmlType" + decl + System.getProperty("line.separator"));
            }
        }
        return newNode;
    }

    public Element parseAttribute(Element node, XSComplexTypeDecl ctype) {
        Element newNode = null;
        XSAttributeGroupDecl attrGrp = ctype.getAttrGrp();
        if (attrGrp != null) {
            XSObjectList attrUseS = attrGrp.getAttributeUses();
            for (int i = 0; i < attrUseS.getLength(); ++i) {
                String name;
                XSAttributeDecl attDecl;
                XSAttributeUse existingAttrUse = (XSAttributeUse)attrUseS.item(i);
                if (existingAttrUse == null || (attDecl = (XSAttributeDecl)existingAttrUse.getAttrDeclaration()) == null || (name = attDecl.getName()) == null) continue;
                newNode = this.mapDom.createElementNS(null, "attribute");
                newNode.setAttributeNS(null, "name", name);
                if (attDecl.getNamespace() != null) {
                    this.currentTargetNamespace = attDecl.getNamespace();
                }
                newNode.setAttributeNS(null, "targetNamespace", this.currentTargetNamespace);
                if (attDecl.getNamespace() != null) {
                    newNode.setAttributeNS(null, "form", "qualified");
                } else {
                    newNode.setAttributeNS(null, "form", attDecl.getScope() == 1 ? "qualified" : this.getAttributeFormDefault(this.currentTargetNamespace));
                }
                if (attDecl.getConstraintType() == 1) {
                    newNode.setAttributeNS(null, "default", attDecl.getConstraintValue());
                }
                XSSimpleType sType = (XSSimpleType)attDecl.getTypeDefinition();
                this.parseSimpleType(newNode, sType);
                boolean req = existingAttrUse.getRequired();
                if (req) {
                    newNode.setAttributeNS(null, "use", "required");
                } else {
                    newNode.setAttributeNS(null, "use", "optional");
                }
                node.appendChild(newNode);
            }
        }
        return newNode;
    }

    public void parseChoice(Element node, XSParticle ptype) {
        XSModelGroupImpl xmgi = (XSModelGroupImpl)ptype.getTerm();
        if (xmgi.getCompositor() == 2) {
            XSObjectList ol = xmgi.getParticles();
            for (int i = 0; i < ol.getLength(); ++i) {
                this.parseParticle(node, (XSParticleDecl)ol.item(i));
            }
        } else {
            this.parseParticle(node, (XSParticleDecl)ptype);
        }
    }

    public void parseAll(Element node, XSParticle ptype) {
        node.setAttributeNS(null, "all", "true");
        XSModelGroupImpl xmgi = (XSModelGroupImpl)ptype.getTerm();
        if (xmgi.getCompositor() == 3) {
            XSObjectList ol = xmgi.getParticles();
            for (int i = 0; i < ol.getLength(); ++i) {
                this.parseParticle(node, (XSParticleDecl)ol.item(i));
            }
        } else {
            this.parseParticle(node, (XSParticleDecl)ptype);
        }
    }

    public void parseAnyType(Element node, XSTypeDefinition atype) {
        node.setAttributeNS(null, "dataType", "string");
    }

    public void parseSimpleType(Element node, XSSimpleType stype) {
        if (stype == null) {
            return;
        }
        if (stype.getVariety() == 1) {
            XSTypeDefinition newCurrType;
            XSTypeDefinition currType = stype;
            while ((currType.getNamespace() == null || currType.getNamespace() != null && !currType.getNamespace().equals(SchemaSymbols.URI_SCHEMAFORSCHEMA)) && (newCurrType = stype.getBaseType()) != currType) {
                currType = newCurrType;
            }
            String dataType = currType.getName();
            if (stype.getPrimitiveKind() == 2 && dataType.equals("string")) {
                dataType = "boolean";
            }
            node.setAttributeNS(null, "dataType", dataType);
        } else {
            node.setAttributeNS(null, "xmlType", "true");
            node.setAttributeNS(null, "dataType", "string");
            this.warnings.append("WARNING: Unsupported simple element variety in parseSimpleType. Treating as xmlType" + stype + System.getProperty("line.separator"));
        }
    }

    public void parseComplexType(Element node, XSComplexTypeDecl ctype) {
        if (ctype != null && ctype.getContentType() != 0) {
            String complexName = ctype.getTargetNamespace() + ":" + ctype.getTypeName();
            try {
                if (this.complexNameStack.search(complexName) != -1) {
                    node.setAttributeNS(null, "xmlType", "true");
                    this.warnings.append("WARNING: Unsupported recursive reference in parseComplexType. Treating as xmlType" + System.getProperty("line.separator"));
                    return;
                }
            }
            catch (EmptyStackException e) {
                // empty catch block
            }
            this.complexNameStack.push(complexName);
            if (ctype.getContentType() == 3) {
                node.setAttributeNS(null, "xmlType", "true");
                node.setAttributeNS(null, "dataType", "string");
                this.warnings.append("WARNING: Unsupported Mixed content type in parseComplexType. Treating as xmlType" + System.getProperty("line.separator"));
            } else if (ctype.getContentType() == 1) {
                this.parseSimpleType(node, (XSSimpleType)ctype.getSimpleType());
            } else if (ctype.getContentType() == 2) {
                if (ctype.getTypeName().indexOf("#Anon") == -1) {
                    node.setAttributeNS(null, "complexType", ctype.getTypeName());
                }
                this.parseParticle(node, (XSParticleDecl)ctype.getParticle());
            }
            this.complexNameStack.pop();
        }
        this.parseAttribute(node, ctype);
    }

    public void parseParticle(Element node, XSParticleDecl ptype) {
        XSModelGroupImpl xmgi = null;
        if (ptype == null) {
            return;
        }
        int minoccurs = ptype.getMinOccurs();
        int maxoccurs = ptype.getMaxOccurs();
        short type = ptype.fType;
        if (type == 3) {
            xmgi = (XSModelGroupImpl)ptype.getTerm();
        }
        if (type == 3 && xmgi != null && xmgi.getCompositor() == 1) {
            XSObjectList ol = xmgi.getParticles();
            for (int i = 0; i < ol.getLength(); ++i) {
                this.parseParticle(node, (XSParticleDecl)ol.item(i));
            }
        } else if (type == 1) {
            XSElementDecl xsElementDecl = (XSElementDecl)ptype.fValue;
            Element newNode = this.parseElement(node, xsElementDecl);
            if (xsElementDecl.getNillable()) {
                newNode.setAttributeNS(null, "nillable", "true");
            }
            if (minoccurs > 0) {
                newNode.setAttributeNS(null, "minOccurs", Integer.toString(minoccurs));
            } else {
                newNode.setAttributeNS(null, "minOccurs", Integer.toString(0));
            }
            if (maxoccurs == -1) {
                newNode.setAttributeNS(null, "maxOccurs", "unbounded");
            } else if (maxoccurs > 1) {
                newNode.setAttributeNS(null, "maxOccurs", Integer.toString(maxoccurs));
            } else {
                newNode.setAttributeNS(null, "maxOccurs", Integer.toString(1));
            }
        } else if (type == 3 && xmgi != null && xmgi.getCompositor() == 2) {
            Element newNode = this.mapDom.createElementNS(null, "choice");
            newNode.setAttributeNS(null, "name", "choiceNode");
            newNode.setAttributeNS(null, "form", this.getElementFormDefault(this.currentTargetNamespace));
            node.appendChild(newNode);
            this.parseChoice(newNode, ptype);
        } else if (type == 3 && xmgi != null && xmgi.getCompositor() == 3) {
            this.parseAll(node, ptype);
        } else {
            node.setAttributeNS(null, "xmlType", "true");
            node.setAttributeNS(null, "dataType", "string");
            this.warnings.append("WARNING: Unsupported Particle type in parseParticle. Treating as xmlType" + ptype + System.getProperty("line.separator"));
        }
    }

    public static String expandSystemId(String systemId, String baseSystemId) {
        String retval;
        try {
            retval = XMLEntityManager.expandSystemId(systemId, baseSystemId, false);
        }
        catch (URI.MalformedURIException e) {
            throw new ARWSException("OTHER_ERROR", "SystemID: " + systemId + " Exception: " + e.toString());
        }
        return retval;
    }
}

