/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.util;

import com.bmc.arsys.ws.util.ARWSException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WsdlUtil {
    protected static boolean nativeLogging = false;
    protected static String adminToolEncoding = System.getProperty("file.encoding");
    public static boolean enableLogging = true;

    public static void trace(String traceString) {
        if (enableLogging) {
            if (nativeLogging) {
                WsdlUtil.nativeTrace("WSDL trace: " + traceString + "\r\n");
            } else {
                System.err.println(traceString);
            }
        }
    }

    protected static native void nativeTrace(String var0);

    public static Document newDocument() {
        Document dom = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ARWSException("OTHER_ERROR", "ParserConfigurationException ", e);
        }
        return dom;
    }

    protected static ARWSException analyseSAXException(SAXException e, InputSource inp) {
        Reader reader = inp.getCharacterStream();
        if (reader == null) {
            InputStream stream = inp.getByteStream();
            if (stream == null) {
                try {
                    stream = new URL(inp.getSystemId()).openStream();
                }
                catch (MalformedURLException e1) {
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            if (stream != null) {
                reader = new BufferedReader(new InputStreamReader(stream));
            }
        }
        if (reader != null) {
            char[] buf = new char[8192];
            try {
                reader.read(buf);
                String buffer = new String(buf);
                if (buffer.indexOf("ARSystem login page") != -1) {
                    return new ARWSException("ARS_WS_NEEDS_PUBLIC_ACCESS", "You need to grant public access to this ARSystem Web Service, before you can use it " + inp.getSystemId(), e, inp.getSystemId());
                }
                if (buffer.indexOf("<HTML>") != -1 || buffer.indexOf("<html>") != -1) {
                    return new ARWSException("XML_IS_ACTUALLY_HTML", "This is not an XML file. It is actually an HTML file, open it in the browser to see what it says " + inp.getSystemId(), e, inp.getSystemId());
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return new ARWSException("INVALID_XML", "Invalid XML in " + inp.getSystemId(), e, inp.getSystemId());
    }

    public static InputSource validateWSDL(InputSource inp) {
        Document dom = null;
        StringWriter strWtr = new StringWriter();
        boolean updated = false;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(inp);
            Element rootElement = dom.getDocumentElement();
            NamedNodeMap nodeMap = rootElement.getAttributes();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node attr = nodeMap.item(i);
                String attrName = attr.getNodeName();
                String attrValue = attr.getNodeValue();
                if (!attrValue.equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
                rootElement.setAttribute(attrName, "http://schemas.xmlsoap.org/wsdl/soap/");
                updated = true;
            }
            if (updated) {
                XMLSerializer serializer = new XMLSerializer(strWtr, null);
                serializer.asDOMSerializer();
                serializer.serialize(dom);
            }
        }
        catch (IOException e) {
            throw new ARWSException("URI_NOT_FOUND", "URI not found " + inp.getSystemId(), e, inp.getSystemId());
        }
        catch (ParserConfigurationException e) {
            throw new ARWSException("OTHER_ERROR", "ParserConfigurationException cannot parse " + inp.getSystemId(), e, inp.getSystemId());
        }
        catch (SAXException e) {
            throw WsdlUtil.analyseSAXException(e, inp);
        }
        InputSource validatedInp = inp;
        if (updated) {
            validatedInp = new InputSource(new StringReader(strWtr.toString()));
        }
        return validatedInp;
    }

    public static Document newDocument(InputSource inp) {
        Document dom = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(inp);
        }
        catch (IOException e) {
            throw new ARWSException("URI_NOT_FOUND", "URI not found " + inp.getSystemId(), e, inp.getSystemId());
        }
        catch (ParserConfigurationException e) {
            throw new ARWSException("OTHER_ERROR", "ParserConfigurationException cannot parse " + inp.getSystemId(), e, inp.getSystemId());
        }
        catch (SAXException e) {
            throw WsdlUtil.analyseSAXException(e, inp);
        }
        return dom;
    }

    public static Document newDocument(InputStream inp) {
        return WsdlUtil.newDocument(new InputSource(inp));
    }

    public static Document newDocument(String uri, boolean isWSDL) {
        InputSource inp = new InputSource(uri);
        if (isWSDL) {
            inp = WsdlUtil.validateWSDL(inp);
        }
        return WsdlUtil.newDocument(inp);
    }

    public static String getAdminToolEncoding() {
        return adminToolEncoding;
    }
}

