/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.sso;

import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class AtriumSSOUserMapping {
    private static final String AUTHENTICATOR_PROPERTIES_FILE_PROPERTY = "atriumSSOProperties";
    private static final String USERNAME_DOMAIN_PROPERTY = "atriumSSOEmailDomain";
    private static final String USERNAME_MAPPING_FILE = "arsystem.atrium.sso.username.mapping.file";
    private static final String USERNAME_REPLACE = "arsystem.atrium.sso.username.replace";
    private static final String USERNAME_CASE = "arsystem.atrium.sso.username.case";
    private static final String USERNAME_EMAIL_TRIM = "arsystem.atrium.sso.username.email.trim";
    private static final String USERNAME_PREFIX = "arsystem.atrium.sso.username.prefix";
    private static final String USERNAME_SUFFIX = "arsystem.atrium.sso.username.suffix";
    private static final String USERNAME_CASE_DEFAULT = "default";
    private static final String USERNAME_REPLACE_ALL = "all";
    private static final String USERNAME_REPLACE_FIRST = "first";
    private String atriumSSOFileName;
    private Properties atriumSSOProperties = null;
    private String usernameCase = "default";
    private String usernameReplaceStr = null;
    private String usernameReplaceType = null;
    private String usernameReplaceMatch = null;
    private String usernameReplaceWith = null;
    private String usernameMappingFile;
    private boolean emailTrim = false;
    private String usernamePrefix = null;
    private String usernameSuffix = null;
    private Map<String, String> userMapReverseProps = null;
    private String userDomainName = null;
    private boolean userMappingConfigured;
    private static final AtriumSSOUserMapping INSTANCE = new AtriumSSOUserMapping();

    private AtriumSSOUserMapping() {
    }

    public static AtriumSSOUserMapping getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSSOConfigFile(ARPluginContext context) {
        this.atriumSSOProperties = new Properties();
        if (this.atriumSSOFileName.length() > 0) {
            InputStream is = null;
            try {
                is = context.getClass().getClassLoader().getResourceAsStream(this.atriumSSOFileName);
                this.atriumSSOProperties.load(is);
                context.logMessage(null, 0, "loadSSOConfigFile() : " + this.atriumSSOFileName);
            }
            catch (IOException e) {
                context.logMessage(null, 0, "Loading file failed : " + this.atriumSSOFileName);
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsernameMappingFile(ARPluginContext context) {
        Properties prop = new Properties();
        if (this.usernameMappingFile.length() > 0) {
            InputStream is = null;
            try {
                is = context.getClass().getClassLoader().getResourceAsStream(this.usernameMappingFile);
                prop.load(is);
                this.userMapReverseProps = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    this.userMapReverseProps.put((String)entry.getValue(), (String)entry.getKey());
                }
                context.logMessage(null, 0, "loadUsernameMappingFile() successful : " + this.atriumSSOFileName);
            }
            catch (IOException e) {
                context.logMessage(null, 0, "loadUsernameMappingFile() : " + this.atriumSSOFileName);
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    public synchronized void init(ARPluginContext context) {
        this.userMappingConfigured = false;
        this.atriumSSOFileName = context.getConfigItem(AUTHENTICATOR_PROPERTIES_FILE_PROPERTY);
        if (this.atriumSSOFileName != null && this.atriumSSOFileName.length() > 0) {
            this.userMappingConfigured = true;
            context.logMessage(null, 0, "SSO mapping is configured.");
        }
        if (this.userMappingConfigured && (this.atriumSSOProperties == null || this.atriumSSOProperties.isEmpty())) {
            context.logMessage(null, 0, "Initializing the SSO user mapping.");
            this.loadSSOConfigFile(context);
            this.usernameMappingFile = (String)this.atriumSSOProperties.get(USERNAME_MAPPING_FILE);
            context.logMessage(null, 0, "arsystem.atrium.sso.username.mapping.file=" + this.usernameMappingFile);
            if (this.usernameMappingFile != null) {
                this.loadUsernameMappingFile(context);
            }
            this.emailTrim = Boolean.valueOf((String)this.atriumSSOProperties.get(USERNAME_EMAIL_TRIM));
            if (this.emailTrim) {
                this.userDomainName = context.getConfigItem(USERNAME_DOMAIN_PROPERTY);
                context.logMessage(null, 0, "arsystem.atrium.sso.username.email.trim= true. atriumSSOEmailDomain=" + this.userDomainName);
            }
            this.usernamePrefix = (String)this.atriumSSOProperties.get(USERNAME_PREFIX);
            if (this.usernamePrefix != null) {
                this.usernamePrefix = this.usernamePrefix.trim();
                context.logMessage(null, 0, "arsystem.atrium.sso.username.prefix=" + this.usernamePrefix);
            }
            this.usernameSuffix = (String)this.atriumSSOProperties.get(USERNAME_SUFFIX);
            if (this.usernameSuffix != null) {
                this.usernameSuffix = this.usernameSuffix.trim();
                context.logMessage(null, 0, "arsystem.atrium.sso.username.suffix=" + this.usernameSuffix);
            }
            this.usernameReplaceStr = (String)this.atriumSSOProperties.get(USERNAME_REPLACE);
            if (this.usernameReplaceStr != null && !this.usernameReplaceStr.equalsIgnoreCase("")) {
                String[] replaceParts = this.usernameReplaceStr.split(";");
                if (replaceParts.length == 3) {
                    this.usernameReplaceType = replaceParts[0].trim().toLowerCase();
                    this.usernameReplaceMatch = replaceParts[1].trim();
                    this.usernameReplaceWith = replaceParts[2].trim();
                    this.usernameReplaceWith = Pattern.quote(this.usernameReplaceWith);
                    if (!this.usernameReplaceType.equalsIgnoreCase(USERNAME_REPLACE_ALL) && !this.usernameReplaceType.equalsIgnoreCase(USERNAME_REPLACE_FIRST)) {
                        this.usernameReplaceType = null;
                        this.usernameReplaceMatch = null;
                        this.usernameReplaceWith = null;
                        context.logMessage(null, 0, "Invalid arsystem.atrium.sso.username.replaceUsage : [all|first];<match>;<replace>");
                    }
                    context.logMessage(null, 0, "arsystem.atrium.sso.username.replace=" + this.usernameReplaceType + ";" + this.usernameReplaceMatch + ";" + this.usernameReplaceWith);
                } else {
                    context.logMessage(null, 0, "Invalid arsystem.atrium.sso.username.replaceUsage : [all|first];<match>;<replace>");
                }
            }
            context.logMessage(null, 0, "Loaded SSO user mapping.");
        }
    }

    public synchronized String getSSOUserName(String userName, ARPluginContext context, boolean replace) throws IOException {
        if (!this.userMappingConfigured) {
            context.logMessage(null, 0, "No mapping. Return original name.");
            return userName;
        }
        context.logMessage(null, 0, "Input user name : " + userName + "Apply Replace :" + replace);
        String ssoName = userName;
        if (this.usernameReplaceType != null && replace) {
            if (this.usernameReplaceType.equalsIgnoreCase(USERNAME_REPLACE_ALL)) {
                context.logMessage(null, 0, "Replacing all matches of [" + this.usernameReplaceWith + "] with [" + this.usernameReplaceMatch + "] for Username [" + userName + "]");
                ssoName = userName.replaceAll(this.usernameReplaceWith, this.usernameReplaceMatch);
            } else if (this.usernameReplaceType.equalsIgnoreCase(USERNAME_REPLACE_FIRST)) {
                context.logMessage(null, 0, "Replacing first match of [" + this.usernameReplaceWith + "] with [" + this.usernameReplaceMatch + "] for Username [" + userName + "]");
                ssoName = userName.replaceFirst(this.usernameReplaceWith, this.usernameReplaceMatch);
            }
            context.logMessage(null, 0, "Intermediate mapped name : " + ssoName);
        }
        if (this.usernameSuffix != null) {
            String suffix = ssoName.substring(ssoName.length() - this.usernameSuffix.length());
            if (this.usernameSuffix.equals(suffix)) {
                ssoName = ssoName.substring(0, ssoName.length() - this.usernameSuffix.length());
            } else {
                context.logMessage(null, 0, "Suffix mismatch : " + this.usernameSuffix + "->" + suffix);
            }
            context.logMessage(null, 0, "Trim suffix:" + this.usernameSuffix + " Intermediate mapped name : " + ssoName);
        }
        if (this.usernamePrefix != null) {
            String prefix = ssoName.substring(0, this.usernamePrefix.length());
            if (this.usernamePrefix.equals(prefix)) {
                ssoName = ssoName.substring(this.usernamePrefix.length());
            } else {
                context.logMessage(null, 0, "Prefix mismatch : " + this.usernamePrefix + "->" + prefix);
            }
            context.logMessage(null, 0, "Trim prefix:" + this.usernamePrefix + " Intermediate mapped name : " + ssoName);
        }
        if (this.userMapReverseProps != null && !this.userMapReverseProps.isEmpty() && this.userMapReverseProps.containsKey(ssoName)) {
            ssoName = this.userMapReverseProps.get(ssoName);
            context.logMessage(null, 0, "User reverse mapping:Intermediate mapped name : " + ssoName);
        } else if (this.emailTrim) {
            if (this.userDomainName != null) {
                ssoName = ssoName + "@" + this.userDomainName;
            } else {
                context.logMessage(null, 0, "Domain name is null");
            }
            context.logMessage(null, 0, "User add domainName:Intermediate mapped name : " + ssoName);
        }
        context.logMessage(null, 0, "Final mapped name : " + userName + " = " + ssoName);
        return ssoName;
    }

    public String getSSOUserNameWithoutEmail(String userName, ARPluginContext context) {
        int atPos = userName.indexOf("@");
        if (atPos > -1) {
            return userName.substring(0, atPos);
        }
        return userName;
    }
}

