/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report.schedule;

import com.bmc.arsys.plugins.report.schedule.OutOfRangeException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class Schedule {
    public static final int serialVersionUID = 1;
    public static final int NaN = -1;
    public static final int FREQUENCY = 0;
    public static final int MINUTELY = 0;
    public static final int HOURLY = 1;
    public static final int DAILY = 2;
    public static final int WEEKLY = 3;
    public static final int MONTHLY = 4;
    public static final int YEARLY = 5;
    public static final int NFREQUENCY = 10;
    public static final int NMINUTES = 11;
    public static final int NHOURS = 12;
    public static final int NDAYS = 13;
    public static final int NMONTHS = 14;
    public static final int NYEARS = 15;
    public static final int EVERYDAY = 21;
    public static final int WEEKDAY = 22;
    public static final int WEEKEND_DAY = 23;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int FIRST = 0;
    public static final int SECOND = 1;
    public static final int THIRD = 2;
    public static final int FOURTH = 3;
    public static final int LAST = 4;
    protected static final String TYPE_FIELD = "type";
    protected static final String STARTDATE_FIELD = "start-date";
    protected static final String SCHEDULE_FIELD = "schedule";
    protected static final String EVERY_FIELD = "every";
    protected static final String BETWEEN_FIELD = "between";
    protected static final String ON_FIELD = "on";
    protected static final String FOR_FIELD = "for";
    protected static final String THE_FIELD = "the";
    protected static final String OF_FIELD = "of";
    protected static final String LOCALE_FIELD = "locale";
    protected static final String FIELD_SEPERATOR = ":";
    protected static final String MINUTES_FIELD = "minutes";
    protected static final String HOURS_FIELD = "hours";
    protected static final String DAYS_FIELD = "days";
    protected static final String WEEKS_FIELD = "weeks";
    protected static final String MONTHS_FIELD = "months";
    protected static final String YEARS_FIELD = "years";
    protected static final String QUOTE = "\"";
    protected static final String SPACE = " ";
    protected static final String CRLF = "\r\n";
    protected static final String COMMA = ",";
    protected static final String SEMICOLON = ";";
    protected static final String AND = "AND";
    protected static final String OR = "OR";
    private Date mStart;
    private int type;
    private int subType;
    private int frequency;
    private int monthOfYear;
    private int weekOfMonth;
    private int dayOfMonth;
    private int[] daysOfWeek;
    private int[] hoursOfDay;
    private Locale locale = Locale.getDefault();
    private static final int SOME_ARBITRARY_NUMBER = 25;

    public Schedule() {
        this.mStart = new Date();
        this.reset();
    }

    public Schedule(Locale locale) {
        this();
        this.locale = locale;
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale = locale;
    }

    public synchronized void setStartDate(Date inStart) {
        if (inStart == null) {
            throw new NullPointerException("start can not be null");
        }
        this.mStart = inStart;
    }

    public Date getStartDate() {
        return this.mStart;
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subType;
    }

    public synchronized int getFrequency() {
        return this.frequency;
    }

    public synchronized int[] getHoursOfDay() {
        return this.hoursOfDay;
    }

    public synchronized int getFirstDayOfWeek() {
        if (this.daysOfWeek == null) {
            return -1;
        }
        if (this.daysOfWeek.length == 0) {
            return -1;
        }
        return this.daysOfWeek[0];
    }

    public int[] getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public int getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public int getMonthOfYear() {
        return this.monthOfYear;
    }

    public synchronized void setMinutely(int minutes, int[] daysOfWeek, int[] hoursOfDay) throws OutOfRangeException {
        Schedule.validateFrequencyInMinutes(minutes);
        Schedule.validateDaysOfWeek(daysOfWeek);
        Schedule.validateHoursOfDay(hoursOfDay);
        this.reset();
        this.type = 0;
        this.subType = 1;
        this.frequency = minutes;
        this.daysOfWeek = daysOfWeek;
        this.hoursOfDay = hoursOfDay;
    }

    public void setHourly(int hours, int[] daysOfWeek, int[] hoursOfDay) throws OutOfRangeException {
        Schedule.validateFrequencyInHours(hours);
        Schedule.validateDaysOfWeek(daysOfWeek);
        Schedule.validateHoursOfDay(hoursOfDay);
        this.reset();
        this.type = 1;
        this.subType = 1;
        this.frequency = hours;
        this.daysOfWeek = daysOfWeek;
        this.hoursOfDay = hoursOfDay;
    }

    private void setDaily(int days) throws OutOfRangeException {
        if (days < 0) {
            throw new OutOfRangeException("range for days in not within [0, 2147483647]");
        }
        this.reset();
        this.type = 2;
        this.subType = 1;
        this.frequency = days == 0 ? 1 : days;
        this.daysOfWeek = Schedule.getAllDaysInWeek();
        this.hoursOfDay = null;
    }

    private void setDailyWeekdaysOnly() {
        this.reset();
        this.type = 2;
        this.subType = 2;
        this.frequency = 1;
        this.daysOfWeek = Schedule.getWeekdays();
        this.hoursOfDay = null;
    }

    public static int[] getWeekdays() {
        return new int[]{1, 2, 3, 4, 5};
    }

    public void setWeekly(int weeks, int[] days) throws OutOfRangeException {
        Schedule.validateFrequencyInWeeks(weeks);
        Schedule.validateDaysOfWeek(days);
        this.reset();
        this.type = 3;
        this.subType = 1;
        this.frequency = weeks;
        this.daysOfWeek = days;
        this.hoursOfDay = null;
    }

    public void setMonthlyByDayOfMonth(int months, int dayOfMonth) throws OutOfRangeException {
        Schedule.validateDayOfMonth(dayOfMonth);
        Schedule.validateFrequencyInMonths(months);
        this.reset();
        this.type = 4;
        this.subType = 1;
        this.dayOfMonth = dayOfMonth;
        this.frequency = months;
    }

    public void setMonthly(int months, int weekOfMonth, int[] daysOfWeek) throws OutOfRangeException {
        Schedule.validateWeekOfMonth(weekOfMonth);
        Schedule.validateDaysOfWeek(daysOfWeek);
        Schedule.validateFrequencyInMonths(months);
        this.reset();
        this.type = 4;
        this.subType = 2;
        this.weekOfMonth = weekOfMonth;
        this.daysOfWeek = daysOfWeek;
        this.frequency = months;
    }

    public void setYearlyByDayOfMonth(int monthOfYear, int day) throws OutOfRangeException {
        Schedule.validateMonthOfYear(monthOfYear);
        Schedule.validateDayOfMonth(day);
        this.reset();
        this.type = 5;
        this.frequency = 1;
        this.monthOfYear = monthOfYear;
        this.dayOfMonth = day;
    }

    public void setYearlyByDayOfWeek(int weekOfMonth, int[] daysOfWeek, int monthOfYear) throws OutOfRangeException {
        Schedule.validateWeekOfMonth(weekOfMonth);
        Schedule.validateDaysOfWeek(daysOfWeek);
        Schedule.validateMonthOfYear(monthOfYear);
        this.reset();
        this.type = 5;
        this.subType = 2;
        this.frequency = 1;
        this.daysOfWeek = daysOfWeek;
        this.weekOfMonth = weekOfMonth;
        this.monthOfYear = monthOfYear;
    }

    private static void validateFrequencyInMinutes(int numMinutes) throws OutOfRangeException {
        if (numMinutes < 1) {
            throw new OutOfRangeException("range for minutes [" + numMinutes + "] is not within [1, " + Integer.MAX_VALUE + "]");
        }
    }

    private static void validateFrequencyInHours(int numHours) throws OutOfRangeException {
        if (numHours < 1) {
            throw new OutOfRangeException("range for hours [" + numHours + "] is not within [1, " + Integer.MAX_VALUE + "]");
        }
    }

    private static void validateFrequencyInWeeks(int numWeeks) throws OutOfRangeException {
        if (numWeeks < 1) {
            throw new OutOfRangeException("range for weeks [" + numWeeks + "] is not within [1, " + Integer.MAX_VALUE + "]");
        }
    }

    private static void validateFrequencyInMonths(int numMonths) throws OutOfRangeException {
        if (numMonths < 1) {
            throw new OutOfRangeException("range for months [" + numMonths + "] is not within [1, " + Integer.MAX_VALUE + "]");
        }
    }

    private static void validateDayOfMonth(int dayOfMonth) throws OutOfRangeException {
        if (dayOfMonth < 1 || dayOfMonth > 31) {
            throw new OutOfRangeException("range for day [" + dayOfMonth + "] is not within [1, 31]");
        }
    }

    private static void validateWeekOfMonth(int weekOfMonth) throws OutOfRangeException {
        if (weekOfMonth < 0 || weekOfMonth > 4) {
            throw new OutOfRangeException("range for week-of-month [" + weekOfMonth + "] is not within [0,4]");
        }
    }

    private static void validateDaysOfWeek(int[] daysOfWeek) throws OutOfRangeException {
        if (daysOfWeek == null) {
            throw new NullPointerException("Days-of-Week can not be null");
        }
        if (daysOfWeek.length == 0) {
            throw new IllegalArgumentException("Days-of-Week must contain at least one value");
        }
        for (int i = 0; i < daysOfWeek.length; ++i) {
            if (daysOfWeek[i] >= 0 && daysOfWeek[i] <= 6) continue;
            throw new OutOfRangeException("range for day-of-week [" + daysOfWeek[i] + "] is not within [0,6]");
        }
    }

    private static void validateHoursOfDay(int[] hoursOfDay) throws OutOfRangeException {
        if (hoursOfDay == null) {
            throw new NullPointerException("Hours-of-Day can not be null");
        }
        if (hoursOfDay.length == 0) {
            throw new IllegalArgumentException("Hours-of-Day must contain at least one value");
        }
        for (int i = 0; i < hoursOfDay.length; ++i) {
            if (hoursOfDay[i] >= 0 && hoursOfDay[i] <= 23) continue;
            throw new OutOfRangeException("range for hour-of-day [" + hoursOfDay[i] + "] is not within [0,23]");
        }
    }

    private static void validateMonthOfYear(int monthOfYear) throws OutOfRangeException {
        if (monthOfYear < 0 || monthOfYear > 11) {
            throw new OutOfRangeException("range for month-of-year [" + monthOfYear + "] is not within [0,11]");
        }
    }

    protected static String parseField(String line, String field) throws ParseException {
        MessageFormat format = new MessageFormat("{0}: {1}");
        Object[] parts = format.parse(line);
        if (parts[0].equals(field)) {
            return (String)parts[1];
        }
        throw new ParseException("field " + field + " not found at expected position", 0);
    }

    public static Object[] parseLine(String line, String format) throws ParseException {
        if (format == null) {
            throw new NullPointerException("format string can not be null");
        }
        MessageFormat mf = new MessageFormat(format);
        return mf.parse(line);
    }

    public static Schedule parse(int type, Integer frequency, int[] hoursOfDay, int[] daysOfWeek, Integer weekOfMonth, Integer monthOfYear, Integer dayOfMonth, Date startDateTime) {
        if (type == -1) {
            throw new IllegalArgumentException("type is not initialized");
        }
        Schedule alloc = new Schedule();
        alloc.setStartDate(startDateTime);
        switch (type) {
            case 0: {
                if (frequency != null) {
                    alloc.setMinutely(frequency, daysOfWeek, hoursOfDay);
                    break;
                }
                alloc = null;
                break;
            }
            case 1: {
                if (frequency != null) {
                    alloc.setHourly(frequency, daysOfWeek, hoursOfDay);
                    break;
                }
                alloc = null;
                break;
            }
            case 2: {
                if (frequency == null || frequency == 0) {
                    alloc.setDailyWeekdaysOnly();
                    break;
                }
                alloc.setDaily(frequency);
                break;
            }
            case 3: {
                if (frequency != null) {
                    alloc.setWeekly(frequency, daysOfWeek);
                    break;
                }
                alloc = null;
                break;
            }
            case 4: {
                if (dayOfMonth == null || dayOfMonth == 0) {
                    alloc.setMonthly(frequency, weekOfMonth, daysOfWeek);
                    break;
                }
                if (dayOfMonth == null) break;
                alloc.setMonthlyByDayOfMonth(frequency, dayOfMonth);
                break;
            }
            case 5: {
                if (dayOfMonth == null || dayOfMonth == 0) {
                    alloc.setYearlyByDayOfWeek(weekOfMonth, daysOfWeek, monthOfYear);
                    break;
                }
                alloc.setYearlyByDayOfMonth(monthOfYear, dayOfMonth);
            }
        }
        if (alloc == null) {
            return null;
        }
        if (startDateTime != null) {
            alloc.setStartDate(startDateTime);
        }
        return alloc;
    }

    public static int[] getAllHoursInDay() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    }

    public static int[] getAllDaysInWeek() {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    public static String getHoursAsString(int[] hours) {
        String buf = "";
        if (hours == null) {
            return buf;
        }
        for (int i = 0; i < hours.length; ++i) {
            if (i > 0 && i == hours.length - 1) {
                buf = buf + hours[i];
                continue;
            }
            if (i >= hours.length) continue;
            buf = buf + hours[i] + SEMICOLON + SPACE;
        }
        return buf;
    }

    public static String getDaysAsString(int[] days) {
        String buf = "";
        for (int i = 0; i < days.length; ++i) {
            if (i > 0 && i == days.length - 1) {
                buf = buf + days[i];
                continue;
            }
            if (i >= days.length) continue;
            buf = buf + days[i] + SEMICOLON + SPACE;
        }
        return buf;
    }

    public static int[] parseHours(String buf) throws ParseException {
        int[] fields = null;
        int i = 0;
        if (buf == null) {
            return new int[0];
        }
        StringTokenizer st = new StringTokenizer(buf.trim(), SEMICOLON);
        String[] items = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            items[i] = st.nextToken().trim();
            ++i;
        }
        fields = new int[items.length];
        for (i = 0; i < items.length; ++i) {
            fields[i] = Integer.parseInt(items[i]);
        }
        return fields;
    }

    public static int[] parseDays(String buf) throws ParseException {
        int[] fields = null;
        int i = 0;
        if (buf == null) {
            return new int[0];
        }
        StringTokenizer st = new StringTokenizer(buf.trim(), SEMICOLON);
        String[] items = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            items[i] = st.nextToken().trim();
            ++i;
        }
        fields = new int[items.length];
        for (i = 0; i < items.length; ++i) {
            fields[i] = Integer.parseInt(items[i]);
        }
        return fields;
    }

    public static int[] getHoursBetween(int a, int b) {
        if (b < a) {
            return new int[0];
        }
        if (b == a) {
            return new int[]{a};
        }
        int[] hours = new int[b - a + 1];
        hours[0] = a;
        hours[b - a] = b;
        for (int i = 1; i < b - a; ++i) {
            hours[i] = a + i;
        }
        return hours;
    }

    public Date getNextTime(Date now, boolean useInitialTime) throws ParseException {
        Date next = null;
        switch (this.getType()) {
            case 0: {
                next = this.getNextTimeMinutely(now);
                break;
            }
            case 1: {
                next = this.getNextTimeHourly(now);
                break;
            }
            case 2: {
                next = this.getNextTimeDaily(now);
                break;
            }
            case 3: {
                next = this.getNextTimeWeekly(now);
                break;
            }
            case 4: {
                next = this.getNextTimeMonthly(now, useInitialTime);
                break;
            }
            case 5: {
                next = this.getNextTimeYearly(now);
            }
        }
        return next;
    }

    public Date getLastTime(Date now) throws ParseException {
        throw new ParseException("can not project schedules into past", 0);
    }

    private Date getNextTimeMinutely(Date now) throws ParseException {
        if (this.getType() != 0) {
            throw new ParseException("schedule is not minutely", -1);
        }
        Calendar cal = Calendar.getInstance(this.getLocale());
        cal.setTime(now);
        cal.set(12, cal.get(12) + this.frequency);
        cal = this.addDaysOfWeekOffset(cal);
        cal = this.addHourOfDayOffset(cal);
        cal = this.resetSecondOfMinute(cal);
        return cal.getTime();
    }

    protected Date getNextTimeHourly(Date now) throws ParseException {
        if (this.getType() != 1) {
            throw new ParseException("schedule is not hourly", -1);
        }
        Calendar cal = Calendar.getInstance(this.getLocale());
        cal.setTime(now);
        cal.set(10, cal.get(10) + this.frequency);
        cal = this.addDaysOfWeekOffset(cal);
        cal = this.addHourOfDayOffset(cal);
        cal = this.resetMinuteOfHour(cal);
        cal = this.resetSecondOfMinute(cal);
        return cal.getTime();
    }

    protected Date getNextTimeDaily(Date now) throws ParseException {
        if (this.getType() != 2) {
            throw new ParseException("schedule is not daily", -1);
        }
        Calendar cal = Calendar.getInstance(this.getLocale());
        cal.setTime(now);
        int days = 1;
        if (this.subType == 1) {
            days = this.frequency;
        } else if (cal.get(7) == 6) {
            days = 3;
        }
        cal.add(5, days);
        cal = this.resetMinuteOfHour(cal);
        cal = this.resetSecondOfMinute(cal);
        return cal.getTime();
    }

    protected Date getNextTimeWeekly(Date now) throws ParseException {
        if (this.getType() != 3) {
            throw new ParseException("schedule is not weekly", -1);
        }
        Calendar cal = Calendar.getInstance(this.getLocale());
        cal.setTime(now);
        Calendar calSav = Calendar.getInstance(this.getLocale());
        calSav.setTime(now);
        this.addDaysOfWeekOffset(cal);
        if (cal.equals(calSav)) {
            cal = this.addDaysOfWeekOffset(cal);
            cal.set(4, cal.get(4) + this.frequency);
        }
        cal = this.resetHourOfDay(cal);
        cal = this.resetMinuteOfHour(cal);
        cal = this.resetSecondOfMinute(cal);
        return cal.getTime();
    }

    private boolean isLeapYear(int year) {
        if ((double)(year / 4) != Math.floor(year / 4)) {
            return false;
        }
        if ((double)(year / 100) != Math.floor(year / 100)) {
            return true;
        }
        return (double)(year / 400) == Math.floor(year / 400);
    }

    private int lastWeekdayOfMonth(int inweekDay, int month, int year) {
        int[] daysOfMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] daysOfMonthLeapYear = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        Calendar lastday = Calendar.getInstance(this.getLocale());
        int lastdate = this.isLeapYear(year) ? daysOfMonthLeapYear[month] : daysOfMonth[month];
        lastday.set(year, month, lastdate);
        int dayofweek = lastday.get(7);
        int weekday = inweekDay + 1;
        while (dayofweek != weekday) {
            lastday.add(5, -1);
            dayofweek = lastday.get(7);
        }
        return lastday.get(5);
    }

    private int findNthWeekDayOfTheMonth(int nth, int inweekDay, int month, int year) {
        if (nth < 0) {
            return this.lastWeekdayOfMonth(inweekDay, month, year);
        }
        Calendar firstday = Calendar.getInstance(this.getLocale());
        firstday.set(year, month, 1);
        int firstdayweekday = firstday.get(7);
        int weekday = inweekDay + 1;
        while (firstdayweekday != weekday) {
            firstday.add(5, 1);
            firstdayweekday = firstday.get(7);
        }
        firstday.add(5, (nth - 1) * 7);
        int newday = firstday.get(5);
        return newday;
    }

    protected Date getNextTimeMonthly(Date initialDate, boolean useInitialTime) throws ParseException {
        if (this.getType() != 4) {
            throw new ParseException("schedule is not monthly", -1);
        }
        Calendar cal = Calendar.getInstance(this.getLocale());
        cal.setTime(initialDate);
        if (!useInitialTime) {
            cal.set(2, cal.get(2) + this.frequency);
        }
        if (this.getSubType() == 2) {
            Calendar now = Calendar.getInstance(this.getLocale());
            int weekOfMonth = this.getWeekOfMonth();
            weekOfMonth = weekOfMonth == 4 ? -1 : ++weekOfMonth;
            int[] daysOfWeek = this.getDaysOfWeek();
            int month = cal.get(2);
            int hour = cal.get(11);
            int minute = cal.get(12);
            int second = cal.get(13);
            int year = cal.get(1);
            int retdayofmonth = 0;
            boolean notinfuture = true;
            do {
                for (int i = 0; i < daysOfWeek.length; ++i) {
                    int dayofmonth = this.findNthWeekDayOfTheMonth(weekOfMonth, daysOfWeek[i], month, year);
                    Calendar startjob = Calendar.getInstance(this.getLocale());
                    startjob.set(year, month, dayofmonth, hour, minute);
                    if (startjob.getTimeInMillis() < now.getTimeInMillis()) continue;
                    retdayofmonth = dayofmonth;
                    notinfuture = false;
                    break;
                }
                if (!notinfuture) continue;
                year += (month + this.frequency) / 12;
                month = (month + this.frequency) % 12;
            } while (notinfuture);
            cal.set(year, month, retdayofmonth, hour, minute, second);
        } else {
            cal = this.addDayOfMonthOffset(cal);
        }
        cal = this.resetHourOfDay(cal);
        cal = this.resetMinuteOfHour(cal);
        cal = this.resetSecondOfMinute(cal);
        return cal.getTime();
    }

    protected Date getNextTimeYearly(Date now) throws ParseException {
        if (this.getType() != 5) {
            throw new ParseException("schedule is not yearly", -1);
        }
        Calendar cal = Calendar.getInstance(this.getLocale());
        cal.setTime(now);
        cal.set(1, cal.get(1) + this.frequency);
        cal = this.addMonthOfYearOffset(cal);
        if (this.getSubType() == 2) {
            cal = this.addWeekOfMonthOffset(cal);
            cal = this.addDaysOfWeekOffset(cal);
        } else {
            cal = this.addDayOfMonthOffset(cal);
        }
        cal = this.resetHourOfDay(cal);
        cal = this.resetMinuteOfHour(cal);
        cal = this.resetSecondOfMinute(cal);
        return cal.getTime();
    }

    private Calendar addDaysOfWeekOffset(Calendar cal) {
        int[] daysOfWeek = this.getDaysOfWeek();
        boolean found = false;
        while (!found) {
            int jfoundindex = -1;
            for (int j = 0; j < daysOfWeek.length; ++j) {
                if (cal.get(7) != daysOfWeek[j] + 1) continue;
                jfoundindex = j;
                found = true;
                break;
            }
            if (jfoundindex != -1) continue;
            cal.add(5, 1);
        }
        return cal;
    }

    private int getNextScheduledDay(Calendar cal) {
        int day = 1;
        int[] daysOfWeek = this.getDaysOfWeek();
        if (daysOfWeek != null && daysOfWeek.length > 0) {
            int currDayOfWeek = cal.get(7);
            int nextDayOfWeek = 0;
            --currDayOfWeek;
            int index = -1;
            for (int i = 0; i < daysOfWeek.length; ++i) {
                if (currDayOfWeek != daysOfWeek[i]) continue;
                index = i;
                break;
            }
            if (++index >= daysOfWeek.length) {
                index = 0;
            }
            day = (nextDayOfWeek = daysOfWeek[index]) > currDayOfWeek ? nextDayOfWeek - currDayOfWeek : 6 - currDayOfWeek + nextDayOfWeek + 1;
        }
        return day;
    }

    private Calendar addHourOfDayOffset(Calendar cal) {
        int currHourOfDay = cal.get(11);
        int[] hoursOfDay = this.getHoursOfDay();
        if (hoursOfDay.length <= 24 && hoursOfDay.length > 0) {
            int i;
            boolean found = false;
            for (i = 0; i < hoursOfDay.length; ++i) {
                if (hoursOfDay[i] != currHourOfDay) continue;
                found = true;
                break;
            }
            if (!found) {
                block1: for (i = currHourOfDay + 1; i < 23 && !found; ++i) {
                    for (int j = 0; j < hoursOfDay.length; ++j) {
                        if (hoursOfDay[j] != i) continue;
                        found = true;
                        cal.set(11, hoursOfDay[j]);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        continue block1;
                    }
                }
            }
            if (!found) {
                cal.add(5, this.getNextScheduledDay(cal));
                cal.set(11, hoursOfDay[0]);
                cal.set(12, 0);
                cal.set(13, 0);
            }
        }
        return cal;
    }

    private Calendar addWeekOfMonthOffset(Calendar cal) {
        int currWeekOfMonth = cal.get(4);
        int weekOfMonth = this.getWeekOfMonth();
        if (weekOfMonth == 4) {
            weekOfMonth = cal.getMaximum(4);
        }
        if (currWeekOfMonth > weekOfMonth) {
            cal.set(2, cal.get(2) + 1);
        }
        switch (weekOfMonth) {
            case 0: {
                cal.set(4, 1);
                break;
            }
            case 1: {
                cal.set(4, 2);
                break;
            }
            case 2: {
                cal.set(4, 3);
                break;
            }
            case 3: {
                cal.set(4, 4);
            }
        }
        return cal;
    }

    protected Calendar addMonthOfYearOffset(Calendar cal) {
        int month;
        int currMonth = cal.get(2);
        if (currMonth > (month = this.getMonthOfYear())) {
            cal.set(1, cal.get(1) + 1);
        }
        switch (month) {
            case 0: {
                cal.set(2, 0);
                break;
            }
            case 1: {
                cal.set(2, 1);
                break;
            }
            case 2: {
                cal.set(2, 2);
                break;
            }
            case 3: {
                cal.set(2, 3);
                break;
            }
            case 4: {
                cal.set(2, 4);
                break;
            }
            case 5: {
                cal.set(2, 5);
                break;
            }
            case 6: {
                cal.set(2, 6);
                break;
            }
            case 7: {
                cal.set(2, 7);
                break;
            }
            case 8: {
                cal.set(2, 8);
                break;
            }
            case 9: {
                cal.set(2, 9);
                break;
            }
            case 10: {
                cal.set(2, 10);
                break;
            }
            case 11: {
                cal.set(2, 11);
            }
        }
        return cal;
    }

    protected Calendar resetSecondOfMinute(Calendar cal) {
        Calendar start = Calendar.getInstance(this.getLocale());
        start.setTime(this.getStartDate());
        cal.set(13, start.get(13));
        return cal;
    }

    protected Calendar resetMinuteOfHour(Calendar cal) {
        Calendar start = Calendar.getInstance(this.getLocale());
        start.setTime(this.getStartDate());
        cal.set(12, start.get(12));
        return cal;
    }

    protected Calendar addDayOfMonthOffset(Calendar cal) {
        int currDayOfMonth = cal.get(5);
        int days = cal.getActualMaximum(5);
        int dayOfMonth = this.getDayOfMonth();
        if (dayOfMonth <= 0) {
            dayOfMonth = 1;
        } else if (dayOfMonth > days) {
            dayOfMonth = days;
        }
        if (currDayOfMonth != dayOfMonth) {
            cal.set(5, dayOfMonth);
        }
        Calendar curtime = Calendar.getInstance(this.getLocale());
        while (curtime.getTime().getTime() > cal.getTime().getTime()) {
            cal.add(2, this.getFrequency());
        }
        return cal;
    }

    protected Calendar resetHourOfDay(Calendar cal) {
        Calendar start = Calendar.getInstance(this.getLocale());
        start.setTime(this.getStartDate());
        cal.set(11, start.get(11));
        return cal;
    }

    protected void reset() {
        this.type = -1;
        this.subType = -1;
        this.frequency = -1;
        this.monthOfYear = -1;
        this.weekOfMonth = -1;
        this.daysOfWeek = new int[0];
        this.dayOfMonth = -1;
        this.hoursOfDay = new int[0];
    }

    public String toString() {
        return "type=" + this.type + SPACE + "frequency=" + this.frequency + SPACE + "monthOfYear=" + this.monthOfYear + SPACE + "weekOfMonth=" + this.weekOfMonth + SPACE + "dayOfMonth=" + this.dayOfMonth + SPACE + "daysOfWeek=" + Schedule.displayIntArray(this.daysOfWeek) + SPACE + "hoursOfDay=" + Schedule.displayIntArray(this.hoursOfDay);
    }

    private static final String displayIntArray(int[] array) {
        if (array == null) {
            return "";
        }
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            tmp.append(array[i]);
            tmp.append(SPACE);
        }
        return tmp.toString();
    }

    public boolean equals(Schedule schedule) {
        int i;
        if (this.type != schedule.getType()) {
            return false;
        }
        if (this.subType != schedule.getSubType()) {
            return false;
        }
        if (this.frequency != schedule.getFrequency()) {
            return false;
        }
        if (this.dayOfMonth != schedule.getDayOfMonth()) {
            return false;
        }
        if (this.monthOfYear != schedule.getMonthOfYear()) {
            return false;
        }
        if (this.weekOfMonth != schedule.getWeekOfMonth()) {
            return false;
        }
        if (this.dayOfMonth != schedule.getDayOfMonth()) {
            return false;
        }
        if (this.daysOfWeek != null) {
            if (schedule.getDaysOfWeek() == null) {
                return false;
            }
            if (this.daysOfWeek.length != schedule.getDaysOfWeek().length) {
                return false;
            }
            for (i = 0; i < this.daysOfWeek.length; ++i) {
                if (this.daysOfWeek[i] == schedule.getDaysOfWeek()[i]) continue;
                return false;
            }
        } else if (schedule.getDaysOfWeek() != null) {
            return false;
        }
        if (this.hoursOfDay != null) {
            if (schedule.getHoursOfDay() == null) {
                return false;
            }
            if (this.hoursOfDay.length != schedule.getHoursOfDay().length) {
                return false;
            }
            for (i = 0; i < this.hoursOfDay.length; ++i) {
                if (this.hoursOfDay[i] == schedule.getHoursOfDay()[i]) continue;
                return false;
            }
        } else if (schedule.getHoursOfDay() != null) {
            return false;
        }
        return true;
    }

    private boolean validateMinutely(Date scheduleDate) {
        return false;
    }

    private boolean validateHourly(Date scheduleDate) {
        return false;
    }

    private boolean validateWeekly(Date scheduleDate) {
        Calendar calScheduleDate = Calendar.getInstance(this.getLocale());
        calScheduleDate.setTime(scheduleDate);
        boolean validWeekly = false;
        int scheduleDayWeek = calScheduleDate.get(7);
        --scheduleDayWeek;
        for (int i = 0; i < this.daysOfWeek.length; ++i) {
            if (scheduleDayWeek != this.daysOfWeek[i]) continue;
            validWeekly = true;
            break;
        }
        return validWeekly;
    }

    private boolean validateScheduleTime(Date scheduleDate) {
        boolean bret = false;
        switch (this.getType()) {
            case 0: {
                bret = this.validateMinutely(scheduleDate);
                break;
            }
            case 1: {
                bret = this.validateHourly(scheduleDate);
                break;
            }
            case 3: {
                bret = this.validateWeekly(scheduleDate);
                break;
            }
        }
        return bret;
    }

    public Date initializeScheduleTimes(boolean useInitialTime) {
        Date curDate = new Date();
        Date scheduleDate = this.mStart;
        try {
            long curTime = curDate.getTime();
            long scheduleTime = scheduleDate.getTime();
            Calendar calCurDate = Calendar.getInstance(this.getLocale());
            calCurDate.setTime(curDate);
            Calendar calScheduleDate = Calendar.getInstance(this.getLocale());
            calScheduleDate.setTime(scheduleDate);
            if (scheduleTime < curTime) {
                long timeDiff = curTime - scheduleTime;
                long nextTime = this.getNextTime(scheduleDate, useInitialTime).getTime();
                long interval = nextTime - scheduleTime;
                long multiple = timeDiff / interval;
                if (multiple > 25L) {
                    scheduleDate = new Date(scheduleTime += (multiple - 1L) * interval);
                }
                while (curTime > scheduleTime) {
                    scheduleDate = this.getNextTime(scheduleDate, useInitialTime);
                    scheduleTime = scheduleDate.getTime();
                }
            } else if (!this.validateScheduleTime(scheduleDate)) {
                scheduleDate = this.getNextTime(scheduleDate, useInitialTime);
            }
        }
        catch (ParseException pe) {
            // empty catch block
        }
        return scheduleDate;
    }
}

