/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.plugins.report.ReportInfo;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.util.List;

public class ReportService {
    private static String schemaPublishReport = null;
    private ARPluginContext context = null;

    public ReportService(ARPluginContext context) {
        this.context = context;
    }

    public String getSchemaPublishReport(ARServerUser serverUser) throws ARException {
        if (schemaPublishReport == null) {
            int[] mPublishReportListFieldIds = new int[]{ReportConstants.PUBLISH_REPORT_PANEL_ID.toInt()};
            List schemas = serverUser.getListForm(0L, FormType.ALL.toInt() | 0x400, null, mPublishReportListFieldIds);
            if (schemas.size() > 0) {
                schemaPublishReport = (String)schemas.get(0);
                this.context.logMessage(0, "Found Publish Report Form Name as - " + schemaPublishReport);
            } else {
                this.context.logMessage(1, "Unable to get Publish Report Schema name");
            }
        }
        if (schemaPublishReport == null) {
            this.context.logMessage(0, "Didn't find Publish Report Form Name. So setting it to default as - 'AR System Publish Report'");
            schemaPublishReport = "AR System Publish Report";
        }
        return schemaPublishReport;
    }

    public String publishReport(ARServerUser serverUser, ReportInfo repInfo) throws ARException {
        Entry entry = new Entry();
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_REPORT_REPORT_NAME.toInt()), new Value(repInfo.getReportName()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_REPORT_RUN_AS.toInt()), new Value(repInfo.getRunAs()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_REPORT_TIMEZONE.toInt()), new Value(repInfo.getTimeZone()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_REPORT_PARAMS.toInt()), new Value(repInfo.getReportParams()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_EMAIL_LIST.toInt()), new Value(repInfo.getEmailList()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_STATUS_EMAIL_LIST.toInt()), new Value(repInfo.getStatusEmailList()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_REPORT_PUBLISH_OPTIONS.toInt()), new Value(repInfo.getPublishOptions()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_EXPORT_OPTIONS.toInt()), new Value(repInfo.getExportOptions()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_WEB_URL.toInt()), new Value(repInfo.getWebURL()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_EXTERNAL_QUAL.toInt()), new Value(repInfo.getExternalQual()));
        entry.put(Integer.valueOf(ReportConstants.JOBPROCESSOR_OVERRIDE_QUERY.toInt()), new Value(repInfo.getOverrideQuery()));
        return serverUser.createEntry(this.getSchemaPublishReport(serverUser), entry);
    }

    public Entry getEntry(ARServerUser serverUser, String entryId) throws ARException {
        return serverUser.getEntry(this.getSchemaPublishReport(serverUser), entryId, new int[]{ReportConstants.JOBPROCESSOR_JOBITEM_NAME.toInt(), ReportConstants.JOBPROCESSOR_JOB_PARAMETERS.toInt(), ReportConstants.JOBPROCESSOR_JOBITEM_PARAMETERS.toInt(), CoreFieldId.EntryId.getFieldId()});
    }
}

