/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.arreporting.birt.BIRTLibraryUtil;
import com.bmc.arsys.plugins.processors.ServerContext;
import com.bmc.arsys.plugins.report.ReportForms;
import com.bmc.arsys.plugins.report.RunReport;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PublishReport
extends ARFilterAPIPlugin {
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.PUBLISHREPORT", (ARPluggable)this);
    private String serverName = "localhost";
    private ARServerUser serverUser = null;
    private StringBuffer statusMessage = new StringBuffer();
    private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private ThreadPoolExecutor executor = null;
    private String reportName = null;
    private String runAsUser = null;
    private String reportParams = null;
    private String timezone = null;
    private String GUID = null;
    private String WEBURL = null;
    private String externalQual = null;
    private Integer exportOptions = null;
    private Integer overrideQuery = null;
    private static String DEFAULT_URL = null;
    private String resourcePath;
    private int maxEntriesInFileReport = 0;

    public void initialize(ARPluginContext context) throws ARException {
        try {
            int i;
            ServerContext.initializeServerUser(context);
            String[] args = context.getCmdLineArgs();
            String message = "initialize method was invoked with args = ";
            if (args.length >= 0) {
                for (i = 0; i < args.length; ++i) {
                    message = message + " " + args[i];
                }
            }
            context.logMessage(this.pluginInfo, 0, message);
            this.maxEntriesInFileReport = Integer.parseInt(context.getConfigItem("maxEntriesInFileReport") == null ? "2000" : context.getConfigItem("maxEntriesInFileReport"));
            context.logMessage(this.pluginInfo, 0, "Config property for Max entries in the file report is set to - " + this.maxEntriesInFileReport);
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equals("-x")) continue;
                this.serverName = args[i + 1];
                i = args.length;
            }
            context.logMessage(this.pluginInfo, 0, "Server name = " + this.serverName);
            String urlPath = context.getARConfigEntry("Notification-Web-Path");
            if (urlPath == null || urlPath.length() == 0) {
                urlPath = context.getARConfigEntry("Default-Web-Path");
            }
            if (urlPath != null && urlPath.length() > 0) {
                if (urlPath.charAt(urlPath.length() - 1) != '/') {
                    urlPath = urlPath + "/";
                }
                DEFAULT_URL = urlPath;
                context.logMessage(this.pluginInfo, 0, "Default URL for liks is  - " + DEFAULT_URL);
            }
            this.executor = new ThreadPoolExecutor(5, 5, Integer.MAX_VALUE, TimeUnit.SECONDS, this.queue);
        }
        catch (Throwable th) {
            context.logMessage(1, th.getMessage());
        }
    }

    private void initServerUser(ARPluginContext context) throws ARException {
        context.logMessage(0, "initServerUser()");
        if (this.serverUser == null) {
            this.serverUser = new ARServerUser((ARNativeAuthenticationInfo)context, "", this.serverName);
            int port = Utilities.getIntegerValue(context.getARConfigEntry("TCD-Specific-Port"));
            this.serverUser.setPort(port);
            int rpcnumber = Utilities.getIntegerValue(context.getARConfigEntry("Plugin-Loopback-RPC-Socket"));
            if (rpcnumber > 0) {
                this.serverUser.usePrivateRpcQueue(rpcnumber);
            }
            this.serverUser.setVUIType(1);
        }
        this.serverUser.setUserContext((ARNativeAuthenticationInfo)context);
    }

    public void terminate(ARPluginContext context) throws ARException {
        context.logMessage(this.pluginInfo, 0, "terminate()");
        this.executor.shutdown();
        try {
            context.logMessage(this.pluginInfo, 0, "Waiting before termination so that the remaining tasks can complete...");
            this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            context.logMessage(this.pluginInfo, 2, e.getMessage());
        }
    }

    public List<Value> filterAPICall(final ARPluginContext context, List<Value> inValues) throws ARException {
        ReportForms.init(context);
        this.initialize(context);
        this.initServerUser(context);
        if (!ReportForms.isCopyBirtLibraries()) {
            try {
                if (this.resourcePath == null) {
                    File pathDir = new File(ReportForms.getDelegator().getProperties().getProperty("birt.libraries.dir"));
                    this.resourcePath = pathDir.getAbsolutePath();
                    if (this.resourcePath != null) {
                        this.resourcePath = this.resourcePath.replace('\\', '/');
                    }
                }
                BIRTLibraryUtil.updateLibraries(ServerContext.getServerUser(), this.resourcePath, context);
                ReportForms.setCopyBirtLibraries(true);
            }
            catch (Exception arex) {
                context.logMessage(this.pluginInfo, 2, arex.getMessage());
            }
        }
        if (inValues.size() == 0) {
            return null;
        }
        if (inValues.size() > 0 && inValues.get(0) != null) {
            this.reportName = (String)inValues.get(0).getValue();
        }
        if (inValues.size() > 1 && inValues.get(1) != null) {
            this.runAsUser = (String)inValues.get(1).getValue();
        }
        if (inValues.size() > 2 && inValues.get(2) != null) {
            this.reportParams = (String)inValues.get(2).getValue();
        }
        if (inValues.size() > 3 && inValues.get(3) != null) {
            this.timezone = (String)inValues.get(3).getValue();
        }
        if (inValues.size() > 4 && inValues.get(4) != null) {
            this.exportOptions = (Integer)inValues.get(4).getValue();
        }
        if (inValues.size() > 5 && inValues.get(5) != null) {
            this.GUID = (String)inValues.get(5).getValue();
        }
        if (inValues.size() > 6 && inValues.get(6) != null) {
            this.WEBURL = (String)inValues.get(6).getValue();
        }
        if (inValues.size() > 7 && inValues.get(7) != null) {
            this.externalQual = (String)inValues.get(7).getValue();
        }
        if (inValues.size() > 8 && inValues.get(8) != null) {
            this.overrideQuery = (Integer)inValues.get(8).getValue();
        }
        if (this.reportName == null) {
            return null;
        }
        if (DEFAULT_URL != null && DEFAULT_URL.length() > 0) {
            this.WEBURL = DEFAULT_URL;
        }
        context.logMessage(this.pluginInfo, 0, "Running report - " + this.reportName);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                RunReport reportService = new RunReport(context);
                reportService.runReport(PublishReport.this.reportName, PublishReport.this.runAsUser, PublishReport.this.reportParams, PublishReport.this.timezone, PublishReport.this.exportOptions, PublishReport.this.GUID, PublishReport.this.WEBURL, PublishReport.this.externalQual, PublishReport.this.overrideQuery, PublishReport.this.maxEntriesInFileReport);
            }
        });
        ArrayList<Value> outValues = new ArrayList<Value>();
        outValues.add(new Value("Not Available"));
        outValues.add(new Value("Ready"));
        outValues.add(new Value(this.statusMessage.toString()));
        return outValues;
    }
}

