/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.processors.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class Utility {
    private static final URL[] EMPTY_URL_ARR = new URL[0];

    public static URL[] getJarURLs(File execJarFile, boolean create) throws IOException {
        JarFile jf = new JarFile(execJarFile);
        File parent = execJarFile.getParentFile();
        Manifest mf = jf.getManifest();
        Attributes ma = mf.getMainAttributes();
        ArrayList<URL> cps = new ArrayList<URL>();
        System.out.println("The processor url is " + execJarFile.toURI().toURL() + "\n");
        cps.add(execJarFile.toURI().toURL());
        String cp = ma.getValue(Attributes.Name.CLASS_PATH);
        if (cp != null) {
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String fname = st.nextToken();
                URL u = Utility.getDependentJarURL(jf, parent, fname, create);
                if (u == null) continue;
                cps.add(u);
            }
        }
        return cps.toArray(EMPTY_URL_ARR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getDependentJarURL(JarFile jf, File parent, String fname, boolean create) throws IOException {
        ZipEntry depEntry = jf.getEntry(fname);
        if (depEntry != null) {
            File depJar = new File(parent, fname);
            if (create || !depJar.exists()) {
                depJar.getParentFile().mkdirs();
                try (InputStream is = jf.getInputStream(depEntry);){
                    Utility.copyStreamDataToFile(is, depJar);
                }
            }
            System.out.println("Dependent jar file URL is " + depJar.toURI().toURL() + "\n");
            return depJar.toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamDataToFile(InputStream is, File output) throws IOException {
        FileOutputStream fos = new FileOutputStream(output);
        try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int len;
            byte[] buff = new byte[8192];
            while ((len = is.read(buff)) != -1) {
                bos.write(buff, 0, len);
            }
        }
    }
}

