/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.processors.impl;

import com.bmc.arsys.plugins.processors.IProcessor;
import com.bmc.arsys.plugins.processors.SchedulerException;
import com.bmc.arsys.plugins.processors.impl.SharedObjectLoader;
import com.bmc.arsys.plugins.processors.impl.Utility;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

public class ExecInfo {
    private String mName;
    private String mClassName;
    private String mVersion;
    private File mJarFile;
    private IProcessor mProcessorInstance;

    public String getName() {
        return this.mName;
    }

    public void setName(String mName) {
        this.mName = mName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public void setClassName(String mClassName) {
        this.mClassName = mClassName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public void setJarFile(File jarFile) {
        this.mJarFile = jarFile;
    }

    public IProcessor getProcessorInstance() {
        return this.mProcessorInstance;
    }

    public void loadInstance(ARPluginContext context) throws SchedulerException {
        if (this.mProcessorInstance == null) {
            URL[] urls = null;
            try {
                urls = Utility.getJarURLs(this.mJarFile, false);
            }
            catch (IOException ioe) {
                throw new SchedulerException("IO Exception loading " + this.mJarFile.getName());
            }
            ClassLoader parent = SharedObjectLoader.getInstance(null);
            if (parent == null) {
                parent = Thread.currentThread().getContextClassLoader();
            }
            URLClassLoader ucl = new URLClassLoader(urls, parent);
            try {
                context.logMessage(context.getPluginInfo(), 0, "The processing class is " + this.mClassName);
                Class<?> pcl = ucl.loadClass(this.mClassName);
                Object pl = pcl.newInstance();
                if (pl.getClass().getClassLoader() != ucl) {
                    context.logMessage(context.getPluginInfo(), 0, "The plugin class " + this.mClassName + " has been loaded by a parent classloader. The class is incorrectly present in the classpath. It should only be present in the jar in the ar system plugin form.");
                }
                if (!(pl instanceof IProcessor)) {
                    throw new SchedulerException("Invalid Entry class " + this.mClassName + " for processor " + this.mName);
                }
                this.mProcessorInstance = (IProcessor)pl;
                this.mProcessorInstance.init();
            }
            catch (ClassNotFoundException cnfe) {
                throw new SchedulerException(cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                throw new SchedulerException(ie.getMessage());
            }
            catch (IllegalAccessException ile) {
                throw new SchedulerException(ile.getMessage());
            }
        }
    }
}

