/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.javascript;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ObjectPrinter;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.javascript.PrimitiveWrapFactory;
import com.bmc.arsys.plugins.javascript.RhinoScriptFile;
import com.bmc.arsys.plugins.util.ScriptInvocationData;
import com.bmc.arsys.plugins.util.ValueConverter;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class JavaScriptPlugin
extends ARFilterAPIPlugin {
    private static final Logger logger = Logger.getLogger(JavaScriptPlugin.class);
    private HashMap<String, RhinoScriptFile> scriptMap = new HashMap();
    private Context cx;
    private Scriptable scope;
    public static int[] supportedDataTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 40};

    public void initialize(ARPluginContext context) throws ARException {
        this.cx = Context.enter();
        this.cx.setWrapFactory((WrapFactory)new PrimitiveWrapFactory());
        this.scope = this.cx.initStandardObjects();
        super.initialize(context);
    }

    public void terminate(ARPluginContext context) throws ARException {
        super.terminate(context);
    }

    public List<Value> filterAPICall(ARPluginContext ctx, List<Value> inArgs) throws ARException {
        List<Value> results = null;
        Object[] args = ValueConverter.convertFromAR(inArgs, supportedDataTypes);
        String[] languageNames = new String[]{"JavaScript", "JScript", "ECMAScript"};
        ScriptInvocationData sid = new ScriptInvocationData(args, languageNames);
        String scriptSnippet = sid.getSourceSnippet();
        Object[] actualArgs = sid.getActualArgs();
        Object scriptResult = null;
        if (!this.scriptMap.containsKey(scriptSnippet)) {
            this.scriptMap.put(scriptSnippet, new RhinoScriptFile(this.cx, this.scope, scriptSnippet));
        }
        RhinoScriptFile rsf = this.scriptMap.get(scriptSnippet);
        scriptResult = rsf.exec(actualArgs);
        Object rawData = this.extractResult(scriptResult);
        results = ValueConverter.convertToAR(rawData);
        return results;
    }

    private Object extractResult(Object scriptResult) {
        Object[] rawData = null;
        if (scriptResult == null) {
            return rawData;
        }
        if (scriptResult instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptResult;
            String str = nativeArray.get("length", (Scriptable)nativeArray).toString();
            int count = (int)Double.parseDouble(str);
            rawData = new Object[count];
            for (int i = 0; i < count; ++i) {
                Object cur = nativeArray.get(i, (Scriptable)nativeArray);
                if (cur != null) {
                    cur = this.jsToJava(cur);
                }
                rawData[i] = cur;
            }
        } else {
            rawData = this.jsToJava(scriptResult);
        }
        return rawData;
    }

    private Object jsToJava(Object cur) {
        if (cur == null) {
            return cur;
        }
        cur = cur.getClass().getName().equals("org.mozilla.javascript.NativeDate") ? Context.jsToJava((Object)cur, Date.class) : cur.toString();
        return cur;
    }

    public static void main(String[] args) {
        ARPluginContext pc = new ARPluginContext();
        JavaScriptPlugin rhp = new JavaScriptPlugin();
        OutputWriter printer = rhp.new OutputWriter();
        try {
            ArrayList<Value> inArgs = new ArrayList<Value>();
            inArgs.add(new Value("C:\\Dev\\appajee\\Scripts\\rhino\\NumberConverter.js?convert"));
            inArgs.add(new Value(100));
            inArgs.add(new Value(10));
            inArgs.add(new Value(2));
            printer.print("", "", rhp.filterAPICall(pc, inArgs));
        }
        catch (ARException e) {
            logger.error((Object)"main(String[])", (Throwable)e);
        }
    }

    class OutputWriter
    extends ObjectPrinter {
        private final Logger logger = Logger.getLogger(OutputWriter.class);

        OutputWriter() {
        }

        public void printResult(String resultString) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("printResult(String) - " + resultString));
            }
            System.out.flush();
        }
    }
}

