/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper.shared;

import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractConfigurationFile;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.CommentEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.ConfigurationFileListIterator;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.LineFeedEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.PropertyEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.UnicodeHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.WhitespaceEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class PropertiesConfigurationFile
extends AbstractConfigurationFile {
    public static final String ISO_8859_1 = "ISO-8859-1";
    protected static final String DEFAULT_CHARSET_NAME = "ISO-8859-1";
    protected static final String DEFAULT_WHITESPACE_CHARACTERS = " \t\r\n\f";
    protected static final String DEFAULT_COMMENT_START_TOKEN = "#";
    protected static final String DEFAULT_KEY_VALUE_SEPARATORS = "=: \t\r\n\f";
    protected static final String DEFAULT_STRICT_KEY_VALUE_SEPARATORS = "=:";
    private String charsetName_ = "ISO-8859-1";
    private boolean encodeUnicode_ = false;
    private boolean allowMultipleValuesPerKey_ = false;
    private String whitespaceCharacters_ = " \t\r\n\f";
    private List<String> commentStartTokens_ = new ArrayList<String>();
    private String keyValueSeparators_;
    private String strictKeyValueSeparators_;
    private boolean useKeySeparatorSpacing_;
    private boolean useSeparatorValueSpacing_;

    public PropertiesConfigurationFile() {
        this.commentStartTokens_.add(DEFAULT_COMMENT_START_TOKEN);
        this.commentStartTokens_.add("!");
        this.keyValueSeparators_ = DEFAULT_KEY_VALUE_SEPARATORS;
        this.strictKeyValueSeparators_ = DEFAULT_STRICT_KEY_VALUE_SEPARATORS;
        this.useKeySeparatorSpacing_ = false;
        this.useSeparatorValueSpacing_ = false;
    }

    @Override
    public boolean allowsEntryType(AbstractEntry entry) {
        boolean result = false;
        if (entry != null) {
            int type = entry.getType();
            if (type == 1) {
                result = true;
            } else if (type == 2) {
                result = true;
            } else if (type == 7) {
                result = true;
            } else if (type == 3) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public void parse(File file) throws FileNotFoundException, IOException, ParseException {
        FileInputStream fis = new FileInputStream(file);
        this.parse(fis);
    }

    public void parse(InputStream inputStream) throws IOException, ParseException {
        String line;
        String charsetName = this.getCharsetName();
        InputStreamReader isr = charsetName == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charsetName);
        BufferedReader reader = new BufferedReader(isr);
        String whitespaceCharacters = this.getWhitespaceCharacters();
        List<String> commentStartTokens = this.getCommentStartTokens();
        while ((line = reader.readLine()) != null) {
            if (line.length() > 0) {
                int keyStart;
                int length = line.length();
                for (keyStart = 0; keyStart < length && whitespaceCharacters.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
                }
                if (keyStart == length) {
                    this.entries_.add(new WhitespaceEntry(line));
                } else {
                    Iterator<String> commentStartTokensIter = commentStartTokens.iterator();
                    String subline = line.substring(keyStart);
                    boolean foundComment = false;
                    while (!foundComment && commentStartTokensIter.hasNext()) {
                        String currentCommentStartToken = commentStartTokensIter.next();
                        if (!subline.startsWith(currentCommentStartToken)) continue;
                        String comment = subline.substring(currentCommentStartToken.length());
                        this.entries_.add(new CommentEntry(currentCommentStartToken, comment));
                        foundComment = true;
                    }
                    if (!foundComment) {
                        this.entries_.add(this.parseProperty(reader, line, length, keyStart));
                    }
                }
            }
            this.entries_.add(new LineFeedEntry());
        }
        reader.close();
        isr.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(File file) throws FileNotFoundException, IOException {
        FTSConfFileHelper.createFile(file);
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        try {
            fos = new FileOutputStream(file);
            String charsetName = this.getCharsetName();
            osw = charsetName == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, charsetName);
            writer = new BufferedWriter(osw);
            writer.write(this.toString());
            writer.flush();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Throwable t) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public void addComment(String comment) {
        this.addComment(null, comment);
    }

    public void addComment(String commentStartToken, String comment) {
        String innerCommentStartToken = commentStartToken;
        if (innerCommentStartToken == null) {
            List<String> commentStartTokens = this.getCommentStartTokens();
            innerCommentStartToken = commentStartTokens != null && commentStartTokens.size() > 0 ? commentStartTokens.get(0) : DEFAULT_COMMENT_START_TOKEN;
        }
        this.entries_.add(new CommentEntry(innerCommentStartToken, comment));
        this.entries_.add(new LineFeedEntry());
    }

    public void removeComment(String comment) {
        if (comment != null) {
            String comment2 = comment.trim();
            Iterator iter = this.entries_.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                CommentEntry commentEntry;
                AbstractEntry current = (AbstractEntry)iter.next();
                if (current.getType() != 1 || !(commentEntry = (CommentEntry)current).getBody().trim().equals(comment2)) continue;
                iter.remove();
                found = true;
                if (!iter.hasNext() || (current = (AbstractEntry)iter.next()).getType() != 2) continue;
                iter.remove();
            }
        }
    }

    public List<String> getProperties(String key) {
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractEntry current : this) {
            PropertyEntry propertyEntry;
            if (current.getType() != 3 || !(propertyEntry = (PropertyEntry)current).getKey().equals(key)) continue;
            String value = propertyEntry.getValue();
            result.add(value);
        }
        return result;
    }

    public String getProperty(String key) {
        String result = null;
        Iterator<AbstractEntry> iter = this.iterator();
        while (iter.hasNext() && result == null) {
            PropertyEntry propertyEntry;
            AbstractEntry current = iter.next();
            if (current.getType() != 3 || !FTSConfFileHelper.nullableEquals((propertyEntry = (PropertyEntry)current).getKey(), key)) continue;
            result = propertyEntry.getValue();
        }
        return result;
    }

    public PropertyEntry getPropertyEntry(String key, String value) {
        PropertyEntry result = null;
        Iterator<AbstractEntry> iter = this.iterator();
        while (iter.hasNext() && result == null) {
            PropertyEntry propertyEntry;
            AbstractEntry current = iter.next();
            if (current.getType() != 3 || !FTSConfFileHelper.nullableEquals((propertyEntry = (PropertyEntry)current).getKey(), key) || !FTSConfFileHelper.nullableEquals(propertyEntry.getValue(), value)) continue;
            result = propertyEntry;
        }
        return result;
    }

    public void addProperty(String key, String value) {
        if (this.getAllowMultipleValuesPerKey()) {
            this.addProperty(new PropertyEntry(key, value));
        } else {
            this.setProperty(key, value);
        }
    }

    public void addProperty(PropertyEntry property) {
        if (property != null) {
            if (this.getAllowMultipleValuesPerKey()) {
                PropertyEntry propertyEntryClone = property.clone();
                propertyEntryClone.setUseKeySeparatorSpacing(this.getUseKeySeparatorSpacing());
                propertyEntryClone.setUseSeparatorValueSpacing(this.getUseSeparatorValueSpacing());
                propertyEntryClone.setEncodeUnicode(this.getEncodeUnicode());
                this.entries_.add(propertyEntryClone);
                this.entries_.add(new LineFeedEntry());
            } else {
                this.setProperty(property);
            }
        }
    }

    public void setProperty(String key, String value) {
        this.setProperty(new PropertyEntry(key, value));
    }

    public void setProperty(PropertyEntry property) {
        if (property != null) {
            boolean found = false;
            String key = property.getKey();
            String value = property.getValue();
            Iterator<AbstractEntry> iter = this.iterator();
            while (iter.hasNext() && !found) {
                PropertyEntry propertyEntry;
                AbstractEntry current = iter.next();
                if (current.getType() != 3 || !(propertyEntry = (PropertyEntry)current).getKey().equals(key)) continue;
                propertyEntry.setValue(value);
                propertyEntry.setSeparator(property.getSeparator());
                propertyEntry.setEncodeUnicode(this.getEncodeUnicode());
                propertyEntry.setUseKeySeparatorSpacing(this.getUseKeySeparatorSpacing());
                propertyEntry.setUseSeparatorValueSpacing(this.getUseSeparatorValueSpacing());
                found = true;
            }
            if (!found) {
                PropertyEntry propertyEntryClone = property.clone();
                propertyEntryClone.setUseKeySeparatorSpacing(this.getUseKeySeparatorSpacing());
                propertyEntryClone.setUseSeparatorValueSpacing(this.getUseSeparatorValueSpacing());
                propertyEntryClone.setEncodeUnicode(this.getEncodeUnicode());
                this.entries_.add(propertyEntryClone);
                this.entries_.add(new LineFeedEntry());
            }
        }
    }

    public void setProperties(Properties properties) {
        String key = null;
        String value = null;
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            value = properties.getProperty(key);
            this.setProperty(new PropertyEntry(key, value));
        }
    }

    public void deleteProperty(PropertyEntry property) {
        if (property != null) {
            Iterator iter = this.entries_.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                PropertyEntry propertyEntry;
                AbstractEntry current = (AbstractEntry)iter.next();
                if (current.getType() != 3 || !FTSConfFileHelper.nullableEquals(propertyEntry = (PropertyEntry)current, property)) continue;
                iter.remove();
                found = true;
                if (!iter.hasNext() || (current = (AbstractEntry)iter.next()).getType() != 2) continue;
                iter.remove();
            }
        }
    }

    public void deleteProperty(String key) {
        Iterator iter = this.entries_.iterator();
        while (iter.hasNext()) {
            PropertyEntry propertyEntry;
            AbstractEntry current = (AbstractEntry)iter.next();
            if (current.getType() != 3 || !FTSConfFileHelper.nullableEquals((propertyEntry = (PropertyEntry)current).getKey(), key)) continue;
            iter.remove();
            if (!iter.hasNext() || (current = (AbstractEntry)iter.next()).getType() != 2) continue;
            iter.remove();
        }
    }

    public Properties toProperties() {
        Properties result = new Properties();
        for (AbstractEntry current : this) {
            if (current.getType() != 3) continue;
            PropertyEntry propertyEntry = (PropertyEntry)current;
            result.put(propertyEntry.getKey(), propertyEntry.getValue());
        }
        return result;
    }

    public String getCharsetName() {
        return this.charsetName_;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName_ = charsetName;
    }

    public boolean getEncodeUnicode() {
        return this.encodeUnicode_;
    }

    public void setEncodeUnicode(boolean encodeUnicode) {
        this.encodeUnicode_ = encodeUnicode;
    }

    public boolean getAllowMultipleValuesPerKey() {
        return this.allowMultipleValuesPerKey_;
    }

    public void setAllowMultipleValuesPerKey(boolean allowMultipleValuesPerKey) {
        this.allowMultipleValuesPerKey_ = allowMultipleValuesPerKey;
    }

    public String getWhitespaceCharacters() {
        return this.whitespaceCharacters_;
    }

    public void setWhitespaceCharacters(String whitespaceCharacters) {
        this.whitespaceCharacters_ = whitespaceCharacters;
    }

    public List<String> getCommentStartTokens() {
        if (this.commentStartTokens_ == null) {
            this.commentStartTokens_ = new ArrayList<String>();
        }
        return this.commentStartTokens_;
    }

    public void setCommentStartTokens(List<String> commentStartTokens) {
        this.commentStartTokens_ = commentStartTokens;
    }

    public void addCommentStartToken(String commentStartToken) {
        this.getCommentStartTokens().add(commentStartToken);
    }

    public void removeCommentStartToken(String commentStartToken) {
        this.getCommentStartTokens().remove(commentStartToken);
    }

    public String getStrictKeyValueSeparators() {
        return this.strictKeyValueSeparators_;
    }

    public void setStrictKeyValueSeparators(String strictKeyValueSeparators) {
        this.strictKeyValueSeparators_ = strictKeyValueSeparators;
    }

    public String getKeyValueSeparators() {
        return this.keyValueSeparators_;
    }

    public void setKeyValueSeparators(String keyValueSeparators) {
        this.keyValueSeparators_ = keyValueSeparators;
    }

    public boolean getUseKeySeparatorSpacing() {
        return this.useKeySeparatorSpacing_;
    }

    public void setUseKeySeparatorSpacing(boolean useKeySeparatorSpacing) {
        this.useKeySeparatorSpacing_ = useKeySeparatorSpacing;
        for (AbstractEntry current : this) {
            if (current.getType() != 3) continue;
            PropertyEntry propertyEntry = (PropertyEntry)current;
            propertyEntry.setUseKeySeparatorSpacing(useKeySeparatorSpacing);
        }
    }

    public boolean getUseSeparatorValueSpacing() {
        return this.useSeparatorValueSpacing_;
    }

    public void setUseSeparatorValueSpacing(boolean useSeparatorValueSpacing) {
        this.useSeparatorValueSpacing_ = useSeparatorValueSpacing;
        for (AbstractEntry current : this) {
            if (current.getType() != 3) continue;
            PropertyEntry propertyEntry = (PropertyEntry)current;
            propertyEntry.setUseSeparatorValueSpacing(useSeparatorValueSpacing);
        }
    }

    public void commentProperty(String commentStartToken, String key) {
        String value;
        if (key != null && (value = this.getProperty(key)) != null) {
            this.commentProperty(commentStartToken, this.getPropertyEntry(key, value));
        }
    }

    public void commentProperty(String commentStartToken, PropertyEntry property) {
        if (property != null) {
            String innerCommentStartToken = commentStartToken;
            if (innerCommentStartToken == null) {
                List<String> commentStartTokens = this.getCommentStartTokens();
                innerCommentStartToken = commentStartTokens != null && commentStartTokens.size() > 0 ? commentStartTokens.get(0) : DEFAULT_COMMENT_START_TOKEN;
            }
            ConfigurationFileListIterator iter = this.getConfigurationFileListIterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                PropertyEntry propertyEntry;
                AbstractEntry current = iter.next();
                if (current.getType() != 3 || !FTSConfFileHelper.nullableEquals((propertyEntry = (PropertyEntry)current).getKey(), property.getKey()) || !FTSConfFileHelper.nullableEquals(propertyEntry.getValue(), property.getValue())) continue;
                iter.set(new CommentEntry(innerCommentStartToken, propertyEntry.toString()));
                found = true;
            }
        }
    }

    protected PropertyEntry parseProperty(BufferedReader reader, String line, int length, int keyStart) throws IOException {
        int valueStart;
        char currentChar;
        String line2 = line;
        int valueEnd = length;
        String whitespaceCharacters = this.getWhitespaceCharacters();
        char separator = '=';
        String strictKeyValueSeparators = this.getStrictKeyValueSeparators();
        while (this.continueLine(line2)) {
            int startIndex;
            String nextLine = null;
            if (reader != null) {
                nextLine = reader.readLine();
            }
            if (nextLine == null) {
                nextLine = "";
            }
            String loppedLine = line2.substring(0, valueEnd - 1);
            for (startIndex = 0; startIndex < nextLine.length() && whitespaceCharacters.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
            }
            nextLine = nextLine.substring(startIndex, nextLine.length());
            line2 = new String(loppedLine + nextLine);
            valueEnd = line2.length();
        }
        int separatorIndex = -1;
        int keyEnd = keyStart;
        boolean done = false;
        String keyValueSeparators = this.getKeyValueSeparators();
        while (keyEnd < valueEnd && !done) {
            currentChar = line2.charAt(keyEnd);
            if (currentChar == '\\') {
                ++keyEnd;
                ++keyEnd;
                continue;
            }
            if (keyValueSeparators.indexOf(currentChar) != -1) {
                separator = currentChar;
                separatorIndex = keyEnd;
                done = true;
                continue;
            }
            ++keyEnd;
        }
        while (keyEnd > keyStart && keyEnd > 0 && whitespaceCharacters.indexOf(line2.charAt(keyEnd - 1)) != -1) {
            --keyEnd;
        }
        for (valueStart = keyEnd; valueStart < valueEnd && whitespaceCharacters.indexOf(line2.charAt(valueStart)) != -1; ++valueStart) {
        }
        if (valueStart < valueEnd && strictKeyValueSeparators.indexOf(currentChar = line2.charAt(valueStart)) != -1) {
            separator = currentChar;
            separatorIndex = valueStart++;
        }
        while (valueStart < valueEnd && whitespaceCharacters.indexOf(line2.charAt(valueStart)) != -1) {
            ++valueStart;
        }
        String key = line2.substring(keyStart, keyEnd);
        String value = "";
        String keySeparatorSpacing = null;
        String separatorValueSpacing = null;
        if (keyEnd < valueEnd) {
            value = line2.substring(valueStart, valueEnd);
            keySeparatorSpacing = line2.substring(keyEnd, separatorIndex);
            separatorValueSpacing = line2.substring(separatorIndex + 1, valueStart);
        }
        if (this.getEncodeUnicode()) {
            key = UnicodeHelper.decodeString(key);
            value = UnicodeHelper.decodeString(value);
        }
        return new PropertyEntry(key, value, separator, this.getEncodeUnicode(), this.getUseKeySeparatorSpacing(), keySeparatorSpacing, this.getUseSeparatorValueSpacing(), separatorValueSpacing);
    }
}

