/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.configchecker;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.configchecker.ConfigCheckerLogForm;
import com.bmc.arsys.plugins.configchecker.Messages;
import com.bmc.arsys.plugins.configchecker.ServerContext;
import com.bmc.arsys.plugins.configchecker.UdmChecker;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.util.ARUtilEgcp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ConfigCheckerFilterPlugin
extends ARFilterAPIPlugin {
    private static final String SERVER_CONNECT_NAME = "Server-Connect-Name";
    private static final String SERVER_NAME = "Server-Name";
    private static final String TCD_SPECIFIC_PORT = "TCD-Specific-Port";
    private static final String REMEDY_APP_SERVICE_PASSWORD = "Remedy-App-Service-Password";
    private static final String RUN_FINISHED_SUCC = "Run finished successfully";
    private static final String RUN_FINISHED_FAIL_CHECKS = "Run finished with failed checks ";
    private static final String SERVER_DIR = "Server-directory";
    private static final String UNIX_SD = "/db";
    private static final String WIN_SD = "\\ARServer\\Db";
    private static Logger logger = Logger.getLogger(ConfigCheckerFilterPlugin.class);
    private ConfigCheckerLogForm checkLogForm = null;

    public void initialize(ARPluginContext context) throws ARException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Plugin name: " + context.getPluginInfo().getName() + " version: " + context.getPluginInfo().getVersion() + "  initialize."));
        }
        super.initialize(context);
    }

    public void terminate(ARPluginContext context) throws ARException {
        super.terminate(context);
    }

    public List<Value> filterAPICall(ARPluginContext context, List<Value> pInValues) throws ARException {
        Value relVal;
        block9: {
            relVal = new Value(RUN_FINISHED_SUCC, DataType.CHAR);
            ARServerUser user = this.getUser(context, true);
            this.checkLogForm = new ConfigCheckerLogForm(user);
            logger.debug((Object)("ConfigChecker filterAPICall with input: " + pInValues.toString()));
            try {
                if (pInValues.size() < 2) {
                    throw this.badArguments();
                }
                String product = pInValues.get(0).toString();
                String check = pInValues.get(1).toString();
                this.validateInput(product, check);
                String serverInstallDir = null;
                int in = -1;
                String tmpInD = context.getARConfigEntry(SERVER_DIR);
                in = tmpInD.indexOf(UNIX_SD);
                if (in != -1 || (in = tmpInD.indexOf(WIN_SD)) != -1) {
                    serverInstallDir = tmpInD.substring(0, in);
                    logger.debug((Object)("server install dir : " + serverInstallDir));
                }
                ServerContext svrContext = new ServerContext(user, serverInstallDir);
                this.checkLogForm.purgeOldEntries();
                if (product.equals(Product.UDM.toString())) {
                    UdmChecker uChecker = new UdmChecker(check, this.checkLogForm);
                    if (uChecker.init(svrContext)) {
                        uChecker.performValidation();
                        List<String> msgs = uChecker.getErrorMessages();
                        if (msgs.size() > 0) {
                            String re = "Errors:\n";
                            for (String it : msgs) {
                                re = re + it + "\n";
                            }
                            relVal = new Value(RUN_FINISHED_FAIL_CHECKS + re, DataType.CHAR);
                        }
                    }
                    break block9;
                }
                throw new Exception(Product.UDM.toString() + "  not suported yet");
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
                relVal = new Value(RUN_FINISHED_FAIL_CHECKS + e.getMessage(), DataType.CHAR);
            }
        }
        if (!this.checkLogForm.allCheckPassed()) {
            relVal = new Value(RUN_FINISHED_FAIL_CHECKS, DataType.CHAR);
        }
        ArrayList<Value> ret = new ArrayList<Value>();
        ret.add(relVal);
        return ret;
    }

    private void validateInput(String product, String check) throws Exception {
        if (product == null || check == null) {
            throw new Exception("input PRODUCT or CHECK is empty");
        }
        if (!Product.validProduct(product)) {
            throw new Exception("Bad product name: " + product);
        }
        if (!UdmChecker.UDMChecks.validCheck(check)) {
            throw new Exception("Bad check Name: " + check);
        }
    }

    public ARServerUser getUser(ARPluginContext arPluginContext, boolean dedicatedAdmin) throws ARException {
        ARServerUser arUser = null;
        int localServerPort = 0;
        String localServerName = null;
        localServerName = arPluginContext.getARConfigEntry(SERVER_CONNECT_NAME);
        if (localServerName == null || localServerName.length() == 0) {
            localServerName = arPluginContext.getARConfigEntry(SERVER_NAME);
        }
        if (localServerName == null || localServerName.length() == 0) {
            logger.error((Object)"Failed to retrieve ar server host from the ar.cfg file");
            throw this.getException(Messages.SERVER_NAME_ITEM_NOT_FOUND);
        }
        String serverPort = arPluginContext.getARConfigEntry(TCD_SPECIFIC_PORT);
        if (null != serverPort && serverPort.length() > 0) {
            try {
                localServerPort = Integer.parseInt(serverPort);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Failed to convert from String to int the TCD-Specific-Port property with value:" + serverPort + " as it configured in the ar.cfg"), (Throwable)e);
                throw this.getException(Messages.FAILED_TO_CONVERT_ITEM);
            }
        }
        if (dedicatedAdmin) {
            String pwd = arPluginContext.getARConfigEntry(REMEDY_APP_SERVICE_PASSWORD);
            ARUtilEgcp egcp = new ARUtilEgcp();
            pwd = egcp.GCEUtilApp(pwd);
            arUser = new ARServerUser("Remedy Application Service", pwd, arPluginContext.getAuthString(), null, localServerName);
        } else {
            arUser = new ARServerUser((ARNativeAuthenticationInfo)arPluginContext, null, localServerName);
        }
        if (localServerPort != 0) {
            arUser.setPort(localServerPort);
        }
        logger.debug((Object)(arPluginContext.getPluginInfo().getName() + " Plugin is configured to connect to AR Server with following AR Server User:" + arUser.toString()));
        return arUser;
    }

    private ARException getException(Messages message) {
        ArrayList<StatusInfo> newStatusList = new ArrayList<StatusInfo>();
        StatusInfo newStatusInfo = new StatusInfo(2, (long)message.getMsgNumber(), message.toString(), "Check plugin log file for details");
        newStatusList.add(newStatusInfo);
        return new ARException(newStatusList);
    }

    private ARException badArguments() {
        StatusInfo newStatusInfo = new StatusInfo(2, (long)Messages.BADARGUMENTS.getMsgNumber(), Messages.BADARGUMENTS.toString(), "");
        ArrayList<StatusInfo> newStatusList = new ArrayList<StatusInfo>();
        newStatusList.add(newStatusInfo);
        return new ARException(newStatusList);
    }

    static enum Product {
        ARS("ARS", 0),
        CMDB("CMDB", 2),
        ITSM("ITSM", 3),
        SLM("SLM", 4),
        SRM("SRM", 5),
        SSI("SSI", 6),
        UDM("UDM", 7);

        private String str;
        private int val;

        private Product(String str, int val) {
            this.str = str;
            this.val = val;
        }

        public String toString() {
            return this.str;
        }

        public int getVal() {
            return this.val;
        }

        public static boolean validProduct(String in) {
            return in.equals(ARS.toString()) || in.equals(CMDB.toString()) || in.equals(ITSM.toString()) || in.equals(SLM.toString()) || in.equals(SRM.toString()) || in.equals(SSI.toString()) || in.equals(UDM.toString());
        }
    }
}

