/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ardbcldap;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import java.util.List;

public class DBCLdapProperties {
    private List<String> hostNames;
    private int portNumber;
    private String bindUser;
    private String bindPassword;
    private boolean useSSL;
    private String certificateDB;
    private int connectTimeout;
    private String baseDN;
    private String certName;
    private String keyPassword;
    private String keyDB;
    private int pageSize;
    private boolean chaseReferrals;
    private String timeFormat;
    private boolean useCache;
    private String cacheTTL;
    private int maxCacheSize;
    private int dnTimeout;
    private String resolvedHost;

    public void setHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
    }

    public List<String> getHostNames() {
        return this.hostNames;
    }

    public void setResolvedHost(String resolvedHost) {
        this.resolvedHost = resolvedHost;
    }

    public String getResolvedHost() {
        return this.resolvedHost;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setBindUser(String bindUser) {
        this.bindUser = bindUser;
    }

    public String getBindUser() {
        return this.bindUser;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = this.decryptPassword(bindPassword);
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setCertificateDB(String certificateDB) {
        this.certificateDB = certificateDB;
    }

    public String getCertificateDB() {
        return this.certificateDB;
    }

    public void setConnectTimeout(String defaultPluginTimeOut, String ardbcLdapTimeOut) {
        int defaultTimeout = 0;
        int ldapTimeOut = 0;
        if (defaultPluginTimeOut != null && !defaultPluginTimeOut.isEmpty()) {
            defaultTimeout = Integer.parseInt(defaultPluginTimeOut);
        }
        if (ardbcLdapTimeOut != null && !ardbcLdapTimeOut.isEmpty()) {
            ldapTimeOut = Integer.parseInt(ardbcLdapTimeOut);
        }
        if (defaultTimeout > 0 && ldapTimeOut > 0) {
            this.connectTimeout = defaultTimeout < ldapTimeOut ? defaultTimeout : ldapTimeOut;
        } else if (defaultTimeout > 0) {
            this.connectTimeout = defaultTimeout;
        } else if (ldapTimeOut > 0) {
            this.connectTimeout = ldapTimeOut;
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    public String getCertName() {
        return this.certName;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = this.decryptPassword(keyPassword);
    }

    private String decryptPassword(String encyptedPassword) {
        if (encyptedPassword == null) {
            return null;
        }
        PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
        byte[] decPasswd = null;
        try {
            decPasswd = pwdEnc.decryptPasswordEx(encyptedPassword.getBytes());
        }
        catch (AREncryptionException e) {
            e.printStackTrace();
        }
        return new String(decPasswd);
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyDB(String keyDB) {
        this.keyDB = keyDB;
    }

    public String getKeyDB() {
        return this.keyDB;
    }

    public void setPageSize(String pageSize) {
        try {
            int pgSize;
            this.pageSize = pgSize = Integer.parseInt(pageSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setChaseReferrals(boolean chaseReferrals) {
        this.chaseReferrals = chaseReferrals;
    }

    public boolean isChaseReferrals() {
        return this.chaseReferrals;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setCacheTTL(String cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public String getCacheTTL() {
        return this.cacheTTL;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setDnTimeout(int dnTimeout) {
        this.dnTimeout = dnTimeout;
    }

    public int getDnTimeout() {
        return this.dnTimeout;
    }
}

