/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ardbcldap;

import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ardbcldap.LDAPUrl;
import com.bmc.arsys.plugins.ardbcldap.LDAPVendorField;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class ARDBCUtils {
    static LDAPUrl parseURL(String tableName) {
        LDAPUrl ldapURL = new LDAPUrl();
        ldapURL.parseURL(tableName);
        return ldapURL;
    }

    static String getFilter(String tableName) {
        String[] parts = tableName.split("\\?");
        return parts[parts.length - 1];
    }

    static Object getAttributeValue(Attribute attr, LDAPVendorField field) throws NamingException, ParseException {
        Object elmValue = null;
        if (field.isMultiValued()) {
            NamingEnumeration<?> values = attr.getAll();
            StringBuilder sb = new StringBuilder();
            while (values.hasMoreElements()) {
                sb.append((String)values.nextElement());
                sb.append(field.getValueSeperator());
            }
            String value = sb.toString();
            if (!value.isEmpty() && value.length() > field.getValueSeperator().length()) {
                value = value.substring(0, value.length() - field.getValueSeperator().length());
                elmValue = value;
            }
        } else {
            switch (field.getDataType()) {
                case 2: {
                    elmValue = Integer.parseInt(attr.get().toString());
                    break;
                }
                case 7: 
                case 13: {
                    elmValue = ARDBCUtils.convertToTimestamp(attr);
                    break;
                }
                default: {
                    elmValue = attr.get();
                }
            }
        }
        return elmValue;
    }

    static Timestamp convertToTimestamp(Attribute attr) throws ParseException, NamingException {
        if (attr != null && attr.get() != null) {
            String sDate = attr.get().toString();
            SimpleDateFormat sdf = null;
            Date dt = null;
            String[] part = sDate.split("\\.");
            if (part.length > 0) {
                if (part.length > 1) {
                    String timeZone = "+0" + part[1].substring(0, part[1].length() - 1) + "00";
                    sdf = new SimpleDateFormat("yyyyMMddHHmmssZ");
                    dt = sdf.parse(part[0] + timeZone);
                } else {
                    sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                    dt = sdf.parse(part[0]);
                }
            } else {
                sdf = new SimpleDateFormat("yyyyMMddHHmmssZ");
                dt = sdf.parse(sDate);
            }
            return new Timestamp(dt);
        }
        return null;
    }

    static void setAttributeValue(Attributes attribs, LDAPVendorField fld, Value val) {
        if (val == null || val.getValue() == null) {
            attribs.put(fld.getName(), null);
            return;
        }
        if (fld.isMultiValued() && fld.getDataType() == 4) {
            String deLim = fld.getValueSeperator();
            StringTokenizer st = new StringTokenizer((String)val.getValue(), deLim);
            if (st.hasMoreTokens()) {
                BasicAttribute battr = new BasicAttribute(fld.getName(), st.nextToken());
                while (st.hasMoreTokens()) {
                    battr.add(st.nextToken());
                }
                attribs.put(battr);
            }
        } else {
            attribs.put(fld.getName(), val.getValue());
        }
    }

    static void setDateAttributeValue(Attributes attribs, String dateTimeFormatIndex, LDAPVendorField fld, Value value) {
        if (value == null || value.getValue() == null) {
            return;
        }
        String dateVal = ARDBCUtils.getLDAPDateRepresentation(dateTimeFormatIndex, value);
        attribs.put(fld.getName(), dateVal);
    }

    static String getLDAPDateRepresentation(String dateTimeFormatIndex, Value value) {
        int format = 0;
        if (dateTimeFormatIndex != null && !dateTimeFormatIndex.isEmpty()) {
            format = Integer.parseInt(dateTimeFormatIndex);
        }
        Date ts = ARDBCUtils.getTimeStamp(value);
        String dateVal = null;
        switch (format) {
            case 1: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
                dateVal = dateFormat.format(ts).concat(".0Z");
                break;
            }
            case 2: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddhhmmss");
                dateVal = dateFormat.format(ts).concat("Z");
                break;
            }
            default: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
                dateVal = dateFormat.format(ts).concat("Z");
            }
        }
        return dateVal;
    }

    static Date getTimeStamp(Value value) {
        Date timestamp = null;
        if (value.getValue() instanceof DateInfo) {
            DateInfo date = (DateInfo)value.getValue();
            timestamp = new Date(date.GetDate().getTimeInMillis());
        } else if (value.getValue() instanceof Timestamp) {
            Timestamp ts = (Timestamp)value.getValue();
            timestamp = ts.toDate();
        }
        return timestamp;
    }

    static void populateFieldMaps(Map<Integer, LDAPVendorField> idVsMap, Map<String, LDAPVendorField> nameVsMap, List<ARVendorField> fieldsList) {
        for (int i = 0; i < fieldsList.size(); ++i) {
            LDAPVendorField arVendorField = new LDAPVendorField(fieldsList.get(i));
            if (idVsMap != null) {
                idVsMap.put(arVendorField.getFieldId(), arVendorField);
            }
            if (nameVsMap == null) continue;
            nameVsMap.put(arVendorField.getName(), arVendorField);
        }
    }

    static ARVendorField getDNField(Map<String, LDAPVendorField> nameVsMap) {
        ARVendorField fld = null;
        for (String key : nameVsMap.keySet()) {
            if (!key.equalsIgnoreCase("dn") && !key.equalsIgnoreCase("distinguishedname")) continue;
            return nameVsMap.get(key);
        }
        return fld;
    }
}

