/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.alert;

import com.bmc.arsys.api.Value;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AlertDeliveryContext {
    private ARPluginContext innerContext;
    private List<Value> rawInValueList;
    private String user;
    private String alertId;
    private String alertText;
    private Map<String, String> pluginArgs;
    private Map<String, String> pluginEncryptedArgs;
    private static final int ALERT_USER_VALUE_INDEX = 0;
    private static final int ALERT_ID_VALUE_INDEX = 1;
    private static final int ALERT_TEXT_VALUE_INDEX = 2;
    private static final int ALERT_PLUGIN_ARGS_VALUE_INDEX = 3;
    private static final int ALERT_PLUGIN_ENCRYPTED_ARGS_VALUE_INDEX = 4;
    private static final String DEFAULT_UNSPECIFIED_VALUE_STRING = "(unspecified)";

    public AlertDeliveryContext(ARPluginContext innerContext, List<Value> rawInValueList) {
        this.innerContext = innerContext;
        this.rawInValueList = rawInValueList;
        this.user = AlertDeliveryContext.getStringValueAt(rawInValueList, 0, DEFAULT_UNSPECIFIED_VALUE_STRING);
        this.alertId = AlertDeliveryContext.getStringValueAt(rawInValueList, 1, DEFAULT_UNSPECIFIED_VALUE_STRING);
        this.alertText = AlertDeliveryContext.getStringValueAt(rawInValueList, 2, DEFAULT_UNSPECIFIED_VALUE_STRING);
        this.pluginArgs = AlertDeliveryContext.getMapValueAt(rawInValueList, 3);
        this.pluginEncryptedArgs = AlertDeliveryContext.getMapValueAt(rawInValueList, 4);
    }

    private static String getStringValueAt(List<Value> list, int index, String defaultValue) {
        Value value = list.size() > index ? list.get(index) : null;
        String str = value != null ? value.toString() : defaultValue;
        return str;
    }

    private static Map<String, String> getMapValueAt(List<Value> list, int index) {
        HashMap<String, String> map = new HashMap<String, String>();
        String str = AlertDeliveryContext.getStringValueAt(list, index, null);
        List<String> lines = AlertDeliveryContext.split(str, ";", "\"\"");
        for (String string : lines) {
            int sepAt = string.indexOf(61);
            if (sepAt == -1) continue;
            String name = string.substring(0, sepAt);
            String value = string.substring(sepAt + 1);
            map.put(name, value);
        }
        return map;
    }

    public static List<String> split(String string, String separator, String escape) {
        List<String> result = new ArrayList<String>();
        if (string != null && separator != null) {
            if (escape == null) {
                result = Arrays.asList(string.split(separator));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("\\s*");
                sb.append(escape);
                sb.append("(.*?)");
                sb.append(escape);
                sb.append("\\s*");
                sb.append("|");
                sb.append("(?<=^|");
                sb.append(separator);
                sb.append(")");
                sb.append("[^");
                sb.append(separator);
                sb.append("]*");
                String regEx = sb.toString();
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(string);
                while (m.find()) {
                    result.add(m.group(1) != null ? m.group(1) : m.group());
                }
            }
        }
        return result;
    }

    public ARPluginContext getInnerContext() {
        return this.innerContext;
    }

    public List<Value> getRawInValueList() {
        return this.rawInValueList;
    }

    public String getUser() {
        return this.user;
    }

    public String getAlertId() {
        return this.alertId;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public Map<String, String> getPluginArgs() {
        return this.pluginArgs;
    }

    public Map<String, String> getPluginEncryptedArgs() {
        return this.pluginEncryptedArgs;
    }
}

