/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzerConfigReader;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSRootCharacterFilter;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSStemmingFilter;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSThesaurusFilter;
import com.bmc.arsys.fts.impl.lucene.analyzers.LiteralTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.SnowballProgram;

public class FTSAnalyzer
extends Analyzer {
    private static final Logger LOGGER = Logger.getLogger(FTSAnalyzer.class);
    private Set<String> stopSet = new HashSet<String>();
    private Hashtable<String, String> rootTable = new Hashtable();
    private Hashtable<String, String> rootCharTable = new Hashtable();
    private static Hashtable<String, String[]> thesTable = new Hashtable();
    private Set<String> regexSet = new HashSet<String>();
    private Analyzer indexAnalyzer = null;
    private Analyzer searchAnalyzer = null;
    private SnowballProgram stemmer = null;
    private boolean useStopwords = false;
    private boolean useRootwords = false;
    private boolean useRootchar = false;
    private boolean useThesuarus = false;
    private boolean useRegex = false;
    private boolean useIndexAnalyzer = false;
    public boolean useSearchAnalyzer = false;
    private boolean useStemmer = false;
    private boolean isSearch = false;
    private FTSAnalyzerConfigReader.FTSAnalyzerConfig config = null;
    public static final CharArraySet STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
    public static final String STOPWORD_TOKEN = "~!~STOPWORD~!~";
    private boolean isCaseSensitive = false;
    private boolean isLiteral = false;
    private boolean doStemming = true;
    private boolean isInWildcardProcessing = false;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public FTSAnalyzer(FTSAnalyzerConfigReader.FTSAnalyzerConfig configArg, boolean caseSensitive) {
        this.config = configArg;
        this.reload(caseSensitive);
    }

    public void reload(boolean caseSensitive) {
        Class<?> analyzeClass;
        int x;
        String[] words;
        List tempSet;
        FileInputStream r;
        File file;
        this.isCaseSensitive = caseSensitive;
        if (this.config.rootwordfile != null && !this.config.rootwordfile.equals("") && (file = new File(this.config.rootwordfile)).exists()) {
            try {
                r = new FileInputStream(file);
                tempSet = WordlistLoader.getLines((InputStream)r, (Charset)this.config.serverCharSet);
                for (String currentLineStr : tempSet) {
                    words = currentLineStr.split(" ");
                    String rootWord = words[0];
                    for (x = 0; x < words.length; ++x) {
                        this.rootTable.put(words[x], rootWord);
                    }
                }
                this.useRootwords = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.rootcharacterfile != null && !this.config.rootcharacterfile.equals("") && (file = new File(this.config.rootcharacterfile)).exists()) {
            try {
                r = new FileInputStream(file);
                tempSet = WordlistLoader.getLines((InputStream)r, (Charset)this.config.serverCharSet);
                for (String currentLineStr : tempSet) {
                    words = currentLineStr.split(" ");
                    String rootChar = words[0];
                    for (x = 1; x < words.length; ++x) {
                        String strTemp = words[x];
                        if (strTemp.length() != 6) continue;
                        int charInt = Integer.parseInt(strTemp.substring(2), 16);
                        char charchar = (char)charInt;
                        this.rootCharTable.put(String.valueOf(charchar), rootChar);
                    }
                }
                this.useRootchar = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.thesaurusfile != null && !this.config.thesaurusfile.equals("") && (file = new File(this.config.thesaurusfile)).exists()) {
            try {
                r = new FileInputStream(file);
                tempSet = WordlistLoader.getLines((InputStream)r, (Charset)this.config.serverCharSet);
                for (String currentLineStr : tempSet) {
                    words = currentLineStr.split(" ");
                    for (int a = 0; a < words.length; ++a) {
                        String workingWord = words[a];
                        String[] synonyms = new String[words.length - 1];
                        for (int x2 = 0; x2 < words.length; ++x2) {
                            int count2 = 0;
                            for (int y = 0; y < words.length; ++y) {
                                if (words[y].equals(workingWord)) continue;
                                synonyms[count2] = words[y];
                                ++count2;
                            }
                        }
                        thesTable.put(workingWord, synonyms);
                    }
                }
                this.useThesuarus = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.regexfile != null && !this.config.regexfile.equals("") && (file = new File(this.config.regexfile)).exists()) {
            try {
                this.regexSet = new HashSet<String>();
                r = new FileInputStream(file);
                tempSet = WordlistLoader.getLines((InputStream)r, (Charset)this.config.serverCharSet);
                for (String currentStr : tempSet) {
                    this.regexSet.add(currentStr);
                }
                this.useRegex = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.stemmer != null && !this.config.stemmer.equals("")) {
            try {
                Class<?> stemClass = this.config.stemmer.indexOf(".") > -1 ? Class.forName(this.config.stemmer) : Class.forName("org.tartarus.snowball.ext." + this.config.stemmer + "Stemmer");
                this.stemmer = (SnowballProgram)stemClass.newInstance();
                this.useStemmer = true;
            }
            catch (Exception e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the stemmer"), (Throwable)e);
            }
        }
        if (this.config.stopwordfile != null && !this.config.stopwordfile.equals("") && (file = new File(this.config.stopwordfile)).exists()) {
            try {
                HashSet<String> tmpStopSet = new HashSet<String>();
                FileInputStream r2 = new FileInputStream(file);
                List tempSet2 = WordlistLoader.getLines((InputStream)r2, (Charset)this.config.serverCharSet);
                for (String currentStr : tempSet2) {
                    tmpStopSet.add(currentStr);
                }
                this.stopSet = this.stopwordStemmer(tmpStopSet);
                this.stopSet.addAll(tmpStopSet);
                this.useStopwords = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.nonstemmedstopwordsfile != null && !this.config.nonstemmedstopwordsfile.equals("") && (file = new File(this.config.nonstemmedstopwordsfile)).exists()) {
            try {
                r = new FileInputStream(file);
                tempSet = WordlistLoader.getLines((InputStream)r, (Charset)this.config.serverCharSet);
                Iterator i = tempSet.iterator();
                if (this.stopSet == null) {
                    this.stopSet = new HashSet<String>();
                }
                while (i.hasNext()) {
                    String currentStr;
                    currentStr = (String)i.next();
                    this.stopSet.add(currentStr);
                }
                this.useStopwords = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.indexAnalyzer != null && !this.config.indexAnalyzer.equals("")) {
            try {
                analyzeClass = Class.forName(this.config.indexAnalyzer);
                this.indexAnalyzer = (Analyzer)analyzeClass.newInstance();
                this.useIndexAnalyzer = true;
            }
            catch (Exception e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the indexAnalyzer"), (Throwable)e);
            }
        }
        if (this.config.searchAnalyzer != null && !this.config.searchAnalyzer.equals("")) {
            try {
                analyzeClass = Class.forName(this.config.searchAnalyzer);
                this.searchAnalyzer = (Analyzer)analyzeClass.newInstance();
                this.useSearchAnalyzer = true;
            }
            catch (Exception e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the searchAnalyzer"), (Throwable)e);
            }
        }
        this.setReuseStrategyByReflection(new FTSReuseStrategy());
    }

    private void setReuseStrategyByReflection(FTSReuseStrategy ftsReuseStrategy) {
        try {
            Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("reuseStrategy");
            f.setAccessible(true);
            f.set((Object)this, (Object)ftsReuseStrategy);
        }
        catch (Exception e) {
            LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to set ReuseStrategy "), (Throwable)e);
        }
    }

    private Set<String> stopwordStemmer(Set<String> stopwords) {
        if (this.doStemming && this.stemmer != null) {
            HashSet<String> stemmedStopwords = new HashSet<String>();
            for (String stopword : stopwords) {
                this.stemmer.setCurrent(stopword);
                this.stemmer.stem();
                stemmedStopwords.add(this.stemmer.getCurrent());
            }
            return stemmedStopwords;
        }
        return stopwords;
    }

    public FTSAnalyzer(String string, boolean caseSensitivity) {
        File file;
        this.isCaseSensitive = caseSensitivity;
        if (string != null && !string.equals("") && (file = new File(string)).exists()) {
            try {
                this.stopSet = new HashSet<String>();
                FileReader r = new FileReader(file);
                CharArraySet tempSet = WordlistLoader.getWordSet((Reader)r, (Version)Version.LUCENE_4_9);
                for (char[] currentChars : tempSet) {
                    String currentStr = new String(currentChars);
                    this.stopSet.add(currentStr);
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    private void checkFieldName(String fieldName) {
        this.isLiteral = fieldName.endsWith("_literal") || fieldName.endsWith("_literalCase");
        if (fieldName.equals("entryid") || fieldName.equals("docid") || fieldName.equals("schemaid")) {
            this.isLiteral = true;
        }
        if (fieldName.endsWith("_noStem") || fieldName.endsWith("_caseNoStem")) {
            this.doStemming = false;
        } else if (!this.isInWildcardProcessing) {
            this.doStemming = true;
        }
    }

    private String getFilteredTokenStreamKey() {
        StringBuffer sb = new StringBuffer("");
        if (this.isLiteral) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.isCaseSensitive) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useIndexAnalyzer) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useSearchAnalyzer) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useStopwords) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useThesuarus) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.doStemming) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useStemmer) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useRootchar) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    public Term analyzeSearchTerm(String fieldName, String searchTerm, boolean hasWildcard) {
        if (hasWildcard) {
            return this.analyzeSearchWildcardTerm(fieldName, searchTerm);
        }
        return this.analyzeSearchTerm(fieldName, searchTerm);
    }

    public ArrayList<Term> analyzeSearchPhrase(String fieldName, String searchPhrase, boolean hasWildcard) {
        if (hasWildcard) {
            return this.analyzeSearchWildcardPhrase(fieldName, searchPhrase);
        }
        return this.analyzeSearchPhrase(fieldName, searchPhrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Term analyzeSearchTerm(String fieldName, String searchTerm) {
        this.isSearch = true;
        Term term = null;
        TokenStream tokenStream = null;
        try {
            tokenStream = this.tokenStream(fieldName, new StringReader(searchTerm));
            tokenStream.reset();
            if (tokenStream.incrementToken()) {
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)tokenStream.getAttribute(TermToBytesRefAttribute.class);
                if (termAtt != null) {
                    termAtt.fillBytesRef();
                    BytesRef bytesRef = BytesRef.deepCopyOf((BytesRef)termAtt.getBytesRef());
                    term = new Term(fieldName, bytesRef);
                } else {
                    LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " analyzeSearchTerm: TermToBytesRefAttribute is null"));
                }
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " analyzeSearchTerm: failed to get next term "), (Throwable)e);
            }
        }
        finally {
            if (tokenStream != null) {
                try {
                    tokenStream.end();
                    tokenStream.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " analyzeSearchTerm: ending/closing tokenStream failed "), (Throwable)e);
                }
            }
        }
        this.isSearch = false;
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Term> analyzeSearchPhrase(String fieldName, String searchPhrase) {
        this.isSearch = true;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        TokenStream tokenStream = null;
        try {
            tokenStream = this.tokenStream(fieldName, new StringReader(searchPhrase));
            PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)tokenStream.getAttribute(PositionIncrementAttribute.class);
            CharTermAttribute termAtt = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            if (posIncrAtt != null && termAtt != null) {
                tokenStream.reset();
                while (tokenStream.incrementToken()) {
                    int pos = posIncrAtt.getPositionIncrement();
                    LOGGER.debug((Object)(((Object)((Object)this)).getClass().getName() + " analyzeSearchPhrase: position is " + pos));
                    if (pos == 0) continue;
                    if (pos > 1) {
                        for (int x = 0; x < pos - 1; ++x) {
                            arrayList.add(null);
                        }
                    }
                    String strTerm = termAtt.toString();
                    arrayList.add(new Term(fieldName, strTerm));
                }
            } else {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + "posIncrAtt or termAtt is null" + "posIncrAtt is " + posIncrAtt + " termAtt is " + termAtt));
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " analyzeSearchPhrase: failed to get next term "), (Throwable)e);
            }
        }
        finally {
            if (tokenStream != null) {
                try {
                    tokenStream.end();
                    tokenStream.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " analyzeSearchPhrase: ending/closing tokenStream failed "), (Throwable)e);
                }
            }
        }
        this.isSearch = false;
        return arrayList;
    }

    private Term analyzeSearchWildcardTerm(String fieldName, String searchTerm) {
        this.isSearch = true;
        this.checkFieldName(fieldName);
        if (!this.isCaseSensitive) {
            searchTerm = searchTerm.toLowerCase();
        }
        this.isSearch = false;
        return new Term(fieldName, searchTerm);
    }

    private ArrayList<Term> analyzeSearchWildcardPhrase(String fieldName, String searchPhrase) {
        this.isSearch = true;
        this.isInWildcardProcessing = true;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        String[] termValues = searchPhrase.split(" ");
        this.doStemming = false;
        for (int x = 0; x < termValues.length; ++x) {
            if (termValues[x].matches("[\\W && [^\\d] && [^\uac00-\ud7af\u0401\u0451\u0410-\u044f\u3100-\u312f\u3040-\u309f\u30a0-\u30ff\u31f0-\u31ff\u3300-\u337f\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\uff65-\uff9f]]+")) continue;
            ArrayList<Term> terms = this.analyzeSearchPhrase(fieldName, termValues[x]);
            if (termValues[x].indexOf("*") > -1) {
                if (terms.size() > 1) {
                    for (Term t : terms) {
                        if (t == null) {
                            arrayList.add(new Term(fieldName, STOPWORD_TOKEN));
                            continue;
                        }
                        arrayList.add(this.wildcardTheTerm(t, termValues[x]));
                    }
                    continue;
                }
                if (terms.size() == 0) {
                    arrayList.add(new Term(fieldName, STOPWORD_TOKEN));
                    continue;
                }
                arrayList.add(this.wildcardTheTerm(terms.get(0), termValues[x]));
                continue;
            }
            if (terms.size() == 0) {
                arrayList.add(new Term(fieldName, STOPWORD_TOKEN));
                continue;
            }
            for (Term t : terms) {
                if (t == null) {
                    arrayList.add(new Term(fieldName, STOPWORD_TOKEN));
                    continue;
                }
                arrayList.add(t);
            }
        }
        this.doStemming = true;
        this.isInWildcardProcessing = false;
        this.isSearch = false;
        return arrayList;
    }

    private Term wildcardTheTerm(Term term, String origValue) {
        StringBuffer stringBuffer = new StringBuffer("");
        String tokenizedWord = term.text();
        String checkValue = null;
        checkValue = !this.isCaseSensitive ? origValue.toLowerCase() : origValue;
        int begin = checkValue.indexOf(tokenizedWord);
        int end = begin + tokenizedWord.length() - 1;
        if (begin > 0 && checkValue.charAt(begin - 1) == '*') {
            stringBuffer.append("*");
        }
        stringBuffer.append(tokenizedWord);
        if (end < checkValue.length() - 1 && checkValue.charAt(end + 1) == '*') {
            stringBuffer.append("*");
        }
        return new Term(term.field(), stringBuffer.toString());
    }

    public String prepareCNJPString(String queryFieldValue) {
        String strReturn = null;
        ArrayList<Term> arrayList = this.analyzeSearchPhrase("xxx", queryFieldValue);
        if (arrayList.size() > 1) {
            StringBuffer stringBuffer = new StringBuffer("");
            for (Term term : arrayList) {
                stringBuffer.append(term.text() + " ");
            }
            strReturn = stringBuffer.toString().trim();
        } else {
            strReturn = queryFieldValue;
        }
        return strReturn;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        this.checkFieldName(fieldName);
        if (this.isLiteral) {
            return this.createLiteralComponents(reader);
        }
        if (this.useIndexAnalyzer && !this.isSearch) {
            return this.createComponents(this.indexAnalyzer, fieldName, reader);
        }
        if (this.useSearchAnalyzer && this.isSearch) {
            return this.createComponents(this.searchAnalyzer, fieldName, reader);
        }
        return this.createComponents(reader);
    }

    private Analyzer.TokenStreamComponents createLiteralComponents(Reader reader) {
        LiteralTokenizer literalTokenizer = new LiteralTokenizer(reader);
        if (!this.isCaseSensitive) {
            LowerCaseFilter tokenStream = new LowerCaseFilter(Version.LUCENE_4_9, (TokenStream)literalTokenizer);
            return new Analyzer.TokenStreamComponents((Tokenizer)literalTokenizer, (TokenStream)tokenStream);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)literalTokenizer);
    }

    private Analyzer.TokenStreamComponents createComponents(Reader reader) {
        StandardTokenizer tokenizer = new StandardTokenizer(Version.LUCENE_4_9, reader);
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        StandardFilter result = new StandardFilter(Version.LUCENE_4_9, (TokenStream)tokenizer);
        result = this.applyFTSFilters((TokenStream)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }

    private Analyzer.TokenStreamComponents createComponents(Analyzer indexAnalyzer, String fieldName, Reader reader) {
        try {
            Analyzer.TokenStreamComponents components = this.createComponentsByReflection(indexAnalyzer, fieldName, reader);
            TokenStream result = components.getTokenStream();
            result = this.applyFTSFilters(result);
            this.setTokenStreamByReflection(components, result);
            return components;
        }
        catch (Exception e) {
            LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " createComponents: failed to create components from configured analyzer "), (Throwable)e);
            return null;
        }
    }

    private TokenStream applyFTSFilters(TokenStream result) {
        if (!this.isCaseSensitive && !this.useIndexAnalyzer) {
            result = new LowerCaseFilter(Version.LUCENE_4_9, result);
        }
        if (!this.isSearch && this.useThesuarus && this.doStemming) {
            result = new FTSThesaurusFilter((TokenStream)result, thesTable);
        }
        if (this.useRootchar) {
            result = new FTSRootCharacterFilter((TokenStream)result, this.rootCharTable);
        }
        if (this.doStemming && this.useStemmer) {
            result = new FTSStemmingFilter((TokenStream)result, this.stemmer, this.rootTable);
        }
        if (this.useStopwords) {
            CharArraySet charArraySet = new CharArraySet(Version.LUCENE_4_9, this.stopSet, !this.isCaseSensitive);
            StopFilter stopFilter = new StopFilter(Version.LUCENE_4_9, result, charArraySet);
            stopFilter.setEnablePositionIncrements(true);
            result = stopFilter;
        }
        return result;
    }

    private Analyzer.TokenStreamComponents createComponentsByReflection(Analyzer indexAnalyzer, String fieldName, Reader reader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = indexAnalyzer.getClass().getDeclaredMethod("createComponents", String.class, Reader.class);
        m.setAccessible(true);
        Analyzer.TokenStreamComponents components = (Analyzer.TokenStreamComponents)m.invoke((Object)indexAnalyzer, fieldName, reader);
        return components;
    }

    private void setTokenStreamByReflection(Analyzer.TokenStreamComponents components, TokenStream tokenStream) {
        try {
            Field f = components.getClass().getDeclaredField("sink");
            f.setAccessible(true);
            f.set(components, tokenStream);
        }
        catch (Exception e) {
            LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " setTokenStream: Failed to set TokenStreamComponents#sink "), (Throwable)e);
        }
    }

    private class FTSReuseStrategy
    extends Analyzer.ReuseStrategy {
        public Analyzer.TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            FTSAnalyzer.this.checkFieldName(fieldName);
            String filteredTokenStreamKey = FTSAnalyzer.this.getFilteredTokenStreamKey();
            Map componentsPerKey = (Map)this.getStoredValue(analyzer);
            return componentsPerKey != null ? (Analyzer.TokenStreamComponents)componentsPerKey.get(filteredTokenStreamKey) : null;
        }

        public void setReusableComponents(Analyzer analyzer, String fieldName, Analyzer.TokenStreamComponents components) {
            FTSAnalyzer.this.checkFieldName(fieldName);
            String filteredTokenStreamKey = FTSAnalyzer.this.getFilteredTokenStreamKey();
            HashMap<String, Analyzer.TokenStreamComponents> componentsPerKey = (HashMap<String, Analyzer.TokenStreamComponents>)this.getStoredValue(analyzer);
            if (componentsPerKey == null) {
                componentsPerKey = new HashMap<String, Analyzer.TokenStreamComponents>();
                this.setStoredValue(analyzer, componentsPerKey);
            }
            componentsPerKey.put(filteredTokenStreamKey, components);
        }
    }
}

