/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.DocHandler.DocumentHandlerException;
import com.bmc.arsys.fts.impl.DocHandler.TikaDocHandler;
import com.bmc.arsys.fts.impl.FTSConfiguration;
import com.bmc.arsys.fts.impl.lucene.AnalyzerUtils;
import com.bmc.arsys.fts.impl.lucene.FTSIndexSearcher;
import com.bmc.arsys.fts.impl.lucene.IndexDocIterator;
import com.bmc.arsys.fts.impl.lucene.WordIterator;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzer;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzerConfigReader;
import com.bmc.arsys.fts.impl.lucene.query.FTSQueryParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class LuceneFTSService
implements FTSService {
    private static final Logger LOGGER = Logger.getLogger(LuceneFTSService.class);
    private static LuceneFTSService luceneFTSService = null;
    private static final int kConstantFields = 2;
    private static final int kTotalConstantFields = 5;
    private static final int FT_COMMIT_NO = 0;
    private static final int FT_COMMIT_YES = 1;
    private static final int FT_COMMIT_FIELD_DEFERRED = 2;
    private static final int FT_COMMIT_FIELD_FORCE = 4;
    private static final int kNormal = 0;
    private static final int kNormalCase = 1;
    private static final int kLiteral = 2;
    private static final int kLiteralCasel = 3;
    private static final int kNo = 0;
    private static final int kYes = 1;
    public static final String VERSION_DOCID = "##FTSIndexVersion##";
    public static final String VERSION_VERSION_FIELD = "##Version##";
    public static final String VERSION_DATE_FIELD = "##Date##";
    public static final String VERSION_VERSION = "2.0";
    public static final String DEFAULT_SCHEMAID = "0";
    public static final String INDEX_TIME_STAMP = "INDEX_TIME_STAMP";
    public static final int TOKEN_COUNT_UNLIMITED = Integer.MAX_VALUE;
    private static Map<String, List<IndexSearcher>> indexSearchers = new HashMap<String, List<IndexSearcher>>();
    private static Map<String, IndexWriter> indexWriters = new HashMap<String, IndexWriter>();
    private final Set<IndexWriter> indexWritersToCommit = new HashSet<IndexWriter>();
    private final ThreadLocal<IndexWriter> pendingIndexWriter = new ThreadLocal();
    private boolean caseSensitive;
    private String collectionDir;
    private String configurationDir;
    private String locale;
    private int searchThreshold;
    private static Analyzer ftsAnalyzer;
    private FTSAnalyzerConfigReader.FTSAnalyzerConfig analyzerConfig;
    private boolean isWriter = false;
    public boolean doNormal = false;
    public boolean doNormalCase = false;
    public boolean doLiteral = false;
    public boolean doLiteralCase = false;
    private int deletePolicyTime;
    private int searcherRetry = 1;
    private int searcherRetryDelay = 0;
    private Charset serverCharSet;
    private static Map<String, DirectoryReader> nrtReaders;
    private static Date recentInit;
    private static Hashtable<String, ArrayList<FieldDataHolder>> entryFieldQueue;
    private CommitTimerTask commitTimer = null;

    private LuceneFTSService() {
    }

    public static synchronized LuceneFTSService getLuceneFTSService() {
        if (luceneFTSService == null) {
            luceneFTSService = new LuceneFTSService();
        }
        return luceneFTSService;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexCount() {
        int nTheCount = 0;
        Object indexSearcher = null;
        try {
            File collectionRootDir = new File(this.collectionDir);
            if (collectionRootDir.isDirectory()) {
                File[] subDirs;
                for (File sd : subDirs = collectionRootDir.listFiles()) {
                    IndexSearcher s;
                    String folderName = sd.getName();
                    if (!sd.isDirectory() || (s = this.getIndexSearcher(folderName)) == null) continue;
                    nTheCount += s.getIndexReader().numDocs();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"FTS: Error getting the index count.", (Throwable)e);
        }
        finally {
            if (indexSearcher != null) {
                ((FTSIndexSearcher)indexSearcher).setCount(false);
            }
        }
        return nTheCount;
    }

    @Override
    public IndexDocIterator getIndexIterator(String schemaId) throws FTSServiceException {
        IndexSearcher searcher = this.getIndexSearcher(schemaId);
        if (searcher != null) {
            IndexReader reader = searcher.getIndexReader();
            return new IndexDocIterator(reader, reader.numDocs());
        }
        return null;
    }

    public void updateDocumentToNewLayout(Document doc) throws FTSServiceException, IOException {
        String schemaId = doc.get("schemaId");
        if (schemaId != null) {
            String entryId = doc.get("entryId");
            String docIdVal = doc.get("docId");
            doc.removeField("docId");
            FieldType fieldType = new FieldType();
            fieldType.setStored(true);
            fieldType.setIndexed(true);
            fieldType.setTokenized(false);
            fieldType.setStoreTermVectors(true);
            fieldType.freeze();
            Field docIdField = new Field("docId", entryId, fieldType);
            doc.add((IndexableField)docIdField);
            this.createFieldVariations(doc, doc.getFields());
            this.updateByField(schemaId, "docId", docIdVal, doc, ftsAnalyzer);
            this.commit(true);
        }
    }

    @Override
    public synchronized void init(FTSConfiguration ftsConfiguration) throws FTSServiceException {
        this.init(ftsConfiguration, true);
    }

    @Override
    public synchronized void init(FTSConfiguration ftsConfiguration, boolean isWriter) throws FTSServiceException {
        this.isWriter = isWriter;
        this.serverCharSet = ftsConfiguration.getServerCharSet();
        this.collectionDir = ftsConfiguration.getFullTextCollectionDir();
        this.caseSensitive = ftsConfiguration.isFullTextCaseInSensitive();
        this.locale = ftsConfiguration.getFullTextLocale();
        this.configurationDir = ftsConfiguration.getFullTextConfigurationDir();
        this.deletePolicyTime = ftsConfiguration.getDeletePolicyTime();
        String[] retryDelay = ftsConfiguration.getIndexSearcherRetry().split(":");
        this.searcherRetry = new Integer(retryDelay[0]);
        if (retryDelay.length == 2) {
            this.searcherRetryDelay = new Integer(retryDelay[1]);
        }
        this.searchThreshold = ftsConfiguration.getSearchThreshold() == 0 ? 1000000 : ftsConfiguration.getSearchThreshold();
        this.updateConfiguration();
        this.init(isWriter);
    }

    private File getCollectionDir(String schemaId, boolean isWriter) throws IOException {
        String schemaCollectionDir = schemaId.equals(DEFAULT_SCHEMAID) ? this.collectionDir : this.collectionDir + System.getProperty("file.separator") + schemaId;
        File f = new File(schemaCollectionDir);
        if (!f.exists()) {
            if (isWriter) {
                f.mkdir();
            } else {
                f = null;
            }
        }
        return f;
    }

    private boolean initExpired() {
        Boolean bReturn = false;
        Date now = new Date();
        if (now.getTime() - recentInit.getTime() >= 10000L) {
            bReturn = true;
        }
        return bReturn;
    }

    private synchronized void init(boolean isWriter) throws FTSServiceException {
        if (recentInit == null || this.initExpired()) {
            LOGGER.debug((Object)"The init is happening.");
            this.initAnalyzer(this.caseSensitive);
            if (isWriter) {
                Collection<IndexWriter> writers = indexWriters.values();
                for (IndexWriter w : writers) {
                    if (w == null) continue;
                    try {
                        w.close();
                    }
                    catch (CorruptIndexException e) {
                        throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", e);
                    }
                    catch (IOException e) {
                        throw new FTSServiceException(this.getClass().getName() + " init: Cannot close index", e);
                    }
                }
                indexWriters.clear();
                IndexWriter indexWriter = this.getIndexWriter(ftsAnalyzer, DEFAULT_SCHEMAID);
                if (indexWriter != null) {
                    this.checkIndexVersion();
                    this.commit(true);
                } else {
                    LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + ftsAnalyzer + "'"));
                }
            }
            recentInit = new Date();
        } else {
            LOGGER.debug((Object)"Init is skipped due to one happening in last 10 seconds");
        }
    }

    private void checkIndexVersion() throws FTSServiceException {
        Document document = this.getDocumentById(VERSION_DOCID, DEFAULT_SCHEMAID);
        if (document == null) {
            document = new Document();
            FieldType fieldTypeNotAnalyzed = new FieldType();
            fieldTypeNotAnalyzed.setIndexed(true);
            fieldTypeNotAnalyzed.setTokenized(false);
            fieldTypeNotAnalyzed.setStored(true);
            fieldTypeNotAnalyzed.freeze();
            document.add((IndexableField)new Field("docId", VERSION_DOCID, fieldTypeNotAnalyzed));
            FieldType fieldTypeNotIndexed = new FieldType();
            fieldTypeNotIndexed.setStored(true);
            fieldTypeNotIndexed.freeze();
            document.add((IndexableField)new Field(VERSION_VERSION_FIELD, VERSION_VERSION, fieldTypeNotIndexed));
            document.add((IndexableField)new Field(VERSION_DATE_FIELD, new Date().toString(), fieldTypeNotIndexed));
            try {
                this.getIndexWriter(ftsAnalyzer, DEFAULT_SCHEMAID).addDocument((Iterable)document);
            }
            catch (IOException e) {
                throw new FTSServiceException(this.getClass().getName() + " checkIndexVersion: Error adding index version", e);
            }
        }
        if (!document.get(VERSION_VERSION_FIELD).equals(VERSION_VERSION)) {
            // empty if block
        }
    }

    @Override
    public void setDocBoost(String schemaId, String entryId, float docBoost) throws FTSServiceException {
        this.notWriterExceptionCheck("setDocBoost");
        if (entryId == null || entryId.equals(DEFAULT_SCHEMAID) || entryId.length() == 0) {
            FTSService.QuerySchemas qs = new FTSService.QuerySchemas(schemaId);
            List<FTSService.EntryData> entryData = this.getEntryIdsByQuery(null, null, null, (boolean)false, (int)0, null, (FTSService.QuerySchemas)qs, null, null, (int)0, null, null).resultList;
            for (FTSService.EntryData ed : entryData) {
                this.indexEntryFields(schemaId, ed.entryId, docBoost, null, null, null, null, 0);
            }
            this.commit(true);
        } else {
            this.indexEntryFields(schemaId, entryId, docBoost, null, null, null, null, 4);
        }
    }

    private int getFieldSize(ArrayList<FieldDataHolder> fields) {
        int nReturn = 2;
        for (FieldDataHolder fdh : fields) {
            if (fdh.fieldNames.length == 1) {
                ++nReturn;
                continue;
            }
            nReturn = nReturn + fdh.fieldNames.length - 2;
        }
        return nReturn;
    }

    @Override
    public synchronized void indexEntryFields(String schemaId, String entryId, float docBoost, String[] fieldNames, String[] values, BitSet[] fullTextOptions, float[] fieldBoost, int doCommit) throws FTSServiceException {
        this.notWriterExceptionCheck("indexEntryFields");
        String key = this.buildDocId(schemaId, entryId);
        if (doCommit == 2) {
            if (entryFieldQueue.containsKey(key)) {
                ArrayList<FieldDataHolder> fields = entryFieldQueue.get(key);
                fields.add(new FieldDataHolder(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost));
            } else {
                ArrayList<FieldDataHolder> fields = new ArrayList<FieldDataHolder>();
                fields.add(new FieldDataHolder(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost));
                entryFieldQueue.put(key, fields);
            }
        } else if (doCommit > 2) {
            if (entryFieldQueue.containsKey(key)) {
                ArrayList<FieldDataHolder> fields = entryFieldQueue.get(key);
                fields.add(new FieldDataHolder(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost));
                int size = this.getFieldSize(fields);
                String[] fieldNamesAll = new String[size];
                String[] valuesAll = new String[size];
                BitSet[] fullTextOptionsAll = new BitSet[size];
                float[] fieldBoost2 = new float[size];
                boolean processedkConstantFields = false;
                int count = 0;
                for (FieldDataHolder fdh : fields) {
                    int fieldCount = fdh.fieldNames.length;
                    if (fieldCount > 1 && !processedkConstantFields) {
                        for (int x = 0; x < 2; ++x) {
                            fieldNamesAll[count] = fdh.fieldNames[x];
                            valuesAll[count] = fdh.values[x];
                            fullTextOptionsAll[count] = fdh.fullTextOptions[x];
                            fieldBoost2[count] = fdh.fieldBoost[x];
                            ++count;
                        }
                        processedkConstantFields = true;
                    }
                    int fieldsToProcess = 0;
                    if (fieldCount > 1) {
                        fieldsToProcess = 2;
                    }
                    for (int x = fieldsToProcess; x < fdh.fieldNames.length; ++x) {
                        fieldNamesAll[count] = fdh.fieldNames[x];
                        valuesAll[count] = fdh.values[x];
                        fullTextOptionsAll[count] = fdh.fullTextOptions[x];
                        fieldBoost2[count] = fdh.fieldBoost[x];
                        ++count;
                    }
                }
                this.indexEntryFieldsAll(schemaId, entryId, docBoost, fieldNamesAll, valuesAll, fullTextOptionsAll, fieldBoost2, doCommit);
                entryFieldQueue.remove(key);
            } else {
                this.indexEntryFieldsAll(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost, doCommit);
            }
        } else {
            this.indexEntryFieldsAll(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost, doCommit);
        }
    }

    @Override
    public void indexAttachmentByPath(String schemaId, String entryId, float docBoost, String fieldName, List<String> attachments, BitSet fullTextOption, float boost, int doCommit) throws FTSServiceException {
        String[] fieldNames = new String[attachments.size()];
        String[] values = new String[attachments.size()];
        BitSet[] fullTextOptions = new BitSet[attachments.size()];
        float[] fieldBoost = new float[attachments.size()];
        TikaDocHandler tikaDocHandler = new TikaDocHandler();
        int index = 0;
        for (String attachment : attachments) {
            String text = null;
            try {
                File file = new File(attachment);
                text = tikaDocHandler.getText(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (DocumentHandlerException e) {
                e.printStackTrace();
            }
            fieldNames[index] = fieldName;
            values[index] = text;
            fullTextOptions[index] = fullTextOption;
            fieldBoost[index] = boost;
            ++index;
        }
        this.indexEntryFields(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost, doCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexEntryFieldsAll(String schemaId, String entryId, float docBoost, String[] fieldNames, String[] values, BitSet[] fullTextOptions, float[] fieldBoost, int doCommit) throws FTSServiceException {
        try {
            String docId = this.buildDocId(schemaId, entryId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Do commit flag " + doCommit));
                LOGGER.debug((Object)("Field Names " + fieldNames));
                LOGGER.debug((Object)("Indexing doc " + docId));
            }
            if (doCommit == 1 && !this.indexWritersToCommit.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Commiting previous buffer");
                }
                this.commit(false);
            }
            Document document = this.getDocumentById(docId, schemaId);
            Analyzer analyzer = ftsAnalyzer;
            if (document == null && doCommit == 1 && !this.indexWritersToCommit.isEmpty()) {
                document = this.searchForDocumentInNRT(analyzer, docId, schemaId);
                if (LOGGER.isDebugEnabled() && document == null) {
                    LOGGER.debug((Object)"Document not found using NRT");
                }
            }
            if (document == null && fieldNames == null) {
                return;
            }
            if (document == null) {
                IndexWriter indexWriter;
                document = this.createDocument(docId, schemaId, entryId);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Created a new document with docId " + docId));
                }
                for (int i = 0; i < fieldNames.length; ++i) {
                    if (fieldNames[i] == null || fieldNames[i].startsWith("DEL_")) continue;
                    int len = values[i].length() > 20 ? 20 : values[i].length();
                    LOGGER.info((Object)("FTS: Indexing with " + analyzer.getClass().getSimpleName() + "-> Schema id = " + schemaId + ", Entry id = " + entryId + ", Field id =  " + fieldNames[i] + ", Value(first 20) = " + values[i].substring(0, len) + ", Literal indexing = " + fullTextOptions[i].get(1)));
                    if (fieldNames[i].equals("modifiedTime") || fieldNames[i].equals("createTime")) {
                        Long dateAsLong = Long.parseLong(values[i]);
                        document.add((IndexableField)new LongField(fieldNames[i], dateAsLong.longValue(), Field.Store.YES));
                        continue;
                    }
                    FieldType fieldType = new FieldType();
                    fieldType.setStored(true);
                    fieldType.freeze();
                    document.add((IndexableField)new Field(fieldNames[i] + "_orig", values[i], fieldType));
                    document.add((IndexableField)new Field(fieldNames[i] + "_bytes", this.setFieldBytes(fullTextOptions[i].get(1)), fieldType));
                    if (fieldBoost == null || fieldBoost[i] == 1.0f) continue;
                    document.add((IndexableField)new Field(fieldNames[i] + "_fieldBoost", PayloadHelper.encodeFloat((float)fieldBoost[i]), fieldType));
                }
                List fieldList = document.getFields();
                document = this.createFieldVariations(document, fieldList);
                if (docBoost != 1.0f) {
                    this.setBoost(docBoost, document);
                }
                if ((indexWriter = this.getIndexWriter(analyzer, schemaId)) != null) {
                    indexWriter.addDocument((Iterable)document);
                } else {
                    LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
                }
            } else {
                List fieldList;
                List list = fieldList = document.getFields();
                synchronized (list) {
                    if (fieldNames != null) {
                        int i;
                        for (i = 0; i < fieldNames.length; ++i) {
                            if (fieldNames[i] == null || fieldNames[i].startsWith("DEL_")) continue;
                            int len = values[i].length() > 20 ? 20 : values[i].length();
                            LOGGER.info((Object)("FTS: Updating with " + analyzer.getClass().getSimpleName() + "-> Schema id = " + schemaId + ", Entry id = " + entryId + ", Field id =  " + fieldNames[i] + ", Value(first 20) = " + values[i].substring(0, len) + ", Literal indexing = " + fullTextOptions[i].get(1)));
                            if (fieldNames[i].equals("modifiedTime") || fieldNames[i].equals("createTime")) {
                                document.removeField(fieldNames[i]);
                                Long dateAsLong = Long.parseLong(values[i]);
                                document.add((IndexableField)new LongField(fieldNames[i], dateAsLong.longValue(), Field.Store.YES));
                                continue;
                            }
                            FieldType fieldType = new FieldType();
                            fieldType.setStored(true);
                            fieldType.freeze();
                            String origName = fieldNames[i] + "_orig";
                            String dataName = fieldNames[i] + "_bytes";
                            document.removeField(origName);
                            document.removeField(dataName);
                            document.add((IndexableField)new Field(origName, values[i], fieldType));
                            document.add((IndexableField)new Field(dataName, this.setFieldBytes(fullTextOptions[i].get(1)), fieldType));
                        }
                        for (i = 0; i < fieldNames.length; ++i) {
                            if (fieldNames[i] == null || !fieldNames[i].startsWith("DEL_")) continue;
                            String strFieldName = fieldNames[i].substring(4);
                            String origName = strFieldName + "_orig";
                            String dataName = strFieldName + "_bytes";
                            document.removeField(origName);
                            document.removeField(dataName);
                        }
                    }
                    document = this.createFieldVariations(document, fieldList);
                    if (docBoost != 1.0f) {
                        this.setBoost(docBoost, document);
                    }
                }
                this.removeTokenized(document.getField("docId"));
                this.removeTokenized(document.getField("entryId"));
                this.removeTokenized(document.getField("schemaId"));
                if (fieldList.size() > 5) {
                    this.updateByField(schemaId, "docId", docId, document, analyzer);
                } else {
                    this.deleteEntryDocument(schemaId, entryId);
                }
            }
            if (doCommit == 1 || doCommit == 4) {
                if (doCommit == 1) {
                    this.commit(false);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Commiting immediately");
                    }
                } else {
                    this.commit(true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Delayed Commit");
                    }
                }
            }
        }
        catch (CorruptIndexException e) {
            throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", e);
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " init: Cannot add to the index or close index", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document searchForDocumentInNRT(Analyzer analyzer, String docId, String schemaId) {
        Document document = null;
        try {
            DirectoryReader nrtIndexReader = nrtReaders.get(schemaId);
            if (nrtIndexReader == null) {
                IndexWriter indexWriter = this.getIndexWriter(ftsAnalyzer, schemaId);
                nrtIndexReader = DirectoryReader.open((IndexWriter)indexWriter, (boolean)true);
                nrtReaders.put(schemaId, nrtIndexReader);
            } else {
                DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)nrtIndexReader);
                if (newReader != null) {
                    nrtIndexReader = newReader;
                    nrtReaders.put(schemaId, nrtIndexReader);
                }
            }
            FTSIndexSearcher indexSearcher = new FTSIndexSearcher((IndexReader)nrtIndexReader);
            Term term = new Term("docId", docId);
            TermQuery termQuery = new TermQuery(term);
            TopDocs matchingDocs = indexSearcher.search((Query)termQuery, 1);
            if (matchingDocs.totalHits > 0) {
                ScoreDoc[] hits = matchingDocs.scoreDocs;
                for (int i = 0; i < hits.length; ++i) {
                    document = indexSearcher.doc(hits[0].doc);
                }
            }
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"IOException while opening real time reader, reverting to document found already. ", (Throwable)e);
            }
        }
        catch (FTSServiceException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"FTSException while opening real time reader, reverting to document found already. ", (Throwable)e);
            }
        }
        return document;
    }

    private void setBoost(float docBoost, Document document) {
        List fields = document.getFields();
        for (IndexableField field : fields) {
            if (!this.isBoostable(field)) continue;
            float fieldBoost = field.boost();
            if (fieldBoost != 0.0f) {
                fieldBoost *= docBoost;
            }
            ((Field)field).setBoost(fieldBoost);
        }
    }

    private boolean isBoostable(IndexableField field) {
        return field.fieldType().indexed() && !field.fieldType().omitNorms() && field instanceof Field;
    }

    @Override
    public void commit() throws FTSServiceException {
        this.commit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void commit(boolean allowDelay) throws FTSServiceException {
        IndexWriter currentWriter = this.pendingIndexWriter.get();
        if (currentWriter == null) {
            return;
        }
        if (allowDelay) {
            Set<IndexWriter> set = this.indexWritersToCommit;
            synchronized (set) {
                this.indexWritersToCommit.add(currentWriter);
            }
            if (this.commitTimer == null) {
                this.commitTimer = new CommitTimerTask();
                Timer timer = new Timer();
                timer.schedule((TimerTask)this.commitTimer, 0L, 2000L);
            }
        } else {
            this.commitNow(currentWriter);
        }
        this.pendingIndexWriter.remove();
    }

    private synchronized void commitNow(IndexWriter writer) throws FTSServiceException {
        if (writer == null) {
            return;
        }
        this.notWriterExceptionCheck("commit");
        try {
            this.setIndexTimeStamp(writer);
            writer.commit();
        }
        catch (CorruptIndexException e) {
            throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", e);
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " init: Cannot add to the index or close index", e);
        }
    }

    private Document createFieldVariations(Document document, List<IndexableField> fieldList) {
        ArrayList<IndexableField> copyList = new ArrayList<IndexableField>(fieldList);
        FieldType fieldTypeAnalyzed = new FieldType();
        fieldTypeAnalyzed.setIndexed(true);
        fieldTypeAnalyzed.setTokenized(true);
        fieldTypeAnalyzed.setStoreTermVectors(true);
        fieldTypeAnalyzed.setStoreTermVectorPositions(true);
        fieldTypeAnalyzed.setStoreTermVectorOffsets(true);
        fieldTypeAnalyzed.freeze();
        FieldType fieldTypeNoNorms = new FieldType();
        fieldTypeNoNorms.setIndexed(true);
        fieldTypeNoNorms.setTokenized(true);
        fieldTypeNoNorms.setOmitNorms(true);
        fieldTypeNoNorms.setStoreTermVectors(true);
        fieldTypeNoNorms.setStoreTermVectorPositions(true);
        fieldTypeNoNorms.setStoreTermVectorOffsets(true);
        fieldTypeNoNorms.freeze();
        for (IndexableField field : copyList) {
            String fieldName = field.name();
            if (!fieldName.endsWith("_orig") || fieldName.startsWith("createTime") || fieldName.startsWith("modifiedTime")) continue;
            String origValue = document.get(fieldName);
            String origFieldName = fieldName.substring(0, fieldName.length() - 5);
            BytesRef bytesRef = document.getBinaryValue(origFieldName + "_bytes");
            BytesRef fieldBoost = document.getBinaryValue(origFieldName + "_fieldBoost");
            if (bytesRef.length != 4) continue;
            if (bytesRef.bytes[0 + bytesRef.offset] == 1) {
                document.add((IndexableField)this.boostField(new Field(origFieldName, origValue, fieldTypeAnalyzed), fieldBoost));
            }
            if (bytesRef.bytes[1 + bytesRef.offset] == 1) {
                document.add((IndexableField)this.boostField(new Field(origFieldName + "_case", origValue, fieldTypeAnalyzed), fieldBoost));
            }
            if (bytesRef.bytes[2 + bytesRef.offset] == 1) {
                document.add((IndexableField)this.boostField(new Field(origFieldName + "_literal", origValue.replaceAll("~!~", "\u0015"), fieldTypeNoNorms), fieldBoost));
            }
            if (bytesRef.bytes[3 + bytesRef.offset] != 1) continue;
            document.add((IndexableField)this.boostField(new Field(origFieldName + "_literalCase", origValue.replaceAll("~!~", "\u0015"), fieldTypeNoNorms), fieldBoost));
        }
        return document;
    }

    private Field boostField(Field field, BytesRef fieldBoost) {
        if (fieldBoost != null && fieldBoost.length > 0) {
            byte[] bytes = Arrays.copyOfRange(fieldBoost.bytes, fieldBoost.offset, fieldBoost.length);
            if (this.isBoostable((IndexableField)field)) {
                field.setBoost(PayloadHelper.decodeFloat((byte[])bytes));
            }
        }
        return field;
    }

    private byte[] setFieldBytes(boolean literal) {
        byte[] data = new byte[]{0, 0, 0, 0};
        if (this.doNormal || !this.caseSensitive && !literal) {
            data[0] = 1;
        }
        if (this.doNormalCase || this.caseSensitive && !literal) {
            data[1] = 1;
        }
        if (this.doLiteral || !this.caseSensitive && literal) {
            data[2] = 1;
        }
        if (this.doLiteralCase || this.caseSensitive && literal) {
            data[3] = 1;
        }
        return data;
    }

    @Override
    public synchronized void deleteEntryDocument(String schemaId, String entryId) throws FTSServiceException {
        this.notWriterExceptionCheck("deleteEntryDocument");
        LOGGER.info((Object)("FTS: delete from index - Schema id = " + schemaId + ", Entry id = " + entryId));
        String docId = this.buildDocId(schemaId, entryId);
        try {
            IndexWriter indexWriter = this.getIndexWriter(ftsAnalyzer, schemaId);
            if (indexWriter != null) {
                Term term = new Term("docId", docId);
                indexWriter.deleteDocuments(new Term[]{term});
                this.commit(true);
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + ftsAnalyzer + "'"));
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " deleteEntryDocument: Error deleting documents with field name '" + "docId" + "' and field data '" + docId, e);
        }
    }

    @Override
    public void deleteIndexDir() throws FTSServiceException {
        this.notWriterExceptionCheck("deleteIndexDir");
        LOGGER.info((Object)"FTS: delete index - all document");
        this.close();
        boolean bSuccess = true;
        File indexDir = new File(this.collectionDir);
        File[] subDirs = indexDir.listFiles();
        if (subDirs != null) {
            for (File sd : subDirs) {
                boolean localSuccess = this.deleteIndexSubDir(sd);
                if (localSuccess || !bSuccess) continue;
                LOGGER.debug((Object)("fail to delete index " + sd.getName()));
                bSuccess = false;
            }
        }
        if (!bSuccess) {
            throw new FTSServiceException(this.getClass().getName() + " deleteIndexDir: Failed to delete index.");
        }
    }

    private boolean deleteIndexSubDir(File sd) {
        boolean bSuccess = true;
        if (sd.isDirectory()) {
            File[] indexFiles = sd.listFiles();
            if (indexFiles != null) {
                for (int x = 0; x < indexFiles.length; ++x) {
                    File indexFile = indexFiles[x];
                    if (!indexFile.exists() || !indexFile.isFile() || indexFile.delete()) continue;
                    LOGGER.debug((Object)String.format("Cannot delete index file %s. The file is in use.", indexFile.getName()));
                    bSuccess = false;
                }
            }
            if (bSuccess) {
                sd.delete();
            }
        }
        return bSuccess;
    }

    @Override
    public synchronized void removeFieldFromDocumentsByQuery(String schemaId, String fieldName, String[] queryFieldNames, String[] queryFieldValues) throws FTSServiceException {
        this.notWriterExceptionCheck("removeFieldFromDocumentsByQuery");
        this.removeFieldFromDocumentsByQuery(schemaId, fieldName, queryFieldNames, queryFieldValues, 1);
    }

    @Override
    public synchronized void removeFieldFromDocumentsByQuery(String schemaId, String fieldName, String[] queryFieldNames, String[] queryFieldValues, int doCommit) throws FTSServiceException {
        this.notWriterExceptionCheck("removeFieldFromDocumentsByQuery(2)");
        String entryId = null;
        if (queryFieldNames != null) {
            for (int x = 0; x < queryFieldNames.length; ++x) {
                if (!queryFieldNames[x].equals("entryId")) continue;
                entryId = queryFieldValues[x];
                break;
            }
        }
        if (doCommit > 1) {
            if (schemaId != null) {
                String[] fieldNames = new String[]{"DEL_" + fieldName};
                String[] values = new String[]{null};
                BitSet bitSet = new BitSet(1);
                bitSet.set(0);
                BitSet[] fullTextOptions = new BitSet[]{bitSet};
                float[] fieldBoost = new float[]{1.0f};
                this.indexEntryFields(schemaId, entryId, 1.0f, fieldNames, values, fullTextOptions, fieldBoost, doCommit);
            }
        } else {
            FTSQueryParser ftsQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
            Query query = ftsQueryParser.createDeleteFieldQuery(fieldName, queryFieldNames, queryFieldValues);
            IndexSearcher indexSearcher = this.getIndexSearcher(schemaId);
            if (indexSearcher == null) {
                return;
            }
            TopDocs matchingDocs = null;
            try {
                matchingDocs = indexSearcher.search(query, 10000);
                ScoreDoc[] hits = matchingDocs.scoreDocs;
                for (int x = 0; x < hits.length; ++x) {
                    Document document = indexSearcher.doc(hits[x].doc);
                    document.removeField(fieldName + "_orig");
                    document.removeField(fieldName + "_bytes");
                    List fieldList = document.getFields();
                    IndexableField docId = document.getField("docId");
                    this.removeTokenized(docId);
                    this.removeTokenized(document.getField("entryId"));
                    this.removeTokenized(document.getField("schemaId"));
                    if (fieldList.size() > 5) {
                        document = this.createFieldVariations(document, fieldList);
                        this.updateByField(schemaId, "docId", docId.stringValue(), document, ftsAnalyzer);
                        continue;
                    }
                    this.deleteEntryDocument(schemaId, docId.stringValue());
                }
                if (doCommit == 1) {
                    this.commit(true);
                }
            }
            catch (IOException e) {
                throw new FTSServiceException(this.getClass().getName() + " removeFieldFromDocumentsByQuery: Problem searching the index", e);
            }
            finally {
                if (indexSearcher != null) {
                    ((FTSIndexSearcher)indexSearcher).setCount(false);
                }
            }
        }
    }

    private void removeTokenized(IndexableField indexableField) {
        FieldType fieldType = (FieldType)indexableField.fieldType();
        fieldType.setTokenized(false);
    }

    @Override
    public List<FTSService.EntryData> getEntryIdsByQuery(String schemaId, String[] queryFieldNames, String[] queryFieldValues, BitSet[] fullTextOptions) throws FTSServiceException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Search Schema ID: " + schemaId + "; Field and Terms: " + this.getFieldTermsForLogger(queryFieldNames, queryFieldValues)));
        }
        FTSQueryParser ftsQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
        Query query = ftsQueryParser.createQuery(schemaId, queryFieldNames, queryFieldValues, fullTextOptions, this.caseSensitive);
        return this.getEntryIdsByQuery((Query)query, null, null, (boolean)false, (int)0, null, (FTSService.QuerySchemas)new FTSService.QuerySchemas((String)schemaId), null, null, (int)0, null, null).resultList;
    }

    private String getFieldTermsForLogger(String[] queryFieldNames, String[] queryFieldValues) {
        StringBuffer strBufReturn = new StringBuffer("");
        for (int x = 0; x < queryFieldNames.length; ++x) {
            strBufReturn.append("[" + queryFieldNames[x] + ":" + queryFieldValues[x] + "] ");
        }
        return strBufReturn.toString();
    }

    private String getSchemaFieldsForLogger(List<FTSService.QuerySchemas> querySchemas) {
        StringBuffer strBufReturn = new StringBuffer("");
        if (querySchemas != null) {
            for (FTSService.QuerySchemas qs : querySchemas) {
                strBufReturn.append("[" + qs.schemaId + ": ");
                for (String field : qs.queryFieldNames) {
                    strBufReturn.append(field + ", ");
                }
                strBufReturn.append("] ");
            }
        }
        return strBufReturn.toString();
    }

    private String getReturnFieldsForLogger(List<FTSService.ReturnFilterFields> returnFilterFields) {
        StringBuffer strBufReturn = new StringBuffer("");
        if (returnFilterFields != null) {
            for (FTSService.ReturnFilterFields rff : returnFilterFields) {
                strBufReturn.append(rff.filterField + ", ");
            }
        }
        return strBufReturn.toString();
    }

    private boolean isUnqualifiedWildcard(String shouldQueryValue, String mustQueryValue, String notQueryValue) {
        boolean bReturn = false;
        if (shouldQueryValue != null && shouldQueryValue.trim().equals("%")) {
            bReturn = true;
        } else if (mustQueryValue != null && mustQueryValue.trim().equals("%")) {
            bReturn = true;
        } else if (notQueryValue != null && notQueryValue.trim().equals("%")) {
            bReturn = true;
        }
        return bReturn;
    }

    @Override
    public FTSService.FTSResultSet getEntryIdsByGlobalQuery(String shouldQueryValue, String mustQueryValue, String notQueryValue, List<FTSService.QuerySchemas> querySchemas, String filterQuery, List<FTSService.ReturnFilterFields> returnFilterFields, String sortOrder, int resultOption, Map<String, String> returnEntries, int maxReturn) throws FTSServiceException {
        return this.getEntryIdsByGlobalQuery(shouldQueryValue, mustQueryValue, notQueryValue, querySchemas, filterQuery, returnFilterFields, sortOrder, resultOption, returnEntries, maxReturn, "[", "]");
    }

    @Override
    public FTSService.FTSResultSet getEntryIdsByGlobalQuery(String shouldQueryValue, String mustQueryValue, String notQueryValue, List<FTSService.QuerySchemas> querySchemas, String filterQuery, List<FTSService.ReturnFilterFields> returnFilterFields, String sortOrder, int resultOption, Map<String, String> returnEntries, int maxReturn, String markupLeft, String markupRight) throws FTSServiceException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Threshold set by AR: " + this.searchThreshold));
            LOGGER.debug((Object)("Search Terms - Must: " + mustQueryValue + "; Should: " + shouldQueryValue + "; Must Not: " + notQueryValue));
            LOGGER.debug((Object)("Search Filter Query: " + filterQuery));
            LOGGER.debug((Object)("Search Schema IDs and Fields - " + this.getSchemaFieldsForLogger(querySchemas)));
            LOGGER.debug((Object)("Search Return Fields: " + this.getReturnFieldsForLogger(returnFilterFields)));
            LOGGER.debug((Object)("Search Sort Order: " + sortOrder));
            LOGGER.debug((Object)("Search Result Option: " + resultOption));
            LOGGER.debug((Object)("Search Return Entries: " + returnEntries));
            LOGGER.debug((Object)("Search Max Return: " + maxReturn));
        }
        boolean unqualifiedWildcard = false;
        unqualifiedWildcard = this.isUnqualifiedWildcard(shouldQueryValue, mustQueryValue, notQueryValue);
        if (unqualifiedWildcard && resultOption == 2) {
            resultOption = 1;
        }
        if (shouldQueryValue != null && shouldQueryValue.length() == 1 && shouldQueryValue.codePointAt(0) == 32) {
            shouldQueryValue = null;
        }
        if (mustQueryValue != null && mustQueryValue.length() == 1 && mustQueryValue.codePointAt(0) == 32) {
            mustQueryValue = null;
        }
        if (notQueryValue != null && notQueryValue.length() == 1 && notQueryValue.codePointAt(0) == 32) {
            notQueryValue = null;
        }
        if (filterQuery != null && filterQuery.length() == 1 && filterQuery.codePointAt(0) == 32) {
            filterQuery = null;
        }
        FTSQueryParser ftsQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
        Query query = null;
        Query queryOld = null;
        Filter filter = null;
        Hashtable<String, String> returnEntriesHash = null;
        if (returnEntries == null) {
            if (unqualifiedWildcard) {
                query = ftsQueryParser.unqualifiedWildcardQuery();
            }
            if (filterQuery != null) {
                filter = ftsQueryParser.createGlobalFilter(filterQuery, querySchemas, this.caseSensitive);
            }
        }
        String sortOrder2 = sortOrder;
        if (returnEntries != null && sortOrder == null) {
            sortOrder2 = "4;2";
        }
        FTSService.FTSResultSet finalResultSet = new FTSService.FTSResultSet();
        for (FTSService.QuerySchemas qs : querySchemas) {
            if (returnEntries != null) {
                returnEntriesHash = this.prepareReturnEntries(returnEntries.get(qs.schemaId));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Number of entries to fetch for phase 2: " + returnEntriesHash.size()));
                }
                if (returnEntriesHash.isEmpty()) continue;
                query = ftsQueryParser.docIdQuery(returnEntriesHash);
                queryOld = ftsQueryParser.createGlobalQuery(shouldQueryValue, mustQueryValue, notQueryValue, qs, this.caseSensitive);
            } else if (!unqualifiedWildcard) {
                query = ftsQueryParser.createGlobalQuery(shouldQueryValue, mustQueryValue, notQueryValue, qs, this.caseSensitive);
                if (LOGGER.isDebugEnabled()) {
                    String queryStr = query != null ? query.toString() : "null";
                    LOGGER.debug((Object)("query = : " + queryStr));
                }
            }
            FTSService.FTSResultSet subSet = this.getEntryIdsByQuery(query, queryOld, filter, true, resultOption, returnFilterFields, qs, sortOrder2, returnEntriesHash, maxReturn, markupLeft, markupRight);
            finalResultSet.numMatches += subSet.numMatches;
            if (finalResultSet.resultList == null) {
                finalResultSet.resultList = subSet.resultList;
                continue;
            }
            finalResultSet.resultList.addAll(subSet.resultList);
        }
        if (sortOrder2 != null) {
            EntryDataSorter entryDataSorter = new EntryDataSorter();
            entryDataSorter.setFieldsToSort(sortOrder2);
            EntryDataSorter comparator = entryDataSorter;
            Collections.sort(finalResultSet.resultList, comparator);
        }
        return finalResultSet;
    }

    private Hashtable<String, String> prepareReturnEntries(String returnEntries) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (returnEntries != null) {
            String[] splitString = returnEntries.split(";");
            for (int x = 0; x < splitString.length; ++x) {
                if (splitString[x] == null || splitString[x].length() == 0) continue;
                String[] xdocid = splitString[x].split("@@");
                hashtable.put(xdocid[0], xdocid[1]);
            }
        }
        return hashtable;
    }

    private FTSService.FTSResultSet getEntryIdsByQuery(Query query, Query queryOld, Filter filter, boolean isGlobal, int resultOption, List<FTSService.ReturnFilterFields> returnFilterFields, FTSService.QuerySchemas querySchema, String sortOrder, Hashtable<String, String> returnEntries, int maxReturn, String markupLeft, String markupRight) throws FTSServiceException {
        Query query2 = null;
        FTSService.FTSResultSet resultSet = new FTSService.FTSResultSet();
        ArrayList<FTSService.EntryData> returnList = new ArrayList<FTSService.EntryData>();
        IndexSearcher indexSearcher = this.getIndexSearcher(querySchema.schemaId);
        if (indexSearcher != null) {
            TopDocs matchingDocs = null;
            int maxToReturn = this.searchThreshold;
            if (maxReturn > 0 && maxReturn < this.searchThreshold) {
                maxToReturn = maxReturn;
            }
            LOGGER.debug((Object)("maxToReturn: " + maxToReturn));
            try {
                LOGGER.debug((Object)"Making initial search request");
                matchingDocs = indexSearcher.search(query, filter, maxToReturn);
                LOGGER.debug((Object)"Completed initial search request");
                resultSet.numMatches = matchingDocs.totalHits;
                if (resultOption != 3) {
                    float maxScore = matchingDocs.getMaxScore();
                    ScoreDoc[] hits = matchingDocs.scoreDocs;
                    if (resultOption == 4) {
                        LOGGER.debug((Object)("Phase 1: Getting Enty ID / Schema data only: " + hits.length));
                    } else {
                        LOGGER.debug((Object)("Phase 2:  Getting All column data: " + hits.length));
                    }
                    HashSet<String> fieldSelector = null;
                    if (!isGlobal || isGlobal && resultOption == 4) {
                        String[] fieldsToFetch = this.getFieldsToFetch(sortOrder);
                        fieldSelector = new HashSet<String>();
                        if (fieldsToFetch != null) {
                            for (String field : fieldsToFetch) {
                                fieldSelector.add(field);
                            }
                        }
                    }
                    for (int i = 0; i < hits.length; ++i) {
                        ArrayList<FTSService.ReturnFilterFields> rff = new ArrayList<FTSService.ReturnFilterFields>();
                        Document document = null;
                        document = !isGlobal || isGlobal && resultOption == 4 ? indexSearcher.doc(hits[i].doc, fieldSelector) : indexSearcher.doc(hits[i].doc);
                        FTSService.EntryData entryData = isGlobal ? new FTSService.GlobalEntryData() : new FTSService.EntryData();
                        IndexableField entryField = document.getField("entryId");
                        entryData.schemaId = querySchema.schemaId;
                        if (entryField == null) continue;
                        entryData.entryId = entryField.stringValue();
                        entryData.score = returnEntries != null ? Float.parseFloat(returnEntries.get(this.buildDocId(entryData.schemaId, entryData.entryId))) : hits[i].score / maxScore * 100.0f;
                        if (isGlobal && resultOption != 4 || isGlobal && sortOrder != null) {
                            if (query2 == null && queryOld == null) {
                                query2 = query.rewrite(indexSearcher.getIndexReader());
                            } else if (query2 == null) {
                                query2 = queryOld.rewrite(indexSearcher.getIndexReader());
                            }
                            IndexableField titleField = document.getField("title_orig");
                            IndexableField createDate = document.getField("createTime");
                            IndexableField modifiedDate = document.getField("modifiedTime");
                            entryData.title = titleField != null ? this.highlightTitleText(indexSearcher.getIndexReader(), hits[i].doc, this.getFieldName(document, "title"), query2, titleField.stringValue(), resultOption, markupLeft, markupRight) : "";
                            if (resultOption != 4) {
                                entryData.excerpt = this.getExcerptText(document, resultOption, query2, indexSearcher.getIndexReader(), hits[i].doc, querySchema, markupLeft, markupRight);
                            }
                            entryData.createDate = createDate != null ? createDate.stringValue() : "";
                            entryData.modifiedDate = modifiedDate != null ? modifiedDate.stringValue() : "";
                            if (returnFilterFields != null) {
                                for (FTSService.ReturnFilterFields rff2 : returnFilterFields) {
                                    IndexableField field = document.getField(rff2.filterField + "_orig");
                                    String tempValue = "";
                                    if (field != null) {
                                        tempValue = field.stringValue();
                                    }
                                    rff.add(new FTSService.ReturnFilterFields(rff2.filterField, tempValue));
                                }
                                entryData.returnFilterFields = rff;
                            }
                        }
                        returnList.add(entryData);
                    }
                    if (resultOption == 4) {
                        LOGGER.debug((Object)("Phase 1:  Completed getting Enty ID / Schema data only: " + returnList.size()));
                    } else {
                        LOGGER.debug((Object)("Phase 2:  Completed getting All column data: " + returnList.size()));
                    }
                }
            }
            catch (CorruptIndexException e) {
                throw new FTSServiceException(this.getClass().getName() + " getEntryIdsByQuery: Problem searching the index: Corrupt Index Exception ", e);
            }
            catch (IOException e) {
                throw new FTSServiceException(this.getClass().getName() + " getEntryIdsByQuery: Problem searching the index: IO Exception ", e);
            }
            finally {
                ((FTSIndexSearcher)indexSearcher).setCount(false);
            }
            if (!isGlobal) {
                Collections.sort(returnList);
            }
        }
        resultSet.resultList = returnList;
        LOGGER.debug((Object)("Search results count: " + resultSet.numMatches));
        return resultSet;
    }

    private String[] getFieldsToFetch(String sortOrder) {
        if (sortOrder == null || sortOrder.length() == 0) {
            return new String[]{"entryId"};
        }
        String[] fieldsToSort = sortOrder.split(";");
        ArrayList<String> arrayList = new ArrayList<String>(fieldsToSort.length / 2);
        arrayList.add("entryId");
        for (int x = 0; x < fieldsToSort.length; x += 2) {
            if (fieldsToSort[x].equals(DEFAULT_SCHEMAID) || fieldsToSort[x].equals("1") || fieldsToSort[x].equals("4")) continue;
            if (fieldsToSort[x].equals("2")) {
                arrayList.add("title");
                continue;
            }
            if (fieldsToSort[x].equals("5")) {
                arrayList.add("createTime");
                continue;
            }
            if (fieldsToSort[x].equals("6")) {
                arrayList.add("modifiedTime");
                continue;
            }
            if (fieldsToSort[x].equals("3")) continue;
            arrayList.add(fieldsToSort[x]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public void deleteDocumentsContainingField(String schemaId, String fieldName, String fieldValue) throws FTSServiceException {
        this.notWriterExceptionCheck("deleteDocumentsContainingField");
        LOGGER.info((Object)String.format("FTS: delete indexes for schema %s - Field = %s, fieldValue = %s", schemaId, fieldName, fieldValue));
        this.deleteDocumentContainingField(schemaId, fieldName, fieldValue, ftsAnalyzer);
        this.deleteDocumentContainingField(schemaId, fieldName + "_literal", fieldValue, ftsAnalyzer);
        this.deleteDocumentContainingField(schemaId, fieldName + "_literalCase", fieldValue, ftsAnalyzer);
        this.deleteDocumentContainingField(schemaId, fieldName + "_case", fieldValue, ftsAnalyzer);
        this.deleteDocumentContainingField(schemaId, fieldName + "_noStem", fieldValue, ftsAnalyzer);
        this.deleteDocumentContainingField(schemaId, fieldName + "_caseNoStem", fieldValue, ftsAnalyzer);
        this.deleteDocumentContainingField(schemaId, fieldName + "_orig", fieldValue, ftsAnalyzer);
        this.deleteDocumentContainingField(schemaId, fieldName + "_bytes", fieldValue, ftsAnalyzer);
    }

    @Override
    public synchronized void deleteDocuments(String schemaId, boolean deleteIndexDir) throws FTSServiceException {
        LOGGER.info((Object)("FTS: delete all indexes for schema " + schemaId));
        try {
            boolean success;
            try {
                IndexWriter writer = this.getIndexWriter(ftsAnalyzer, schemaId);
                if (!deleteIndexDir) {
                    writer.deleteAll();
                    this.commit(false);
                    return;
                }
                writer.rollback();
                IndexSearcher searcher = this.getIndexSearcher(schemaId);
                if (searcher != null) {
                    searcher.getIndexReader().close();
                }
            }
            catch (FTSServiceException ex) {
                LOGGER.warn((Object)"error on delete all indexes", (Throwable)ex);
            }
            catch (AlreadyClosedException ex) {
                LOGGER.warn((Object)"error on delete all indexes", (Throwable)ex);
            }
            indexSearchers.remove(schemaId);
            indexWriters.remove(schemaId);
            File schemaIndexDir = this.getCollectionDir(schemaId, false);
            if (schemaIndexDir != null && schemaIndexDir.isDirectory() && !(success = this.deleteIndexSubDir(schemaIndexDir))) {
                LOGGER.warn((Object)String.format("Indexes of schema %s are in use, and cannot be deleted", schemaId));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void updateConfiguration() throws FTSServiceException {
        try {
            if (ftsAnalyzer != null) {
                ((FTSAnalyzer)ftsAnalyzer).reload(this.caseSensitive);
            }
        }
        catch (Exception e) {
            throw new FTSServiceException(this.getClass().getName() + " updateConfiguration(): Analyzer reload failed", e);
        }
    }

    @Override
    public void close() throws FTSServiceException {
        if (this.isWriter) {
            try {
                if (indexSearchers != null) {
                    Collection<List<IndexSearcher>> searchQueues = indexSearchers.values();
                    for (List<IndexSearcher> indexSearcherQueue : searchQueues) {
                        for (IndexSearcher is : indexSearcherQueue) {
                            IndexReader indexReader = is.getIndexReader();
                            indexReader.close();
                        }
                        indexSearcherQueue.clear();
                    }
                    indexSearchers.clear();
                }
                if (indexWriters != null) {
                    Collection<IndexWriter> writers = indexWriters.values();
                    for (IndexWriter w : writers) {
                        w.close();
                    }
                    indexWriters.clear();
                }
                recentInit = null;
            }
            catch (IOException e) {
                throw new FTSServiceException(this.getClass().getName() + " close: Problem closing the index", e);
            }
        }
    }

    private void initAnalyzer(boolean caseSensitive) {
        LOGGER.info((Object)"FTS: Initialize full text analyzers");
        if (this.configurationDir != null && !this.configurationDir.equals("")) {
            File file = new File(this.configurationDir + "/FTSLocaleConfig.xml");
            if (file.exists()) {
                FTSAnalyzerConfigReader configReader = new FTSAnalyzerConfigReader();
                try {
                    this.analyzerConfig = configReader.readConfig(this.configurationDir, this.locale);
                }
                catch (Exception e) {
                    this.analyzerConfig = this.getDefaultAnalyzerConfig();
                    LOGGER.error((Object)(this.getClass().getName() + "initAnalyser: Failed to read FTSLocaleConfig.xml."), (Throwable)e);
                }
            } else {
                this.analyzerConfig = this.getDefaultAnalyzerConfig();
                LOGGER.warn((Object)(this.getClass().getName() + "initAnalyser: FTSLocaleConfig.xml is not a file."));
            }
        } else {
            this.analyzerConfig = this.getDefaultAnalyzerConfig();
            LOGGER.warn((Object)(this.getClass().getName() + "initAnalyser: Configuration directory does not exist."));
        }
        if (ftsAnalyzer != null) {
            ftsAnalyzer = null;
        }
        this.analyzerConfig.serverCharSet = this.serverCharSet;
        ftsAnalyzer = new FTSAnalyzer(this.analyzerConfig, caseSensitive);
    }

    private FTSAnalyzerConfigReader.FTSAnalyzerConfig getDefaultAnalyzerConfig() {
        FTSAnalyzerConfigReader.FTSAnalyzerConfig analyzerConfig = new FTSAnalyzerConfigReader().new FTSAnalyzerConfigReader.FTSAnalyzerConfig();
        analyzerConfig.stemmer = "English";
        analyzerConfig.serverCharSet = Charset.defaultCharset();
        return analyzerConfig;
    }

    private Document getDocumentById(String docId, String schemaId) throws FTSServiceException {
        Document document = null;
        TopDocs matchingDocs = null;
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = this.getIndexSearcher(schemaId);
            if (indexSearcher == null) {
                Document document2 = null;
                return document2;
            }
            Term term = new Term("docId", docId);
            TermQuery termQuery = new TermQuery(term);
            matchingDocs = indexSearcher.search((Query)termQuery, 1);
            if (matchingDocs.totalHits > 0) {
                ScoreDoc[] hits = matchingDocs.scoreDocs;
                for (int i = 0; i < hits.length; ++i) {
                    document = indexSearcher.doc(hits[0].doc);
                }
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " getDocumentById: Failed to retrieve document", e);
        }
        finally {
            if (indexSearcher != null) {
                ((FTSIndexSearcher)indexSearcher).setCount(false);
            }
        }
        return document;
    }

    private Document createDocument(String docId, String schemaId, String entryId) {
        Document document = new Document();
        FieldType fieldType = new FieldType();
        fieldType.setIndexed(true);
        fieldType.setTokenized(false);
        fieldType.setStored(true);
        fieldType.setStoreTermVectors(true);
        fieldType.freeze();
        Field docField = new Field("docId", docId, fieldType);
        Field schemaField = new Field("schemaId", schemaId, fieldType);
        Field entryField = new Field("entryId", entryId, fieldType);
        document.add((IndexableField)docField);
        document.add((IndexableField)schemaField);
        document.add((IndexableField)entryField);
        return document;
    }

    private synchronized void updateByField(String schemaId, String fieldName, String fieldValue, Document doc, Analyzer analyzer) throws FTSServiceException {
        try {
            IndexWriter indexWriter = this.getIndexWriter(analyzer, schemaId);
            if (indexWriter != null) {
                Term term = new Term(fieldName, fieldValue);
                indexWriter.updateDocument(term, (Iterable)doc);
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " updateByField: Error updating documents with field name '" + fieldName + "' and field value '" + fieldValue, e);
        }
    }

    private synchronized void deleteDocumentContainingField(String schemaId, String fieldName, String fieldValue, Analyzer analyzer) throws FTSServiceException {
        try {
            IndexWriter indexWriter = this.getIndexWriter(analyzer, schemaId);
            if (indexWriter != null) {
                indexWriter.deleteDocuments(new Term[]{new Term(fieldName, fieldValue)});
                this.commit(false);
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " deleteEntryDocument: Error deleting documents with field name '" + fieldName + "' and field data '" + fieldValue, e);
        }
    }

    private synchronized IndexWriter getIndexWriter(Analyzer analyzer, String schemaId) throws FTSServiceException {
        IndexWriter indexWriter = indexWriters.get(schemaId);
        if (indexWriter == null) {
            try {
                File dir = this.getCollectionDir(schemaId, true);
                FSDirectory fsDir = FSDirectory.open((File)dir);
                if (IndexWriter.isLocked((Directory)fsDir)) {
                    IndexWriter.unlock((Directory)fsDir);
                }
                LimitTokenCountAnalyzer tokenCountAnalyzer = new LimitTokenCountAnalyzer(analyzer, Integer.MAX_VALUE);
                IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_4_9, (Analyzer)tokenCountAnalyzer);
                indexWriterConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new FTSIndexDeletionPolicy());
                indexWriter = new IndexWriter((Directory)fsDir, indexWriterConfig);
                indexWriter.commit();
                indexWriters.put(schemaId, indexWriter);
            }
            catch (IOException e) {
                throw new FTSServiceException(this.getClass().getName() + " getIndexWriter: Error getting index writer", e);
            }
        }
        this.pendingIndexWriter.set(indexWriter);
        return indexWriter;
    }

    private static boolean isWindows() {
        String os = LuceneFTSService.getOSPlatform();
        return os.indexOf("win") >= 0;
    }

    private static String getOSPlatform() {
        return System.getProperty("os.name").toLowerCase();
    }

    private boolean canAddToQueue(String schemaId) {
        boolean bReturn = false;
        List<IndexSearcher> indexSearcherQueue = indexSearchers.get(schemaId);
        if (indexSearcherQueue == null || indexSearcherQueue.size() < 2) {
            bReturn = true;
            LOGGER.debug((Object)"Can add searcher");
        }
        if (this.isWriter) {
            bReturn = true;
        }
        return bReturn;
    }

    private synchronized IndexSearcher getIndexSearcher(String schemaId) throws FTSServiceException {
        return this.getIndexSearcher(0, schemaId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IndexSearcher getIndexSearcher(int retryCount, String schemaId) throws FTSServiceException {
        FTSIndexSearcher returnSearcher;
        block23: {
            returnSearcher = null;
            LOGGER.debug((Object)"Searcher Requested");
            List<IndexSearcher> indexSearcherQueue = indexSearchers.get(schemaId);
            if (indexSearcherQueue == null) {
                indexSearcherQueue = new ArrayList<IndexSearcher>();
                indexSearchers.put(schemaId, indexSearcherQueue);
            }
            try {
                if (indexSearcherQueue.size() == 0) {
                    File dir = this.getCollectionDir(schemaId, false);
                    if (dir == null) {
                        return null;
                    }
                    FSDirectory fsDir = FSDirectory.open((File)dir);
                    DirectoryReader dirReader = DirectoryReader.open((Directory)fsDir);
                    returnSearcher = new FTSIndexSearcher((IndexReader)dirReader);
                    indexSearcherQueue.add(returnSearcher);
                } else {
                    DirectoryReader directoryReader = (DirectoryReader)indexSearcherQueue.get(indexSearcherQueue.size() - 1).getIndexReader();
                    LOGGER.debug((Object)("Searcher Queue Count: " + indexSearcherQueue.size()));
                    if (!directoryReader.isCurrent()) {
                        LOGGER.debug((Object)("Entering Searcher check, Queue Count: " + indexSearcherQueue.size()));
                        for (int x = indexSearcherQueue.size() - 1; x > -1; --x) {
                            LOGGER.debug((Object)("Searcher object count: " + ((FTSIndexSearcher)indexSearcherQueue.get(x)).getCount() + "; indexSearcherQueue size: " + indexSearcherQueue.size()));
                            if (((FTSIndexSearcher)indexSearcherQueue.get(x)).getCount() != 0 || indexSearcherQueue.size() <= 1) continue;
                            LOGGER.debug((Object)"Searcher object count is now 0");
                            IndexSearcher indexSearcher = indexSearcherQueue.get(x);
                            IndexReader indexReader2 = indexSearcher.getIndexReader();
                            try {
                                indexReader2.close();
                                continue;
                            }
                            catch (AlreadyClosedException ace) {
                                LOGGER.debug((Object)("Lucene generated a non-fatal exception trying to close the reader object(s) during a clean-up of the cache and prior to an insert of a newly reopened. " + ace.getLocalizedMessage()), (Throwable)ace);
                                continue;
                            }
                            finally {
                                directoryReader = null;
                                indexSearcher = null;
                                indexSearcherQueue.remove(x);
                                LOGGER.debug((Object)"Removing searcher from queue");
                            }
                        }
                        if (this.canAddToQueue(schemaId)) {
                            directoryReader = (DirectoryReader)indexSearcherQueue.get(indexSearcherQueue.size() - 1).getIndexReader();
                            DirectoryReader drReopen = DirectoryReader.openIfChanged((DirectoryReader)directoryReader);
                            if (drReopen == null) {
                                drReopen = directoryReader;
                            }
                            returnSearcher = new FTSIndexSearcher((IndexReader)drReopen);
                            indexSearcherQueue.add(returnSearcher);
                            LOGGER.debug((Object)"Returning new searcher in queue");
                        } else {
                            returnSearcher = indexSearcherQueue.get(indexSearcherQueue.size() - 1);
                            LOGGER.debug((Object)"Returning old searcher");
                        }
                    } else {
                        returnSearcher = indexSearcherQueue.get(indexSearcherQueue.size() - 1);
                        LOGGER.debug((Object)"Returning old searcher");
                    }
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    return returnSearcher;
                }
                if (retryCount < this.searcherRetry) {
                    int newCount = retryCount + 1;
                    LOGGER.warn((Object)("Retry getIndexSearcher, retryCount: " + newCount));
                    if (this.searcherRetryDelay == 0) {
                        return this.getIndexSearcher(newCount, schemaId);
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(this.searcherRetryDelay);
                        return this.getIndexSearcher(newCount, schemaId);
                    }
                    catch (InterruptedException ie) {
                        break block23;
                    }
                }
                throw new FTSServiceException(this.getClass().getName() + " getIndexSearcher: Error getting index searcher.  Likely cause is index does not exist", e);
            }
        }
        if (returnSearcher != null) {
            returnSearcher.setCount(true);
        }
        return returnSearcher;
    }

    private String buildDocId(String schemaId, String entryId) {
        return entryId;
    }

    private String getExcerptText(Document document, int excerptOption, Query query, IndexReader indexReader, int docId, FTSService.QuerySchemas querySchema, String markupLeft, String markupRight) {
        String strReturn = null;
        switch (excerptOption) {
            case 0: {
                strReturn = "";
                break;
            }
            case 1: {
                strReturn = this.getExcerpt(document, querySchema);
                break;
            }
            case 2: {
                strReturn = this.getWAH(document, query, indexReader, docId, querySchema, markupLeft, markupRight);
                if (strReturn != null && strReturn.length() != 0) break;
                strReturn = this.getExcerpt(document, querySchema);
            }
        }
        boolean leftMarkPH = false;
        String markupLeftPH = "s!_01-$:Lft";
        if (markupLeft != null && markupLeft.length() > 0) {
            strReturn = strReturn.replace(markupLeft, markupLeftPH);
            leftMarkPH = true;
        }
        boolean rightMarkPH = false;
        String markupRightPH = "s!_01-$:Rht";
        if (markupRight != null && markupRight.length() > 0) {
            strReturn = strReturn.replace(markupRight, markupRightPH);
            rightMarkPH = true;
        }
        strReturn = strReturn.replaceAll("(?:\\<.*?\\>)+", " ");
        if (rightMarkPH) {
            strReturn = strReturn.replace(markupRightPH, markupRight);
        }
        if (leftMarkPH) {
            strReturn = strReturn.replace(markupLeftPH, markupLeft);
        }
        return strReturn;
    }

    private String getWAH(Document document, Query query, IndexReader indexReader, int docId, FTSService.QuerySchemas querySchema, String markupLeft, String markupRight) {
        List fields = document.getFields();
        Iterator i = fields.iterator();
        StringBuffer finalString = new StringBuffer("");
        LOGGER.debug((Object)("Number of pontential fields in entry to check for WAH: " + fields.size()));
        LOGGER.debug((Object)("Getting WAH data for: " + docId));
        while (i.hasNext()) {
            String strBestText;
            IndexableField field = (IndexableField)i.next();
            if (!field.name().endsWith("_orig") || field.name().equals("title_orig") || field.name().equals("createTime_orig") || field.name().equals("modifiedTime_orig")) continue;
            String strText = field.stringValue();
            String strFieldName = field.name().substring(0, field.name().length() - 5);
            if (!this.userHasRights(strFieldName = this.getFieldName(document, strFieldName), querySchema) || (strBestText = this.doHighlight(indexReader, docId, strFieldName, query, strText, false, markupLeft, markupRight)) == null || strBestText.equals("")) continue;
            strBestText.replaceAll("\n", "").replaceAll("\f", "").replaceAll("\r", "").replaceAll("\t", "").trim();
            if (finalString.length() > 0) {
                finalString.append(" *** ");
            }
            finalString.append(strBestText);
        }
        LOGGER.debug((Object)("Completed WAH data for: " + docId));
        return finalString.toString();
    }

    private String getFieldName(Document document, String strFieldName) {
        String strReturn = null;
        BytesRef bytesRef = document.getBinaryValue(strFieldName + "_bytes");
        if (bytesRef.length == 4) {
            if (bytesRef.bytes[0 + bytesRef.offset] == 1) {
                strReturn = strFieldName;
            }
            if (bytesRef.bytes[1 + bytesRef.offset] == 1) {
                strReturn = strFieldName + "_case";
            }
            if (bytesRef.bytes[2 + bytesRef.offset] == 1) {
                strReturn = strFieldName + "_literal";
            }
            if (bytesRef.bytes[3 + bytesRef.offset] == 1) {
                strReturn = strFieldName + "_literalCase";
            }
        }
        return strReturn;
    }

    private String doHighlight(IndexReader indexReader, int docId, String strFieldName, Query query, String strText, boolean isTitle, String markupLeft, String markupRight) {
        String strBestText = null;
        try {
            TokenStream tokenStream = TokenSources.getTokenStreamWithOffsets((IndexReader)indexReader, (int)docId, (String)strFieldName);
            QueryScorer scorer = new QueryScorer(query, strFieldName);
            Object fragmenter = null;
            fragmenter = isTitle ? new NullFragmenter() : new SimpleSpanFragmenter(scorer);
            SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(markupLeft, markupRight);
            Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)scorer);
            highlighter.setTextFragmenter((Fragmenter)fragmenter);
            strBestText = highlighter.getBestFragment(tokenStream, strText);
        }
        catch (IOException e) {
            LOGGER.error((Object)("IOException when trying to generate Words Around Hits " + e.getLocalizedMessage()));
            return "";
        }
        catch (InvalidTokenOffsetsException e) {
            LOGGER.error((Object)("InvalidTokenOffsetsException when trying to generate Words Around Hits " + e.getLocalizedMessage()));
            return "";
        }
        catch (Exception e) {
            // empty catch block
        }
        return strBestText;
    }

    private String highlightTitleText(IndexReader indexReader, int docId, String strFieldName, Query query, String strText, int resultOption, String markupLeft, String markupRight) {
        String strBestText = null;
        if (strText != null && strText.length() != 0 && resultOption == 2) {
            strBestText = this.doHighlight(indexReader, docId, strFieldName, FTSQueryParser.createTitleQuery(query), strText, true, markupLeft, markupRight);
            if (strBestText == null) {
                strBestText = strText;
            }
        } else {
            strBestText = strText;
        }
        return strBestText;
    }

    private boolean userHasRights(String fieldName, FTSService.QuerySchemas querySchema) {
        if (querySchema.queryFieldNames == null) {
            return true;
        }
        boolean bReturn = false;
        Iterator<String> it = querySchema.queryFieldNames.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(fieldName)) continue;
            bReturn = true;
            break;
        }
        return bReturn;
    }

    private String getExcerpt(Document document, FTSService.QuerySchemas querySchema) {
        List fields = document.getFields();
        Iterator i = fields.iterator();
        StringBuffer finalString = new StringBuffer("");
        int numWords = 30;
        while (i.hasNext()) {
            String strFieldName;
            IndexableField field = (IndexableField)i.next();
            if (!field.name().endsWith("_orig") || field.name().equals("title_orig") || field.name().equals("createTime_orig") || field.name().equals("modifiedTime_orig") || numWords <= 0 || !this.userHasRights(strFieldName = field.name().substring(0, field.name().length() - 5), querySchema)) continue;
            if (numWords != 30) {
                finalString.append(" *** ");
            }
            String strText = field.stringValue();
            numWords = this.getWords(strText, numWords, finalString);
        }
        if (numWords == 0) {
            finalString.append("...");
        }
        return finalString.toString();
    }

    private int getWords(String strText, int nWords, StringBuffer finalString) {
        int last = 0;
        WordIterator iter = new WordIterator(strText);
        while (iter.hasNext()) {
            iter.next();
            if (nWords == 0) break;
            last = iter.getEnd();
            --nWords;
        }
        finalString.append(strText.substring(0, last));
        return nWords;
    }

    private void notWriterExceptionCheck(String method) throws FTSServiceException {
        if (!this.isWriter) {
            throw new FTSServiceException(this.getClass().getName() + " A writing method, " + method + ", was called to a non-writer instance of FTSService.");
        }
    }

    private long getIndexTimeStamp(IndexCommit idc) throws IOException {
        Directory directory = idc.getDirectory();
        if (directory instanceof FSDirectory) {
            return this.fileModified((FSDirectory)directory, idc.getSegmentsFileName());
        }
        Map userData = idc.getUserData();
        return Long.parseLong((String)userData.get(INDEX_TIME_STAMP));
    }

    private long fileModified(FSDirectory directory, String segmentsFileName) {
        File fsDir = directory.getDirectory();
        File file = new File(fsDir, segmentsFileName);
        return file.lastModified();
    }

    private void setIndexTimeStamp(IndexWriter idxWriter) {
        HashMap<String, String> userData = new HashMap<String, String>();
        long currTime = System.currentTimeMillis();
        userData.put(INDEX_TIME_STAMP, String.valueOf(currTime));
        idxWriter.setCommitData(userData);
    }

    public static void main(String[] args) throws IOException, FTSServiceException {
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        luceneFTSService.init(LuceneFTSService.getConfig());
        LuceneFTSService.testAnalyzer((FTSAnalyzer)ftsAnalyzer, "firewall mapping");
    }

    private static void testAnalyzer(FTSAnalyzer analyzer, String str) throws FTSServiceException, IOException {
        AnalyzerUtils.displayTokens(analyzer, str);
        Term term = analyzer.analyzeSearchTerm("field1", "works", false);
        System.out.println(term.toString());
        term = analyzer.analyzeSearchTerm("field2", "works", false);
        System.out.println(term.toString());
        term = analyzer.analyzeSearchTerm("field3", "works", false);
        System.out.println(term.toString());
        term = analyzer.analyzeSearchTerm("field4", "works", false);
        System.out.println(term.toString());
    }

    private static FTSConfiguration getConfig() {
        FTSConfiguration config = new FTSConfiguration();
        config.setFullTextCaseInSensitive(false);
        config.setFullTextCollectionDir("C://Temp//Lucene");
        config.setFullTextConfigurationDir("C://Temp//config");
        config.setFullTextLocale("en");
        config.setFullTextOptimizeThreshold(500);
        config.setGetIndexSearcherRetry("1:0");
        return config;
    }

    private static void testCreateTerms() {
        ArrayList terms = new ArrayList();
        TermsFilter termsFilter = new TermsFilter(terms);
    }

    private static void testQuery(FTSAnalyzer ftsAnalyzer, String str, IndexReader indexReader) throws IOException {
        FTSQueryParser ftsQueryParser = new FTSQueryParser(ftsAnalyzer);
        BitSet[] bitSetArr = new BitSet[]{new BitSet(1)};
        bitSetArr[0].clear();
        Query query = ftsQueryParser.createQuery("100", new String[]{"field"}, new String[]{str}, bitSetArr, false);
        query.rewrite(indexReader);
    }

    @Override
    public void reInitializeSearchEngines(String ftsPluginName) {
    }

    static {
        nrtReaders = new HashMap<String, DirectoryReader>();
        recentInit = null;
        entryFieldQueue = new Hashtable();
    }

    public class FTSIndexDeletionPolicy
    extends IndexDeletionPolicy {
        public void onCommit(List arg0) throws IOException {
            LOGGER.debug((Object)"FTS-IndexDeletionPolicy::onCommit processing doDeletePolicy...");
            this.doDeletePolicy(arg0);
            LOGGER.debug((Object)"FTS-IndexDeletionPolicy::onCommit \tfinished doDeletePolicy...");
        }

        public void onInit(List arg0) throws IOException {
            LOGGER.debug((Object)"FTS-IndexDeletionPolicy::onInit processing doDeletePolicy...");
            this.doDeletePolicy(arg0);
            LOGGER.debug((Object)"FTS-IndexDeletionPolicy::onInit \tfinished doDeletePolicy...");
        }

        private void doDeletePolicy(List arg0) {
            LOGGER.debug((Object)("Delete Policy Time: " + LuceneFTSService.this.deletePolicyTime));
            int numCommitPoints = arg0.size();
            if (numCommitPoints > 1 && LuceneFTSService.this.deletePolicyTime > -1) {
                for (int x = 0; x < numCommitPoints - 1; ++x) {
                    try {
                        IndexCommit idc = (IndexCommit)arg0.get(x);
                        long curTime = new Date().getTime();
                        long elapseTimeAllowed = 1000 * LuceneFTSService.this.deletePolicyTime;
                        long nextNewerItemTime = LuceneFTSService.this.getIndexTimeStamp((IndexCommit)arg0.get(x + 1));
                        if (curTime - nextNewerItemTime <= elapseTimeAllowed) continue;
                        idc.delete();
                        LOGGER.debug((Object)("FTS:Deleted prior-commit-point  Generation='" + idc.getGeneration() + "'  File name='" + idc.getSegmentsFileName() + "'  Version='" + idc.getGeneration() + "'  TS/CTS/Allowed/Delta='" + LuceneFTSService.this.getIndexTimeStamp(idc) + "/" + curTime + "/" + elapseTimeAllowed + "/" + (curTime - nextNewerItemTime) + "'  POS/Last='" + x + "/" + numCommitPoints + "'  Location='" + idc.getDirectory() + "'."));
                        continue;
                    }
                    catch (IOException ioe) {
                        LOGGER.warn((Object)("FTS:Error(non-fatal) in doDeletePolicy: " + ioe.getLocalizedMessage()), (Throwable)ioe);
                    }
                }
            }
        }
    }

    private class EntryDataSorter
    implements Comparator<FTSService.GlobalEntryData> {
        private String[] fieldsToSort = null;

        private EntryDataSorter() {
        }

        public void setFieldsToSort(String string) {
            this.fieldsToSort = string.split(";");
        }

        @Override
        public int compare(FTSService.GlobalEntryData globalEntryData1, FTSService.GlobalEntryData globalEntryData2) {
            int bReturn = 0;
            int count = 0;
            boolean processFields = true;
            while (processFields && count < this.fieldsToSort.length) {
                Number minus;
                Object value2;
                Object value1;
                String field = this.fieldsToSort[count];
                if (field.equals("4")) {
                    value1 = Float.valueOf(globalEntryData1.score);
                    value2 = Float.valueOf(globalEntryData2.score);
                    minus = Float.valueOf(((Float)value1).floatValue() - ((Float)value2).floatValue());
                    if (((Float)minus).floatValue() != 0.0f) {
                        bReturn = this.fieldsToSort[count + 1].equals("1") ? ((Float)value1).compareTo((Float)value2) : ((Float)value1).compareTo((Float)value2) * -1;
                        processFields = false;
                        continue;
                    }
                    if (count < this.fieldsToSort.length - 1) {
                        count += 2;
                        continue;
                    }
                    bReturn = 0;
                    continue;
                }
                if (field.equals("5") || field.equals("6")) {
                    value1 = this.getDateFieldData(field, globalEntryData1);
                    value2 = this.getDateFieldData(field, globalEntryData2);
                    minus = (Long)value1 - (Long)value2;
                    if ((Long)minus != 0L) {
                        bReturn = this.fieldsToSort[count + 1].equals("1") ? ((Long)value1).compareTo((Long)value2) : ((Long)value1).compareTo((Long)value2) * -1;
                        processFields = false;
                        continue;
                    }
                    if (count < this.fieldsToSort.length - 1) {
                        count += 2;
                        continue;
                    }
                    bReturn = 0;
                    continue;
                }
                value1 = this.getFieldData(field, globalEntryData1);
                if (!((String)value1).equals(value2 = this.getFieldData(field, globalEntryData2))) {
                    bReturn = this.fieldsToSort[count + 1].equals("1") ? ((String)value1).compareToIgnoreCase((String)value2) : ((String)value1).compareToIgnoreCase((String)value2) * -1;
                    processFields = false;
                    continue;
                }
                if (count < this.fieldsToSort.length - 1) {
                    count += 2;
                    continue;
                }
                bReturn = 0;
                return 0;
            }
            return bReturn;
        }

        private long getDateFieldData(String field, FTSService.GlobalEntryData globalEntryData) {
            long nReturn = 0L;
            nReturn = field.equals("6") ? Long.parseLong(globalEntryData.modifiedDate) : Long.parseLong(globalEntryData.createDate);
            return nReturn;
        }

        private String getFieldData(String field, FTSService.GlobalEntryData globalEntryData) {
            String strReturn = "";
            if (field.equals(LuceneFTSService.DEFAULT_SCHEMAID)) {
                strReturn = globalEntryData.schemaId;
            } else if (field.equals("1")) {
                strReturn = globalEntryData.entryId;
            } else if (field.equals("2")) {
                strReturn = globalEntryData.title;
            } else if (field.equals("3")) {
                strReturn = globalEntryData.excerpt;
            } else {
                List<FTSService.ReturnFilterFields> returnFilterFields = globalEntryData.returnFilterFields;
                for (FTSService.ReturnFilterFields rff : returnFilterFields) {
                    if (!field.equals("\"" + rff.filterField + "\"")) continue;
                    strReturn = rff.value;
                    break;
                }
            }
            return strReturn;
        }
    }

    private class CommitTimerTask
    extends TimerTask {
        private CommitTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet copyWriter = null;
            Set set = LuceneFTSService.this.indexWritersToCommit;
            synchronized (set) {
                if (LuceneFTSService.this.indexWritersToCommit.size() == 0) {
                    return;
                }
                copyWriter = new HashSet(LuceneFTSService.this.indexWritersToCommit);
                LuceneFTSService.this.indexWritersToCommit.clear();
            }
            try {
                for (IndexWriter writer : copyWriter) {
                    LuceneFTSService.this.commitNow(writer);
                }
            }
            catch (FTSServiceException e) {
                LOGGER.error((Object)e.getLocalizedMessage());
                if (e.getCause() != null) {
                    LOGGER.error((Object)(" Root Exception: " + e.getCause().getLocalizedMessage()));
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getLocalizedMessage());
            }
        }
    }

    private class FieldDataHolder {
        public String schemaId;
        public String entryId;
        public float docBoost;
        public String[] fieldNames;
        public String[] values;
        public BitSet[] fullTextOptions;
        public float[] fieldBoost;

        FieldDataHolder(String schemaId, String entryId, float docBoost, String[] fieldNames, String[] values, BitSet[] fullTextOptions, float[] fieldBoost) {
            this.schemaId = schemaId;
            this.entryId = entryId;
            this.docBoost = docBoost;
            this.fieldNames = fieldNames;
            this.values = values;
            this.fullTextOptions = fullTextOptions;
            this.fieldBoost = fieldBoost;
        }
    }
}

