/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting.birt;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ChartType;
import com.bmc.arsys.arreporting.FieldInfo;
import com.bmc.arsys.arreporting.IARReportEngine;
import com.bmc.arsys.arreporting.ILogListener;
import com.bmc.arsys.arreporting.OutputFormat;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.ReportParameters;
import com.bmc.arsys.arreporting.ReportStyle;
import com.bmc.arsys.arreporting.ReportType;
import com.bmc.arsys.utils.LocaleUtil;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IDataSet;
import org.eclipse.birt.report.engine.api.script.element.IDataSource;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IDesignEngineFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;

public class BIRTReportEngine
implements IARReportEngine {
    private static final String TIME_OF_DAY_ON_PREPARE = "this.getStyle().dateTimeFormat = params[\"customTimeFormat\"]";
    private static final String DATE_ON_PREPARE = "this.getStyle().dateTimeFormat = params[\"customDateFormat\"]";
    private static final String TIME_ON_PREPARE = "this.getStyle().dateTimeFormat = params[\"customDateFormat\"] + \" \" + params[\"customTimeFormat\"]";
    private static final String TABLE_DETAIL_ROW_STYLE = "TableDetailRow";
    private static final String TABLE_HEADER_STYLE = "TableHeader";
    private static final String INTERNAL_NON_DISPLAY_ARRAY_LIST = "internalNonDisplayArrayList";
    private static final String AR_BIRT_NULL_PASSWORD = "AR_BIRT_NULL_PASSWORD";
    private static final int MAX_AR_COND_OP_CODE = 5;
    private static final int MIN_AR_COND_OP_CODE = 0;
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String HTML_RENDER_FORMAT = "html";
    private static final String PDF_RENDER_FORMAT = "pdf";
    private static final String DOC_RENDER_FORMAT = "doc";
    private static final String EXCEL_RENDER_FORMAT = "xls";
    private static final String PPT_RENDER_FORMAT = "ppt";
    private static final String QUALIFICATION = "qualification";
    private static final String RESULTLIST = "resultList";
    private static final String FORM = "form";
    private static final String FIELDS = "fields";
    private static final String SORTINFO = "sortInfo";
    private static final String HIDE_ENTRY_ID = "hideEntryId";
    private static final String NON_DISPLAY_FIELDS = "nonDisplayFields";
    private EngineConfig reportConfig = null;
    private DesignConfig designConfig = null;
    private IReportEngine reportEngine = null;
    private IDesignEngine designEngine = null;
    private String engineHome = null;
    private boolean initialized = false;
    private Properties properties = null;
    private final ILogListener logListener;
    private final Map<Integer, String> groupStyles = new HashMap<Integer, String>();

    public BIRTReportEngine(Properties properties, ILogListener logListener) {
        this.properties = properties;
        this.logListener = logListener;
        if (properties.getProperty("birt.engine") == null) {
            properties.setProperty("birt.engine", System.getenv("BIRT_ENGINE"));
        }
        if (properties.getProperty("birt.template.dir") == null) {
            properties.setProperty("birt.template.dir", System.getenv("BIRT_TEMPLATES"));
        }
        if (properties.getProperty("birt.log.dir") == null) {
            properties.setProperty("birt.log.dir", System.getenv("BIRT_LOGDIR"));
        }
        this.setupGroupStyles();
    }

    private void setupGroupStyles() {
        this.groupStyles.put(4, "GroupHeader");
        this.groupStyles.put(3, "GroupHeader1");
        this.groupStyles.put(2, "GroupHeader2");
        this.groupStyles.put(1, "GroupHeader3");
        this.groupStyles.put(0, "GroupHeader4");
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void shutdown() {
        if (this.reportEngine != null) {
            this.reportEngine.destroy();
        }
        Platform.shutdown();
        this.reportConfig = null;
        this.designConfig = null;
        this.reportEngine = null;
        this.designEngine = null;
        this.initialized = false;
    }

    @Override
    public void startup() throws ARException {
        try {
            String logDir;
            if (this.engineHome == null) {
                this.engineHome = this.properties.getProperty("birt.engine");
            }
            if (this.engineHome == null) {
                this.engineHome = System.getenv("BIRT_ENGINE");
            }
            if (this.engineHome == null) {
                throw new ARException(2, -1, "No value supplied for BIRT_ENGINE");
            }
            this.reportConfig = new EngineConfig();
            this.reportConfig.setEngineHome(this.engineHome);
            String resourcePath = this.properties.getProperty("birt.reports.dir");
            if (resourcePath != null) {
                this.reportConfig.setResourcePath(resourcePath);
            }
            if ((logDir = this.properties.getProperty("birt.log.dir")) != null) {
                this.reportConfig.setLogConfig(logDir, Level.FINE);
            }
            this.logMessage(0, "Starting BIRT Reporting Engine");
            Platform.startup((PlatformConfig)this.reportConfig);
            IReportEngineFactory reportFactory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            this.reportEngine = reportFactory.createReportEngine(this.reportConfig);
            this.reportEngine.changeLogLevel(Level.WARNING);
            this.designConfig = new DesignConfig();
            this.designConfig.setBIRTHome(this.engineHome);
            IDesignEngineFactory designFactory = (IDesignEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.model.DesignEngineFactory");
            this.designEngine = designFactory.createDesignEngine(this.designConfig);
            this.initialized = true;
            this.logMessage(0, "BIRT Reporting Engine successfully initialized");
        }
        catch (BirtException e) {
            this.logMessage(2, e.getMessage());
            throw new ARException(2, -1, e.getMessage());
        }
    }

    @Override
    public void setEngineHome(String engineHome) {
        this.engineHome = engineHome;
    }

    public OutputStream runReport(ARServerUser context, ReportParameters parameters, OutputFormat format) throws SemanticException, URISyntaxException, IOException, EngineException, ARException, ScriptException, DesignFileException {
        File tempFile = File.createTempFile("temp", ".rptdesign");
        String tempFileName = tempFile.getAbsolutePath();
        this.createReport(context, parameters, tempFileName);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.runReport(context, parameters, tempFileName, (OutputStream)result);
        tempFile.delete();
        return result;
    }

    public void createReport(ARServerUser context, ReportParameters parameters, String fileName) throws SemanticException, URISyntaxException, IOException, DesignFileException, ARException {
        ReportStyle style = parameters.getStyle();
        if (style == null) {
            style = ReportStyle.LIST;
        }
        switch (style) {
            case LIST: {
                this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "list.rptdesign");
                break;
            }
            case CHART: 
            case CHART_AND_LIST: {
                ChartType chartType = parameters.getChartType();
                if (chartType == null) {
                    throw new ARException(2, -1, "Unsuported chart type");
                }
                switch (chartType) {
                    case METER: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "meterchart.rptdesign");
                        break;
                    }
                    case PIE: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "piechart.rptdesign");
                        break;
                    }
                    case AREA: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "areachart.rptdesign");
                        break;
                    }
                    case BAR: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "barchart.rptdesign");
                        break;
                    }
                    case BUBBLE: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "bubblechart.rptdesign");
                        break;
                    }
                    case CONE: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "conechart.rptdesign");
                        break;
                    }
                    case DIFFERENCE: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "diffchart.rptdesign");
                        break;
                    }
                    case LINE: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "linechart.rptdesign");
                        break;
                    }
                    case PYRAMID: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "pyramidchart.rptdesign");
                        break;
                    }
                    case SCATTER: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "scatterchart.rptdesign");
                        break;
                    }
                    case STOCK: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "stockchart.rptdesign");
                        break;
                    }
                    case TUBE: {
                        this.createReportFromTemplate(context, parameters, fileName, this.properties.getProperty("birt.template.dir") + SEPARATOR + "tubechart.rptdesign");
                    }
                }
                break;
            }
            default: {
                throw new ARException(2, -1, "Unsuported report style");
            }
        }
    }

    private void addTableContent(ReportParameters parameters, ElementFactory factory, TableHandle table, boolean fromTemplate, boolean enableDrillDown) throws SemanticException, ContentException, NameException {
        RowHandle headerRow = (RowHandle)table.getHeader().get(0);
        if (!fromTemplate) {
            headerRow.setProperty("backgroundColor", (Object)"#AAAAAA");
        }
        RowHandle detailRow = (RowHandle)table.getDetail().get(0);
        detailRow.setStyleName(TABLE_DETAIL_ROW_STYLE);
        int headerCount = headerRow.getCells().getCount();
        headerRow.setStyleName(TABLE_HEADER_STYLE);
        List<FieldInfo> parameterFields = parameters.getFields();
        for (int iLoop = 0; iLoop < headerCount; ++iLoop) {
            CellHandle headerCell = (CellHandle)headerRow.getCells().get(iLoop);
            if (iLoop >= parameterFields.size()) continue;
            LabelHandle labelHandle = factory.newLabel(parameters.getFieldName(parameterFields.get(iLoop).getFieldId()));
            labelHandle.setText(parameterFields.get(iLoop).getLabel());
            labelHandle.setStyleName(TABLE_HEADER_STYLE);
            if (!fromTemplate) {
                this.addCellBorders(headerCell);
            } else {
                headerCell.setStyleName(TABLE_HEADER_STYLE);
            }
            headerCell.getContent().add((DesignElementHandle)labelHandle);
        }
        List<FieldInfo> parameterGroups = parameters.getGroups();
        if (parameterGroups != null && !parameterGroups.isEmpty()) {
            int groupCount = 0;
            for (FieldInfo groupField : parameterGroups) {
                if (groupField.getGroup() == 0) continue;
                TableGroupHandle group = factory.newTableGroup();
                String fieldName = parameters.getFieldName(groupField.getFieldId());
                group.setName(fieldName + "_group");
                group.setKeyExpr("row[\"" + fieldName + "\"]");
                group.setInterval("none");
                group.setSortDirection(groupField.getSortDir() == 1 ? "asc" : "desc");
                table.getGroups().add((DesignElementHandle)group);
                RowHandle groupHeader = factory.newTableRow(headerCount);
                CellHandle groupCell = (CellHandle)groupHeader.getCells().get(0);
                String label = groupField.getLabel();
                if (label == null || label.length() == 0) {
                    label = fieldName;
                }
                TextDataHandle textData = factory.newTextData(fieldName + "_textLabel");
                textData.setValueExpr("\"" + label + ": \" + " + "row[\"" + fieldName + "\"]");
                textData.setProperty("marginLeft", (Object)(groupCount * 10 + "pt"));
                textData.setProperty("textAlign", (Object)"left");
                groupCell.getContent().add((DesignElementHandle)textData);
                groupHeader.setStyleName(this.groupStyles.get(groupCount));
                group.getHeader().add((DesignElementHandle)groupHeader);
                if (++groupCount < this.groupStyles.size()) continue;
                groupCount = 0;
            }
        }
        int urlField = 1;
        if (parameterFields != null && !parameterFields.isEmpty()) {
            urlField = parameterFields.get(0).getFieldId();
        }
        for (FieldInfo fieldInfo : parameterFields) {
            if (urlField != 1 && fieldInfo.getFieldId() == 8) {
                urlField = fieldInfo.getFieldId();
            }
            if (fieldInfo.getFieldId() != 1) continue;
            urlField = fieldInfo.getFieldId();
            break;
        }
        block11: for (int iLoop = 0; iLoop < headerCount; ++iLoop) {
            FieldInfo fieldInfo;
            CellHandle detailCell = (CellHandle)detailRow.getCells().get(iLoop);
            if (iLoop >= parameterFields.size()) continue;
            fieldInfo = parameterFields.get(iLoop);
            DataItemHandle dataHandle = factory.newDataItem(parameters.getFieldName(fieldInfo.getFieldId()) + "_data");
            if (DataType.CURRENCY.equals((Object)fieldInfo.getDataType())) {
                dataHandle.setResultSetColumn(parameters.getFieldName(fieldInfo.getFieldId()));
            } else {
                dataHandle.setResultSetColumn(parameters.getFieldName(fieldInfo.getFieldId()));
            }
            if (enableDrillDown && urlField == fieldInfo.getFieldId()) {
                if (dataHandle.getActionHandle() == null) {
                    org.eclipse.birt.report.model.api.elements.structures.Action action = StructureFactory.createAction();
                    dataHandle.setAction(action);
                }
                dataHandle.getActionHandle().setURI("params[\"midTierURL\"].value + row[\"" + parameters.getFieldName(1) + "\"]");
                dataHandle.getActionHandle().setLinkType("hyperlink");
                ExpressionHandle expression = dataHandle.getActionHandle().getExpressionProperty("uri");
                expression.setType("javascript");
            }
            if (!fromTemplate) {
                this.addCellBorders(detailCell);
            } else {
                detailCell.setStyleName(TABLE_DETAIL_ROW_STYLE);
            }
            detailCell.getContent().add((DesignElementHandle)dataHandle);
            DataType dataType = fieldInfo.getDataType();
            switch (dataType.toInt()) {
                case 7: {
                    dataHandle.setOnPrepare(TIME_ON_PREPARE);
                    continue block11;
                }
                case 13: {
                    dataHandle.setOnPrepare(DATE_ON_PREPARE);
                    continue block11;
                }
                case 14: {
                    dataHandle.setOnPrepare(TIME_OF_DAY_ON_PREPARE);
                    continue block11;
                }
                case 2: {
                    dataHandle.getPrivateStyle().setNumberFormatCategory("Fixed");
                    dataHandle.getPrivateStyle().setNumberFormat("###0");
                    continue block11;
                }
                case 10: 
                case 12: {
                    int fLoop;
                    StringBuffer formatter = new StringBuffer();
                    formatter.append("#,##0.");
                    for (fLoop = 0; fLoop < fieldInfo.getPrecision(); ++fLoop) {
                        formatter.append("0");
                    }
                    dataHandle.getPrivateStyle().setNumberFormatCategory("Fixed");
                    dataHandle.getPrivateStyle().setNumberFormat(formatter.toString());
                    continue block11;
                }
                case 3: {
                    int fLoop;
                    StringBuffer formatter = new StringBuffer();
                    formatter.append("###0.");
                    for (fLoop = 0; fLoop < fieldInfo.getPrecision(); ++fLoop) {
                        formatter.append("0");
                    }
                    dataHandle.getPrivateStyle().setNumberFormatCategory("Fixed");
                    dataHandle.getPrivateStyle().setNumberFormat(formatter.toString());
                    continue block11;
                }
            }
        }
    }

    private void setDetailCellFormatting(CellHandle detailCell, DataType dataType) throws SemanticException {
        int typeInt = dataType.toInt();
        switch (typeInt) {
            case 12: {
                detailCell.getStyle().setNumberFormatCategory("Currency");
                detailCell.getStyle().setNumberFormat("###0.00");
                Locale locale = LocaleUtil.getLocale();
                break;
            }
            case 10: {
                detailCell.getStyle().setNumberFormatCategory("Fixed");
                detailCell.getStyle().setNumberFormat("###0.00");
                break;
            }
            case 13: {
                detailCell.getStyle().setDateFormatCategory("General Date");
                break;
            }
            case 5: {
                detailCell.getStyle().setStringFormatCategory("Unformatted");
                break;
            }
            case 4: {
                detailCell.getStyle().setStringFormatCategory("Unformatted");
                break;
            }
            case 6: {
                detailCell.getStyle().setStringFormatCategory("Unformatted");
                break;
            }
            case 2: {
                detailCell.getStyle().setNumberFormatCategory("Unformatted");
                break;
            }
            case 3: {
                detailCell.getStyle().setNumberFormatCategory("Fixed");
                detailCell.getStyle().setNumberFormat("###0.00");
                break;
            }
            case 7: {
                detailCell.getStyle().setDateTimeFormatCategory("Long Date");
                break;
            }
            case 14: {
                break;
            }
            case 40: {
                detailCell.getStyle().setNumberFormatCategory("Unformatted");
                break;
            }
        }
    }

    private void addTableColumnBindings(ReportParameters parameters, OdaDataSetHandle dataSet, TableHandle table) throws SemanticException {
        List resultSetCols = dataSet.getListProperty("resultSet");
        PropertyHandle boundCols = table.getColumnBindings();
        for (ResultSetColumn rsHandle : resultSetCols) {
            ComputedColumn col = StructureFactory.createComputedColumn();
            col.setName(rsHandle.getColumnName());
            col.setDisplayName(rsHandle.getColumnName());
            col.setExpression("dataSetRow[\"" + rsHandle.getColumnName() + "\"]");
            col.setDataType(rsHandle.getDataType());
            boundCols.addItem((IStructure)col);
        }
        List<FieldInfo> fields = parameters.getFields();
        for (FieldInfo fieldInfo : fields) {
            if (!DataType.CURRENCY.equals((Object)fieldInfo.getDataType())) continue;
            ComputedColumn col = StructureFactory.createComputedColumn();
            String fieldName = parameters.getFieldName(fieldInfo.getFieldId());
            col.setName(parameters.getFieldName(fieldInfo.getFieldId()));
            col.setDisplayName(fieldName);
            col.setExpression("if (dataSetRow[\"" + fieldName + ".VALUE\"] == null) {\"\"" + " } else { var nf =  java.text.NumberFormat.getInstance(reportContext.getLocale()); nf.setMinimumFractionDigits(2); nf.format(dataSetRow[\"" + fieldName + ".VALUE\"]) + \" \" + dataSetRow[\"" + fieldName + ".TYPE\"]}");
            col.setDataType("string");
            boundCols.addItem((IStructure)col);
        }
    }

    private void addChartColumnBindings(OdaDataSetHandle dataSet, ExtendedItemHandle handle, int categoryField, int seriesField) throws SemanticException {
        List resultSetCols = dataSet.getListProperty("resultSet");
        PropertyHandle boundCols = handle.getColumnBindings();
        boundCols.clearValue();
        for (ResultSetColumn rsHandle : resultSetCols) {
            ComputedColumn col = StructureFactory.createComputedColumn();
            col.setName(rsHandle.getColumnName());
            col.setDisplayName(rsHandle.getColumnName());
            col.setExpression("dataSetRow[\"" + rsHandle.getColumnName() + "\"]");
            col.setDataType(rsHandle.getDataType());
            boundCols.addItem((IStructure)col);
        }
    }

    private OdaDataSetHandle createDataSet(ReportParameters parameters, ReportDesignHandle design, ElementFactory factory) throws SemanticException, IOException, ContentException, NameException {
        OdaDataSetHandle dataSet = factory.newOdaDataSet("adhoc_dataset", "com.bmc.arsys.oda.runtime.dataSet");
        dataSet.setQueryText(this.createQueryPropertyString(parameters).toString());
        dataSet.setDataSource("adhoc_datasource");
        dataSet.setRowFetchLimit(parameters.getMaxRecords());
        design.getDataSets().add((DesignElementHandle)dataSet);
        PropertyHandle resultSet = dataSet.getPropertyHandle("resultSet");
        ArrayList<Integer> tempFieldsList = new ArrayList<Integer>();
        ArrayList<Integer> displayFields = new ArrayList<Integer>();
        ArrayList<Integer> nonDisplayFields = new ArrayList<Integer>();
        List<FieldInfo> parameterFields = parameters.getFields();
        int position = 0;
        for (int iLoop = 0; iLoop < parameterFields.size(); ++iLoop) {
            FieldInfo fieldInfo = parameterFields.get(iLoop);
            tempFieldsList.add(fieldInfo.getFieldId());
            position = !DataType.CURRENCY.equals((Object)fieldInfo.getDataType()) ? this.addFieldToResultSet(resultSet, parameters, fieldInfo.getFieldId(), position) : this.addCurrencyFieldToResultset(resultSet, parameters, fieldInfo.getFieldId(), position);
        }
        displayFields.addAll(tempFieldsList);
        List<FieldInfo> parameterGroups = parameters.getGroups();
        for (int iLoop = 0; iLoop < parameterGroups.size(); ++iLoop) {
            FieldInfo fieldInfo = parameterGroups.get(iLoop);
            if (!displayFields.contains(fieldInfo.getFieldId())) {
                nonDisplayFields.add(fieldInfo.getFieldId());
            }
            if (tempFieldsList.contains(fieldInfo.getFieldId())) continue;
            tempFieldsList.add(fieldInfo.getFieldId());
            position = !DataType.CURRENCY.equals((Object)fieldInfo.getDataType()) ? this.addFieldToResultSet(resultSet, parameters, fieldInfo.getFieldId(), position) : this.addCurrencyFieldToResultset(resultSet, parameters, fieldInfo.getFieldId(), position);
        }
        if (parameters.isIncludeChart()) {
            int seriesField;
            int categoryField = parameters.getCategoryField();
            if (categoryField > 0 && !tempFieldsList.contains(categoryField)) {
                tempFieldsList.add(categoryField);
                if (!displayFields.contains(categoryField)) {
                    nonDisplayFields.add(categoryField);
                }
                position = 12 != parameters.getFieldDataType(categoryField) ? this.addFieldToResultSet(resultSet, parameters, categoryField, position) : this.addCurrencyFieldToResultset(resultSet, parameters, categoryField, position);
            }
            if ((seriesField = parameters.getSeriesField()) > 0 && !tempFieldsList.contains(seriesField)) {
                tempFieldsList.add(seriesField);
                if (!displayFields.contains(seriesField)) {
                    nonDisplayFields.add(seriesField);
                }
                position = 12 != parameters.getFieldDataType(seriesField) ? this.addFieldToResultSet(resultSet, parameters, seriesField, position) : this.addCurrencyFieldToResultset(resultSet, parameters, seriesField, position);
            }
        }
        if (!tempFieldsList.contains(1)) {
            nonDisplayFields.add(1);
            OdaResultSetColumn resultColumn = StructureFactory.createOdaResultSetColumn();
            resultColumn.setPosition(Integer.valueOf(position + 1));
            ++position;
            resultColumn.setColumnName(parameters.getFieldName(1));
            resultColumn.setDataType("string");
            resultSet.addItem((IStructure)resultColumn);
        }
        parameters.getProperties().put(INTERNAL_NON_DISPLAY_ARRAY_LIST, nonDisplayFields);
        return dataSet;
    }

    private int addFieldToResultSet(PropertyHandle resultSet, ReportParameters parameters, int fieldId, int position) throws SemanticException {
        OdaResultSetColumn resultColumn = StructureFactory.createOdaResultSetColumn();
        resultColumn.setPosition(Integer.valueOf(position + 1));
        resultColumn.setColumnName(parameters.getFieldName(fieldId));
        resultColumn.setDataType(this.getDataType(parameters.getFieldDataType(fieldId)));
        resultSet.addItem((IStructure)resultColumn);
        return ++position;
    }

    private int addCurrencyFieldToResultset(PropertyHandle resultSet, ReportParameters parameters, int fieldId, int position) throws SemanticException {
        OdaResultSetColumn curValueColumn = StructureFactory.createOdaResultSetColumn();
        curValueColumn.setPosition(Integer.valueOf(position + 1));
        ++position;
        curValueColumn.setColumnName(parameters.getFieldName(fieldId) + ".VALUE");
        curValueColumn.setDataType("decimal");
        resultSet.addItem((IStructure)curValueColumn);
        OdaResultSetColumn curTypeColumn = StructureFactory.createOdaResultSetColumn();
        curTypeColumn.setPosition(Integer.valueOf(position + 1));
        ++position;
        curTypeColumn.setColumnName(parameters.getFieldName(fieldId) + ".TYPE");
        curTypeColumn.setDataType("string");
        resultSet.addItem((IStructure)curTypeColumn);
        OdaResultSetColumn curObjectColumn = StructureFactory.createOdaResultSetColumn();
        curObjectColumn.setPosition(Integer.valueOf(position + 1));
        curObjectColumn.setColumnName(parameters.getFieldName(fieldId) + ".OBJECT");
        curObjectColumn.setNativeDataType(Integer.valueOf(1000));
        resultSet.addItem((IStructure)curObjectColumn);
        return ++position;
    }

    private String getDataType(DataType dataType) {
        if (dataType == null) {
            return "string";
        }
        return this.getDataType(dataType.toInt());
    }

    private String getDataType(int dataType) {
        switch (dataType) {
            case 4: {
                return "string";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "float";
            }
            case 10: {
                return "decimal";
            }
            case 6: {
                return "string";
            }
            case 7: {
                return "date-time";
            }
            case 13: {
                return "date";
            }
            case 14: {
                return "time";
            }
        }
        return "string";
    }

    private DataType getARDataType(String dataType) {
        if (dataType.equals("string")) {
            return DataType.CHAR;
        }
        if (dataType.equals("integer")) {
            return DataType.INTEGER;
        }
        if (dataType.equals("float")) {
            return DataType.REAL;
        }
        if (dataType.equals("decimal")) {
            return DataType.DECIMAL;
        }
        if (dataType.equals("date-time")) {
            return DataType.TIME;
        }
        if (dataType.equals("date")) {
            return DataType.DATE;
        }
        if (dataType.equals("time")) {
            return DataType.TIME_OF_DAY;
        }
        return DataType.CHAR;
    }

    private void createReportFromTemplate(ARServerUser context, ReportParameters parameters, String fileName, String templateFile) throws SemanticException, URISyntaxException, IOException, DesignFileException {
        boolean enableDrillDown = true;
        boolean enableChartDrillDown = true;
        FormCriteria criteria = new FormCriteria();
        criteria.setPropertiesToRetrieve(60062);
        try {
            Form form = context.getForm(parameters.getForm(), criteria);
            Value val = (Value)form.getProperties().get((Object)60062);
            if (val != null && val.getIntValue() == 0) {
                enableDrillDown = false;
            }
        }
        catch (ARException e) {
            // empty catch block
        }
        SessionHandle session = this.designEngine.newSessionHandle(ULocale.forLocale((Locale)LocaleUtil.parseLocale((String)context.getLocale())));
        ReportDesignHandle design = session.openDesign(templateFile);
        ElementFactory factory = design.getElementFactory();
        if (ReportStyle.LIST.equals((Object)parameters.getStyle())) {
            parameters.setChartType(null);
            parameters.setAggregation(null);
            parameters.setCategoryField(0);
            parameters.setSeriesField(0);
        }
        if (ReportStyle.CHART.equals((Object)parameters.getStyle())) {
            parameters.clearFields();
            parameters.clearGroups();
        }
        TextItemHandle titleElement = (TextItemHandle)design.findElement("adhoc_header_text");
        if (parameters.getTitle() != null) {
            titleElement.setContent(parameters.getTitle());
        } else if (titleElement.canDrop()) {
            titleElement.dropAndClear();
        }
        OdaDataSourceHandle dataSource = null;
        for (OdaDataSourceHandle item : design.getDataSources()) {
            if (!"com.bmc.arsys.oda.runtime".equals(item.getExtensionID())) continue;
            dataSource = item;
            break;
        }
        OdaDataSetHandle dataSet = null;
        for (OdaDataSetHandle item : design.getDataSets()) {
            if (!"com.bmc.arsys.oda.runtime.dataSet".equals(item.getExtensionID())) continue;
            dataSet = item;
            break;
        }
        String beforeOpen = dataSet.getBeforeOpen();
        design.getDataSets().drop(dataSet);
        Properties customProps = parameters.getProperties();
        this.clearChartProperties(parameters);
        this.clearListProperties(parameters);
        if (customProps != null && !customProps.isEmpty()) {
            for (Map.Entry<Object, Object> propertyEntry : customProps.entrySet()) {
                String key = (String)propertyEntry.getKey();
                if (key.equals("arFieldObjects") || key.equals(INTERNAL_NON_DISPLAY_ARRAY_LIST)) continue;
                dataSource.setPrivateDriverProperty(key, (String)propertyEntry.getValue());
            }
        }
        dataSource.setPrivateDriverProperty("reportDesigner", "AR_DESIGNER");
        dataSet = this.createDataSet(parameters, design, factory);
        List nonDisplayFieldArrayList = (List)customProps.get(INTERNAL_NON_DISPLAY_ARRAY_LIST);
        if (nonDisplayFieldArrayList != null && !nonDisplayFieldArrayList.isEmpty()) {
            String nonDisplayString = "";
            for (Integer fieldId : nonDisplayFieldArrayList) {
                if (fieldId == null) continue;
                nonDisplayString = nonDisplayString + fieldId + ",";
            }
            dataSource.setPrivateDriverProperty(NON_DISPLAY_FIELDS, nonDisplayString);
            customProps.setProperty(NON_DISPLAY_FIELDS, nonDisplayString);
        } else {
            dataSource.setPrivateDriverProperty(NON_DISPLAY_FIELDS, "");
            customProps.setProperty(NON_DISPLAY_FIELDS, "");
        }
        dataSet.setBeforeOpen(beforeOpen);
        PropertyHandle resultSet = dataSet.getPropertyHandle("resultSet");
        TableHandle table = (TableHandle)design.findElement("adhoc_list_table");
        design.setLayoutPreference("auto layout");
        if (table != null && !parameters.isIncludeList() && table.canDrop()) {
            table.dropAndClear();
            table = null;
        }
        List<FieldInfo> parameterFields = parameters.getFields();
        if (table != null) {
            table.setDataSet((DataSetHandle)dataSet);
            int columnCount = table.getColumnCount();
            boolean hasEntryId = false;
            for (int iLoop = columnCount; iLoop < parameterFields.size(); ++iLoop) {
                ColumnHandle column = factory.newTableColumn();
                column.setProperty("width", (Object)"20%");
                table.getColumns().add((DesignElementHandle)column);
                ((RowHandle)table.getHeader().get(0)).getCells().add((DesignElementHandle)factory.newCell());
                ((RowHandle)table.getDetail().get(0)).getCells().add((DesignElementHandle)factory.newCell());
                ((RowHandle)table.getFooter().get(0)).getCells().add((DesignElementHandle)factory.newCell());
            }
            columnCount = table.getColumnCount();
            int columnWidth = 100 / columnCount;
            for (ColumnHandle column : table.getColumns()) {
                column.setProperty("width", (Object)(columnWidth + "%"));
            }
            for (FieldInfo fieldInfo : parameterFields) {
                if (fieldInfo.getFieldId() != 1) continue;
                hasEntryId = true;
            }
            table.setWidth("100%");
            table.getColumnBindings().clearValue();
            this.addTableColumnBindings(parameters, dataSet, table);
            this.addTableContent(parameters, factory, table, true, enableDrillDown);
        }
        this.configureChart(context, design, dataSet, parameters, enableDrillDown, enableChartDrillDown);
        design.saveAs(fileName);
        design.close();
    }

    public Series getValueSeries(Chart cm) {
        Axis baseAxis = (Axis)((ChartWithAxes)cm).getAxes().get(0);
        Axis valueAxis = (Axis)baseAxis.getAssociatedAxes().get(0);
        SeriesDefinition valueSeries = (SeriesDefinition)valueAxis.getSeriesDefinitions().get(0);
        return (Series)valueSeries.getSeries().get(0);
    }

    public void setTimeFormat(Chart cm, String dateFormat) {
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes chart = (ChartWithAxes)cm;
            ((Axis)chart.getAxes().get(0)).setFormatSpecifier((FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)dateFormat));
        } else if (cm instanceof ChartWithoutAxes) {
            SeriesDefinition valueSeries = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
            valueSeries.setFormatSpecifier((FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)dateFormat));
        }
    }

    private void configureChart(ARServerUser context, ReportDesignHandle design, OdaDataSetHandle dataSet, ReportParameters parameters, boolean enableDrillDown, boolean enableChartDrillDown) throws SemanticException, ExtendedElementException {
        ExtendedItemHandle chartHandle = (ExtendedItemHandle)design.findElement("adhoc_chart");
        if (chartHandle != null && !parameters.isIncludeChart() && chartHandle.canDrop()) {
            chartHandle.dropAndClear();
            chartHandle = null;
        }
        if (chartHandle != null) {
            int seriesField = parameters.getSeriesField();
            int categoryField = parameters.getCategoryField();
            this.addChartColumnBindings(dataSet, chartHandle, categoryField, seriesField);
            Chart chartItem = (Chart)chartHandle.getReportItem().getProperty("chart.instance");
            String seriesLabel = parameters.getSeriesLabel();
            String categoryLabel = parameters.getCategoryLabel();
            chartItem.getTitle().setVisible(false);
            String categoryName = parameters.getFieldName(parameters.getCategoryField());
            boolean numericCategoryField = false;
            boolean dateTimeCategoryField = false;
            boolean dateOnlyCategoryField = false;
            boolean timeOnlyCategoryField = false;
            try {
                Field catField = context.getField(parameters.getForm(), parameters.getCategoryField());
                if (catField.getDataType() == 2 || catField.getDataType() == 3 || catField.getDataType() == 10) {
                    numericCategoryField = true;
                } else if (catField.getDataType() == 7) {
                    dateTimeCategoryField = true;
                } else if (catField.getDataType() == 13) {
                    dateOnlyCategoryField = true;
                } else if (catField.getDataType() == 14) {
                    timeOnlyCategoryField = true;
                }
            }
            catch (ARException e) {
                // empty catch block
            }
            Trigger tr1 = TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)0, (String)("row[\"" + categoryName + "\"] + \" (\" +  valueData + \")\" "))));
            String midTierURL = "";
            midTierURL = numericCategoryField ? "params[\"chartURL\"].value + encodeURIComponent(\"'" + parameters.getCategoryField() + "'=\" + row[\"" + categoryName + "\"])" : (dateTimeCategoryField ? "params[\"chartURL\"].value + encodeURIComponent(\"'" + parameters.getCategoryField() + "'=\\\"\"" + " + Date.parse(row[\"" + categoryName + "\"]) + \"\\\"\")" : (dateOnlyCategoryField ? "params[\"chartURL\"].value + encodeURIComponent(\"'" + parameters.getCategoryField() + "'=\\\"\"" + " + convertDate(row[\"" + categoryName + "\"]) + \"\\\"\")" : "params[\"chartURL\"].value + encodeURIComponent(\"'" + parameters.getCategoryField() + "'=\\\"\"" + " + row[\"" + categoryName + "\"] + \"\\\"\")"));
            if (timeOnlyCategoryField) {
                this.setTimeFormat(chartItem, "HH:mm:ss");
            }
            String url = "<structure name=\"action\"><property name=\"linkType\">hyperlink</property><expression name=\"uri\" type=\"javascript\">" + midTierURL + "</expression> <property name=\"targetWindow\">_blank</property>" + "</structure>";
            Trigger tr2 = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)URLValueImpl.create((String)url, null, (String)"", (String)"", (String)"")));
            if (chartItem instanceof ChartWithAxes) {
                ChartWithAxes chart = (ChartWithAxes)chartItem;
                Axis xAxis = chart.getPrimaryBaseAxes()[0];
                String categoryElement = "row[\"" + categoryName + "\"]";
                if (12 == parameters.getFieldDataType(parameters.getCategoryField())) {
                    categoryElement = "row[\"" + categoryName + ".VALUE\"] + \" \" + row[\"" + categoryName + ".TYPE\"]";
                }
                xAxis.getTitle().getCaption().setValue(categoryLabel);
                xAxis.getTitle().getCaption().getFont().setBold(false);
                xAxis.getTitle().setVisible(true);
                ((Query)((Series)((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getSeries().get(0)).getDataDefinition().get(0)).setDefinition(categoryElement);
                switch (parameters.getChartType()) {
                    case BAR: 
                    case CONE: 
                    case PYRAMID: 
                    case TUBE: {
                        chart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
                        break;
                    }
                }
                Axis yAxis = chart.getPrimaryOrthogonalAxis(xAxis);
                yAxis.getTitle().getCaption().setValue(seriesLabel);
                yAxis.getTitle().getCaption().getFont().setBold(false);
                yAxis.getTitle().setVisible(true);
                chartHandle.setDataSet((DataSetHandle)dataSet);
                String seriesName = parameters.getFieldName(parameters.getSeriesField());
                String seriesElement = "row[\"" + seriesName + "\"]";
                if (12 == parameters.getFieldDataType(parameters.getSeriesField())) {
                    seriesElement = "row[\"" + seriesName + ".VALUE\"]";
                }
                ((Query)((Series)((SeriesDefinition)yAxis.getSeriesDefinitions().get(0)).getSeries().get(0)).getDataDefinition().get(0)).setDefinition(seriesElement);
                if (parameters.getAggregation() != null) {
                    SeriesGrouping sgp = DataFactory.eINSTANCE.createSeriesGrouping();
                    sgp.setEnabled(true);
                    sgp.setAggregateExpression(parameters.getAggregation().getBIRTType());
                    sgp.setGroupType(org.eclipse.birt.chart.model.attribute.DataType.TEXT_LITERAL);
                    ((Query)((Series)((SeriesDefinition)yAxis.getSeriesDefinitions().get(0)).getSeries().get(0)).getDataDefinition().get(0)).setGrouping(sgp);
                }
                this.getValueSeries(chartItem).getTriggers().add((Object)tr1);
                if (enableDrillDown && enableChartDrillDown) {
                    this.getValueSeries(chartItem).getTriggers().add((Object)tr2);
                }
            } else if (chartItem instanceof ChartWithoutAxes) {
                ChartWithoutAxes chart = (ChartWithoutAxes)chartItem;
                String seriesName = parameters.getFieldName(parameters.getSeriesField());
                String seriesElement = "row[\"" + seriesName + "\"]";
                if (12 == parameters.getFieldDataType(parameters.getSeriesField())) {
                    seriesElement = "row[\"" + seriesName + ".VALUE\"]";
                }
                Series series = (Series)((SeriesDefinition)((SeriesDefinition)chart.getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0)).getSeries().get(0);
                ((Query)series.getDataDefinition().get(0)).setDefinition(seriesElement);
                series.getLabel().getCaption().setValue(seriesLabel);
                series.getLabel().getCaption().getFont().setBold(false);
                series.setSeriesIdentifier((Object)seriesLabel);
                series.getTriggers().add((Object)tr1);
                if (enableDrillDown && enableChartDrillDown) {
                    series.getTriggers().add((Object)tr2);
                }
                if (parameters.getAggregation() != null) {
                    SeriesGrouping sgp = DataFactory.eINSTANCE.createSeriesGrouping();
                    sgp.setEnabled(true);
                    sgp.setAggregateExpression(parameters.getAggregation().getBIRTType());
                    sgp.setGroupType(org.eclipse.birt.chart.model.attribute.DataType.TEXT_LITERAL);
                    ((Query)series.getDataDefinition().get(0)).setGrouping(sgp);
                }
                String categoryElement = "row[\"" + categoryName + "\"]";
                if (12 == parameters.getFieldDataType(parameters.getCategoryField())) {
                    categoryElement = "row[\"" + categoryName + ".VALUE\"] + \" \" + row[\"" + categoryName + ".TYPE\"]";
                }
                ((Query)((Series)((SeriesDefinition)chart.getSeriesDefinitions().get(0)).getSeries().get(0)).getDataDefinition().get(0)).setDefinition(categoryElement);
            }
        }
    }

    private void addCellBorders(CellHandle handle) throws SemanticException {
        handle.setProperty("borderBottomWidth", (Object)"thin");
        handle.setProperty("borderBottomStyle", (Object)"solid");
        handle.setProperty("borderBottomColor", (Object)"black");
        handle.setProperty("borderLeftWidth", (Object)"thin");
        handle.setProperty("borderLeftStyle", (Object)"solid");
        handle.setProperty("borderLeftColor", (Object)"black");
        handle.setProperty("borderTopWidth", (Object)"thin");
        handle.setProperty("borderTopStyle", (Object)"solid");
        handle.setProperty("borderTopColor", (Object)"black");
        handle.setProperty("borderRightWidth", (Object)"thin");
        handle.setProperty("borderRightStyle", (Object)"solid");
        handle.setProperty("borderRightColor", (Object)"black");
    }

    private String createQueryPropertyString(ReportParameters parameters) throws IOException {
        Properties outProps = new Properties();
        outProps.setProperty(FORM, parameters.getForm());
        if (parameters.getQualification() != null) {
            outProps.setProperty(QUALIFICATION, parameters.getQualification());
        } else {
            parameters.setQualification("1 = 1");
        }
        if (parameters.getResultList() != null) {
            outProps.setProperty(RESULTLIST, parameters.getResultList());
            outProps.remove(QUALIFICATION);
        }
        outProps.setProperty(HIDE_ENTRY_ID, "true");
        List<FieldInfo> parameterFields = parameters.getFields();
        for (FieldInfo fieldInfo : parameterFields) {
            if (fieldInfo.getFieldId() != 1) continue;
            outProps.setProperty(HIDE_ENTRY_ID, "false");
            break;
        }
        this.addFieldProperties(parameters, outProps);
        StringBuffer sortStringBuffer = new StringBuffer();
        List<FieldInfo> parameterGroups = parameters.getGroups();
        if (parameterGroups != null) {
            List<FieldInfo> groups = parameterGroups;
            for (FieldInfo fieldInfo : groups) {
                if (fieldInfo.getSortDir() == -1) continue;
                sortStringBuffer.append(fieldInfo.getFieldId()).append(",").append(fieldInfo.getSortDir() == 0 ? 2 : 1).append(",").append(fieldInfo.getGroup()).append(";");
            }
        }
        if (sortStringBuffer.length() > 0) {
            outProps.setProperty(SORTINFO, sortStringBuffer.toString());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        outProps.store(out, null);
        String buffer = new String(out.toByteArray());
        out.close();
        return buffer.toString();
    }

    private void addFieldProperties(ReportParameters parameters, Properties outProps) {
        int iLoop;
        StringBuffer buffer = new StringBuffer();
        ArrayList<Integer> fields = new ArrayList<Integer>();
        List<FieldInfo> parameterFields = parameters.getFields();
        for (int iLoop2 = 0; iLoop2 < parameterFields.size(); ++iLoop2) {
            FieldInfo fieldInfo = parameterFields.get(iLoop2);
            fields.add(fieldInfo.getFieldId());
        }
        List<FieldInfo> parameterGroups = parameters.getGroups();
        for (iLoop = 0; iLoop < parameterGroups.size(); ++iLoop) {
            FieldInfo fieldInfo = parameterGroups.get(iLoop);
            if (fields.contains(fieldInfo.getFieldId())) continue;
            fields.add(parameterGroups.get(iLoop).getFieldId());
        }
        if (parameters.getCategoryField() > 0 && !fields.contains(parameters.getCategoryField())) {
            fields.add(parameters.getCategoryField());
        }
        if (parameters.getSeriesField() > 0 && !fields.contains(parameters.getSeriesField())) {
            fields.add(parameters.getSeriesField());
        }
        if (!fields.contains(1)) {
            fields.add(1);
        }
        for (iLoop = 0; iLoop < fields.size(); ++iLoop) {
            if (iLoop != 0) {
                buffer.append(",");
            }
            Integer fieldId = (Integer)fields.get(iLoop);
            buffer.append(fieldId);
            outProps.setProperty("Field-" + fieldId, parameters.getFieldDataType(fieldId) + "::" + parameters.getFieldName(fieldId));
        }
        outProps.setProperty(FIELDS, buffer.toString());
    }

    private String getTableFieldString(ReportParameters parameters) {
        int iLoop;
        StringBuffer buffer = new StringBuffer();
        ArrayList<Integer> fields = new ArrayList<Integer>();
        List<FieldInfo> parameterFields = parameters.getFields();
        for (iLoop = 0; iLoop < parameterFields.size(); ++iLoop) {
            fields.add(parameterFields.get(iLoop).getFieldId());
        }
        for (iLoop = 0; iLoop < fields.size(); ++iLoop) {
            if (iLoop != 0) {
                buffer.append(",");
            }
            buffer.append(fields.get(iLoop));
        }
        return buffer.toString();
    }

    public ReportParameters getParameters(String reportName) throws ARException {
        ReportParameters result = new ReportParameters();
        try {
            IReportRunnable report = this.reportEngine.openReportDesign(reportName);
            this.populateParameters(report, result);
        }
        catch (IOException e) {
            throw new ARException();
        }
        catch (EngineException e) {
            throw new ARException();
        }
        return result;
    }

    private void populatePrivateDriverProperties(ReportParameters result, IDataSource dataSource) {
        for (ReportConstants reportConstants : ReportConstants.values()) {
            if (dataSource.getPrivateDriverProperty(Integer.toString(reportConstants.toInt())) == null) continue;
            result.getProperties().setProperty(Integer.toString(reportConstants.toInt()), dataSource.getPrivateDriverProperty(Integer.toString(reportConstants.toInt())));
        }
        if (dataSource.getPrivateDriverProperty("reportDesigner") != null) {
            result.getProperties().setProperty("reportDesigner", dataSource.getPrivateDriverProperty("reportDesigner"));
        }
        if (dataSource.getPrivateDriverProperty(NON_DISPLAY_FIELDS) != null) {
            result.getProperties().setProperty(NON_DISPLAY_FIELDS, dataSource.getPrivateDriverProperty(NON_DISPLAY_FIELDS));
        }
        this.clearChartProperties(result);
        this.clearListProperties(result);
    }

    private void clearListProperties(ReportParameters result) {
        if (ReportStyle.CHART.equals((Object)result.getStyle())) {
            result.getProperties().remove((Object)ReportConstants.DESIGNER_REPORT_FIELDS_ID);
            result.getProperties().remove((Object)ReportConstants.DESIGNER_SORTINFO_ID);
        }
    }

    private void clearChartProperties(ReportParameters result) {
        if (ReportStyle.LIST.equals((Object)result.getStyle())) {
            result.getProperties().remove((Object)ReportConstants.DESIGNER_REPORT_CHART_ID);
            result.getProperties().remove((Object)ReportConstants.DESIGNER_CHART_AGGREGATE_BY);
            result.getProperties().remove((Object)ReportConstants.DESIGNER_CHART_CATEGORY_ID);
            result.getProperties().remove((Object)ReportConstants.DESIGNER_CHART_SERIES_ID);
        }
    }

    public ReportParameters getParameters(byte[] content) throws ARException {
        ReportParameters result = new ReportParameters();
        result.setType(ReportType.BIRT);
        try {
            IReportRunnable report = this.reportEngine.openReportDesign((InputStream)new ByteArrayInputStream(content));
            this.populateParameters(report, result);
            return result;
        }
        catch (IOException e) {
            throw new ARException();
        }
        catch (EngineException e) {
            throw new ARException();
        }
    }

    private void populateParameters(IReportRunnable report, ReportParameters result) throws ARException, IOException {
        String[] split;
        IDataSource dataSource = this.getDataSource(report);
        String designer = dataSource.getPrivateDriverProperty("reportDesigner");
        IDataSet dataSet = this.getDataSet(report);
        if (dataSet != null) {
            this.populateParametersFromQueryText(result, dataSet.getQueryText());
        }
        if ("AR_DESIGNER".equals(designer)) {
            String chartProp;
            result.getProperties().setProperty("reportDesigner", "AR_DESIGNER");
            this.populatePrivateDriverProperties(result, dataSource);
            String property = result.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()));
            if (property != null && property.length() > 0) {
                int intProp = Integer.parseInt(property);
                result.setStyle(ReportStyle.fromInt(intProp));
            }
            if ((chartProp = result.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()))) != null && chartProp.length() > 0) {
                int intProp = Integer.parseInt(chartProp);
                result.setChartType(ChartType.fromInt(intProp));
            } else {
                result.setChartType(null);
            }
            if (!ReportStyle.CHART.equals((Object)result.getStyle())) {
                ReportDesignHandle design = (ReportDesignHandle)report.getDesignHandle().getModuleHandle();
                TableHandle table = (TableHandle)design.findElement("adhoc_list_table");
                if (table != null) {
                    RowHandle headerRow = (RowHandle)table.getHeader().get(0);
                    int headerCount = headerRow.getCells().getCount();
                    for (int iLoop = 0; iLoop < headerCount; ++iLoop) {
                        CellHandle headerCell = (CellHandle)headerRow.getCells().get(iLoop);
                        LabelHandle label = (LabelHandle)headerCell.getContent().get(0);
                        if (label == null) continue;
                        result.getFields().get(iLoop).setLabel(label.getText());
                    }
                }
            } else {
                result.clearFields();
                result.clearGroups();
            }
        } else {
            result.getProperties().setProperty("reportDesigner", "BIRT_DESIGNER");
        }
        String nonDisplayString = result.getProperties().getProperty(NON_DISPLAY_FIELDS);
        if (nonDisplayString != null && nonDisplayString.length() > 0 && (split = nonDisplayString.split(",")) != null && split.length > 0) {
            ArrayList<Integer> nonDisplayFields = new ArrayList<Integer>();
            for (String splitString : split) {
                if (splitString == null || splitString.length() <= 0) continue;
                nonDisplayFields.add(Integer.parseInt(splitString));
            }
            for (Integer fieldId : nonDisplayFields) {
                result.removeField(fieldId);
            }
        }
        this.clearChartProperties(result);
        this.clearListProperties(result);
    }

    private IDataSource getDataSource(IReportRunnable report) throws ARException {
        IDataSource dataSource = null;
        SlotHandle dataSources = report.getDesignHandle().getModuleHandle().getDataSources();
        for (OdaDataSourceHandle slot : dataSources) {
            DesignElement slotElement = slot.getElement();
            if (!(slotElement instanceof OdaDataSource)) continue;
            dataSource = report.getDesignInstance().getDataSource(((OdaDataSource)slotElement).getName());
            break;
        }
        if (dataSource == null) {
            dataSource = report.getDesignInstance().getDataSource("adhoc_datasource");
        }
        if (dataSource == null) {
            this.logMessage(2, "Unable to find data source");
            throw new ARException(2, 3356, "Unable to find data source");
        }
        return dataSource;
    }

    private IDataSet getDataSet(IReportRunnable report) throws ARException {
        IDataSet dataSet = null;
        SlotHandle dataSets = report.getDesignHandle().getModuleHandle().getDataSets();
        for (OdaDataSetHandle slot : dataSets) {
            DesignElement slotElement = slot.getElement();
            if (!(slotElement instanceof OdaDataSet)) continue;
            dataSet = report.getDesignInstance().getDataSet(((OdaDataSet)slotElement).getName());
            break;
        }
        if (dataSet == null) {
            dataSet = report.getDesignInstance().getDataSet("adhoc_dataset");
        }
        if (dataSet == null) {
            this.logMessage(2, "Unable to find data set");
            throw new ARException(2, 3356, "Unable to find data set");
        }
        return dataSet;
    }

    private void populateParametersFromQueryText(ReportParameters parameters, String queryText) throws IOException {
        Properties inProps = new Properties();
        inProps.load(new ByteArrayInputStream(queryText.getBytes()));
        parameters.setQualification(inProps.getProperty(QUALIFICATION));
        String fieldString = inProps.getProperty(FIELDS);
        String sortString = inProps.getProperty(SORTINFO);
        String hideEntryId = inProps.getProperty(HIDE_ENTRY_ID);
        parameters.clearFields();
        String[] fieldSplit = null;
        if (fieldSplit == null) {
            fieldSplit = fieldString.split(",");
        }
        for (String fieldIdString : fieldSplit) {
            parameters.addField(new FieldInfo(Integer.parseInt(fieldIdString), null, null));
        }
        if ("true".equals(hideEntryId)) {
            parameters.removeField(1);
        }
        if (sortString != null && sortString.length() > 0) {
            String[] sortSplit = sortString.split(";");
            parameters.clearGroups();
            for (String sortInfoString : sortSplit) {
                String[] sortInfoSplit = sortInfoString.split(",");
                if (sortInfoSplit.length < 2) continue;
                FieldInfo fInfo = new FieldInfo(Integer.parseInt(sortInfoSplit[0]), null, Integer.parseInt(sortInfoSplit[1]), 0);
                if (sortInfoSplit.length >= 3) {
                    fInfo.setGroup(Integer.parseInt(sortInfoSplit[2]));
                }
                parameters.addGroup(fInfo);
            }
        }
    }

    public void runReport(ARServerUser context, byte[] content, OutputFormat format, OutputStream outStream) throws ARException {
        try {
            IReportRunnable reportRunnable = this.reportEngine.openReportDesign((InputStream)new ByteArrayInputStream(content));
            ReportParameters parameters = new ReportParameters();
            parameters.setOutputFormat(format);
            this.runReport(context, reportRunnable, parameters, outStream);
        }
        catch (EngineException e) {
            throw new ARException(2, -1, e.getMessage());
        }
        catch (SemanticException e) {
            throw new ARException(2, -1, e.getMessage());
        }
        catch (ScriptException e) {
            throw new ARException(2, -1, e.getMessage());
        }
    }

    private void runReport(ARServerUser context, IReportRunnable reportRunnable, ReportParameters parameters, OutputStream outStream) throws EngineException, ARException, ScriptException, SemanticException {
        String qualProp;
        Properties inProps;
        String queryText;
        IDataSet dataSet;
        IDataSource dataSource = this.getDataSource(reportRunnable);
        if (dataSource != null) {
            dataSource.setPrivateDriverProperty("user", context.getUser());
            dataSource.setPrivateDriverProperty("server", context.getServer());
            if (context.getPassword() == null || context.getPassword() != null && context.getPassword().length() == 0) {
                dataSource.setPrivateDriverProperty("password", AR_BIRT_NULL_PASSWORD);
            } else {
                dataSource.setPrivateDriverProperty("password", context.getPassword());
            }
            dataSource.setPrivateDriverProperty("port", Integer.toString(context.getPort()));
            dataSource.setPrivateDriverProperty("authentication", context.getAuthentication());
            if (context.getLocale() != null) {
                dataSource.setPrivateDriverProperty("locale", context.getLocale());
            } else {
                dataSource.getPrivateDriverProperty("");
            }
            if (context.getTimeZone() != null) {
                dataSource.setPrivateDriverProperty("timezone", context.getTimeZone());
            } else {
                dataSource.setPrivateDriverProperty("timezone", "");
            }
        }
        if (parameters.getQualification() == null || parameters.getQualification().length() == 0) {
            parameters.setQualification("1 = 1");
        }
        if (parameters.getQualification() != null && parameters.getQualification().length() > 0 || parameters.getResultList() != null && parameters.getResultList().length() > 0) {
            dataSet = this.getDataSet(reportRunnable);
            queryText = dataSet.getQueryText();
            inProps = new Properties();
            try {
                inProps.load(new ByteArrayInputStream(queryText.getBytes()));
                if (parameters.getQualification() != null && parameters.getQualification().length() > 0) {
                    qualProp = inProps.getProperty(QUALIFICATION);
                    if (parameters.isOverrideQualification()) {
                        inProps.setProperty(QUALIFICATION, parameters.getQualification());
                    } else if (qualProp != null && qualProp.length() > 0) {
                        inProps.setProperty(QUALIFICATION, qualProp + " AND " + parameters.getQualification());
                    } else {
                        inProps.setProperty(QUALIFICATION, parameters.getQualification());
                    }
                }
                inProps.remove(RESULTLIST);
                if (parameters.getResultList() != null && parameters.getResultList().length() > 0) {
                    inProps.setProperty(RESULTLIST, parameters.getResultList());
                    inProps.remove(QUALIFICATION);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                inProps.store(out, null);
                String buffer = new String(out.toByteArray());
                dataSet.setQueryText(buffer.toString());
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (parameters.getQualification() != null && parameters.getQualification().length() > 0) {
            dataSet = this.getDataSet(reportRunnable);
            queryText = dataSet.getQueryText();
            inProps = new Properties();
            try {
                inProps.load(new ByteArrayInputStream(queryText.getBytes()));
                qualProp = inProps.getProperty(QUALIFICATION);
                if (parameters.isOverrideQualification()) {
                    inProps.setProperty(QUALIFICATION, parameters.getQualification());
                } else if (qualProp != null && qualProp.length() > 0) {
                    inProps.setProperty(QUALIFICATION, qualProp + " AND " + parameters.getQualification());
                } else {
                    inProps.setProperty(QUALIFICATION, parameters.getQualification());
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                inProps.store(out, null);
                String buffer = new String(out.toByteArray());
                dataSet.setQueryText(buffer.toString());
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        IRunAndRenderTask task = this.reportEngine.createRunAndRenderTask(reportRunnable);
        task.setLocale(LocaleUtil.parseLocale((String)context.getLocale()));
        task.setParameterValue("midTierURL", (Object)parameters.getMidtierUrl());
        if (context.getTimeZone() != null) {
            TimeZone tz = TimeZone.getTimeZone((String)context.getTimeZone());
            task.setTimeZone(tz);
        }
        HTMLRenderOption renderOption = null;
        OutputFormat format = parameters.getOutputFormat();
        HTMLRenderOption htmlRenderOption = null;
        switch (format) {
            case HTML: {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat(HTML_RENDER_FORMAT);
                HTMLServerImageHandler sih = new HTMLServerImageHandler();
                renderOption.setImageHandler((IHTMLImageHandler)sih);
                htmlRenderOption = renderOption;
                htmlRenderOption.setBaseImageURL(this.properties.getProperty("birt.base.image.url"));
                htmlRenderOption.setImageDirectory(this.properties.getProperty("birt.image.dir"));
                if (parameters.isForcePNG()) {
                    htmlRenderOption.setSupportedImageFormats("PNG");
                }
                htmlRenderOption.setEmbeddable(false);
                break;
            }
            case EMBEDDED_HTML: {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat(HTML_RENDER_FORMAT);
                HTMLServerImageHandler sih = new HTMLServerImageHandler();
                renderOption.setImageHandler((IHTMLImageHandler)sih);
                htmlRenderOption = renderOption;
                htmlRenderOption.setEmbeddable(true);
                htmlRenderOption.setBaseImageURL(this.properties.getProperty("birt.base.image.url"));
                htmlRenderOption.setImageDirectory(this.properties.getProperty("birt.image.dir"));
                if (!parameters.isForcePNG()) break;
                htmlRenderOption.setSupportedImageFormats("PNG");
                break;
            }
            case PDF: {
                renderOption = new RenderOption();
                renderOption.setOutputFormat(PDF_RENDER_FORMAT);
                break;
            }
            case XLS: {
                renderOption = new RenderOption();
                renderOption.setOutputFormat(EXCEL_RENDER_FORMAT);
                break;
            }
            case DOC: {
                renderOption = new RenderOption();
                renderOption.setOutputFormat(DOC_RENDER_FORMAT);
                break;
            }
            case PPT: {
                renderOption = new RenderOption();
                renderOption.setOutputFormat(PPT_RENDER_FORMAT);
            }
        }
        renderOption.setOutputStream(outStream);
        task.setRenderOption((IRenderOption)renderOption);
        task.run();
        task.close();
    }

    public void runReport(ARServerUser context, ReportParameters parameters, String fileName, OutputStream outStream) throws ARException {
        try {
            IReportRunnable reportRunnable = this.reportEngine.openReportDesign(fileName);
            this.runReport(context, reportRunnable, parameters, outStream);
        }
        catch (EngineException e) {
            throw new ARException(2, -1, e.getMessage());
        }
        catch (SemanticException e) {
            throw new ARException(2, -1, e.getMessage());
        }
        catch (ScriptException e) {
            throw new ARException(2, -1, e.getMessage());
        }
    }

    @Override
    public void setTemp() {
    }

    public EngineConfig getReportConfig() {
        return this.reportConfig;
    }

    public void setReportConfig(EngineConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public DesignConfig getDesignConfig() {
        return this.designConfig;
    }

    public void setDesignConfig(DesignConfig designConfig) {
        this.designConfig = designConfig;
    }

    public IReportEngine getReportEngine() {
        return this.reportEngine;
    }

    public void setReportEngine(IReportEngine reportEngine) {
        this.reportEngine = reportEngine;
    }

    public IDesignEngine getDesignEngine() {
        return this.designEngine;
    }

    public void setDesignEngine(IDesignEngine designEngine) {
        this.designEngine = designEngine;
    }

    public String getEngineHome() {
        return this.engineHome;
    }

    private void logMessage(int level, String message) {
        if (this.logListener != null) {
            this.logListener.logMessage(level, message);
        }
    }

    public void runReport(ARServerUser context, ReportParameters parameters, byte[] reportDefinition, ByteArrayOutputStream out) throws ARException {
        this.runReport(context, reportDefinition, parameters.getOutputFormat(), (OutputStream)out);
    }

    public Properties getEngineProperties() {
        return this.properties;
    }

    private String combineQualifications(ARServerUser context, String primaryQualString, String secondaryQualString) throws ARException {
        QualifierInfo primaryQual = this.getAllQualifier();
        QualifierInfo secondaryQual = this.getAllQualifier();
        if (primaryQualString != null && !this.isEncodedQualification(primaryQualString)) {
            throw new ARException(2, -1, "Primary qualification is in an unsupported format");
        }
        if (secondaryQualString != null && !this.isEncodedQualification(secondaryQualString)) {
            throw new ARException(2, -1, "Secondary qualification is in an unsupported format");
        }
        return null;
    }

    private QualifierInfo getAllQualifier() {
        ArithmeticOrRelationalOperand left = new ArithmeticOrRelationalOperand(new Value(1));
        ArithmeticOrRelationalOperand right = new ArithmeticOrRelationalOperand(new Value(1));
        QualifierInfo qualInfo = new QualifierInfo(new RelationalOperationInfo(1, left, right));
        return qualInfo;
    }

    private boolean isEncodedQualification(String qual) {
        int df;
        return qual != null && qual.length() > 2 && (df = qual.charAt(0) - 48) <= 5 && df >= 0 && qual.charAt(1) == '\\';
    }
}

