/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting.birt;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BIRTLibraryUtil {
    private static final String AR_SYSTEM_RESOURCE_DEFINITIONS = "AR System Resource Definitions";
    private static final String BIRT_LIBRARY = "BIRT Library";
    private static final int TYPE_CONSTANT = 2;
    private static final int FIELD_ATTACHMENT = 41103;
    private static final int FIELD_NAME = 41100;
    private static final int FIELD_TYPE = 41105;
    private static final String TIMESTAMP_FILE = ".timestamp";
    private static ARPluginContext pluginContext;
    private static final Value STATUS_ACTIVE;
    private static final QualifierInfo STATUS_EQ_ACTIVE;
    private static final Value TYPE_BIRT;
    private static final QualifierInfo TYPE_EQ_BIRT;
    private static final QualifierInfo QUAL_STATUS_BIRTLIB;
    private static final ArithmeticOrRelationalOperand TIMESTAMP_OP;

    public static ARPluginContext getContext() {
        return pluginContext;
    }

    public static void setContext(ARPluginContext context) {
        pluginContext = context;
    }

    public static void main(String[] args) {
        BIRTLibraryUtil instance = new BIRTLibraryUtil();
        String timestampFile = "c:/temp/libraries/libtimestamp";
        String toPath = "c:/temp/libraries";
        ARServerUser context = new ARServerUser("Demo", "", null, "localhost");
        try {
            BIRTLibraryUtil.updateLibraries(context, toPath, null);
        }
        catch (ARException e) {
            System.out.println(BIRTLibraryUtil.getExceptionStack(e));
        }
    }

    public static void updateLibraries(ARServerUser context, String toPath, ARPluginContext pluginContext) throws ARException {
        String timestampFilePath;
        Timestamp timestamp;
        List<Entry> libraries;
        BIRTLibraryUtil.setContext(pluginContext);
        String contextPath = toPath + "/" + context.getServer();
        File checkFile = new File(contextPath);
        if (!checkFile.exists()) {
            checkFile.mkdirs();
        }
        if ((libraries = BIRTLibraryUtil.getLibraryList(context, timestamp = BIRTLibraryUtil.getLastTimestamp(timestampFilePath = contextPath + "/" + context.getServer() + TIMESTAMP_FILE))) != null && !libraries.isEmpty()) {
            for (Entry entry : libraries) {
                BIRTLibraryUtil.getLibrary(context, contextPath, entry);
            }
        }
        BIRTLibraryUtil.updateLastTimestamp(timestampFilePath);
    }

    private static void unpackLibrary(String toPath, byte[] content) {
        block8: {
            ZipInputStream zIn = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(content)));
            ZipEntry entry = null;
            try {
                while ((entry = zIn.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        File dir = new File(toPath + "/" + entry.getName());
                        if (!dir.exists()) {
                            dir.mkdir();
                        }
                    } else {
                        int counter;
                        FileOutputStream fos = null;
                        byte[] buffer = new byte[1024];
                        String fileName = toPath + "/" + entry.getName();
                        int lastSlash = fileName.lastIndexOf("/");
                        if (lastSlash > 0) {
                            String dirName = fileName.substring(0, lastSlash);
                            new File(dirName).mkdirs();
                        }
                        fos = new FileOutputStream(toPath + "/" + entry.getName());
                        while ((counter = zIn.read(buffer, 0, 1024)) > -1) {
                            fos.write(buffer, 0, counter);
                        }
                        fos.close();
                    }
                    zIn.closeEntry();
                }
                zIn.close();
            }
            catch (IOException e) {
                if (pluginContext == null) break block8;
                pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
            }
        }
    }

    private static void getLibrary(ARServerUser context, String toPath, Entry entry) throws ARException {
        AttachmentValue attValue;
        Value value;
        if (entry != null && (value = (Value)entry.get((Object)41103)) != null && value.getValue() != null && DataType.ATTACHMENT.equals((Object)value.getDataType()) && (attValue = (AttachmentValue)value.getValue()) != null) {
            attValue.setValue(new byte[0]);
            byte[] entryBlob = context.getEntryBlob(AR_SYSTEM_RESOURCE_DEFINITIONS, entry.getEntryId(), 41103);
            if (entryBlob != null && attValue.getName() != null) {
                String fileName = attValue.getName();
                if (fileName.contains("/") || fileName.contains("\\")) {
                    fileName = fileName.replace("\\", "/");
                    fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                }
                if (fileName.toLowerCase().endsWith(".rptlibrary") || fileName.toLowerCase().endsWith(".rpttemplate")) {
                    String destName = toPath + "/" + fileName;
                    BIRTLibraryUtil.writeToFile(destName, entryBlob);
                } else if (fileName.toLowerCase().endsWith(".zip")) {
                    BIRTLibraryUtil.unpackLibrary(toPath, entryBlob);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String fileName, byte[] bytes) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            fos.write(bytes);
        }
        catch (FileNotFoundException e) {
            if (pluginContext != null) {
                pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
            }
        }
        catch (IOException e) {
            if (pluginContext != null) {
                pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
            }
        }
        finally {
            block19: {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        if (pluginContext == null) break block19;
                        pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
                    }
                }
            }
        }
    }

    private static List<Entry> getLibraryList(ARServerUser context, Timestamp timestamp) throws ARException {
        QualifierInfo parseQualification = new QualifierInfo(1, QUAL_STATUS_BIRTLIB, new QualifierInfo(new RelationalOperationInfo(2, TIMESTAMP_OP, new ArithmeticOrRelationalOperand(new Value(timestamp)))));
        int[] fieldIds = new int[]{41105, 41100, 41103};
        return context.getListEntryObjects(AR_SYSTEM_RESOURCE_DEFINITIONS, parseQualification, 0, 0, null, fieldIds, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Timestamp getLastTimestamp(String timestampFilePath) {
        Timestamp result = new Timestamp(0L);
        if (new File(timestampFilePath).exists()) {
            FilterInputStream dataIn = null;
            try {
                dataIn = new DataInputStream(new FileInputStream(timestampFilePath));
                long timestamp = ((DataInputStream)dataIn).readLong();
                result = new Timestamp(timestamp);
            }
            catch (FileNotFoundException e) {
                if (pluginContext != null) {
                    pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
                }
            }
            catch (IOException e) {
                if (pluginContext != null) {
                    pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
                }
            }
            finally {
                block20: {
                    if (dataIn != null) {
                        try {
                            dataIn.close();
                        }
                        catch (IOException e) {
                            if (pluginContext == null) break block20;
                            pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
                        }
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLastTimestamp(String timestampFilePath) {
        FilterOutputStream dataOut = null;
        try {
            dataOut = new DataOutputStream(new FileOutputStream(timestampFilePath));
            ((DataOutputStream)dataOut).writeLong(new Timestamp(new Date()).getValue());
        }
        catch (FileNotFoundException e) {
            if (pluginContext != null) {
                pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
            }
        }
        catch (IOException e) {
            if (pluginContext != null) {
                pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
            }
        }
        finally {
            block19: {
                if (dataOut != null) {
                    try {
                        dataOut.close();
                    }
                    catch (IOException e) {
                        if (pluginContext == null) break block19;
                        pluginContext.logMessage(2, BIRTLibraryUtil.getExceptionStack(e));
                    }
                }
            }
        }
    }

    public static String getExceptionStack(Throwable th) {
        StackTraceElement[] elements;
        StringBuffer statusMessage = new StringBuffer();
        statusMessage.append(th.getMessage() + "\n");
        for (StackTraceElement element : elements = th.getStackTrace()) {
            statusMessage.append(element.toString() + "\n");
        }
        return statusMessage.toString();
    }

    static {
        STATUS_ACTIVE = new Value((Object)0L, DataType.ENUM);
        STATUS_EQ_ACTIVE = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(OperandType.FIELDID, CoreFieldId.Status.getFieldId()), new ArithmeticOrRelationalOperand(STATUS_ACTIVE)));
        TYPE_BIRT = new Value((Object)2L, DataType.ENUM);
        TYPE_EQ_BIRT = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(OperandType.FIELDID, 41105), new ArithmeticOrRelationalOperand(TYPE_BIRT)));
        QUAL_STATUS_BIRTLIB = new QualifierInfo(1, STATUS_EQ_ACTIVE, TYPE_EQ_BIRT);
        TIMESTAMP_OP = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 6);
    }
}

