/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARBulkException;
import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARQualifierHelper;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARSetGetEntryException;
import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.ARWebSocketConfig;
import com.bmc.arsys.api.ActiveLink;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ActiveLinkCriteria;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.AlertMessageInfo;
import com.bmc.arsys.api.ArchiveInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.Association;
import com.bmc.arsys.api.AssociationCardinality;
import com.bmc.arsys.api.AssociationCriteria;
import com.bmc.arsys.api.AssociationEnforcement;
import com.bmc.arsys.api.AssociationsToFollow;
import com.bmc.arsys.api.AuditInfo;
import com.bmc.arsys.api.BulkEntryReturn;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerCriteria;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.DirectAssociation;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryKey;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.EntryPointInfo;
import com.bmc.arsys.api.Escalation;
import com.bmc.arsys.api.EscalationCriteria;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.ExtFieldCandidatesInfo;
import com.bmc.arsys.api.ExtFormCandidatesInfo;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldCriteria;
import com.bmc.arsys.api.FieldKey;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.Filter;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FilterCriteria;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormAliasInfo;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.GroupInfo;
import com.bmc.arsys.api.Image;
import com.bmc.arsys.api.ImageCriteria;
import com.bmc.arsys.api.ImageData;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.IndirectAssociation;
import com.bmc.arsys.api.LicenseInfo;
import com.bmc.arsys.api.LicenseValidInfo;
import com.bmc.arsys.api.LocalizedRequestInfo;
import com.bmc.arsys.api.LocalizedValueCriteria;
import com.bmc.arsys.api.LocalizedValueInfo;
import com.bmc.arsys.api.LoggingInfo;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuCriteria;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.ObjectOperationTimes;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.OverlaidInfo;
import com.bmc.arsys.api.OverlayPropInfo;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.ProcessResult;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QuerySourceValues;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.RegularForm;
import com.bmc.arsys.api.RegularQuery;
import com.bmc.arsys.api.RoleInfo;
import com.bmc.arsys.api.SQLResult;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.SqlMenu;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.SupportFile;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.UserInfo;
import com.bmc.arsys.api.ValidateFormCacheInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewCriteria;
import com.bmc.arsys.api.ViewDisplayPropertyMap;
import com.bmc.arsys.api.WfdBreakpoint;
import com.bmc.arsys.api.WfdDebugLocation;
import com.bmc.arsys.api.WorkflowLockInfo;
import com.bmc.arsys.demo.javadriver.CommandProcessor;
import com.bmc.arsys.demo.javadriver.Commands;
import com.bmc.arsys.demo.javadriver.InputFile;
import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.LocaleCharSet;
import com.bmc.arsys.demo.javadriver.OutputWriter;
import com.bmc.arsys.demo.javadriver.RandomNumberThread;
import com.bmc.arsys.demo.javadriver.RowIterator;
import com.bmc.arsys.demo.javadriver.SyncObject;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import com.bmc.arsys.demo.javadriver.ThreadControlLocalStorage;
import com.bmc.arsys.demo.javadriver.ThreadStartInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JavaDriver
extends Thread {
    boolean executeCommand = true;
    static int quietMode = 0;
    static int randomNumberSeed;
    static String resultDirectory;
    boolean primaryThread;
    static String[] commandLineArgs;
    static int maxConnectionPerServer;
    static int idleConnectionsPerServer;
    static long connectionTimeoutDefault;
    static long connectionLifespanDefault;
    static String connectionTimeUnit;
    static ThreadControlLocalStorage localStorage;
    static RandomNumberThread randomNumberGenerator;
    static CommandProcessor timerCommandProcessor;
    static OutputWriter outputWriter;
    ThreadStartInfo threadStartInfoObject = null;
    static boolean javaDriverOnly;
    static int SUPPRESS_RESULTS;
    static int SUPPRESS_HEADERS;
    static int SUPPRESS_PROMPTS;
    static int SUPPRESS_MENU;
    static int SUPPRESS_ERRORS;
    static int SUPPRESS_WARNINGS;
    static int MAX_NESTED_LOOP_DEPTH;
    static int RAND_MAX;

    void printAuxillaryStatus() {
    }

    public void initCommandProcessing() {
        this.launchRandomNumberThread();
    }

    public void termCommandProcessing() {
    }

    public void beginAPICall() {
    }

    public void endAPICall(List<StatusInfo> statusList) {
    }

    protected void logResult(List<StatusInfo> statusList, long startTime) throws IOException {
    }

    public static int getRandomNumber() {
        if (randomNumberGenerator != null) {
            return randomNumberGenerator.getRandomNumber();
        }
        return 0;
    }

    public void cleanupThreadEnvironment() {
        if (randomNumberGenerator != null) {
            randomNumberGenerator.interrupt();
        }
        randomNumberGenerator.setWaitObjToNull();
        randomNumberGenerator = null;
    }

    public void setThreadStartInfo(ThreadStartInfo infoObject) {
        this.threadStartInfoObject = infoObject;
    }

    public ARServerUser getControlStructObject() {
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        return threadControlBlockPtr.getContext();
    }

    public void launchRandomNumberThread() {
        randomNumberGenerator = new RandomNumberThread(randomNumberSeed);
        randomNumberGenerator.start();
    }

    public static ThreadControlBlock getThreadControlBlockPtr() {
        if (localStorage == null) {
            return null;
        }
        return (ThreadControlBlock)localStorage.get();
    }

    public void setPrimaryThread(boolean primary) {
        this.primaryThread = primary;
    }

    public boolean isPrimaryThread() {
        return this.primaryThread;
    }

    public void setCommandLineArgs(String[] args) {
        commandLineArgs = args;
    }

    public String[] getCommandLineArgs() {
        return commandLineArgs;
    }

    public static void setResultDirectory(String directory) {
        resultDirectory = directory;
    }

    public static String getResultDirectory() {
        return resultDirectory;
    }

    public static void setQuietMode(int value) {
        quietMode = value;
    }

    public static int getQuietMode() {
        return quietMode;
    }

    public static void setRandomNumberSeed(int value) {
        randomNumberSeed = value;
    }

    public static int getRandomNumberSeed() {
        return randomNumberSeed;
    }

    int getNextCommand(StringBuilder args) throws IOException {
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        threadControlBlockPtr.args = null;
        outputWriter.driverPrintPrompt("\nCommand: ");
        int commandCode = -99;
        while (commandCode == -99) {
            String buffer;
            InputReader.getInputLine();
            String command = buffer = threadControlBlockPtr.getBuffer();
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) != ' ') continue;
                char[] tempArgs = new char[buffer.length() - i - 1];
                buffer.getChars(i + 1, buffer.length(), tempArgs, 0);
                String tmp = new String(tempArgs);
                threadControlBlockPtr.setArgs(tmp);
                char[] tempCmd = new char[i];
                buffer.getChars(0, i, tempCmd, 0);
                command = new String(tempCmd);
                break;
            }
            if (command.length() == 0 || command.charAt(0) == '#') {
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (command.length() > 6) {
                outputWriter.driverPrintError(" ***Command too long, unrecognized ****\n");
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (command.equals("h") || command.equals("?")) {
                outputWriter.driverPrintHelp();
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (command.equals("e") || command.equals("q") || command.equals("x")) {
                commandCode = -1;
                continue;
            }
            commandCode = Commands.getCommandCode(command);
            if (commandCode != -2) {
                threadControlBlockPtr.setCurrentCommand(command);
                continue;
            }
            outputWriter.driverPrintError(" *** Command not recognized ***\n");
            outputWriter.driverPrintPrompt("\nCommand: ");
        }
        if (threadControlBlockPtr.args != null && threadControlBlockPtr.args.length() > 0 && !threadControlBlockPtr.args.equals("null")) {
            args.append(threadControlBlockPtr.args);
        }
        return commandCode;
    }

    public void processCommands() throws IOException {
        int commandCode = -1;
        StringBuilder argsBuf = new StringBuilder();
        block194: while ((commandCode = this.getNextCommand(argsBuf)) != -1) {
            String args = argsBuf.toString().length() > 0 ? argsBuf.toString() : null;
            argsBuf = new StringBuilder();
            switch (commandCode) {
                case 0: {
                    this.getARServerUser();
                    continue block194;
                }
                case 1: {
                    this.getEntry();
                    continue block194;
                }
                case 2: {
                    this.setEntry();
                    continue block194;
                }
                case 3: {
                    this.createEntry();
                    continue block194;
                }
                case 4: {
                    this.deleteEntry();
                    continue block194;
                }
                case 5: {
                    this.getListEntry();
                    continue block194;
                }
                case 83: 
                case 999: {
                    this.getListEntryWithFields();
                    continue block194;
                }
                case 138: {
                    this.getListEntryBlocks();
                    continue block194;
                }
                case 6: {
                    this.getFilter();
                    continue block194;
                }
                case 7: {
                    this.setFilter();
                    continue block194;
                }
                case 8: {
                    this.createFilter();
                    continue block194;
                }
                case 9: {
                    this.deleteFilter();
                    continue block194;
                }
                case 10: {
                    this.getListFilter();
                    continue block194;
                }
                case 152: {
                    this.getMultipleFilters();
                    continue block194;
                }
                case 51: {
                    this.getEscalation();
                    continue block194;
                }
                case 52: {
                    this.setEscalation();
                    continue block194;
                }
                case 53: {
                    this.createEscalation();
                    continue block194;
                }
                case 54: {
                    this.deleteEscalation();
                    continue block194;
                }
                case 55: {
                    this.getListEscalation();
                    continue block194;
                }
                case 153: {
                    this.getMultipleEscalations();
                    continue block194;
                }
                case 11: {
                    this.getListGroup();
                    continue block194;
                }
                case 12: {
                    this.getForm();
                    continue block194;
                }
                case 13: {
                    this.setForm();
                    continue block194;
                }
                case 14: {
                    this.createForm();
                    continue block194;
                }
                case 15: {
                    this.deleteForm();
                    continue block194;
                }
                case 16: {
                    this.getListForm();
                    continue block194;
                }
                case 17: {
                    this.getMultipleForms();
                    continue block194;
                }
                case 18: {
                    this.getField();
                    continue block194;
                }
                case 19: {
                    this.setField();
                    continue block194;
                }
                case 179: {
                    this.setMultipleFields();
                    continue block194;
                }
                case 20: {
                    this.createField();
                    continue block194;
                }
                case 187: {
                    this.createMultipleFields();
                    continue block194;
                }
                case 21: {
                    this.deleteField();
                    continue block194;
                }
                case 22: {
                    this.getListField();
                    continue block194;
                }
                case 23: {
                    this.getCharMenu();
                    continue block194;
                }
                case 24: {
                    this.setCharMenu();
                    continue block194;
                }
                case 25: {
                    this.createCharMenu();
                    continue block194;
                }
                case 26: {
                    this.deleteCharMenu();
                    continue block194;
                }
                case 27: {
                    this.getListCharMenu();
                    continue block194;
                }
                case 151: {
                    this.getMultipleCharMenu();
                    continue block194;
                }
                case 63: {
                    this.getVUI();
                    continue block194;
                }
                case 64: {
                    this.setVUI();
                    continue block194;
                }
                case 65: {
                    this.createVUI();
                    continue block194;
                }
                case 66: {
                    this.deleteVUI();
                    continue block194;
                }
                case 67: {
                    this.getListVUI();
                    continue block194;
                }
                case 28: {
                    this.export();
                    continue block194;
                }
                case 29: {
                    this.arImport();
                    continue block194;
                }
                case 30: {
                    this.getServerInfo();
                    continue block194;
                }
                case 31: {
                    this.verifyUser();
                    continue block194;
                }
                case 32: {
                    this.openInputFile(args);
                    continue block194;
                }
                case 33: {
                    this.openOutputFile();
                    continue block194;
                }
                case 34: {
                    this.closeOutputFile();
                    continue block194;
                }
                case 35: {
                    this.startRecording();
                    continue block194;
                }
                case 36: {
                    this.stopRecording();
                    continue block194;
                }
                case 75: {
                    this.launchThread(false);
                    continue block194;
                }
                case 76: {
                    this.launchThread(true);
                    continue block194;
                }
                case 77: {
                    timerCommandProcessor.releaseWaitingThreads();
                    continue block194;
                }
                case 78: {
                    timerCommandProcessor.sleepTimer();
                    continue block194;
                }
                case 79: {
                    timerCommandProcessor.randomSleepTimer();
                    continue block194;
                }
                case 80: {
                    timerCommandProcessor.millisecondSleepTimer();
                    continue block194;
                }
                case 81: {
                    this.beginLoop();
                    continue block194;
                }
                case 82: {
                    this.endLoop();
                    continue block194;
                }
                case 38: {
                    continue block194;
                }
                case 39: {
                    this.termination();
                    continue block194;
                }
                case 40: {
                    this.getActiveLink();
                    continue block194;
                }
                case 41: {
                    this.setActiveLink();
                    continue block194;
                }
                case 42: {
                    this.createActiveLink();
                    continue block194;
                }
                case 43: {
                    this.deleteActiveLink();
                    continue block194;
                }
                case 44: {
                    this.getListActiveLink();
                    continue block194;
                }
                case 45: {
                    this.getMultipleActiveLinks();
                    continue block194;
                }
                case 46: {
                    this.mergeEntry();
                    continue block194;
                }
                case 47: {
                    this.getQualifier();
                    continue block194;
                }
                case 48: {
                    this.expandCharMenu();
                    continue block194;
                }
                case 49: {
                    this.setServerInfo();
                    continue block194;
                }
                case 50: {
                    this.getListUser();
                    continue block194;
                }
                case 56: {
                    this.getEntryStatistics();
                    continue block194;
                }
                case 59: {
                    this.getServerStatistics();
                    continue block194;
                }
                case 60: {
                    this.getListSQL();
                    continue block194;
                }
                case 61: {
                    this.deleteMultipleFields();
                    continue block194;
                }
                case 62: {
                    this.executeProcess();
                    continue block194;
                }
                case 68: {
                    this.setServerPort();
                    continue block194;
                }
                case 69: {
                    this.getMultipleEntries();
                    continue block194;
                }
                case 70: {
                    this.getSupportFile();
                    continue block194;
                }
                case 71: {
                    this.setSupportFile();
                    continue block194;
                }
                case 72: {
                    this.createSupportFile();
                    continue block194;
                }
                case 73: {
                    this.deleteSupportFile();
                    continue block194;
                }
                case 74: {
                    this.getListSupportFile();
                    continue block194;
                }
                case 84: {
                    this.getEntryBLOB();
                    continue block194;
                }
                case 85: {
                    this.getContainer();
                    continue block194;
                }
                case 86: {
                    this.setContainer();
                    continue block194;
                }
                case 87: {
                    this.createContainer();
                    continue block194;
                }
                case 88: {
                    this.deleteContainer();
                    continue block194;
                }
                case 89: {
                    this.getListContainer();
                    continue block194;
                }
                case 90: {
                    this.getMultipleContainers();
                    continue block194;
                }
                case 91: {
                    this.getTextForErrorMessage();
                    continue block194;
                }
                case 92: {
                    this.setLogging();
                    continue block194;
                }
                case 93: {
                    continue block194;
                }
                case 94: {
                    continue block194;
                }
                case 95: {
                    this.getvalidateFormCache();
                    continue block194;
                }
                case 96: {
                    this.getMultipleFields();
                    continue block194;
                }
                case 98: {
                    this.getLocalizedValue();
                    continue block194;
                }
                case 119: {
                    this.getMultipleLocalizedValues();
                    continue block194;
                }
                case 97: {
                    this.getListFormWithAlias();
                    continue block194;
                }
                case 99: {
                    this.createAlertEvent();
                    continue block194;
                }
                case 100: {
                    this.registerForAlerts();
                    continue block194;
                }
                case 101: {
                    this.deregisterForAlerts();
                    continue block194;
                }
                case 102: {
                    this.getListAlertUser();
                    continue block194;
                }
                case 103: {
                    this.getAlertCount();
                    continue block194;
                }
                case 104: {
                    this.decodeAlertMessage();
                    continue block194;
                }
                case 105: {
                    this.encodeARQualifierStruct();
                    continue block194;
                }
                case 106: {
                    this.decodeARQualifierStruct();
                    continue block194;
                }
                case 107: {
                    this.encodeARAssignStruct();
                    continue block194;
                }
                case 108: {
                    this.decodeARAssignStruct();
                    continue block194;
                }
                case 109: {
                    this.encodeStatusHistory();
                    continue block194;
                }
                case 110: {
                    this.encodeDiary();
                    continue block194;
                }
                case 111: {
                    this.getListExtFormCandidates();
                    continue block194;
                }
                case 112: {
                    this.getMultipleExtFieldCandidates();
                    continue block194;
                }
                case 113: {
                    continue block194;
                }
                case 114: {
                    this.validateLicense();
                    continue block194;
                }
                case 115: {
                    this.validateMultipleLicenses();
                    continue block194;
                }
                case 116: {
                    this.getListLicense();
                    continue block194;
                }
                case 117: {
                    continue block194;
                }
                case 118: {
                    continue block194;
                }
                case 120: {
                    this.getListSQLForActiveLink();
                    continue block194;
                }
                case 121: {
                    this.executeProcessForActiveLink();
                    continue block194;
                }
                case 122: {
                    this.printDriverVersion();
                    continue block194;
                }
                case 123: {
                    this.getSessionConfiguration();
                    continue block194;
                }
                case 124: {
                    this.setSessionConfiguration();
                    continue block194;
                }
                case 125: {
                    continue block194;
                }
                case 126: {
                    continue block194;
                }
                case 127: {
                    this.xmlCreateEntry();
                    continue block194;
                }
                case 128: {
                    this.xmlGetEntry();
                    continue block194;
                }
                case 129: {
                    this.xmlSetEntry();
                    continue block194;
                }
                case 132: {
                    this.getMultipleCurrencyRatioSets();
                    continue block194;
                }
                case 133: {
                    this.getCurrencyRatio();
                    continue block194;
                }
                case 130: {
                    continue block194;
                }
                case 131: {
                    this.setClientType();
                    continue block194;
                }
                case 134: {
                    this.getMultipleEntryPoints();
                    continue block194;
                }
                case 135: {
                    this.getListRole();
                    continue block194;
                }
                case 136: {
                    this.beginBulkEntryTransaction();
                    continue block194;
                }
                case 137: {
                    this.endBulkEntryTransaction();
                    continue block194;
                }
                case 139: {
                    this.dumpProxyInfo();
                    continue block194;
                }
                case 140: {
                    this.setUseConnectionPooling();
                    continue block194;
                }
                case 150: {
                    this.setConnectionLimitPerServer();
                    continue block194;
                }
                case 185: {
                    this.adjustConnectionParametersPerServer();
                    continue block194;
                }
                case 141: {
                    this.setImpersonatedUser();
                    continue block194;
                }
                case 142: {
                    this.getServerCharSet();
                    continue block194;
                }
                case 143: {
                    this.beginApiRecording();
                    continue block194;
                }
                case 144: {
                    this.stopApiRecording();
                    continue block194;
                }
                case 145: {
                    this.executeService();
                    continue block194;
                }
                case 146: {
                    this.getListApplicationState();
                    continue block194;
                }
                case 147: {
                    this.getApplicationState();
                    continue block194;
                }
                case 148: {
                    this.setApplicationState();
                    continue block194;
                }
                case 149: {
                    this.xmlExecuteService();
                    continue block194;
                }
                case 154: {
                    this.getObjectChangeTimes();
                    continue block194;
                }
                case 155: {
                    this.getImage();
                    continue block194;
                }
                case 160: {
                    this.getMultipleImages();
                    continue block194;
                }
                case 156: {
                    this.setImage();
                    continue block194;
                }
                case 157: {
                    this.createImage();
                    continue block194;
                }
                case 158: {
                    this.deleteImage();
                    continue block194;
                }
                case 159: {
                    this.getListImage();
                    continue block194;
                }
                case 161: {
                    this.deleteAlert();
                    continue block194;
                }
                case 162: {
                    this.wfdGetDebugLocation();
                    continue block194;
                }
                case 163: {
                    this.wfdExecute();
                    continue block194;
                }
                case 164: {
                    this.wfdGetFieldValues();
                    continue block194;
                }
                case 165: {
                    this.wfdSetFieldValues();
                    continue block194;
                }
                case 166: {
                    this.wfdGetDebugMode();
                    continue block194;
                }
                case 167: {
                    this.wfdSetDebugMode();
                    continue block194;
                }
                case 168: {
                    this.wfdGetFilterQual();
                    continue block194;
                }
                case 169: {
                    this.wfdSetQualifierResult();
                    continue block194;
                }
                case 172: {
                    this.beginClientManagedTransaction();
                    continue block194;
                }
                case 173: {
                    this.endClientManagedTransaction();
                    continue block194;
                }
                case 174: {
                    this.setClientManagedTransaction();
                    continue block194;
                }
                case 175: {
                    this.removeClientManagedTransaction();
                    continue block194;
                }
                case 170: {
                    this.wfdTerminateAPI();
                    continue block194;
                }
                case 171: {
                    this.runEscalation();
                    continue block194;
                }
                case 176: {
                    this.getOneEntryWithFields();
                    continue block194;
                }
                case 177: {
                    this.getListEntryWithMultiSchemaFields();
                    continue block194;
                }
                case 178: {
                    this.getCacheEvent();
                    continue block194;
                }
                case 180: {
                    this.setGetEntry();
                    continue block194;
                }
                case 181: {
                    this.createOverlay();
                    continue block194;
                }
                case 182: {
                    this.getMultipleVUI();
                    continue block194;
                }
                case 183: {
                    this.setOverlayGroup();
                    continue block194;
                }
                case 184: {
                    this.createOverlayFromObject();
                    continue block194;
                }
                case 186: {
                    this.verifyUser2();
                    continue block194;
                }
                case 188: {
                    this.addWebSocketConfig();
                    continue block194;
                }
                case 189: {
                    this.createAssociation();
                    continue block194;
                }
                case 190: {
                    this.setAssociation();
                    continue block194;
                }
                case 191: {
                    this.getAssociation();
                    continue block194;
                }
                case 192: {
                    this.deleteAssociation();
                    continue block194;
                }
                case 193: {
                    this.getListAssociation();
                    continue block194;
                }
                case 194: {
                    this.getMultipleAssociation();
                    continue block194;
                }
            }
            outputWriter.driverPrintNotSupportCommand(commandCode);
        }
    }

    void setClientType() {
        this.getControlStructObject().setClientType(3);
    }

    boolean processCommandLine() {
        String[] argv = this.getCommandLineArgs();
        int maxArgumentLen = 0;
        String tempPtr = null;
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        int argc = 0;
        if (argv != null) {
            argc = argv.length;
        }
        block29: for (int i = 0; i < argc; ++i) {
            if (argv[i].charAt(0) != '-' || argv[i].charAt(1) != 'u' && argv[i].charAt(1) != 'p' && argv[i].charAt(1) != 'l' && argv[i].charAt(1) != 's' && argv[i].charAt(1) != 'x' && argv[i].charAt(1) != 'o' && argv[i].charAt(1) != 'd' && argv[i].charAt(1) != 'q' && argv[i].charAt(1) != 'g' && argv[i].charAt(1) != 'c' && argv[i].charAt(1) != 'a' && argv[i].charAt(1) != 't' && argv[i].charAt(1) != 'S' && argv[i].charAt(1) != 'P') {
                if (argv[i].equals("-version")) {
                    outputWriter.driverPrintHeader("Java Driver Version 9.0 build001");
                    return false;
                }
                outputWriter.driverPrintError("Unrecognized option " + argv[i] + "\n");
                return false;
            }
            char option = argv[i].charAt(1);
            if (argv[i].length() > 2) {
                int cmdLength = argv[i].length() - 2;
                char[] tempCmd = new char[cmdLength];
                argv[i].getChars(2, argv[i].length(), tempCmd, 0);
                tempPtr = new String(tempCmd);
            } else if (++i < argc) {
                tempPtr = argv[i];
            } else {
                outputWriter.driverPrintError("Missing value for -" + option + "  option\n");
                return false;
            }
            switch (option) {
                case 'a': {
                    maxArgumentLen = 2047;
                    break;
                }
                case 'u': {
                    maxArgumentLen = 254;
                    break;
                }
                case 'p': {
                    maxArgumentLen = 30;
                    break;
                }
                case 'l': {
                    maxArgumentLen = 64;
                    break;
                }
                case 's': {
                    maxArgumentLen = 64;
                    break;
                }
                case 'd': 
                case 'x': {
                    maxArgumentLen = 255;
                    break;
                }
                case 't': {
                    maxArgumentLen = 15;
                    break;
                }
                case 'o': 
                case 'q': {
                    maxArgumentLen = 3;
                    break;
                }
                case 'g': {
                    maxArgumentLen = 10;
                    break;
                }
                case 'P': 
                case 'c': {
                    maxArgumentLen = 5;
                    break;
                }
                case 'S': {
                    maxArgumentLen = 6;
                }
            }
            if (tempPtr.length() > maxArgumentLen) {
                outputWriter.driverPrintError("Value for -" + option + "  option is too long: " + tempPtr + "\n");
                return false;
            }
            char[] tempCmd = null;
            switch (option) {
                case 'u': {
                    boolean authStringFound = false;
                    int j = 0;
                    for (j = 0; j < tempPtr.length(); ++j) {
                        if (tempPtr.charAt(j) != '\\') continue;
                        tempCmd = new char[j];
                        tempPtr.getChars(0, j, tempCmd, 0);
                        threadControlBlockPtr.setAuthentication(new String(tempCmd));
                        authStringFound = true;
                        break;
                    }
                    if (authStringFound) {
                        int cmdLength = tempPtr.length() - j - 1;
                        tempCmd = new char[cmdLength];
                        tempPtr.getChars(j + 1, tempPtr.length(), tempCmd, 0);
                        threadControlBlockPtr.setUser(new String(tempCmd));
                        continue block29;
                    }
                    threadControlBlockPtr.setUser(tempPtr);
                    continue block29;
                }
                case 'a': {
                    threadControlBlockPtr.setAuthentication(tempPtr);
                    continue block29;
                }
                case 'p': {
                    threadControlBlockPtr.setPassword(tempPtr);
                    continue block29;
                }
                case 'l': {
                    threadControlBlockPtr.setLocale(tempPtr);
                    continue block29;
                }
                case 't': {
                    threadControlBlockPtr.setTimeZone(tempPtr);
                    continue block29;
                }
                case 's': {
                    threadControlBlockPtr.setServer(tempPtr);
                    continue block29;
                }
                case 'P': {
                    threadControlBlockPtr.setPort(new Integer(tempPtr));
                    continue block29;
                }
                case 'S': {
                    threadControlBlockPtr.setPrivateRpcQueue(new Integer(tempPtr));
                    continue block29;
                }
                case 'x': {
                    this.openInputFile(tempPtr);
                    continue block29;
                }
                case 'o': {
                    this.setOutputSetting(tempPtr);
                    continue block29;
                }
                case 'd': {
                    resultDirectory = tempPtr;
                    continue block29;
                }
                case 'q': {
                    quietMode = new Integer(tempPtr);
                    continue block29;
                }
                case 'g': {
                    randomNumberSeed = new Integer(tempPtr);
                    continue block29;
                }
                case 'c': {
                    this.setOutputCount(tempPtr);
                }
            }
        }
        return true;
    }

    protected void setOutputSetting(String tempPtr) {
        ProxyManager.setConnectionLimits(maxConnectionPerServer);
    }

    protected void setOutputCount(String tempPtr) {
    }

    void getARServerUser() {
        try {
            InputReader.getARServerUser();
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (IllegalArgumentException e) {
            outputWriter.printString("Bad User or Password...\n");
        }
    }

    void openInputFile(String fileName) {
        try {
            InputReader.openInputFile(fileName);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void closeOutputFile() {
        outputWriter.closeOutputFile();
    }

    void openOutputFile() {
        try {
            String fileName = InputReader.getString("Filename of output file (): ", "");
            outputWriter.openOutputFile(fileName);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void startRecording() {
        String fileName = null;
        try {
            ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
            if (threadControlBlockPtr.getRecordFile() != null) {
                outputWriter.driverPrintWarning(" **** Recording already active; stop previous to start new\n");
            } else {
                fileName = InputReader.getString("Filename of record file (): ", "");
                if (fileName == null || fileName.length() == 0) {
                    outputWriter.driverPrintError(" **** No filename specified so no recording started\n");
                } else {
                    threadControlBlockPtr.setRecordFile(new PrintWriter(new FileOutputStream(new File(fileName))));
                }
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...or opening the file " + fileName + "  .\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void stopRecording() {
        try {
            ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
            if (threadControlBlockPtr.getRecordFile() == null) {
                outputWriter.driverPrintWarning(" **** Recording is not active\n");
            } else {
                threadControlBlockPtr.setRecordFile(null);
            }
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void beginLoop() {
        try {
            outputWriter.driverPrintHeader("BEGIN LOOP");
            ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
            if (threadControlBlockObject.isCurrentInputSourceStdInput()) {
                outputWriter.driverPrintError("\n*** Command must be issued from input file\n");
                return;
            }
            int numIterations = InputReader.getInt("Number of iterations (1): ", 1);
            if (numIterations <= 0) {
                numIterations = 1;
            }
            if (threadControlBlockObject.getCurrentLoopDepth() == MAX_NESTED_LOOP_DEPTH - 1) {
                outputWriter.driverPrintError("\n*** Maximum nested loop depth exceeded\n");
                threadControlBlockObject.incrementNumFailedBeginLoop();
                return;
            }
            threadControlBlockObject.incrementCurrentLoopDepth();
            threadControlBlockObject.setNumberOfIterations(threadControlBlockObject.getCurrentLoopDepth(), numIterations);
            threadControlBlockObject.setLoopBeginFilePos(threadControlBlockObject.getCurrentLoopDepth(), threadControlBlockObject.getCurrentInputFilePos());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void endLoop() throws IOException, FileNotFoundException {
        try {
            outputWriter.driverPrintHeader("END LOOP");
            ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
            if (threadControlBlockObject.isCurrentInputSourceStdInput()) {
                outputWriter.driverPrintError("\n*** Command must be issued from input file\n");
                return;
            }
            if (threadControlBlockObject.getCurrentLoopDepth() < 0) {
                outputWriter.driverPrintWarning("\n*** Command ignored because no corresponding begin loop issued\n");
                return;
            }
            if (threadControlBlockObject.getNumFailedBeginLoop() > 0) {
                outputWriter.driverPrintWarning("\n*** Command ignored because previous begin loop failed\n");
                threadControlBlockObject.reduceNumFailedBeginLoop();
                return;
            }
            long numIterations = threadControlBlockObject.getNumberOfIterations(threadControlBlockObject.getCurrentLoopDepth());
            threadControlBlockObject.reduceNumberOfIterations(threadControlBlockObject.getCurrentLoopDepth());
            if (numIterations - 1L > 0L) {
                int loopDepth = threadControlBlockObject.getCurrentLoopDepth();
                long filePosition = threadControlBlockObject.getLoopBeginFilePos(loopDepth);
                threadControlBlockObject.setCurrentInputFileReadingPostion(filePosition);
            } else {
                threadControlBlockObject.reduceCurrentLoopDepth();
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void setLogging() {
        try {
            boolean enable = InputReader.getBooleanForChangingInfo("enable logging? (T):", true);
            long logType = 0L;
            long whereToLog = 0L;
            String fileName = null;
            if (enable) {
                logType = InputReader.getLong("Logging Type NONE(0), SQL(1), Filter(2), API(16)? (0): ", 0L);
                whereToLog = InputReader.getLong("Return logging records to file(1), status list(2)? (1): ", 1L);
                if ((int)(whereToLog & 1L) == 1) {
                    fileName = InputReader.getString("Name of file to hold returned records: ", "");
                }
            }
            LoggingInfo info = new LoggingInfo(enable, logType, whereToLog, fileName);
            this.getControlStructObject().setLogging(info);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createForm() {
        try {
            outputWriter.driverPrintHeader("CREATE SCHEMA");
            Form form = InputReader.getForm();
            String formName = InputReader.getString("Form Name: ");
            form.setName(formName);
            List<PermissionInfo> permissions = InputReader.getPermissionInfoList(false);
            form.setPermissions(permissions);
            outputWriter.driverPrintHeader("Ids of sub admin groups allowed to access form:");
            List<Integer> adminGroupList = InputReader.getIntegerList();
            form.setAdminGrpList(adminGroupList);
            List<EntryListFieldInfo> fldInfos = InputReader.getEntryListFieldInfoList();
            form.setEntryListFieldInfo(fldInfos);
            List<SortInfo> sortarr = InputReader.getSortInfoList();
            form.setSortInfo(sortarr);
            List<IndexInfo> index = InputReader.getIndexInfoList();
            form.setIndexInfo(index);
            if (InputReader.getBooleanForChangingInfo("Change archive info? (F): ", false)) {
                ArchiveInfo archive = InputReader.getArchiveInfo();
                form.setArchiveInfo(archive);
            }
            if (InputReader.getBooleanForChangingInfo("Do you want to specify associations to follow for archive ? (F): ", false)) {
                AssociationsToFollow assocsToFollow = InputReader.getAssociationsToFollow();
                form.setAssociationToFollowForArchive(assocsToFollow);
            }
            if (InputReader.getBooleanForChangingInfo("Change audit info? (F): ", false)) {
                AuditInfo auditInfo = InputReader.getAuditInfo();
                form.setAuditInfo(auditInfo);
            }
            String vuiName = InputReader.getString("   Default VUI  ");
            form.setDefaultVUI(vuiName);
            String helpText = InputReader.getString("Help Text:", "");
            form.setHelpText(helpText);
            String ownerID = InputReader.getString("Owner:");
            form.setOwner(ownerID);
            String diary = InputReader.getString("Change DiaryList:", "");
            form.appendDiaryText(diary);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            form.setProperties(propList);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().createForm(form, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Form Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteForm() {
        try {
            outputWriter.driverPrintHeader("DELETE SCHEMA");
            String formName = InputReader.getString("Form Name: ");
            int deleteOption = InputReader.getInt("Delete option ? ( 0, 1, 2, 4, 8 ) ( 0 ):", 0);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().deleteForm(formName, deleteOption, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Form Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getForm() {
        try {
            String formName = InputReader.getString("Form Name:", "");
            FormCriteria criteria = new FormCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            Form form = this.getControlStructObject().getForm(formName, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Form Information...", form);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Form Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleForms() {
        try {
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            FormType formType = InputReader.getFormType();
            boolean hidden = InputReader.getBooleanForChangingInfo("Include hidden forms (T):", true);
            if (hidden && formType != null) {
                formType.setHiddenIncrement();
            }
            outputWriter.driverPrintPrompt("Ids of fields, which must be on the form:\n");
            int[] fieldIds = InputReader.getIntArray();
            this.beginAPICall();
            FormCriteria criteria = new FormCriteria();
            criteria.setRetrieveAll(true);
            List<Form> formList = null;
            if (formType != null) {
                formList = this.getControlStructObject().getListFormObjects(changedSince, formType.toInt(), null, fieldIds, criteria);
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (formList != null) {
                outputWriter.print("", "Total number of forms: ", formList.size());
                for (int i = 0; i < formList.size(); ++i) {
                    Form form = formList.get(i);
                    outputWriter.print("    ", "Form: ", form);
                }
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListForm Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListForm() {
        try {
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            FormType formType = InputReader.getFormType();
            boolean includeHidden = InputReader.getBooleanForChangingInfo("Include hidden forms (T):", true);
            String formName = null;
            formName = formType != null && (formType.equals(FormType.UPLINK) || formType.equals(FormType.DOWNLINK) || formType.equals(FormType.ARCHIVE_DOWNLINK)) ? InputReader.getString("Form name (): ", "") : "";
            int intFormType = includeHidden ? formType.toInt() | 0x400 : formType.toInt();
            outputWriter.driverPrintPrompt("Ids of fields, which must be on the form:\n");
            int[] fieldIds = InputReader.getIntArray();
            outputWriter.driverPrintPrompt("list of props to search for:\n");
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<String> formList = this.getControlStructObject().getListForm(changedSince, intFormType, formName, fieldIds, propList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Schama name List: ", formList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListForm Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setForm() {
        try {
            Form form = new RegularForm();
            if (InputReader.getBooleanForChangingInfo("Change compound form info? (F): ", false)) {
                form = InputReader.getForm();
            }
            String name = InputReader.getString("Form Name: ");
            form.setName(name);
            if (InputReader.getBooleanForChangingInfo("Change form name? (F): ", false)) {
                String newName = InputReader.getString("Form name: ");
                form.setNewName(newName);
            }
            if (InputReader.getBooleanForChangingInfo("Change group list? (F): ", false)) {
                List<PermissionInfo> permissions = InputReader.getPermissionInfoList(true);
                form.setPermissions(permissions);
            }
            if (InputReader.getBooleanForChangingInfo("Change sub admin group list? (F): ", false)) {
                outputWriter.driverPrintHeader("Ids of sub admin groups allowed to access form:");
                List<Integer> id = InputReader.getIntegerList();
                form.setAdminGrpList(id);
            }
            if (InputReader.getBooleanForChangingInfo("Change query list fields? (F): ", false)) {
                List<EntryListFieldInfo> fldInfos = InputReader.getEntryListFieldInfoList();
                form.setEntryListFieldInfo(fldInfos);
            }
            if (InputReader.getBooleanForChangingInfo("Change sort list? (F): ", false)) {
                List<SortInfo> sortarr = InputReader.getSortInfoList();
                form.setSortInfo(sortarr);
            }
            if (InputReader.getBooleanForChangingInfo("Change index list? (F): ", false)) {
                List<IndexInfo> index = InputReader.getIndexInfoList();
                form.setIndexInfo(index);
            }
            if (InputReader.getBooleanForChangingInfo("Change archive info? (F): ", false)) {
                ArchiveInfo archive = InputReader.getArchiveInfo();
                form.setArchiveInfo(archive);
            }
            if (InputReader.getBooleanForChangingInfo("Change association list to follow for archive? (F): ", false)) {
                AssociationsToFollow associationToFollowForArchive = InputReader.getAssociationsToFollow();
                form.setAssociationToFollowForArchive(associationToFollowForArchive);
            }
            if (InputReader.getBooleanForChangingInfo("Change audit info? (F): ", false)) {
                AuditInfo auditInfo = InputReader.getAuditInfo();
                form.setAuditInfo(auditInfo);
            }
            if (InputReader.getBoolean("Change default VUI? (F): ", false)) {
                String vuiName = InputReader.getString("   Default VUI  ");
                form.setDefaultVUI(vuiName);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String help = InputReader.getString("Help Text (): ", "");
                form.setHelpText(help);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String owner = InputReader.getString("New Owner");
                form.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                String diary = InputReader.getString("Change DiaryList (): ", "");
                form.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                form.setProperties(propList);
            }
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().setForm(form, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Form Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getEntry() {
        try {
            outputWriter.driverPrintHeader("GET ENTRY");
            EntryKey entryKey = this.getAndConvertEntryKey();
            int[] entryListFields = InputReader.getIntArray();
            this.beginAPICall();
            Entry entry = this.getControlStructObject().getEntry(entryKey.getFormName(), entryKey.getEntryID(), entryListFields);
            List<StatusInfo> statusList1 = this.getControlStructObject().getLastStatus();
            this.endAPICall(statusList1);
            outputWriter.printEntry("", "Entry Information:", entry);
            List<StatusInfo> statusList2 = this.getControlStructObject().getLastStatus();
            statusList1.addAll(statusList1.size(), statusList2);
            outputWriter.printStatusInfoList("", "Get Entry Status", statusList1);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    protected EntryKey getAndConvertEntryKey() throws IOException {
        return InputReader.getEntryKey();
    }

    void setEntry() {
        try {
            outputWriter.driverPrintHeader("SET  ENTRY");
            EntryKey entryKey = InputReader.getEntryKey();
            outputWriter.driverPrintPrompt("Field/value pairs to set:\n");
            Entry entry = InputReader.getEntry();
            Timestamp getTime = new Timestamp(InputReader.getLong("Time of Get operation (0): ", 0L));
            int option = InputReader.getInt("SetEntry option ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().setEntry(entryKey.getFormName(), entryKey.getEntryID(), entry, getTime, option);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "SetEntry Status", statusList);
        }
        catch (IOException x) {
            outputWriter.printString("Problem in getting the input for set entry...\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    public void createEntry() {
        Entry entry = null;
        try {
            outputWriter.driverPrintHeader("CREATE ENTRY");
            String formName = InputReader.getString("Form Name: ");
            outputWriter.driverPrintHeader("Field/value pairs to create:");
            entry = InputReader.getEntry();
            this.beginAPICall();
            this.getControlStructObject().createEntry(formName, entry);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("Entry id: " + entry.getEntryId());
            outputWriter.printNewLine();
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Entry Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void executeService() {
        try {
            outputWriter.driverPrintHeader("EXECUTE SERVICE");
            String formName = InputReader.getString("Form Name: ");
            String entryId = InputReader.getString("Entry ID:", null);
            outputWriter.driverPrintPrompt("Field/value pairs to set:\n");
            Entry entry = InputReader.getEntry();
            int[] entryListFields = InputReader.getIntArray();
            this.beginAPICall();
            entry = this.getControlStructObject().executeService(formName, entryId, entry, entryListFields);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            this.endAPICall(statusList);
            outputWriter.printEntry("", "Entry Information:", entry);
            outputWriter.printStatusInfoList("", "executeService Status", statusList);
        }
        catch (IOException x) {
            outputWriter.printString("Problem in getting the input for executeService input entry...\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void xmlExecuteService() {
        try {
            outputWriter.driverPrintHeader("XML EXECUTE SERVICE");
            String queryMapping = InputReader.getFileContent("Filename containing XML query mapping: ", null, 3, outputWriter);
            if (queryMapping == null) {
                return;
            }
            String queryDoc = InputReader.getFileContent("Filename containing XML query document: ", null, 3, outputWriter);
            if (queryDoc == null) {
                return;
            }
            String inputMapping = InputReader.getFileContent("Filename containing XML input mapping: ", null, 3, outputWriter);
            if (inputMapping == null) {
                return;
            }
            String inputDoc = InputReader.getFileContent("Filename containing XML input document: ", null, 3, outputWriter);
            if (inputDoc == null) {
                return;
            }
            String outputMapping = InputReader.getFileContent("Filename containing XML output mapping: ", null, 3, outputWriter);
            if (outputMapping == null) {
                return;
            }
            String optionDoc = InputReader.getFileContent("Filename containing XML option document: ", null, 3, outputWriter);
            if (optionDoc == null) {
                return;
            }
            String xmlOutputDoc = null;
            this.beginAPICall();
            xmlOutputDoc = this.getControlStructObject().xmlExecuteService(queryMapping, queryDoc, inputMapping, inputDoc, outputMapping, optionDoc);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "XMLExecuteService Results", statusList);
            if (xmlOutputDoc != null) {
                outputWriter.printString(xmlOutputDoc);
            } else {
                outputWriter.printString("xmlOutputDoc is null...\n");
            }
        }
        catch (NullPointerException e) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteEntry() {
        try {
            outputWriter.driverPrintHeader("DELETE ENTRY");
            EntryKey key = InputReader.getEntryKey();
            int deleteOption = InputReader.getInt("DeleteEntry option ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteEntry(key.getFormName(), key.getEntryID(), deleteOption);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Entry", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleEntries() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ENTRIES");
            String formName = InputReader.getString("Form Name (): ", "");
            List<String> entryIdList = InputReader.getStringList("", "Entry Id");
            outputWriter.driverPrintPrompt("Ids of fields to retrieve:\n");
            int[] fieldIdList = InputReader.getIntArray();
            this.beginAPICall();
            List<Entry> entries = this.getControlStructObject().getListEntryObjects(formName, entryIdList, fieldIdList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Entry List: ", entries);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetMultipleEntries Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListEntry() {
        try {
            outputWriter.driverPrintHeader("GETLIST ENTRY");
            String formName = InputReader.getString("Form Name (): ", "");
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            List<EntryListFieldInfo> entryListFields = InputReader.getEntryListFieldInfoList();
            List<SortInfo> sortOrder = InputReader.getSortInfoList();
            int firstRetrieve = InputReader.getInt("firstRetrieve (0): ", 0);
            int limit = InputReader.getInt("Maximum Number of Entries to retrieve (500):", 500);
            OutputInteger matches = null;
            if (InputReader.getBooleanForChangingInfo("Get number of matches? (F): ", false)) {
                matches = new OutputInteger(0);
            }
            boolean useLocaleFlag = InputReader.getBooleanForChangingInfo("Use Locale Sensitive Search(F):", false);
            this.beginAPICall();
            List<EntryListInfo> entryInfoList = this.getControlStructObject().getListEntry(formName, qualifier, firstRetrieve, limit, sortOrder, entryListFields, useLocaleFlag, matches);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Entry List:", entryInfoList);
            if (matches != null) {
                outputWriter.printInteger("", "Number of Matches:", matches);
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListEntry Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListEntryWithFields() {
        try {
            outputWriter.driverPrintHeader("GETLIST ENTRY WITH FIELDS");
            String formName = InputReader.getString("Form Name (): ", "");
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            int[] fieldIdList = InputReader.getIntArray();
            List<SortInfo> sortOrder = InputReader.getSortInfoList();
            int firstRetrieve = InputReader.getInt("firstRetrieve (0): ", 0);
            int limit = InputReader.getInt("Maximum Number of Entries to retrieve (500):", 500);
            OutputInteger matches = null;
            if (InputReader.getBooleanForChangingInfo("Get number of matches? (F): ", false)) {
                matches = new OutputInteger(0);
            }
            boolean useLocaleFlag = InputReader.getBooleanForChangingInfo("Use Locale Sensitive Search(F):", false);
            this.beginAPICall();
            List<Entry> entries = this.getControlStructObject().getListEntryObjects(formName, qualifier, firstRetrieve, limit, sortOrder, fieldIdList, useLocaleFlag, matches);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Entry List: ", entries);
            if (matches != null) {
                outputWriter.printInteger("", "Number of Matches:", matches);
            }
            ThreadControlBlock threadControlBlockObj = JavaDriver.getThreadControlBlockPtr();
            threadControlBlockObj.resetListIds();
            if (entries.size() > 0) {
                threadControlBlockObj.setFirstListId(entries.get(0).getEntryId());
                if (entries.size() > 1) {
                    threadControlBlockObj.setSecondListId(entries.get(1).getEntryId());
                } else {
                    threadControlBlockObj.setSecondListId(entries.get(0).getEntryId());
                }
                threadControlBlockObj.setLastListId(entries.get(entries.size() - 1).getEntryId());
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListEntryWithFields Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListEntryWithMultiSchemaFields() {
        try {
            outputWriter.driverPrintHeader("GETLIST ENTRY WITH MULTISCHEMA FIELDS");
            RegularQuery query = InputReader.getRegularQuery();
            int firstRetrieve = InputReader.getInt("First Entry to retrieve (0): ", 0);
            int limit = InputReader.getInt("Maximum Number of Entries to retrieve (500):", 500);
            OutputInteger matches = null;
            if (InputReader.getBooleanForChangingInfo("Get Number of Matches? (F): ", false)) {
                matches = new OutputInteger(0);
            }
            boolean useLocaleFlag = InputReader.getBooleanForChangingInfo("Use Locale Sensitive Search(F):", false);
            this.beginAPICall();
            List<QuerySourceValues> entries = this.getControlStructObject().getListEntryObjects(query, firstRetrieve, limit, useLocaleFlag, matches);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Query Source Values List: ", entries);
            if (matches != null) {
                outputWriter.printInteger("", "Number of Matches:", matches);
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListEntryWithMultiSchemaFields Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getOneEntryWithFields() {
        try {
            outputWriter.driverPrintHeader("GETONE ENTRY WITH FIELDS");
            String formName = InputReader.getString("Form Name (): ", "");
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            int[] fieldIdList = InputReader.getIntArray();
            List<SortInfo> sortOrder = InputReader.getSortInfoList();
            OutputInteger matches = null;
            if (InputReader.getBooleanForChangingInfo("Get number of matches? (F): ", false)) {
                matches = new OutputInteger(0);
            }
            boolean useLocaleFlag = InputReader.getBooleanForChangingInfo("Use Locale Sensitive Search(F):", false);
            this.beginAPICall();
            Entry entryObj = this.getControlStructObject().getOneEntryObject(formName, qualifier, sortOrder, fieldIdList, useLocaleFlag, matches);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Entry: ", entryObj);
            if (matches != null) {
                outputWriter.printInteger("", "Number of Matches:", matches);
            }
            ThreadControlBlock threadControlBlockObj = JavaDriver.getThreadControlBlockPtr();
            threadControlBlockObj.resetListIds();
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetOneEntryWithFields Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getCacheEvent() {
        try {
            outputWriter.driverPrintHeader("GET CACHE EVENT");
            int[] cacheEventIds = InputReader.getIntArray();
            int returnOption = InputReader.getInt("Return Option: Immediate, Next (0-1) (0):", 0);
            OutputInteger cacheCount = new OutputInteger(0);
            this.beginAPICall();
            List<Integer> cacheEventIdList = this.getControlStructObject().getCacheEvent(cacheEventIds, returnOption, cacheCount);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (cacheEventIdList != null) {
                outputWriter.printInteger("", "Number of Events Occured:", cacheEventIdList.size());
            }
            for (int i = 0; i < cacheEventIdList.size(); ++i) {
                outputWriter.printInteger("", "Event ID :", cacheEventIdList.get(i));
            }
            outputWriter.printInteger("", "Number of Matches:", cacheCount.intValue());
            ThreadControlBlock threadControlBlockObj = JavaDriver.getThreadControlBlockPtr();
            threadControlBlockObj.resetListIds();
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetCacheEvent Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListEntryBlocks() {
        try {
            outputWriter.driverPrintHeader("GETLIST ENTRY BLOCKS");
            String formName = InputReader.getString("Form Name (): ", "");
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            int[] fieldIdList = InputReader.getIntArray();
            List<SortInfo> sortOrder = InputReader.getSortInfoList();
            int firstRetrieve = InputReader.getInt("firstRetrieve (0): ", 0);
            int limit = InputReader.getInt("Maximum Number of Entries to retrieve (500):", 500);
            OutputInteger matches = null;
            if (InputReader.getBooleanForChangingInfo("Get number of matches? (F): ", false)) {
                matches = new OutputInteger(0);
            }
            boolean useLocaleFlag = InputReader.getBooleanForChangingInfo("Use Locale Sensitive Search(F):", false);
            this.beginAPICall();
            RowIterator ri = new RowIterator();
            this.getControlStructObject().getListEntryObjects(formName, qualifier, firstRetrieve, limit, sortOrder, fieldIdList, useLocaleFlag, matches, ri);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (matches != null) {
                outputWriter.printInteger("", "Number of Matches:", matches);
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    public void mergeEntry() {
        try {
            outputWriter.driverPrintHeader("MERGE ENTRY");
            String form = InputReader.getString("Form Name: ");
            outputWriter.driverPrintHeader("Field/value pairs to merge:");
            Entry entry = InputReader.getEntry();
            int mergeType = InputReader.getInt("Operation on duplicate entry (error, new ID, overwrite, merge) (1-4): ", 4);
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            int multimatchOption = InputReader.getInt("Multi Match Options (do nothing, change first)(0-1):", 0);
            this.beginAPICall();
            this.getControlStructObject().mergeEntry(form, entry, mergeType, qualifier, multimatchOption);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("Entry id: " + entry.getEntryId());
            outputWriter.printNewLine();
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Merge Entry Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createField() {
        try {
            outputWriter.driverPrintHeader("CREATE FIELD");
            String formName = InputReader.getString("Form Name: ");
            int id = InputReader.getInt("Field id (0): ", 0);
            boolean reservedID = InputReader.getBoolean("Create even if ID is reserved? (F): ", false);
            String fieldName = InputReader.getString("Field Name: ");
            Field field = InputReader.getField();
            field.setForm(formName);
            field.setFieldID(id);
            field.setReservedIDOK(reservedID);
            field.setName(fieldName);
            int option = InputReader.getInt("Required, Optional, System, or Display-only (1-4) (2): ", 2);
            field.setFieldOption(option);
            int createMode = InputReader.getInt("Open or Protected at create (1 or 2) (1): ", 1);
            field.setCreateMode(createMode);
            int auditOption = InputReader.getInt("Field option for Audit/Copy (0): ", 0);
            field.setAuditOption(auditOption);
            int type = field.getDataType();
            if (InputReader.getBooleanForChangingInfo("Have new default value? (F): ", false)) {
                Value val = InputReader.getValue(type);
                field.setDefaultValue(val);
            }
            List<PermissionInfo> permissions = InputReader.getPermissionInfoList(true);
            field.setPermissions(permissions);
            if (InputReader.getBooleanForChangingInfo("Have field limits? (T): ", true)) {
                FieldLimit limitInfo = InputReader.getFieldLimitInfo(type);
                field.setFieldLimit(limitInfo);
            }
            DisplayInstanceMap dispInstanceList = InputReader.getDisplayInstanceMap();
            field.setDisplayInstance(dispInstanceList);
            String helpText = InputReader.getString("Help Text: ", "");
            field.setHelpText(helpText);
            String owner = InputReader.getString("Owner:");
            field.setOwner(owner);
            String diary = InputReader.getString("DiaryList: ", "");
            field.appendDiaryText(diary);
            FieldMapping mapInfo = InputReader.getFieldMappingInfo();
            field.setFieldMap(mapInfo);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            field.setObjectProperty(propList);
            this.beginAPICall();
            this.getControlStructObject().createField(field, true);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "CreateField Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createMultipleFields() {
        try {
            outputWriter.driverPrintHeader("CREATE MULTIPLE FIELDS");
            String formName = InputReader.getString("Form name: ");
            int noOfFields = InputReader.getInt("Number of Fields (0): ", 0);
            ArrayList<Field> fields = new ArrayList<Field>(noOfFields);
            for (int index = 0; index < noOfFields; ++index) {
                outputWriter.driverPrintHeader("Enter information for field(" + (index + 1) + ")");
                int id = InputReader.getInt("Field id (0): ", 0);
                boolean reservedID = InputReader.getBooleanForChangingInfo("Create even if ID is reserved? (F): ", false);
                String fieldName = InputReader.getString("Field Name: ");
                Field field = InputReader.getField();
                field.setForm(formName);
                field.setFieldID(id);
                field.setReservedIDOK(reservedID);
                field.setName(fieldName);
                int option = InputReader.getInt("Required, Optional, System, or Display-only (1-4) (2): ", 2);
                field.setFieldOption(option);
                int createMode = InputReader.getInt("Open or Protected at create (1 or 2) (1): ", 1);
                field.setCreateMode(createMode);
                int auditOption = InputReader.getInt("Field option for Audit/Copy (0): ", 0);
                field.setAuditOption(auditOption);
                int type = field.getDataType();
                if (InputReader.getBooleanForChangingInfo("Have new default value? (F): ", false)) {
                    Value val = InputReader.getValue(type);
                    field.setDefaultValue(val);
                }
                List<PermissionInfo> permissions = InputReader.getPermissionInfoList(true);
                field.setPermissions(permissions);
                if (InputReader.getBooleanForChangingInfo("Have field limits? (T): ", true)) {
                    FieldLimit limitInfo = InputReader.getFieldLimitInfo(type);
                    field.setFieldLimit(limitInfo);
                }
                DisplayInstanceMap dispInstanceList = InputReader.getDisplayInstanceMap();
                field.setDisplayInstance(dispInstanceList);
                String helpText = InputReader.getString("Help Text: ", "");
                field.setHelpText(helpText);
                String owner = InputReader.getString("Owner:");
                field.setOwner(owner);
                String diary = InputReader.getString("DiaryList: ", "");
                field.appendDiaryText(diary);
                FieldMapping mapInfo = InputReader.getFieldMappingInfo();
                field.setFieldMap(mapInfo);
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                field.setObjectProperty(propList);
                fields.add(field);
            }
            this.beginAPICall();
            this.getControlStructObject().createMultipleFields(fields);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Multiple Fields Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteField() {
        try {
            outputWriter.driverPrintHeader("DELETE FIELD");
            String formName = InputReader.getString("Form Name: ");
            int fieldId = InputReader.getInt("Field id (0):", 0);
            int deleteOption = InputReader.getInt("Delete option - clean, data, cascade (0 - 2) (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteField(formName, fieldId, deleteOption);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "DeleteField Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteMultipleFields() {
        try {
            outputWriter.driverPrintHeader("DELETE MULTIPLE FIELDS");
            String formName = InputReader.getString("Form Name: ");
            outputWriter.driverPrintPrompt("Ids of fields to delete:\n");
            int[] idList = InputReader.getIntArray();
            int deleteOption = InputReader.getInt("Delete Option- clean, data, cascade (0, 1, 2 ) (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteFields(formName, idList, deleteOption);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Multiple Fields  Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getField() {
        try {
            outputWriter.driverPrintHeader("GET FIELD");
            String formName = InputReader.getString("Form Name: ");
            int id = InputReader.getInt("Field id (1): ", 1);
            FieldKey key = new FieldKey(formName, id);
            FieldCriteria crit = new FieldCriteria();
            crit.setRetrieveAll(true);
            this.beginAPICall();
            Field field = this.getControlStructObject().getField(key.getFormName(), key.getFieldID(), crit);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printField("", "Field Information:", field);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Field Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListField() {
        try {
            outputWriter.driverPrintHeader("GET LIST FIELD");
            String name = InputReader.getString("Form Name (): ", "");
            long changedSince = InputReader.getLong("Get all changed since ", 0L);
            int type = InputReader.getInt("Field Type - data, trim, control, page, page holder, table, column, attach,\n attach pool  (1, 2, 4, 8, 16, 32, 64, 128, 256) (1): ", 1);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<Integer> fieldList = this.getControlStructObject().getListField(name, type, changedSince, propList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Field ID List:", fieldList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List Field Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setField() {
        try {
            outputWriter.driverPrintHeader("SET FIELD");
            String formName = InputReader.getString("Form name: ");
            int id = InputReader.getInt("Field id (1): ", 1);
            Field field = InputReader.getField();
            field.setForm(formName);
            field.setFieldID(id);
            if (InputReader.getBooleanForChangingInfo("Change fieldName? (F): ", false)) {
                String fieldName = InputReader.getString("field name");
                field.setNewName(fieldName);
            }
            if (InputReader.getBooleanForChangingInfo("Change field mapping? (F): ", false)) {
                FieldMapping mapInfo = InputReader.getFieldMappingInfo();
                field.setFieldMap(mapInfo);
            }
            if (InputReader.getBooleanForChangingInfo("Have new option? (F): ", false)) {
                int option = InputReader.getInt("Required, Optional, System, or Display-only (1-4) (2): ", 2);
                field.setFieldOption(option);
            }
            if (InputReader.getBooleanForChangingInfo("Have new create mode? (F): ", false)) {
                int createMode = InputReader.getInt("Open or Protected at create (1 or 2) (1) ", 1);
                field.setCreateMode(createMode);
            }
            if (InputReader.getBooleanForChangingInfo("Have new field option? (F): ", false)) {
                int auditOption = InputReader.getInt("Field option for Audit/Copy (0): ", 0);
                field.setAuditOption(auditOption);
            }
            int type = field.getDataType();
            if (InputReader.getBooleanForChangingInfo("Have new default value? (F): ", false)) {
                Value val = InputReader.getValue(type);
                field.setDefaultValue(val);
            }
            if (InputReader.getBooleanForChangingInfo("Have new permissions? (F): ", false)) {
                List<PermissionInfo> permissions = InputReader.getPermissionInfoList(true);
                field.setPermissions(permissions);
            }
            if (InputReader.getBooleanForChangingInfo("Have new field limits? (F): ", false)) {
                FieldLimit limitInfo = InputReader.getFieldLimitInfo(type);
                field.setFieldLimit(limitInfo);
            }
            if (InputReader.getBooleanForChangingInfo("Have new display instance? (F): ", false)) {
                DisplayInstanceMap dispInstanceList = InputReader.getDisplayInstanceMap();
                field.setDisplayInstance(dispInstanceList);
            }
            if (InputReader.getBooleanForChangingInfo("Have a new set field option for display instance? (F): ", false)) {
                int setFieldsOptions = InputReader.getInt("Replace only new display instances(1) or Replace all display instances(0) ", 1);
                field.setSetFieldOptions(setFieldsOptions);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String helpText = InputReader.getString("Help Text: ", "");
                field.setHelpText(helpText);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String owner = InputReader.getString("Owner: ");
                field.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                String diary = InputReader.getString("DiaryList: ", "");
                field.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                field.setObjectProperty(propList);
            }
            this.beginAPICall();
            this.getControlStructObject().setField(field);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Field Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setMultipleFields() {
        try {
            outputWriter.driverPrintHeader("SET MULTIPLE FIELDS");
            int noOfFields = InputReader.getInt("Number of Fields (0): ", 0);
            ArrayList<Field> fields = new ArrayList<Field>(noOfFields);
            String formName = InputReader.getString("Form name: ");
            for (int index = 0; index < noOfFields; ++index) {
                outputWriter.driverPrintHeader("Enter information for field(" + (index + 1) + ")");
                int id = InputReader.getInt("Field id (1): ", 1);
                Field field = InputReader.getField();
                field.setForm(formName);
                field.setFieldID(id);
                if (InputReader.getBooleanForChangingInfo("Change fieldName? (F): ", false)) {
                    String fieldName = InputReader.getString("field name");
                    field.setNewName(fieldName);
                }
                if (InputReader.getBooleanForChangingInfo("Change field mapping? (F): ", false)) {
                    FieldMapping mapInfo = InputReader.getFieldMappingInfo();
                    field.setFieldMap(mapInfo);
                }
                if (InputReader.getBooleanForChangingInfo("Have new option? (F): ", false)) {
                    int option = InputReader.getInt("Required, Optional, System, or Display-only (1-4) (2): ", 2);
                    field.setFieldOption(option);
                }
                if (InputReader.getBooleanForChangingInfo("Have new create mode? (F): ", false)) {
                    int createMode = InputReader.getInt("Open or Protected at create (1 or 2) (1) ", 1);
                    field.setCreateMode(createMode);
                }
                if (InputReader.getBooleanForChangingInfo("Have new field option? (F): ", false)) {
                    int auditOption = InputReader.getInt("Field option for Audit/Copy (0): ", 0);
                    field.setAuditOption(auditOption);
                }
                int type = field.getDataType();
                if (InputReader.getBooleanForChangingInfo("Have new default value? (F): ", false)) {
                    Value val = InputReader.getValue(type);
                    field.setDefaultValue(val);
                }
                if (InputReader.getBooleanForChangingInfo("Have new permissions? (F): ", false)) {
                    List<PermissionInfo> permissions = InputReader.getPermissionInfoList(true);
                    field.setPermissions(permissions);
                }
                if (InputReader.getBooleanForChangingInfo("Have new field limits? (F): ", false)) {
                    FieldLimit limitInfo = InputReader.getFieldLimitInfo(type);
                    field.setFieldLimit(limitInfo);
                }
                if (InputReader.getBooleanForChangingInfo("Have new display instance? (F): ", false)) {
                    DisplayInstanceMap dispInstanceList = InputReader.getDisplayInstanceMap();
                    field.setDisplayInstance(dispInstanceList);
                }
                if (InputReader.getBooleanForChangingInfo("Have a new set field option for display instance? (F): ", false)) {
                    int setFieldsOptions = InputReader.getInt("Replace only new display instances(1) or Replace all display instances(0) ", 1);
                    field.setSetFieldOptions(setFieldsOptions);
                }
                if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                    String helpText = InputReader.getString("Help Text: ", "");
                    field.setHelpText(helpText);
                }
                if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                    String owner = InputReader.getString("Owner: ");
                    field.setOwner(owner);
                }
                if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                    String diary = InputReader.getString("DiaryList: ", "");
                    field.appendDiaryText(diary);
                }
                if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                    ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                    field.setObjectProperty(propList);
                }
                fields.add(field);
            }
            this.beginAPICall();
            this.getControlStructObject().setMultipleFields(fields);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<List<StatusInfo>> statusList = this.getControlStructObject().getMultiLastStatus();
            statusList.add(this.getControlStructObject().getLastStatus());
            outputWriter.printMultiStatusInfoList("", "Set Multiple Fields Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createCharMenu() {
        try {
            outputWriter.driverPrintHeader("CREATE CHAR MENU");
            Menu menu = InputReader.getMenu();
            String menuName = InputReader.getString("Character Menu Name");
            menu.setName(menuName);
            int refreshCode = InputReader.getInt("Refresh on connect, open, interval (1 - 3) (1): ", 1);
            menu.setRefreshCode(refreshCode);
            String helpText = InputReader.getString("Help Text():", "");
            menu.setHelpText(helpText);
            String owner = InputReader.getString("Owner:");
            menu.setOwner(owner);
            String changeDiary = InputReader.getString("Change DiaryList():", "");
            menu.appendDiaryText(changeDiary);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            menu.setProperties(propList);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().createMenu(menu, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "CreateCharMenu Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteCharMenu() {
        try {
            outputWriter.driverPrintHeader("DELETE CHAR MENU");
            String menuName = InputReader.getString("Character Menu Name");
            int deleteOption = InputReader.getInt("Delete option ? ( 0, 1, 2 ) ( 0 ):", 0);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().deleteMenu(menuName, deleteOption, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "DeleteCharMenu", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getCharMenu() {
        try {
            outputWriter.driverPrintHeader("GET CHAR MENU");
            String key = InputReader.getString("Menu Name:", "");
            MenuCriteria crit = new MenuCriteria();
            crit.setRetrieveAll(true);
            this.beginAPICall();
            Menu menu = this.getControlStructObject().getMenu(key, crit);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printMenu("", "Menu Information: ", menu);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetCharMenu Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListCharMenu() {
        try {
            outputWriter.driverPrintHeader("GET LIST CHAR MENU");
            long changedSince = InputReader.getLong("Get all changed since (0): ", 0L);
            outputWriter.driverPrintHeader("Get menus associated with forms:");
            List<String> formKeys = InputReader.getStringList("", "Form Name");
            outputWriter.driverPrintHeader("Get menus associated with active links:");
            List<String> activeLinkKeys = InputReader.getStringList("", "Active Link Name");
            ObjectPropertyMap propMap = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<String> menuList = this.getControlStructObject().getListMenu(changedSince, formKeys, activeLinkKeys, propMap);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Menu List Information: ", menuList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List Char Menu Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleCharMenu() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE CHAR MENUS");
            long changedSince = InputReader.getLong("Get all changed since (0): ", 0L);
            outputWriter.driverPrintHeader("Get char menu by name:");
            List<String> menuKeys = InputReader.getStringList("", "char menu Name");
            MenuCriteria crit = new MenuCriteria();
            crit.setRetrieveAll(true);
            this.beginAPICall();
            List<Menu> menuList = this.getControlStructObject().getListMenuObjects(changedSince, menuKeys, crit);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Multiple Menu Information: ", menuList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Multiple Char Menu Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void expandCharMenu() {
        try {
            outputWriter.driverPrintHeader("EXPAND CHAR MENU");
            Entry keywordList = null;
            Entry parameterList = null;
            Menu menu = InputReader.getMenu();
            if (menu.getName() != null && menu.getName().length() != 0) {
                outputWriter.driverPrintPrompt("      Keyword List:\n");
                keywordList = InputReader.getEntry();
                outputWriter.driverPrintPrompt("      Parameter List:\n");
                parameterList = InputReader.getEntry();
                outputWriter.driverPrintPrompt("      Extern List:\n");
                InputReader.getQualifierInfoList();
                ((SqlMenu)menu).setServer(InputReader.getString("      Server (): ", ""));
                InputReader.getString("      Form Name (): ", "");
            }
            int maxRetrieve = InputReader.getInt("Number of entries to retrieve:", 0);
            int nMatches = InputReader.getInt("Returns the number of (accessible) entries that match the qualification criteria :", 0);
            this.beginAPICall();
            List<MenuItem> expandedMenuInfo = this.getControlStructObject().expandMenu(menu, keywordList, parameterList, maxRetrieve, nMatches == 0 ? null : new OutputInteger(nMatches));
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printCharMenuItemInfoList("", "Expanded char Menu Info:", expandedMenuInfo);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ExpandCharMenu Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setCharMenu() {
        try {
            outputWriter.driverPrintHeader("SET CHAR MENU");
            Menu menu = InputReader.getMenu();
            String name = InputReader.getString("Character Menu Name");
            menu.setName(name);
            if (InputReader.getBooleanForChangingInfo("Change Character Menu Name? (F): ", false)) {
                String newName = InputReader.getString("New Name");
                menu.setNewName(newName);
            }
            if (InputReader.getBooleanForChangingInfo("Change Refresh Code? (F): ", false)) {
                int refreshCode = InputReader.getInt("Refresh on connect, open, interval (1 - 3) (1): ", 1);
                menu.setRefreshCode(refreshCode);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String helpText = InputReader.getString("    Help Text(): ", "");
                menu.setHelpText(helpText);
            }
            if (InputReader.getBooleanForChangingInfo("Change Owner? (F): ", false)) {
                String owner = InputReader.getString("Owner:");
                menu.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to Change DiaryList? (F): ", false)) {
                String diary = InputReader.getString("    Change DiaryList (): ", "");
                menu.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                menu.setProperties(propList);
            }
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().setMenu(menu, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Char Menu Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createContainer() {
        try {
            outputWriter.driverPrintHeader("CREATE CONTAINER");
            Container container = InputReader.getContainer();
            String name = InputReader.getString("Container Name");
            container.setName(name);
            List<PermissionInfo> permissionList = InputReader.getPermissionInfoList(true);
            container.setPermissions(permissionList);
            outputWriter.driverPrintPrompt("Ids of sub admin groups allowed to access container:\n");
            List<Integer> adminGroupList = InputReader.getIntegerList();
            container.setAdminGroupList(adminGroupList);
            List<ContainerOwner> containerOwnerList = InputReader.getContainerOwnerList();
            container.setContainerOwner(containerOwnerList);
            String label = InputReader.getString("Label ():", "");
            container.setLabel(label);
            String desc = InputReader.getString("Description ():", "");
            container.setDescription(desc);
            List<Reference> references = InputReader.getReferenceList();
            container.setReferences(references);
            boolean removeInvalidReference = InputReader.getBooleanForChangingInfo("Remove Invalid References( F ):", false);
            String help = InputReader.getString("Help Text():", "");
            container.setHelpText(help);
            String owner = InputReader.getString("Owner:");
            container.setOwner(owner);
            String diary = InputReader.getString("Change DiaryList():", "");
            container.appendDiaryText(diary);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            container.setProperties(propList);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().createContainer(container, removeInvalidReference, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Container Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setContainer() {
        try {
            outputWriter.driverPrintHeader("SET CONTAINER");
            Container container = InputReader.getContainer();
            String name = InputReader.getString("Container Name:", "");
            container.setName(name);
            if (InputReader.getBooleanForChangingInfo("Change container name? (F): ", false)) {
                String newName = InputReader.getString("New Name");
                container.setNewName(newName);
            }
            if (InputReader.getBooleanForChangingInfo("Change group( permission ) list? (F): ", false)) {
                List<PermissionInfo> permissionList = InputReader.getPermissionInfoList(true);
                container.setPermissions(permissionList);
            }
            if (InputReader.getBooleanForChangingInfo("Change sub admin group list? (F): ", false)) {
                outputWriter.driverPrintPrompt("Ids of sub admin groups allowed to access container:\n");
                List<Integer> adminGroupList = InputReader.getIntegerList();
                container.setAdminGroupList(adminGroupList);
            }
            if (InputReader.getBooleanForChangingInfo("Change container owner object? (F): ", false)) {
                List<ContainerOwner> containerOwnerList = InputReader.getContainerOwnerList();
                container.setContainerOwner(containerOwnerList);
            }
            if (InputReader.getBooleanForChangingInfo("Change label? (F): ", false)) {
                String label = InputReader.getString("    Label ():", "");
                container.setLabel(label);
            }
            if (InputReader.getBooleanForChangingInfo("Change description? (F): ", false)) {
                String desc = InputReader.getString("    Description ():", "");
                container.setDescription(desc);
            }
            boolean removeInvalidReference = false;
            if (InputReader.getBooleanForChangingInfo("Change reference list? (F): ", false)) {
                List<Reference> references = InputReader.getReferenceList();
                container.setReferences(references);
                removeInvalidReference = InputReader.getBooleanForChangingInfo("Remove invalid references? (F): ", false);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String help = InputReader.getString("    Help Text():", "");
                container.setHelpText(help);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String owner = InputReader.getString("Owner:");
                container.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                String diary = InputReader.getString("    Change DiaryList():", "");
                container.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                container.setProperties(propList);
            }
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().setContainer(container, removeInvalidReference, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Container Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteContainer() {
        try {
            outputWriter.driverPrintHeader("DELETE CONTAINER");
            String name = InputReader.getString("Container Name");
            int deleteOption = InputReader.getInt("Delete option ? ( 0, 1, 2 ) ( 0 ):", 0);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().deleteContainer(name, deleteOption, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Container Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getContainer() {
        try {
            outputWriter.driverPrintHeader("GET CONTAINER");
            String key = InputReader.getString("Container Key:");
            ContainerCriteria criteria = new ContainerCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            Container container = this.getControlStructObject().getContainer(key, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printContainer("", "Container Information:", container);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetContainer Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListContainer() {
        try {
            outputWriter.driverPrintHeader("GET LIST CONTAINER");
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            int[] containerTypes = InputReader.getIntArray();
            boolean hiddenFlag = InputReader.getBooleanForChangingInfo("Retrieve hidden containers (F-T) (T):", true);
            List<ContainerOwner> containerOwnerList = InputReader.getContainerOwnerList();
            ObjectPropertyMap propsToSearch = InputReader.getObjectPropertyMap();
            ContainerCriteria containerCriteria = new ContainerCriteria();
            containerCriteria.setRetrieveAll(true);
            this.beginAPICall();
            List<String> containers = this.getControlStructObject().getListContainer(changedSince, containerTypes, hiddenFlag, containerOwnerList, propsToSearch);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Container List:", containers);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListContainer Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleContainers() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE CONTAINERS");
            List<String> containerKeys = InputReader.getStringList("", "Container Name");
            List<Container> containers = this.getControlStructObject().getListContainerObjects(containerKeys);
            outputWriter.print("", "Container List:", containers);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException e) {
            outputWriter.printARException(e);
        }
    }

    void createVUI() {
        try {
            outputWriter.driverPrintHeader("CREATE VIEW");
            View view = new View();
            String name = InputReader.getString("Form Name: ");
            view.setFormName(name);
            int id = InputReader.getInt("VUI id (0): ", 0);
            view.setVUIId(id);
            String vuiName = InputReader.getString("VUI name");
            view.setName(vuiName);
            String locale = InputReader.getString("Locale (): ", "");
            view.setLocale(locale);
            int type = InputReader.getInt("VUI-Type (0): ", 0);
            view.setVUIType(type);
            ViewDisplayPropertyMap properties = InputReader.getViewDisplayPropertyMap();
            view.setDisplayProperties(properties);
            String helpText = InputReader.getString("Help Text:", "");
            view.setHelpText(helpText);
            String owner = InputReader.getString("Owner:");
            view.setOwner(owner);
            String changeDiary = InputReader.getString("Change DiaryList:", "");
            view.appendDiaryText(changeDiary);
            this.beginAPICall();
            this.getControlStructObject().createView(view);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "CreateView Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteVUI() {
        try {
            outputWriter.driverPrintHeader("DELETE VIEW");
            View view = new View();
            String name = InputReader.getString("Form Name: ");
            view.setFormName(name);
            int id = InputReader.getInt("VUI id (0): ", 0);
            view.setVUIId(id);
            this.beginAPICall();
            this.getControlStructObject().deleteView(view.getFormName(), view.getVUIId());
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete View Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getVUI() {
        try {
            outputWriter.driverPrintHeader("GET VIEW");
            String formName = InputReader.getString("Form Name (): ", "");
            int vuiId = InputReader.getInt("VUI id (1): ", 1);
            ViewCriteria criteria = new ViewCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            View view = this.getControlStructObject().getView(formName, vuiId, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printView("", "View Information:", view);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get View STatus", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListVUI() {
        try {
            outputWriter.driverPrintHeader("GET LIST VIEW");
            ViewCriteria criteria = new ViewCriteria();
            criteria.setRetrieveAll(true);
            String formName = InputReader.getString("Form Name (): ", "");
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            ObjectPropertyMap objProp = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<Integer> viewsList = this.getControlStructObject().getListView(formName, changedSince, objProp);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Views Ids:", viewsList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListView status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setVUI() {
        try {
            outputWriter.driverPrintHeader("SET VIEW");
            View view = new View();
            String name = InputReader.getString("Form Name: ");
            view.setFormName(name);
            int id = InputReader.getInt(" VUI id (1): ", 1);
            view.setVUIId(id);
            if (InputReader.getBooleanForChangingInfo("Change VUI name? (F): ", false)) {
                String vuiName = InputReader.getString("VUI name");
                view.setNewName(vuiName);
            }
            if (InputReader.getBooleanForChangingInfo("Change Locale? (F): ", false)) {
                view.setLocale(InputReader.getString("Locale(): ", ""));
            }
            if (InputReader.getBooleanForChangingInfo("Change VUI-Type? (F): ", false)) {
                view.setVUIType(InputReader.getInt("VUI-Type (0): ", 0));
            }
            if (InputReader.getBooleanForChangingInfo("Have new Prop List Info? (F): ", false)) {
                ViewDisplayPropertyMap properties = InputReader.getViewDisplayPropertyMap();
                view.setDisplayProperties(properties);
            }
            if (InputReader.getBooleanForChangingInfo("Change Help Text? (F): ", false)) {
                String helpText = InputReader.getString("Help Text:", "");
                view.setHelpText(helpText);
            }
            if (InputReader.getBooleanForChangingInfo("Change Owner? (F): ", false)) {
                String owner = InputReader.getString("Owner:");
                view.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to Change DiaryList? (F): ", false)) {
                String changeDiary = InputReader.getString("Change DiaryList (): ", "");
                view.appendDiaryText(changeDiary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                view.setObjectProperties(propList);
            }
            this.beginAPICall();
            this.getControlStructObject().setView(view);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set View status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createActiveLink() {
        try {
            outputWriter.driverPrintHeader("CREATE ACTIVE LINK");
            ActiveLink activeLink = new ActiveLink();
            String name = InputReader.getString("Active link Name:");
            activeLink.setName(name);
            int order = InputReader.getInt("Execution order (1-1000) (1):", 1);
            activeLink.setOrder(order);
            int wkflowtype = InputReader.getInt("Workflow type (1):", 1);
            if (wkflowtype == 1) {
                List<String> formList = InputReader.getStringList("", "Form");
                activeLink.setFormList(formList);
            }
            outputWriter.driverPrintPrompt("Ids of groups allowed to perform active link:\n");
            List<Integer> idList = InputReader.getInternalIDArrayList();
            activeLink.setGroupList(idList);
            int executeMask = InputReader.getInt("Execution bit mask (1):", 1);
            activeLink.setExecuteMask(executeMask);
            int controlField = InputReader.getInt("Control Field to tie active link to (0):", 0);
            activeLink.setControlField(controlField);
            int focusField = InputReader.getInt("Focus Field to tie active link to (0):", 0);
            activeLink.setFocusField(focusField);
            boolean enable = InputReader.getBoolean("Disable/Enable (F-T) (T):", true);
            activeLink.setEnable(enable);
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            activeLink.setQualifier(qualifier);
            List<ActiveLinkAction> actionList = InputReader.getActiveLinkActionInfoList(true);
            activeLink.setActionList(actionList);
            List<ActiveLinkAction> elseActionList = InputReader.getActiveLinkActionInfoList(false);
            activeLink.setElseList(elseActionList);
            String helpText = InputReader.getString("Help Text():", "");
            activeLink.setHelpText(helpText);
            String owner = InputReader.getString("Owner:");
            activeLink.setOwner(owner);
            String diary = InputReader.getString("Change DiaryList():", "");
            activeLink.appendDiaryText(diary);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            activeLink.setProperties(propList);
            int option = InputReader.getInt("Error Handler activelink Options (0-1) (0):", 0);
            activeLink.setErrorActlinkOptions(option);
            name = InputReader.getString("Error Handler Name: ");
            activeLink.setErrorActlinkName(name);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().createActiveLink(activeLink, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Active Link Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteActiveLink() {
        try {
            outputWriter.driverPrintHeader("DELETE ACTIVELINK");
            String name = InputReader.getString("Active link Name:");
            int deleteOption = InputReader.getInt("Delete option ? ( 0, 1, 2 ) ( 0 ):", 0);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().deleteActiveLink(name, deleteOption, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Active Link Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getActiveLink() {
        try {
            outputWriter.driverPrintHeader("GET ACTIVELINK");
            String key = InputReader.getString("Active link Name:");
            ActiveLinkCriteria criteria = new ActiveLinkCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            ActiveLink activeLink = this.getControlStructObject().getActiveLink(key, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printActiveLink("", "Active Link:", activeLink);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Active Link Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListActiveLink() {
        try {
            outputWriter.driverPrintHeader("GETLIST ACTIVE LINK");
            String formName = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                formName = InputReader.getString("Form Name (): ", "");
            }
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            ObjectPropertyMap objProp = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<String> names = this.getControlStructObject().getListActiveLink(formName, changedSince, objProp);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Active Link List:", names);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Active Link List Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleActiveLinks() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ACTIVE LINKS");
            ActiveLinkCriteria criteria = new ActiveLinkCriteria();
            criteria.setRetrieveAll(true);
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            List<String> names = InputReader.getStringList("", "Active link name");
            this.beginAPICall();
            List<ActiveLink> activeLinkList = this.getControlStructObject().getListActiveLinkObjects(names, changedSince, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Active Link List:", activeLinkList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Active Link List Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setActiveLink() {
        try {
            outputWriter.driverPrintHeader("SET ACTIVE LINK");
            ActiveLink activeLink = new ActiveLink();
            String name = InputReader.getString("Active link Name:");
            activeLink.setName(name);
            if (InputReader.getBooleanForChangingInfo("Change active link name? (F): ", false)) {
                String newName = InputReader.getString("New Name");
                activeLink.setNewName(newName);
            }
            if (InputReader.getBooleanForChangingInfo("Change execution order? (F): ", false)) {
                int order = InputReader.getInt("Execution order (1-1000) (1):", 1);
                activeLink.setOrder(order);
            }
            if (InputReader.getBooleanForChangingInfo("Change Work Flow information? (F): ", false)) {
                List<String> formList = InputReader.getStringList("", "Form");
                activeLink.setFormList(formList);
            }
            if (InputReader.getBooleanForChangingInfo("Change group List? (F): ", false)) {
                outputWriter.driverPrintPrompt("Ids of groups allowed to perform active link:\n");
                List<Integer> idList = InputReader.getIntegerList();
                activeLink.setGroupList(idList);
            }
            if (InputReader.getBooleanForChangingInfo("Change execute mask? (F): ", false)) {
                int executeMask = InputReader.getInt("Execution bit mask (1):", 1);
                activeLink.setExecuteMask(executeMask);
            }
            if (InputReader.getBooleanForChangingInfo("Change control field? (F): ", false)) {
                int controlField = InputReader.getInt("Control Field to tie active link to (0):", 0);
                activeLink.setControlField(controlField);
            }
            if (InputReader.getBooleanForChangingInfo("Change focus field? (F): ", false)) {
                int focusField = InputReader.getInt("Focus Field to tie active link to (0):", 0);
                activeLink.setFocusField(focusField);
            }
            if (InputReader.getBooleanForChangingInfo("Change enable/disable? (F): ", false)) {
                boolean enable = InputReader.getBooleanForChangingInfo("Disable/Enable (F-T) (T):", true);
                activeLink.setEnable(enable);
            }
            if (InputReader.getBooleanForChangingInfo("Change query? (F): ", false)) {
                QualifierInfo qualifier = InputReader.getQualifierInfo();
                activeLink.setQualifier(qualifier);
            }
            if (InputReader.getBooleanForChangingInfo("Change actions? (F): ", false)) {
                List<ActiveLinkAction> actionList = InputReader.getActiveLinkActionInfoList(true);
                activeLink.setActionList(actionList);
            }
            if (InputReader.getBooleanForChangingInfo("Change else actions? (F): ", false)) {
                List<ActiveLinkAction> elseActionList = InputReader.getActiveLinkActionInfoList(false);
                activeLink.setElseList(elseActionList);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String helpText = InputReader.getString("Help Text():", "");
                activeLink.setHelpText(helpText);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String owner = InputReader.getString("Owner:");
                activeLink.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                String diary = InputReader.getString("Change DiaryList():", "");
                activeLink.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                activeLink.setProperties(propList);
            }
            if (InputReader.getBooleanForChangingInfo("Change error handler activelink options? (F): ", false)) {
                int value = InputReader.getInt("Error Handler activelink Options (0-1) (0):", 0);
                activeLink.setErrorActlinkOptions(value);
            }
            if (InputReader.getBooleanForChangingInfo("Change error handler name? (F): ", false)) {
                String value = InputReader.getString("Error Handler Name: ");
                activeLink.setErrorActlinkName(value);
            }
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().setActiveLink(activeLink, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Active Link Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createFilter() {
        try {
            outputWriter.driverPrintHeader("CREATE FILTER");
            Filter filter = new Filter();
            String name = InputReader.getString("Filter Name: ");
            filter.setName(name);
            int order = InputReader.getInt("Filter order (0-1000) (500): ", 500);
            filter.setOrder(order);
            List<String> formList = InputReader.getStringList("", "Form");
            filter.setFormList(formList);
            int bitMask = InputReader.getInt("Operation bit mask (0):", 0);
            filter.setOpSet(bitMask);
            boolean enable = InputReader.getBooleanForChangingInfo("Disable/Enable (0-1) (1):", true);
            filter.setEnable(enable);
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            filter.setQualifier(qualifier);
            List<FilterAction> actionList = InputReader.getFilterActionInfoList(true);
            filter.setActionList(actionList);
            List<FilterAction> elseActionList = InputReader.getFilterActionInfoList(false);
            filter.setElseList(elseActionList);
            String helpText = InputReader.getString("Help Text ():", "");
            filter.setHelpText(helpText);
            String owner = InputReader.getString("Owner ():");
            filter.setOwner(owner);
            String diary = InputReader.getString("Change DiaryList ():", "");
            filter.appendDiaryText(diary);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            filter.setProperties(propList);
            int option = InputReader.getInt("Error Handler Filter Options (0-1) (0):", 0);
            filter.setErrorFilterOptions(option);
            name = InputReader.getString("Error Handler Name: ");
            filter.setErrorHandlingFilter(name);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().createFilter(filter, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Filter Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteFilter() {
        try {
            outputWriter.driverPrintHeader("DELETE FILTER");
            String name = InputReader.getString("Filter Name: ");
            int deleteOpt = InputReader.getInt("Delete option ? (0): ", 0);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().deleteFilter(name, deleteOpt, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Filter Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getFilter() {
        try {
            outputWriter.driverPrintHeader("GET FILTER");
            String key = InputReader.getString("Filter Name: ");
            FilterCriteria criteria = new FilterCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            Filter filter = this.getControlStructObject().getFilter(key, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printFilter("", "Filter:", filter);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Filter Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListFilter() {
        try {
            outputWriter.driverPrintHeader("GET FILTER LIST");
            String formName = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                formName = InputReader.getString("Form Name (): ", "");
            }
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            ObjectPropertyMap propMap = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<String> filterList = this.getControlStructObject().getListFilter(formName, changedSince, propMap);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Filter List:", filterList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List Filter status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleFilters() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE FILTERS");
            FilterCriteria criteria = new FilterCriteria();
            String formName = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                formName = InputReader.getString("Form Name (): ", "");
            }
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            List<Filter> filterList = this.getControlStructObject().getListFilterObjects(formName, changedSince, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Filter List:", filterList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Multiple Filters status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setFilter() {
        try {
            outputWriter.driverPrintHeader("SET FILTER");
            Filter filter = new Filter();
            String name = InputReader.getString("Filter Name: ");
            filter.setName(name);
            if (InputReader.getBooleanForChangingInfo("Change filter name? (F): ", false)) {
                String newName = InputReader.getString("New Name ():");
                filter.setNewName(newName);
            }
            if (InputReader.getBooleanForChangingInfo("Change filter order? (F): ", false)) {
                int order = InputReader.getInt("Filter order (1-1000) (500):", 500);
                filter.setOrder(order);
            }
            if (InputReader.getBooleanForChangingInfo("Change workflow info? (F): ", false)) {
                List<String> formList = InputReader.getStringList("", "Form");
                filter.setFormList(formList);
            }
            if (InputReader.getBooleanForChangingInfo("Change operations mask? (F): ", false)) {
                int bitMask = InputReader.getInt("Operation bit mask (0):", 0);
                filter.setOpSet(bitMask);
            }
            if (InputReader.getBooleanForChangingInfo("Change enable/disable? (F): ", false)) {
                boolean enable = InputReader.getBooleanForChangingInfo("Disable/Enable (0-1) (1):", true);
                filter.setEnable(enable);
            }
            if (InputReader.getBooleanForChangingInfo("Change Query? (F): ", false)) {
                QualifierInfo qualifier = InputReader.getQualifierInfo();
                filter.setQualifier(qualifier);
            }
            if (InputReader.getBooleanForChangingInfo("Change action(s)? (F): ", false)) {
                List<FilterAction> actionList = InputReader.getFilterActionInfoList(true);
                filter.setActionList(actionList);
            }
            if (InputReader.getBooleanForChangingInfo("Change else(s)? (F): ", false)) {
                List<FilterAction> elseActionList = InputReader.getFilterActionInfoList(false);
                filter.setElseList(elseActionList);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String helpText = InputReader.getString("Help Text():", "");
                filter.setHelpText(helpText);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String owner = InputReader.getString("Owner:");
                filter.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to Change DiaryList? (F): ", false)) {
                String diary = InputReader.getString("Change DiaryList(): ", "");
                filter.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                filter.setProperties(propList);
            }
            if (InputReader.getBooleanForChangingInfo("Change error handler filter options? (F): ", false)) {
                int value = InputReader.getInt("Error Handler Filter Options (0-1) (0):", 0);
                filter.setErrorFilterOptions(value);
            }
            if (InputReader.getBooleanForChangingInfo("Change error handler name? (F): ", false)) {
                String value = InputReader.getString("Error Handler Name: ");
                filter.setErrorHandlingFilter(value);
            }
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().setFilter(filter, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Filter Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createEscalation() {
        try {
            outputWriter.driverPrintHeader("CREATE ESCALATION");
            Escalation escalation = new Escalation();
            String name = InputReader.getString("Escalation Name: ");
            escalation.setName(name);
            EscalationTimeCriteria timeInfo = InputReader.getEsclationTmInfo();
            escalation.setEscalationTm(timeInfo);
            List<String> formList = InputReader.getStringList("", "Form");
            escalation.setFormList(formList);
            boolean enable = InputReader.getBoolean("Disable/Enable (0-1) (1): ", true);
            escalation.setEnable(enable);
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            escalation.setQualifier(qualifier);
            List<FilterAction> actionList = InputReader.getFilterActionInfoList(true);
            escalation.setActionList(actionList);
            List<FilterAction> elseActionList = InputReader.getFilterActionInfoList(false);
            escalation.setElseList(elseActionList);
            String helpText = InputReader.getString("Help Text (): ", "");
            escalation.setHelpText(helpText);
            String owner = InputReader.getString("Owner: ");
            escalation.setOwner(owner);
            String diary = InputReader.getString("Change DiaryList (): ", "");
            escalation.appendDiaryText(diary);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            escalation.setProperties(propList);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().createEscalation(escalation, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Escalation status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteEscalation() {
        try {
            outputWriter.driverPrintHeader("DELETE ESCALATION");
            String name = InputReader.getString("Escalation Name: ");
            int deleteOpt = InputReader.getInt("Delete option ? (0): ", 0);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().deleteEscalation(name, deleteOpt, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Escalation Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getEscalation() {
        try {
            outputWriter.driverPrintHeader("GET ESCALATION");
            String key = InputReader.getString("Escalation Key:");
            EscalationCriteria criteria = new EscalationCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            Escalation escalation = this.getControlStructObject().getEscalation(key, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printEscalation("", "Esclation Data:", escalation);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Escalation Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListEscalation() {
        try {
            outputWriter.driverPrintHeader("GET LIST ESCALATION");
            String formName = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                formName = InputReader.getString("Form Name (): ", "");
            }
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<String> escalationList = this.getControlStructObject().getListEscalation(formName, changedSince, propList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Esclation List:", escalationList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListEscalation status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleEscalations() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ESCALATIONS");
            EscalationCriteria criteria = new EscalationCriteria();
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            criteria.setRetrieveAll(true);
            String formName = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                formName = InputReader.getString("Form Name (): ", "");
                this.beginAPICall();
                List<Escalation> escalationList = this.getControlStructObject().getListEscalationObjects(formName, changedSince, criteria);
                this.endAPICall(this.getControlStructObject().getLastStatus());
                outputWriter.print("", "Esclation List:", escalationList);
                List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
                outputWriter.printStatusInfoList("", "GetMultipleEscalations status", statusList);
            } else {
                List<String> names = InputReader.getStringList("", "Escalation");
                this.beginAPICall();
                List<Escalation> escalationList = this.getControlStructObject().getListEscalationObjects(names, changedSince, criteria);
                this.endAPICall(this.getControlStructObject().getLastStatus());
                outputWriter.print("", "Esclation List:", escalationList);
                List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
                outputWriter.printStatusInfoList("", "GetMultipleEscalations status", statusList);
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setEscalation() {
        try {
            outputWriter.driverPrintHeader("SET ESCALATION");
            Escalation escalation = new Escalation();
            String name = InputReader.getString("Escalation Name: ");
            escalation.setName(name);
            if (InputReader.getBooleanForChangingInfo("Change escalation name? (F): ", false)) {
                String newName = InputReader.getString("New Name: ");
                escalation.setNewName(newName);
            }
            if (InputReader.getBooleanForChangingInfo("Change escalation Time? (F): ", false)) {
                EscalationTimeCriteria timeInfo = InputReader.getEsclationTmInfo();
                escalation.setEscalationTm(timeInfo);
            }
            if (InputReader.getBooleanForChangingInfo("Change Work Flow information? (F): ", false)) {
                List<String> formList = InputReader.getStringList("", "Form");
                escalation.setFormList(formList);
            }
            if (InputReader.getBooleanForChangingInfo("Change enable/disable? (F): ", false)) {
                boolean enable = InputReader.getBooleanForChangingInfo("Disable/Enable (0-1) (1): ", true);
                escalation.setEnable(enable);
            }
            if (InputReader.getBooleanForChangingInfo("Change Query? (F): ", false)) {
                QualifierInfo qualifier = InputReader.getQualifierInfo();
                escalation.setQualifier(qualifier);
            }
            if (InputReader.getBooleanForChangingInfo("Change action(s)? (F): ", false)) {
                List<FilterAction> actionList = InputReader.getFilterActionInfoList(true);
                escalation.setActionList(actionList);
            }
            if (InputReader.getBooleanForChangingInfo("Change else(s)? (F): ", false)) {
                List<FilterAction> elseActionList = InputReader.getFilterActionInfoList(false);
                escalation.setElseList(elseActionList);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String helpText = InputReader.getString("Help Text (): ", "");
                escalation.setHelpText(helpText);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String owner = InputReader.getString("Owner: ");
                escalation.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to Change DiaryList? (F): ", false)) {
                String diary = InputReader.getString("Change DiaryList (): ", "");
                escalation.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                escalation.setProperties(propList);
            }
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().setEscalation(escalation, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Escalation Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createSupportFile() {
        try {
            outputWriter.driverPrintHeader("CREATE SUPPORT FILE");
            SupportFile supportFile = new SupportFile();
            SupportFileKey key = InputReader.getSupportFileKey();
            supportFile.setKey(key);
            String fileName = InputReader.getString("File name ():", "");
            supportFile.setFilePath(fileName);
            this.beginAPICall();
            this.getControlStructObject().createSupportFile(supportFile);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Support File Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteSupportFile() {
        try {
            outputWriter.driverPrintHeader("DELETE SUPPORT FILE");
            SupportFile supportFile = new SupportFile();
            SupportFileKey key = InputReader.getSupportFileKey();
            supportFile.setKey(key);
            this.beginAPICall();
            this.getControlStructObject().deleteSupportFile(supportFile.getKey());
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Support File Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getSupportFile() {
        try {
            outputWriter.driverPrintHeader("GET SUPPORT FILE");
            SupportFileKey key = InputReader.getSupportFileKey();
            String filePath = InputReader.getString("Filename to hold returned file: ", "");
            this.beginAPICall();
            SupportFile supportFile = this.getControlStructObject().getSupportFile(key.getName(), key.getFileId(), key.getFileType(), key.getFieldId(), filePath);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printSupportFile("", "SupportFile Data:", supportFile);
            if (supportFile != null) {
                String tempPath = supportFile.getFilePath();
                String contents = InputReader.getFileContents(tempPath);
                FileWriter newFp = new FileWriter(tempPath);
                newFp.write(contents, 0, contents.length());
                newFp.close();
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Support File Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setSupportFile() {
        try {
            outputWriter.driverPrintHeader("SET SUPPORT FILE");
            SupportFile supportFile = new SupportFile();
            SupportFileKey key = InputReader.getSupportFileKey();
            supportFile.setKey(key);
            String fileName = InputReader.getString("File name to load to server():", "");
            supportFile.setFilePath(fileName);
            this.beginAPICall();
            this.getControlStructObject().setSupportFile(supportFile);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set SupportFile Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListSupportFile() {
        try {
            outputWriter.driverPrintHeader("GET List SUPPORT FILE");
            int fileType = InputReader.getInt("File type -- external report (1) (1): ", 1);
            String name = InputReader.getString("Nameof associated object ():", "");
            int fieldId = InputReader.getInt("   Supporting ID for object (0): ", 0);
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            this.beginAPICall();
            List<SupportFile> fileList = this.getControlStructObject().getListSupportFileObjects(fileType, name, fieldId, changedSince);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Support Files:", fileList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List SupportFile STatus", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListGroup() {
        try {
            outputWriter.driverPrintHeader("GET LIST GROUP");
            String user = null;
            String password = null;
            if (InputReader.getBooleanForChangingInfo("For a specific user? (F): ", false)) {
                user = InputReader.getString("Name of the user: ");
                password = InputReader.getString("Password of the User: ");
            }
            this.beginAPICall();
            List<GroupInfo> groupList = this.getControlStructObject().getListGroup(user, password);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListGroup Results:", groupList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListGroup Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListRole() {
        try {
            outputWriter.driverPrintHeader("GET LIST ROLE");
            String application = null;
            String user = null;
            String password = null;
            application = InputReader.getString("Application name:");
            if (InputReader.getBooleanForChangingInfo("For a specific user? (F): ", false)) {
                user = InputReader.getString("Name of the user: ");
                password = InputReader.getString("Password of the User: ");
            }
            this.beginAPICall();
            List<RoleInfo> roleList = this.getControlStructObject().getListRole(application, user, password);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListRole Results:", roleList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListRoles Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListUser() {
        try {
            outputWriter.driverPrintHeader("GET LIST USER");
            int type = InputReader.getInt("User List Type (myself, registered or current (0-2)(1): ", 1);
            long changedSince = InputReader.getLong("Get registered users changed since (0 means all): ", 0L);
            this.beginAPICall();
            List<UserInfo> userList = this.getControlStructObject().getListUser(type, changedSince);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListUser Results:", userList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListUser Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getServerInfo() {
        try {
            outputWriter.driverPrintHeader("GET SERVER INFO");
            int total = InputReader.getInt("Number of server info operations (1): ", 1);
            if (total < 1) {
                total = 1;
            }
            int[] requestList = new int[total];
            for (int j = 0; j < total; ++j) {
                requestList[j] = InputReader.getInt("   Operation (1-426) (1): ", 1);
            }
            this.beginAPICall();
            ServerInfoMap serverInfoMap = this.getControlStructObject().getServerInfo(requestList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetServerInfo Results:", serverInfoMap);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetServerInfo Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setServerInfo() {
        try {
            outputWriter.driverPrintHeader("SET SERVER INFO");
            ServerInfoMap serverInfoMap = InputReader.getServerInfoMap();
            this.beginAPICall();
            this.getControlStructObject().setServerInfo(serverInfoMap);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Server Information Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setServerPort() {
        try {
            outputWriter.driverPrintHeader("SET SERVER PORT");
            int portNumber = InputReader.getInt("The port number of server (0):", 0);
            int progNumber = InputReader.getInt("The RPC program number of Server (0):", 0);
            this.getControlStructObject().setPort(portNumber);
            this.getControlStructObject().usePrivateRpcQueue(progNumber);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Server Port Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void export() {
        try {
            outputWriter.driverPrintHeader("ARExport");
            int exportOption = 0;
            List<StructItemInfo> items = InputReader.getStructItemInfoList();
            String displayTag = null;
            int vuiType = 0;
            WorkflowLockInfo lockInfo = InputReader.getWorkflowLockInfo();
            boolean asXml = false;
            if (items != null) {
                int i;
                for (i = 0; i < items.size(); ++i) {
                    if (items.get(i).getType() >= 0x40000000) {
                        asXml = true;
                    }
                    if (items.get(i).getType() != 3 && items.get(i).getType() != 103) continue;
                    displayTag = InputReader.getString("Display Tag");
                    vuiType = InputReader.getInt("VUI- Type (0): ", 0);
                    break;
                }
                for (i = 0; i < items.size(); ++i) {
                    if (items.get(i).getType() != 16) continue;
                    exportOption = items.get(i).getExportOption();
                    break;
                }
            }
            String fileName = InputReader.getString("Filename for exported data: ", "");
            this.beginAPICall();
            this.getControlStructObject().exportDefToFile(items, asXml, displayTag, vuiType, lockInfo, fileName, true, exportOption);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARExport Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString(e.getLocalizedMessage());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getServerStatistics() {
        try {
            outputWriter.driverPrintHeader("GET SERVER STATISTICS");
            int numberOfOperations = InputReader.getInt("Number Of server info Operations (0):", 0);
            int[] requestList = null;
            if (numberOfOperations != 0) {
                requestList = new int[numberOfOperations];
                for (int i = 0; i < numberOfOperations; ++i) {
                    requestList[i] = InputReader.getInt("Operation (1-76 ):", 1);
                }
            }
            this.beginAPICall();
            ServerInfoMap serverInfoMap = this.getControlStructObject().getServerStatistics(requestList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("ARGetServerStatistics Results\n");
            outputWriter.print("", "Server Information", serverInfoMap);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetServerStatistics Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void executeProcess() {
        try {
            outputWriter.driverPrintHeader("EXECUTE PROCESS");
            String command = InputReader.getString("Command:", "");
            boolean waitFlag = InputReader.getBooleanForChangingInfo("Wait For process to complete (F): ", false);
            this.beginAPICall();
            ProcessResult result = this.getControlStructObject().executeProcess(command, waitFlag);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printProcessResult("", "ARExecuteProcess Results:", result);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARExecuteProcess Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListSQL() {
        try {
            outputWriter.driverPrintHeader("GETLIST SQL");
            String command = InputReader.getString("SQL Command:", "");
            int numberOfEntries = InputReader.getInt("Maximum number of entries to retrieve (500):", 500);
            boolean flag = InputReader.getBooleanForChangingInfo("Get Number Of Matches? (F): ", false);
            this.beginAPICall();
            SQLResult result = this.getControlStructObject().getListSQL(command, numberOfEntries, flag);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printSQLResult("", "ARGetListSQL Results:", result);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListSQL Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getTextForErrorMessage() {
        try {
            outputWriter.driverPrintHeader("GET TEXT FOR ERROR MESSAGE");
            int msgNumber = InputReader.getInt("The message identifier for the message (0):", 0);
            this.beginAPICall();
            String message = this.getControlStructObject().getTextForErrorMessage(msgNumber);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("", "ARGetTextForErrorMessage Results:", message, "\n");
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetTextForErrorMessage Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getEntryBLOB() {
        try {
            outputWriter.driverPrintHeader("GET ENTRY BLOB");
            String form = InputReader.getString("Form Name: ");
            String entryId = InputReader.getString("Entry ID:", "");
            int fieldId = InputReader.getInt("Field ID (1):", 1);
            String filePath = InputReader.getString("File path to retrieve the attachment value :", "");
            byte[] content = null;
            this.beginAPICall();
            if (filePath != null && filePath.length() > 0) {
                this.getControlStructObject().getEntryBlob(form, entryId, fieldId, filePath);
            } else {
                outputWriter.printString("File path was not supplied, so content will be retrieved into a buffer\n");
                content = this.getControlStructObject().getEntryBlob(form, entryId, fieldId);
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (filePath != null && filePath.length() > 0 && new File(filePath).exists()) {
                outputWriter.printString("File retrieved to: " + filePath + "\n");
            } else if (content != null) {
                outputWriter.printString("Buffer size is: " + content.length + "\n");
            } else {
                outputWriter.printString("Empty buffer...\n");
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Entry Blob Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void verifyUser() {
        try {
            outputWriter.driverPrintHeader("VERIFY USER");
            this.beginAPICall();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Verify User Results:", this.getControlStructObject());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Verify User Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void encodeARQualifierStruct() {
        try {
            outputWriter.driverPrintHeader("ENCODE ARQUALIFIER STRUCT TO STRING");
            QualifierInfo qal = InputReader.getQualifierInfo();
            this.beginAPICall();
            String qaltxt = this.getControlStructObject().encodeQualification(qal);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (qaltxt != null) {
                outputWriter.printHeader("", "Qualifier Text: ", "\n");
                outputWriter.printString(qaltxt);
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "EncodeQualifier Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void decodeARQualifierStruct() {
        try {
            outputWriter.driverPrintHeader("DECODE STRING TO ARQUALIFIER STRUCT");
            String qaltxt = InputReader.getString("Qualifier Text: ", "");
            this.beginAPICall();
            QualifierInfo qal = this.getControlStructObject().decodeQualification(qaltxt);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (qal != null) {
                outputWriter.printQualifierInfo("", "ARDecodeARQualifierStruct: ", qal);
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARDecodeARQualifierStruct  Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void encodeARAssignStruct() {
        try {
            outputWriter.driverPrintHeader("ENCODE ARASSIGN STRUCT TO STRING");
            AssignInfo asn = InputReader.getAssignInfo();
            this.beginAPICall();
            String asntxt = this.getControlStructObject().encodeAssignment(asn);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printHeader("", "Assign Text: ", "\n");
            if (asntxt != null) {
                outputWriter.printString(asntxt);
                outputWriter.printNewLine();
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "AREncodeARAssignStruct Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void decodeARAssignStruct() {
        try {
            outputWriter.driverPrintHeader("DECODE STRING TO ARASSIGN STRUCT");
            String asntxt = InputReader.getString("Assign Text: ", "");
            this.beginAPICall();
            AssignInfo asn = this.getControlStructObject().decodeAssignment(asntxt);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (asn != null) {
                outputWriter.printAssignInfo("", "ARDecodeARAssignStruct: ", asn);
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARDecodeARAssignStruct Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void encodeStatusHistory() {
        try {
            outputWriter.driverPrintHeader("ENCODE STATUS HISTORY ARRAY TO STRING");
            StatusHistoryValue statHist = InputReader.getStatusHistory();
            this.beginAPICall();
            String statHistTxt = statHist.encode();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (statHistTxt != null) {
                outputWriter.printString("Status History String: \n");
                outputWriter.printString(statHistTxt);
                outputWriter.printStatusHistoryString("", "Status History Items:", statHistTxt);
                List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
                outputWriter.printStatusInfoList("", "AREncodeStatusHistory Status", statusList);
            } else {
                outputWriter.printString("Status History String: Null\n");
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void encodeDiary() {
        try {
            outputWriter.driverPrintHeader("ENCODE DIARY ARRAY TO STRING");
            DiaryListValue diary = InputReader.getDiaryInfoList();
            this.beginAPICall();
            String diarytxt = ARServerUser.encodeDiary(diary);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printHeader("", "DiaryList Text: ", "\n");
            if (diarytxt != null) {
                outputWriter.printString(diarytxt);
                outputWriter.printString("", "DiaryList Items:", diarytxt);
                DiaryListValue diaryList = DiaryListValue.decode(diarytxt);
                outputWriter.printDiaryList("", "DiaryList Items:", diaryList);
            } else {
                outputWriter.printString("Encoded diary String: Null\n");
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "AREncodeDiary Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    private void deleteAlert() {
        outputWriter.driverPrintHeader("DELETE ALERT");
        try {
            String entryId = InputReader.getString("Entry ID:", "");
            this.beginAPICall();
            this.getControlStructObject().deleteAlert(entryId);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "deleteAlert Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createAlertEvent() {
        try {
            outputWriter.driverPrintHeader("CREATE ALERT EVENT");
            String user = InputReader.getString("User");
            String alertText = InputReader.getString("Alert Text(): ", "");
            int alertPriority = InputReader.getInt("Alert Priority (0):", 0);
            String alertSource = InputReader.getString("Alert Source");
            String serverName = InputReader.getString("Server Name: ", "");
            String formName = InputReader.getString("Form Name");
            String objectId = InputReader.getString("Object Id(): ", "");
            this.beginAPICall();
            String entryId = this.getControlStructObject().createAlertEvent(user, alertText, alertPriority, alertSource, serverName, formName, objectId);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("", "String:", entryId);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARCreateAlertEvent Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void registerForAlerts() {
        try {
            outputWriter.driverPrintHeader("REGISTER FOR ALERTS");
            int clientPort = InputReader.getInt("clientPort (0):", 0);
            int registrationFlags = InputReader.getInt("registrationFlags (0):", 0);
            this.beginAPICall();
            this.getControlStructObject().registerForAlerts(clientPort, registrationFlags);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARRegisterForAlerts Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deregisterForAlerts() {
        try {
            outputWriter.driverPrintHeader("Deregister For Alerts");
            int clientPort = InputReader.getInt("clientPort (0):", 0);
            this.beginAPICall();
            this.getControlStructObject().deregisterForAlerts(clientPort);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARDeregisterForAlerts STatus", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListAlertUser() {
        try {
            outputWriter.driverPrintHeader("GET LIST ALERT USER");
            this.beginAPICall();
            List<String> users = this.getControlStructObject().getListAlertUser();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "users List: ", users);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListAlertUser Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getAlertCount() {
        try {
            outputWriter.driverPrintHeader("GET ALERT COUNT");
            QualifierInfo qal = InputReader.getQualifierInfo();
            this.beginAPICall();
            int count = this.getControlStructObject().getAlertCount(qal);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printInt("", "ALert Count = ", count, "\n");
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetAlertCount Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getLocalizedValue() {
        try {
            outputWriter.driverPrintHeader("GET LOCALIZED VALUE");
            LocalizedRequestInfo request = InputReader.getLocalizedRequestInfo();
            LocalizedValueCriteria criteria = InputReader.getLocalizedValueCriteria();
            this.beginAPICall();
            LocalizedValueInfo localizedValue = this.getControlStructObject().getLocalizedValue(criteria, request);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (localizedValue != null) {
                if (localizedValue.getValue() != null) {
                    outputWriter.printValue("   ", "Localized Value: ", localizedValue.getValue());
                }
                if (localizedValue.getTimestamp() != null) {
                    outputWriter.printString("Got the time stamp");
                }
                outputWriter.printNewLine();
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetLocalizedValue Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleLocalizedValues() {
        try {
            outputWriter.driverPrintHeader("GET LOCALIZED VALUES");
            int numRequests = InputReader.getInt("Number of requests (1): ", 1);
            ArrayList<LocalizedRequestInfo> requests = new ArrayList<LocalizedRequestInfo>();
            if (numRequests > 0) {
                for (int i = 0; i < numRequests; ++i) {
                    requests.add(InputReader.getLocalizedRequestInfo());
                }
            }
            LocalizedValueCriteria criteria = InputReader.getLocalizedValueCriteria();
            this.beginAPICall();
            List<LocalizedValueInfo> localizedValues = this.getControlStructObject().getMultipleLocalizedValues(criteria, requests);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            for (int i = 0; i < localizedValues.size(); ++i) {
                if (localizedValues.get(i).getValue() != null) {
                    outputWriter.printValue("   ", "Localized Request " + i + ": ", localizedValues.get(i).getValue());
                }
                if (localizedValues.get(i).getTimestamp() == null) continue;
                outputWriter.printLong("   ", "Timestamp: ", localizedValues.get(i).getTimestamp().getValue(), "\n");
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetMultipleLocalizedValues Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListFormWithAlias() {
        try {
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            FormType formType = InputReader.getFormType();
            String formName = null;
            if (formType != null && (formType.equals(FormType.UPLINK) || formType.equals(FormType.DOWNLINK))) {
                formName = InputReader.getString("Form name (): ", "");
            }
            outputWriter.driverPrintPrompt("Ids of fields, which must be on the form:\n");
            int[] fieldIds = InputReader.getIntArray();
            String vuiLabel = InputReader.getString("VUI Label (): ", "");
            this.beginAPICall();
            List<FormAliasInfo> formAliases = this.getControlStructObject().getListFormAliases(changedSince, formType.toInt(), formName, fieldIds, vuiLabel);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Form Alias Info", formAliases);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "findAliases Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void decodeAlertMessage() {
        try {
            outputWriter.driverPrintHeader("DECODE ALERT MESSAGE");
            AlertMessageCriteria criteria = new AlertMessageCriteria();
            String message = InputReader.getString(" Message (): ", "");
            int len = message.length();
            this.beginAPICall();
            AlertMessageInfo result = this.getControlStructObject().decodeAlertMessage(criteria, message.getBytes(), len);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printAlertMessageInfo("", "DecodeAlertMessage Results: ", result);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void executeProcessForActiveLink() {
        try {
            outputWriter.driverPrintHeader("EXECUTE PROCESS FOR ACTIVE LINK");
            String actlinkName = InputReader.getString("Name of Active Link");
            int actionIndex = InputReader.getInt("Action Index (0): ", 0);
            int actionType = InputReader.getInt("actionType (0): ", 0);
            int fieldID = InputReader.getInt("fieldid(0):", 0);
            Timestamp time = InputReader.getTimestamp("timestamp", new Timestamp());
            outputWriter.driverPrintPrompt("Keyword List: \n");
            List<Value> keywordsList = InputReader.getValueList();
            outputWriter.driverPrintPrompt("Parameter List:\n");
            List<Value> parametersList = InputReader.getValueList();
            boolean waitFlag = InputReader.getBooleanForChangingInfo("Wait For process to complete (F): ", false);
            InputReader.getBooleanForChangingInfo("Get return command? (F): ", false);
            this.beginAPICall();
            ProcessResult result = this.getControlStructObject().executeProcessForActiveLink(actlinkName, actionIndex, actionType, fieldID, time, keywordsList, parametersList, waitFlag);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printProcessResult("", "ARExecuteProcessForActiveLink Results:", result);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARExecuteProcessForActiveLink Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListSQLForActiveLink() {
        try {
            outputWriter.driverPrintHeader("GETLIST SQL FOR ACTIVE LINK");
            String actlinkName = InputReader.getString("Name of Active Link ");
            int actionIndex = InputReader.getInt("Action Index (0): ", 0);
            int actionType = InputReader.getInt("action type (0): ", 0);
            Timestamp time = InputReader.getTimestamp("timestamp", new Timestamp());
            outputWriter.driverPrintPrompt("Keyword List: \n");
            List<Value> keywordsList = InputReader.getValueList();
            outputWriter.driverPrintPrompt("Parameter List:\n");
            List<Value> parametersList = InputReader.getValueList();
            int maxRetrieve = InputReader.getInt("Maximum number of entries to retrieve (500): ", 500);
            boolean retrieveTotalMatches = InputReader.getBooleanForChangingInfo("Get Number of Matches (F): ", false);
            InputReader.getBooleanForChangingInfo("Get return command? (F): ", false);
            this.beginAPICall();
            SQLResult result = this.getControlStructObject().getListSQLForActiveLink(actlinkName, actionIndex, actionType, time, keywordsList, parametersList, maxRetrieve, retrieveTotalMatches);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printSQLResult("", "ARGetListSQLForActiveLink Results:", result);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListSQLForActiveLink Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListExtFormCandidates() {
        try {
            outputWriter.driverPrintHeader("GET LIST EXTERNAL SCHEMA CANDIDATES");
            int formType = InputReader.getInt("Form Type (3(view) or 5(vendor)): ", 3);
            this.beginAPICall();
            List<ExtFormCandidatesInfo> result = this.getControlStructObject().getListExtFormCandidates(formType);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListExtFormCandidates Results: ", result);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListExtFormCandidates Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleExtFieldCandidates() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE EXTERNAL FIELD CANDIDATES");
            int type = InputReader.getInt("Form Type (3(view) or 5(vendor)): ", 3);
            String vendorName = "";
            String tableName = "";
            if (type == 3) {
                tableName = InputReader.getString("Table Name: ");
            } else if (type == 5) {
                vendorName = InputReader.getString("Vendor Name: ");
                tableName = InputReader.getString("Table Name: ");
            } else {
                outputWriter.printString("Form type not applicable");
                return;
            }
            List<ExtFieldCandidatesInfo> result = null;
            this.beginAPICall();
            if (type == 3) {
                result = this.getControlStructObject().getListViewFormFieldCandidates(tableName);
            } else if (type == 5) {
                result = this.getControlStructObject().getListVendorFormFieldCandidates(vendorName, tableName);
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListExtFormCandidates Results: ", result);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListExtFormCandidates Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getEntryStatistics() {
        try {
            outputWriter.driverPrintHeader("GET ENTRY STATISTICS");
            String formKey = InputReader.getString("Form Key:", "");
            QualifierInfo qualifier = InputReader.getQualifierInfo();
            outputWriter.driverPrintHeader("Target Expression:");
            ArithmeticOrRelationalOperand target = InputReader.getArithmeticOrRelationalOperand(null, "");
            int type = InputReader.getInt("Statistic Operation to Perform (Count,Sum,Avg,Min,Max) (1-5)(1):", 1);
            outputWriter.driverPrintPrompt("Ids of fields to group statistics by:\n ");
            int[] idList = InputReader.getInternalIDList();
            this.beginAPICall();
            List<StatisticsResultInfo> statResInfoList = this.getControlStructObject().getEntryStatistics(formKey, qualifier, target, type, idList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "GET ENTRY STATISTICS RESULTS:", statResInfoList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetEntryStatistics Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void validateLicense() {
        try {
            outputWriter.driverPrintHeader("VALIDATE LICENSE");
            String licType = InputReader.getString("License Type: ");
            this.beginAPICall();
            LicenseValidInfo licValidInfo = this.getControlStructObject().validateLicense(licType);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printLicenseValidInfo("", "ARValidateLicense Results:", licValidInfo);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleFields() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE FIELDS");
            String formName = InputReader.getString("Form Name (): ", "");
            outputWriter.driverPrintPrompt("Ids of fields to retrieve:\n");
            int[] fieldIdList = InputReader.getIntArray();
            FieldCriteria criteria = new FieldCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            List<Field> fieldList = this.getControlStructObject().getListFieldObjects(formName, fieldIdList, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Field List Information:", fieldList);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListLicense() {
        try {
            outputWriter.driverPrintHeader("GET LIST LICENSE");
            String licType = InputReader.getString("License Type: ");
            this.beginAPICall();
            List<LicenseInfo> licInfo = this.getControlStructObject().getListLicense(licType);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListLicense Results:", licInfo);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void validateMultipleLicenses() {
        try {
            outputWriter.driverPrintHeader("VALIDATE MULTIPLE LICENSE");
            List<String> licTypeList = InputReader.getStringList("", "license");
            this.beginAPICall();
            List<LicenseValidInfo> licValidList = this.getControlStructObject().validateMultipleLicense(licTypeList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARValidateMultipleLicenses Results:", licValidList);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListApplicationState() {
        try {
            outputWriter.driverPrintHeader("GET LIST APPLICATION STATE");
            this.beginAPICall();
            List<String> list = this.getControlStructObject().getListApplicationState();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "getListApplicationState Results:", list);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getApplicationState() {
        try {
            outputWriter.driverPrintHeader("GET APPLICATION STATE");
            String applicationName = InputReader.getString("Application Name:");
            this.beginAPICall();
            String state = this.getControlStructObject().getApplicationState(applicationName);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Application State Data:", state);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Application State Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setApplicationState() {
        try {
            outputWriter.driverPrintHeader("SET APPLICATION STATE");
            String applicationName = InputReader.getString("Application Name:");
            String state = InputReader.getString("New state:");
            this.beginAPICall();
            this.getControlStructObject().setApplicationState(applicationName, state);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Application State Data:", state);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Application State Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getObjectChangeTimes() {
        try {
            outputWriter.driverPrintHeader("GET OBJECT CHANGE TIMES");
            this.beginAPICall();
            HashMap<Integer, ObjectOperationTimes> objList = this.getControlStructObject().getObjectChangeTimes();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("Object Change Times:");
            outputWriter.printObjectOperationTimes("", "OP TIMES", objList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Object Change Times Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getImage() {
        try {
            outputWriter.driverPrintHeader("GET IMAGE");
            String imageName = InputReader.getString("Image Name: ", "");
            String fileName = InputReader.getString("Filename to hold returned image (): ", "");
            ImageCriteria criteria = new ImageCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            Image image = this.getControlStructObject().getImage(imageName, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printImage("", "Image Information...", image);
            if (image != null && image.getImageData() != null) {
                image.getImageData().writeToFile(fileName);
                String fileInfo = "Image \"" + image.getName() + "\" saved to ";
                outputWriter.printString("", fileInfo, fileName);
                outputWriter.printNewLine();
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Image Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleImages() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE IMAGES");
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            outputWriter.driverPrintPrompt("Get images by name\n");
            List<String> imageList = InputReader.getStringList("", "");
            outputWriter.driverPrintHeader("Images are returned in files based on image name and type");
            String fileDir = InputReader.getString("Directory to place resulting images (): ", "");
            ImageCriteria criteria = new ImageCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            List<Image> objList = this.getControlStructObject().getListImageObjects(imageList, changedSince, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (objList != null && !objList.isEmpty()) {
                for (Image image : objList) {
                    outputWriter.printImage("", "Image Information...", image);
                    if (image == null || image.getImageData() == null) continue;
                    String fileName = null;
                    fileName = fileDir != null && fileDir.length() > 0 ? fileDir + "\\" + image.getName() + "." + image.getType() : ".\\" + image.getName() + "." + image.getType();
                    image.getImageData().writeToFile(fileName);
                    String fileInfo = "Image \"" + image.getName() + "\" saved to ";
                    outputWriter.printString("", fileInfo, fileName);
                    outputWriter.printNewLine();
                }
            }
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Multiple Images Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setImage() {
        try {
            outputWriter.driverPrintHeader("SET IMAGE");
            Image image = new Image();
            String name = InputReader.getString("Image Name: ");
            image.setName(name);
            if (InputReader.getBooleanForChangingInfo("Change image name? (F): ", false)) {
                String newName = InputReader.getString("Image name: ");
                image.setNewName(newName);
            }
            if (InputReader.getBooleanForChangingInfo("Change image type? (F): ", false)) {
                outputWriter.driverPrintHeader("Enter Image type (i.e., \"jpg\", \"bmp\", etc.)");
                String imageType = InputReader.getString("Image type (): ", "");
                image.setType(imageType);
            }
            if (InputReader.getBooleanForChangingInfo("Change description? (F): ", false)) {
                String description = InputReader.getString("Description (): ", "");
                image.setDescription(description);
            }
            if (InputReader.getBooleanForChangingInfo("Change image? (F): ", false)) {
                String fileName = InputReader.getString("Image File name (): ", "");
                ImageData data = new ImageData(fileName);
                image.setImageData(data);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String help = InputReader.getString("Help Text (): ", "");
                image.setHelpText(help);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String owner = InputReader.getString("New Owner");
                image.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                String diary = InputReader.getString("Change DiaryList (): ", "");
                image.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                image.setProperties(propList);
            }
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().setImage(image, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Image Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createImage() {
        try {
            outputWriter.driverPrintHeader("CREATE IMAGE");
            Image image = new Image();
            String name = InputReader.getString("Image Name: ");
            image.setName(name);
            outputWriter.driverPrintHeader("Enter Image type (i.e., \"jpg\", \"bmp\", etc.)");
            String imageType = InputReader.getString("Image Type (\"jpg\"): ", "jpg");
            image.setType(imageType);
            String description = InputReader.getString("Description (): ", "");
            image.setDescription(description);
            ImageData data = InputReader.getImageData();
            image.setImageData(data);
            String helpText = InputReader.getString("Help Text (): ", "");
            image.setHelpText(helpText);
            String owner = InputReader.getString("Owner (): ");
            image.setOwner(owner);
            String diary = InputReader.getString("Change DiaryList (): ", "");
            image.appendDiaryText(diary);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            image.setProperties(propList);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().createImage(image, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Image Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteImage() {
        try {
            outputWriter.driverPrintHeader("DELETE IMAGE");
            String imageName = InputReader.getString("Image to delete: ");
            boolean updateRef = InputReader.getBooleanForChangingInfo("Delete image references in field display props? (F): ", false);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().deleteImage(imageName, updateRef, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "DeleteImage Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListImage() {
        try {
            outputWriter.driverPrintHeader("GET LIST IMAGE");
            boolean searchAll = InputReader.getBoolean("Search all schemas for associated images? (T): ", true);
            List<String> formList = null;
            if (!searchAll) {
                outputWriter.driverPrintPrompt("Get schemas by name\n");
                formList = InputReader.getStringList("", "");
            }
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            String imageType = InputReader.getString("Get specific image type (\"jpg\", \"bmp\", etc.) (\"\"): ", "");
            outputWriter.driverPrintPrompt("list of props to search for:\n");
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<String> imageList = this.getControlStructObject().getListImage(formList, changedSince, imageType, propList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Image list: ", imageList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListImage Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void printDriverVersion() {
        outputWriter.driverPrintHeader("9.0 build001");
    }

    void getSessionConfiguration() {
        try {
            outputWriter.driverPrintHeader("GET SESSION CONFIGURATION");
            int variableId = InputReader.getInt("Session Variable Id (0): ", 0);
            this.beginAPICall();
            ARServerUser ctx = this.getControlStructObject();
            int variableValue = 0;
            switch (variableId) {
                case 1: {
                    variableValue = ctx.getChunkResponseSize();
                    break;
                }
                case 2: {
                    variableValue = ctx.getTimeoutNormal();
                    break;
                }
                case 3: {
                    variableValue = ctx.getTimeoutLong();
                    break;
                }
                case 4: {
                    variableValue = ctx.getTimeoutXLong();
                    break;
                }
                case 5: {
                    variableValue = ctx.getServerRpcQueueNumber();
                    break;
                }
                case 7: {
                    variableValue = ctx.getClientType();
                    break;
                }
                case 8: {
                    variableValue = ctx.getVUIType();
                    break;
                }
                case 9: {
                    variableValue = ctx.getOverridePrevIP() ? 1 : 0;
                    break;
                }
                case 13: 
                case 1962: {
                    variableValue = 0;
                    try {
                        variableValue = Integer.parseInt(ctx.getOverlayGroup());
                    }
                    catch (Exception e) {}
                    break;
                }
                case 12: 
                case 1961: {
                    variableValue = 0;
                    try {
                        variableValue = Integer.parseInt(ctx.getDesignOverlayGroup());
                    }
                    catch (Exception e) {}
                    break;
                }
                case 14: {
                    variableValue = 0;
                    variableValue = ctx.getGranularMode();
                    break;
                }
                case 15: {
                    variableValue = 0;
                    variableValue = Integer.parseInt(ctx.getTenantId());
                    break;
                }
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printInteger("   ", "Session Variable: ", variableValue);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void createAssociation() {
        try {
            outputWriter.driverPrintHeader("CREATE ASSOCIATION");
            int type = InputReader.getInt("Association Type DIRECT/INDIRECT (1-2) (1) : ", 1);
            String assocName = InputReader.getString("Association Name: ");
            String description = InputReader.getString("Description: ");
            String pFormName = InputReader.getString("Primary Form Name: ");
            String sFormName = InputReader.getString("Secondary Form Name: ");
            String extFormName = null;
            if (type == 2) {
                extFormName = InputReader.getString("Association FormName : ");
            }
            outputWriter.driverPrintPrompt("Primary Form ");
            QualifierInfo pQualifierInfo = InputReader.getQualifierInfo();
            outputWriter.driverPrintPrompt("Secondary Form ");
            QualifierInfo sQualifierInfo = InputReader.getQualifierInfo();
            QualifierInfo eQualifierInfo = null;
            if (type == 2) {
                outputWriter.driverPrintPrompt("Association Form ");
                eQualifierInfo = InputReader.getQualifierInfo();
            }
            Association association = InputReader.getAssociation(type);
            association.setName(assocName);
            association.setDescription(description);
            association.setPrimaryFormName(pFormName);
            association.setSecondaryFormName(sFormName);
            association.setPrimaryFormQualification(pQualifierInfo);
            association.setSecondaryFormQualification(sQualifierInfo);
            if (type == 2) {
                ((IndirectAssociation)association).setAssociationFormName(extFormName);
                ((IndirectAssociation)association).setAssociationFormQualification(eQualifierInfo);
            }
            int cardinality = InputReader.getInt("Cardinality OneToOne/OneToMany/ManyToMany (1-3) (1)", 1);
            association.setCardinality(AssociationCardinality.getEnumValue(cardinality));
            boolean enable = InputReader.getBooleanForChangingInfo("Enable, T/F? (T):", true);
            association.setEnable(enable);
            int enforcement = InputReader.getInt("Enforced Yes/No (1-2) (1):", 1);
            association.setEnforcement(AssociationEnforcement.getEnumValue(enforcement));
            String helpText = InputReader.getString("Help Text:", "");
            association.setHelpText(helpText);
            String ownerID = InputReader.getString("Owner:");
            association.setOwner(ownerID);
            String diary = InputReader.getString("Change DiaryList ():", "");
            association.appendDiaryText(diary);
            ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
            association.setProperties(propList);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().createAssociation(association, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Association Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setAssociation() {
        try {
            String formsPrompt;
            Association association = new DirectAssociation();
            int type = 1;
            String name = InputReader.getString("Association Name: ");
            if (InputReader.getBooleanForChangingInfo("Change compound association info? (F): ", false)) {
                type = InputReader.getInt("Association Type PKFK/EXTERNAL (1-2) (1) : ", 1);
                association = InputReader.getAssociation(type);
            }
            association.setName(name);
            if (InputReader.getBooleanForChangingInfo("Change Association name? (F): ", false)) {
                String newName = InputReader.getString("Association name: ");
                association.setNewName(newName);
            }
            if (InputReader.getBooleanForChangingInfo("Change description? (F): ", false)) {
                String description = InputReader.getString("Description: ", "");
                association.setDescription(description);
            }
            String string = formsPrompt = type == 2 ? "Change Primary/Secondary/External Form Names ? (F): " : "Change Primary/Secondary Form Names ? (F): ";
            if (InputReader.getBooleanForChangingInfo(formsPrompt, false)) {
                String pFormName = InputReader.getString("Primary Form Name: ");
                String sFormName = InputReader.getString("Secondary Form Name: ");
                association.setPrimaryFormName(pFormName);
                association.setSecondaryFormName(sFormName);
                if (type == 2) {
                    String eFormName = InputReader.getString("External Form Name: ");
                    ((IndirectAssociation)association).setAssociationFormName(eFormName);
                }
            }
            if (InputReader.getBooleanForChangingInfo("Change Primary Form Qualifer Info? (F): ", false)) {
                outputWriter.driverPrintPrompt("Primary Form ");
                association.setPrimaryFormQualification(InputReader.getQualifierInfo());
            }
            if (InputReader.getBooleanForChangingInfo("Change Secondary Form Qualifer Info? (F): ", false)) {
                outputWriter.driverPrintPrompt("Secondary Form ");
                association.setSecondaryFormQualification(InputReader.getQualifierInfo());
            }
            if (type == 2 && InputReader.getBooleanForChangingInfo("Change External Form Qualifer Info? (F): ", false)) {
                outputWriter.driverPrintPrompt("External Form ");
                ((IndirectAssociation)association).setAssociationFormQualification(InputReader.getQualifierInfo());
            }
            if (InputReader.getBooleanForChangingInfo("Change cardinality? (F): ", false)) {
                int cardinality = InputReader.getInt("Cardinality OneToOne/OneToMany/ManyToMany (1-3) (1)", 1);
                association.setCardinality(AssociationCardinality.getEnumValue(cardinality));
            }
            if (InputReader.getBooleanForChangingInfo("Change enabled-disabled? (F): ", false)) {
                boolean enable = InputReader.getBooleanForChangingInfo("Enable, T/F? (T):", true);
                association.setEnable(enable);
            }
            if (InputReader.getBooleanForChangingInfo("Change Enforcement? (F): ", false)) {
                int enforcement = InputReader.getInt("Enforced Yes/No (1-2) (1):", 1);
                association.setEnforcement(AssociationEnforcement.getEnumValue(enforcement));
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String help = InputReader.getString("Help Text (): ", "");
                association.setHelpText(help);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String owner = InputReader.getString("New Owner");
                association.setOwner(owner);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                String diary = InputReader.getString("Change DiaryList (): ", "");
                association.appendDiaryText(diary);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap propList = InputReader.getObjectPropertyMap();
                association.setProperties(propList);
            }
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().setAssociation(association, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Association Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void deleteAssociation() {
        try {
            outputWriter.driverPrintHeader("DELETE ASSOCIATION");
            String assocName = InputReader.getString("Association Name: ");
            int deleteOption = InputReader.getInt("Delete option ? ( 0, 1, 2, 4, 8 ) ( 0 ):", 0);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().deleteAssociation(assocName, deleteOption, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Association Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getAssociation() {
        try {
            String assocName = InputReader.getString("Association Name:", "");
            AssociationCriteria criteria = new AssociationCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            Association association = this.getControlStructObject().getAssociation(assocName, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Association Information...", association);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Association Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getListAssociation() {
        try {
            outputWriter.driverPrintHeader("GET Association LIST");
            String formName = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                formName = InputReader.getString("Form Name (): ", "");
            }
            int associationType = InputReader.getInt("AssociationType All/Direct/Indirect (0-2) (0)", 0);
            int cardinality = InputReader.getInt("Cardinality All/OneToOne/OneToMany/ManyToMany (0-3) (0)", 0);
            int enforcement = InputReader.getInt("Enforcement All/Enforced/NotEnforced (0-2)(0)", 0);
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            ObjectPropertyMap propMap = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List<String> associationNames = this.getControlStructObject().getListAssociation(formName, changedSince, propMap, enforcement, cardinality, associationType);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Association List:", associationNames);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List Association status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleAssociation() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ASSOCIATIONS");
            AssociationCriteria criteria = new AssociationCriteria();
            List<String> names = InputReader.getStringList("", "Association name");
            long changedSince = InputReader.getLong("Get all changed since (0):", 0L);
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            List<Association> associationList = this.getControlStructObject().getListAssociationObjects(names, changedSince, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Association List:", associationList);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Multiple Association status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setSessionConfiguration() {
        try {
            outputWriter.driverPrintHeader("SET SESSION CONFIGURATION");
            int variableId = InputReader.getInt("Variable Id (0): ", 0);
            Value variableValue = InputReader.getValue();
            ARServerUser ctx = this.getControlStructObject();
            this.beginAPICall();
            switch (variableId) {
                case 1: {
                    ctx.setChunkResponseSize((Integer)variableValue.getValue());
                    break;
                }
                case 2: {
                    ctx.setTimeoutNormal((Integer)variableValue.getValue());
                    break;
                }
                case 3: {
                    ctx.setTimeoutLong((Integer)variableValue.getValue());
                    break;
                }
                case 4: {
                    ctx.setTimeoutXLong((Integer)variableValue.getValue());
                    break;
                }
                case 5: {
                    ctx.usePrivateRpcQueue((Integer)variableValue.getValue());
                    break;
                }
                case 7: {
                    ctx.setClientType((Integer)variableValue.getValue());
                    break;
                }
                case 8: {
                    ctx.setVUIType((Integer)variableValue.getValue());
                    break;
                }
                case 9: {
                    int intVal = (Integer)variableValue.getValue();
                    ctx.setOverridePrevIP(intVal == 1);
                    break;
                }
                case 13: 
                case 1962: {
                    ctx.setOverlayGroup((String)variableValue.getValue());
                    break;
                }
                case 12: 
                case 1961: {
                    ctx.setDesignOverlayGroup((String)variableValue.getValue());
                    break;
                }
                case 14: {
                    ctx.setGranularMode((Integer)variableValue.getValue());
                    break;
                }
                case 15: {
                    ctx.setTenantId((String)variableValue.getValue());
                    break;
                }
                default: {
                    outputWriter.printString("Wrong tag for setSessionConfiguration tag = " + variableId);
                }
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Session Results", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void xmlCreateEntry() {
        int bytesRead = 0;
        InputStreamReader fileReader = null;
        try {
            outputWriter.driverPrintHeader("XML CREATE ENTRY");
            String fileName = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML input mapping: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String xmlInputMapping = "";
            StringBuffer stringInputMappingBuffer = new StringBuffer();
            char[] readBuffer = new char[1024];
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringInputMappingBuffer.append(readBuffer, 0, bytesRead);
            }
            xmlInputMapping = stringInputMappingBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML input document: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String xmlInputDoc = "";
            StringBuffer stringInputDocBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringInputDocBuffer.append(readBuffer, 0, bytesRead);
            }
            xmlInputDoc = stringInputDocBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML output mapping: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String outputMapping = "";
            StringBuffer stringOutputMappingBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringOutputMappingBuffer.append(readBuffer, 0, bytesRead);
            }
            outputMapping = stringOutputMappingBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            String optionDoc = "";
            for (int i = 0; i < 3 && (fileName = InputReader.getString("Filename containing XML option document: ", "")) != null && fileName.length() > 0; ++i) {
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                    StringBuffer stringOptionDocBuffer = new StringBuffer();
                    while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                        stringOptionDocBuffer.append(readBuffer, 0, bytesRead);
                    }
                    optionDoc = stringOptionDocBuffer.toString();
                    continue;
                }
            }
            String xmlOutputDoc = null;
            this.beginAPICall();
            xmlOutputDoc = this.getControlStructObject().xmlCreateEntry(xmlInputMapping, xmlInputDoc, outputMapping, optionDoc);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "XMLCreateEntry Results", statusList);
            if (xmlOutputDoc != null) {
                outputWriter.printString(xmlOutputDoc);
                return;
            }
            outputWriter.printString("xmlOutputDoc is null...\n");
            return;
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
            return;
        }
        catch (NullPointerException e) {
            outputWriter.printString("Null Pointer exception...\n");
            return;
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
            return;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void xmlGetEntry() {
        int bytesRead = 0;
        InputStreamReader fileReader = null;
        try {
            outputWriter.driverPrintHeader("XML GET ENTRY");
            String fileName = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML query mapping: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String xmlQueryMapping = "";
            StringBuffer stringQueryMappingBuffer = new StringBuffer();
            char[] readBuffer = new char[1024];
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringQueryMappingBuffer.append(readBuffer, 0, bytesRead);
            }
            xmlQueryMapping = stringQueryMappingBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML query document: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String xmlQueryDoc = "";
            StringBuffer stringQueryDocBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringQueryDocBuffer.append(readBuffer, 0, bytesRead);
            }
            xmlQueryDoc = stringQueryDocBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML output mapping: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String outputMapping = "";
            StringBuffer stringOutputMappingBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringOutputMappingBuffer.append(readBuffer, 0, bytesRead);
            }
            outputMapping = stringOutputMappingBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML option document: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String optionDoc = "";
            StringBuffer stringOptionDocBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringOptionDocBuffer.append(readBuffer, 0, bytesRead);
            }
            optionDoc = stringOptionDocBuffer.toString();
            String xmlOutputDoc = null;
            this.beginAPICall();
            xmlOutputDoc = this.getControlStructObject().xmlGetEntry(xmlQueryMapping, xmlQueryDoc, outputMapping, optionDoc);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "XMLGetEntry Results", statusList);
            if (xmlOutputDoc != null) {
                outputWriter.printString(xmlOutputDoc);
                return;
            }
            outputWriter.printString("xmlOutputDoc is null...\n");
            return;
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
            return;
        }
        catch (NullPointerException e) {
            outputWriter.printString("Null Pointer exception...\n");
            return;
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
            return;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void xmlSetEntry() {
        int bytesRead = 0;
        InputStreamReader fileReader = null;
        try {
            outputWriter.driverPrintHeader("XML SET ENTRY");
            String fileName = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML query mapping: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String xmlQueryMapping = "";
            StringBuffer stringQueryMappingBuffer = new StringBuffer();
            char[] readBuffer = new char[1024];
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringQueryMappingBuffer.append(readBuffer, 0, bytesRead);
            }
            xmlQueryMapping = stringQueryMappingBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML query document: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String xmlQueryDoc = "";
            StringBuffer stringQueryDocBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringQueryDocBuffer.append(readBuffer, 0, bytesRead);
            }
            xmlQueryDoc = stringQueryDocBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML input mapping: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String xmlInputMapping = "";
            StringBuffer stringInputMappingBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringInputMappingBuffer.append(readBuffer, 0, bytesRead);
            }
            xmlInputMapping = stringInputMappingBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML input document: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String xmlInputDoc = "";
            StringBuffer stringInputDocBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringInputDocBuffer.append(readBuffer, 0, bytesRead);
            }
            xmlInputDoc = stringInputDocBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML output mapping: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String outputMapping = "";
            StringBuffer stringOutputMappingBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringOutputMappingBuffer.append(readBuffer, 0, bytesRead);
            }
            outputMapping = stringOutputMappingBuffer.toString();
            fileReader.close();
            fileName = null;
            fileReader = null;
            for (int i = 0; i < 3; ++i) {
                fileName = InputReader.getString("Filename containing XML option document: ", "");
                if (fileName == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    fileReader = new FileReader(fileName);
                    break;
                }
                catch (FileNotFoundException e) {
                    outputWriter.printString("Input file not found\n");
                    fileName = null;
                }
            }
            if (fileName == null) {
                return;
            }
            String optionDoc = "";
            StringBuffer stringOptionDocBuffer = new StringBuffer();
            while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length - 1)) >= 0) {
                stringOptionDocBuffer.append(readBuffer, 0, bytesRead);
            }
            optionDoc = stringOptionDocBuffer.toString();
            this.beginAPICall();
            this.getControlStructObject().xmlSetEntry(xmlQueryMapping, xmlQueryDoc, xmlInputMapping, xmlInputDoc, outputMapping, optionDoc);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "XMLSetEntry Results", statusList);
            return;
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
            return;
        }
        catch (NullPointerException e) {
            outputWriter.printString("Null Pointer exception...\n");
            return;
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
            return;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    void getMultipleCurrencyRatioSets() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE CURRENCY RATIO SETS");
            List<Timestamp> timestampList = InputReader.getTimestampList();
            this.beginAPICall();
            List<String> currencyRatioSets = this.getControlStructObject().getMultipleCurrencyRatioSets(timestampList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetMultipleCurrencyRatioSets Results", statusList);
            for (int i = 0; i < currencyRatioSets.size(); ++i) {
                outputWriter.printString(currencyRatioSets.get(i) + "\n");
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getCurrencyRatio() {
        try {
            outputWriter.driverPrintHeader("GET CURRENCY RATIO");
            String currencyRatioString = InputReader.getString("Currency ratios string:", "");
            String fromCurrencyCode = InputReader.getString("From Currency Code:", "");
            System.out.println(fromCurrencyCode);
            String toCurrencyCode = InputReader.getString("To Currency Code:", "");
            System.out.println(toCurrencyCode);
            this.beginAPICall();
            BigDecimal currencyRatio = this.getControlStructObject().getCurrencyRatio(currencyRatioString.trim(), fromCurrencyCode.trim(), toCurrencyCode.trim());
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetCurrencyRadio Results", statusList);
            outputWriter.printString("Currency Ratio: " + currencyRatio.toString());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getQualifier() {
        try {
            QualifierInfo qual;
            String formName = InputReader.getString("Local Form Name: ");
            boolean x = InputReader.getNullPromptOption();
            InputReader.setNullPromptOption(true);
            String remoteformName = InputReader.getString("Remote Form Name: ");
            InputReader.setNullPromptOption(x);
            FieldCriteria crit = new FieldCriteria();
            crit.setRetrieveAll(true);
            List<Field> fieldList = this.getControlStructObject().getListFieldObjects(formName, 511, 0L, crit);
            List<Field> remoteFieldList = null;
            if (remoteformName != null) {
                remoteFieldList = this.getControlStructObject().getListFieldObjects(remoteformName, 511, 0L, crit);
            }
            int vuiId = InputReader.getInt("Enter ViewID (0):", 0);
            int opt = InputReader.getInt("Customized? (0):", 0);
            String szQual = InputReader.getString("Qualifier String: ", "");
            if (opt == 0) {
                qual = remoteFieldList == null ? this.getControlStructObject().parseQualification(szQual, fieldList, null, 0) : this.getControlStructObject().parseQualification(szQual, remoteFieldList, fieldList, 0);
            } else {
                ARQualifierHelper qualHelper = new ARQualifierHelper();
                qualHelper.generateFieldMaps(fieldList, vuiId, null, remoteFieldList);
                qual = qualHelper.parseQualification(this.getControlStructObject().getLocale(), szQual);
            }
            outputWriter.printQualifierInfo("", "", qual);
            String szQualNew = this.getControlStructObject().formatQualification(qual, fieldList, remoteFieldList, 0, false);
            System.out.println("\nOriginal Query : " + szQual);
            System.out.println("\nRebuilt Query : " + szQualNew);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            outputWriter.printARException(e);
        }
    }

    void setImpersonatedUser() {
        try {
            outputWriter.driverPrintHeader("SET IMPERSONATED USER");
            String szUser = InputReader.getString("User To Impersonate: ", "");
            this.beginAPICall();
            this.getControlStructObject().impersonateUser(szUser);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            System.out.println("\nCall Returned OK");
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void dumpProxyInfo() {
        ProxyManager.PoolInfo[] ppi = ProxyManager.getPoolInformation();
        outputWriter.printString("Pooling Info:\n");
        for (int i = 0; i < ppi.length; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(ppi[i].getPoolServerName()).append(" * ").append(new Integer(ppi[i].getPoolInUse())).append(" * ").append(new Integer(ppi[i].getPoolFree())).append(" * ").append(new Integer(ppi[i].getPoolNotCreated()));
            outputWriter.printString(sb.toString());
            outputWriter.printString("\n");
        }
    }

    void setUseConnectionPooling() {
        boolean orgFlag;
        boolean poolFlag = orgFlag = ProxyManager.isUseConnectionPooling();
        try {
            outputWriter.driverPrintHeader("SET CONNECTION POOLING");
            poolFlag = InputReader.getBooleanForChangingInfo("Use Connection Pooling (false-true) (" + orgFlag + "): ", orgFlag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (poolFlag != orgFlag) {
            ProxyManager.setUseConnectionPooling(poolFlag);
        }
    }

    void setConnectionLimitPerServer() throws IOException {
        outputWriter.driverPrintHeader("SET CONNECTION LIMITS PER SERVER");
        int currentLimits = InputReader.getInt("Maximum pooled proxy connections per server :", maxConnectionPerServer);
        ProxyManager.setConnectionLimits(currentLimits);
    }

    void adjustConnectionParametersPerServer() throws IOException {
        outputWriter.driverPrintHeader("ADJUST CONNECTION PARAMETERS PER SERVER");
        int maxProxies = InputReader.getInt("Maximum pooled proxy connections per server :", maxConnectionPerServer);
        int minProxies = InputReader.getInt("Idle Connection per server :", idleConnectionsPerServer);
        String unitStr = InputReader.getString("Time unit for connection life span and timeout (DAYS, HOURS, MINUTES, SECONDS) (" + connectionTimeUnit + "):", connectionTimeUnit);
        ARTimeUnit timeUnit = ARTimeUnit.convert(unitStr);
        long connectionTimeout = InputReader.getLong("Connection timeout (" + connectionTimeoutDefault + "):", connectionTimeoutDefault);
        long connectionLifespan = InputReader.getLong("Connection life span (" + connectionLifespanDefault + "):", connectionLifespanDefault);
        ProxyManager.PoolInfo poolSetting = new ProxyManager.PoolInfo(maxProxies, minProxies, connectionTimeout, timeUnit);
        ProxyManager.adjustConnectionPoolVariables(poolSetting);
        ProxyManager.setConnectionLifespan(connectionLifespan, timeUnit);
    }

    void getServerCharSet() {
        try {
            outputWriter.driverPrintHeader("GET SERVER CHARSET");
            this.beginAPICall();
            String charSet = this.getControlStructObject().getServerCharSet();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("", "char-set: ", charSet, "\n");
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetServerCharSet Status", statusList);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void beginApiRecording() {
        try {
            outputWriter.driverPrintHeader("BEGIN API RECORDING");
            int recordingMode = InputReader.getInt("Recording Mode (0,1,2,4,8,16,32,64)(0):", 0);
            String fileName = InputReader.getString("Command and Result Filename prefix:", "");
            List<String> fileList = this.getControlStructObject().startRecording(recordingMode, fileName);
            if (fileList.size() != 0) {
                outputWriter.print("", "Api Recording files created", fileList);
            } else {
                outputWriter.printString("Problem in creating the Api Recording files\n");
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
    }

    void stopApiRecording() {
        outputWriter.driverPrintHeader("STOP API RECORDING");
        this.getControlStructObject().stopRecording();
    }

    void termination() {
        this.getControlStructObject().logout();
    }

    void arImport() {
        try {
            outputWriter.driverPrintHeader("IMPORT");
            List<StructItemInfo> itemsList = InputReader.getStructItemInfoList();
            String fileName = InputReader.getString("Filename containing import data:", "");
            int importOption = InputReader.getInt("The import option (0):", 0);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            this.beginAPICall();
            this.getControlStructObject().importDefFromFile(fileName, importOption, itemsList, omLabelAndTaskName[0]);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARImport ", statusList);
        }
        catch (IOException e) {
            outputWriter.printString(e.getLocalizedMessage());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleEntryPoints() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ENTRYPOINTS");
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            List<String> applicationKeys = InputReader.getStringList("", "Application name");
            int[] refTypes = InputReader.getIntArray();
            String displayTag = InputReader.getString("Display Tag ():", "");
            int vuiType = InputReader.getInt("VUI Type (1-4) (0): ", 0);
            boolean hiddenFlag = InputReader.getBooleanForChangingInfo("Include hidden (false-true) (true): ", true);
            this.beginAPICall();
            List<EntryPointInfo> entryPointInfoList = this.getControlStructObject().getListEntryPoint(changedSince, applicationKeys, refTypes, vuiType, displayTag, hiddenFlag);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetMultipleEntryPoints ", statusList);
            outputWriter.print("", "Entry Points List:", entryPointInfoList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException e) {
            outputWriter.printARException(e);
        }
    }

    void beginBulkEntryTransaction() {
        try {
            outputWriter.driverPrintHeader("BEGIN BULK ENTRY TRANSACTION");
            this.beginAPICall();
            this.getControlStructObject().beginBulkEntryTransaction();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printStatusInfoList("", "BeginBulkEntryTransaction Results", this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void endBulkEntryTransaction() {
        List<BulkEntryReturn> bulkEntryReturnList = null;
        try {
            outputWriter.driverPrintHeader("END BULK ENTRY TRANSACTION");
            int actionType = InputReader.getInt("Action Type (1, 2): ", 1);
            this.beginAPICall();
            bulkEntryReturnList = this.getControlStructObject().endBulkEntryTransaction(actionType);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printBulkEntryReturnList("   ", "Bulk Entry Return", bulkEntryReturnList);
            outputWriter.printStatusInfoList("", "EndBulkEntryTransaction Results", this.getControlStructObject().getLastStatus());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (e.getClass() == ARBulkException.class) {
                bulkEntryReturnList = ((ARBulkException)e).getBulkEntryReturn();
                outputWriter.printBulkEntryReturnList("   ", "Bulk Entry Return", bulkEntryReturnList);
            }
            outputWriter.printARException(e);
        }
    }

    void beginClientManagedTransaction() {
        String transactionHandle = null;
        try {
            outputWriter.driverPrintHeader("BEGIN CLIENT MANAGED TRANSACTION");
            this.beginAPICall();
            transactionHandle = this.getControlStructObject().beginClientManagedTransaction();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("", "Transaction Handle: ", transactionHandle, null);
            outputWriter.printStatusInfoList("", "BeginClientManagedTransaction results", this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void endClientManagedTransaction() {
        try {
            int transactionOption = InputReader.getInt("Transaction Type (1 - Commit, 2 - Rollback): ", 1);
            outputWriter.driverPrintHeader("END CLIENT MANAGED TRANSACTION");
            this.beginAPICall();
            this.getControlStructObject().endClientManagedTransaction(transactionOption);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printStatusInfoList("", "EndClientManagedTransaction results", this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setClientManagedTransaction() {
        String transactionHandle = null;
        try {
            transactionHandle = InputReader.getString("Transaction handle: ", transactionHandle);
            outputWriter.driverPrintHeader("SET CLIENT MANAGED TRANSACTION");
            this.beginAPICall();
            this.getControlStructObject().setClientManagedTransaction(transactionHandle);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printStatusInfoList("", "SetClientManagedTransaction results", this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void removeClientManagedTransaction() {
        try {
            outputWriter.driverPrintHeader("REMOVE CLIENT MANAGED TRANSACTION");
            this.beginAPICall();
            this.getControlStructObject().removeClientManagedTransaction();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printStatusInfoList("", "RemoveClientManagedTransaction results", this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdExecute() {
        try {
            outputWriter.driverPrintHeader("WFD EXECUTE");
            int mode = InputReader.getInt("Execute mode ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().wfdExecute(mode);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Current Location Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdGetDebugLocation() {
        WfdDebugLocation currentLocation = null;
        try {
            outputWriter.driverPrintHeader("WFD GET CURRENT LOCATION");
            int depth = InputReader.getInt("Stack frame ? (0): ", 0);
            this.beginAPICall();
            currentLocation = this.getControlStructObject().wfdGetDebugLocation(depth);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printCurrentLocation("Current Location:\n", currentLocation);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Current Location Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdGetDebugMode() {
        try {
            outputWriter.driverPrintHeader("WFD GET DEBUG MODE");
            this.beginAPICall();
            int mode = this.getControlStructObject().wfdGetDebugMode();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printInteger("", "Debug mode is:\n", mode);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Debug Mode Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdSetDebugMode() {
        try {
            outputWriter.driverPrintHeader("WFD SET DEBUG MODE");
            int mode = InputReader.getInt("Debug mode ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().wfdSetDebugMode(mode);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Debug Mode Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdGetFieldValues() {
        try {
            outputWriter.driverPrintHeader("WFD GET FIELD VALUES");
            int depth = InputReader.getInt("Field from stack frame ? (0): ", 0);
            this.beginAPICall();
            List<Entry> fieldValues = this.getControlStructObject().wfdGetFieldValues(depth);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printEntry("", "Transaction Fields - ", fieldValues.get(0));
            outputWriter.printEntry("", "Database Fields - ", fieldValues.get(1));
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Debug Mode Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdSetFieldValues() {
        try {
            outputWriter.driverPrintHeader("WFD Set Field Values");
            ArrayList<Entry> fieldValues = new ArrayList<Entry>(2);
            outputWriter.driverPrintPrompt("Field/value pairs to set in transaction list:\n");
            Entry trans = InputReader.getEntry();
            outputWriter.driverPrintPrompt("Field/value pairs to set in database list:\n");
            Entry dbase = InputReader.getEntry();
            fieldValues.add(0, trans);
            fieldValues.add(1, dbase);
            this.beginAPICall();
            this.getControlStructObject().wfdSetFieldValues(fieldValues);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Debug Mode Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdGetFilterQual() {
        try {
            outputWriter.driverPrintHeader("WFD GET FILTER QUALIFIER");
            this.beginAPICall();
            QualifierInfo qualifier = this.getControlStructObject().wfdGetFilterQual();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printQualifierInfo("", "Filter Qualifier:\n", qualifier);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Filter Qualifier Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdTerminateAPI() {
        try {
            outputWriter.driverPrintHeader("WFD Terminate API");
            int errorCode = InputReader.getInt("Error Code to return (AR_ERROR_TERMINATED_BY_DEBUGGER): ", 9871);
            this.beginAPICall();
            this.getControlStructObject().wfdTerminateAPI(errorCode);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Terminate API Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdSetQualifierResult() {
        try {
            outputWriter.driverPrintHeader("WFD Set Qualifier Result");
            boolean result = InputReader.getBooleanForChangingInfo("Set Qualfier Result, T/F? (T): ", true);
            this.beginAPICall();
            this.getControlStructObject().wfdSetQualifierResult(result);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Qualifier Result Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void runEscalation() {
        try {
            outputWriter.driverPrintHeader("WFD Run Escalation");
            String escalation = InputReader.getString("Escalation to run: ");
            this.beginAPICall();
            this.getControlStructObject().runEscalation(escalation);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Run Escalation Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getvalidateFormCache() {
        try {
            outputWriter.driverPrintHeader("VALIDATE FORM CACHE");
            String formNm = InputReader.getString("Form name:");
            Timestamp ts = new Timestamp(0L);
            Timestamp tsAL = InputReader.getTimestamp("Get active links changed since (0): ", ts);
            Timestamp tsMenu = InputReader.getTimestamp("Get menus changed since (0):", ts);
            Timestamp tsGuide = InputReader.getTimestamp("Get guides changed since (0):", ts);
            this.beginAPICall();
            ValidateFormCacheInfo fci = this.getControlStructObject().getValidateFormCache(formNm, tsAL, tsMenu, tsGuide);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printValidateFormCache("", " ARValidateFormCache  results", fci);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "VALIDATE FORM CACHE Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    protected void wfdRmtSetBreakPt() {
        try {
            outputWriter.driverPrintHeader("WFD Set Remote Breakpoint");
            WfdBreakpoint bp = InputReader.WFDFillBreakPt(false);
            if (bp.filter == "" || bp.schema == "" || bp.stage < 2 || bp.stage > 8) {
                outputWriter.printString("Invalid Breakpoint definition. Breakpoint not set.\n");
            } else {
                this.beginAPICall();
                this.getControlStructObject().wfdSetBreakpoint(bp.id, bp);
                this.endAPICall(this.getControlStructObject().getLastStatus());
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    protected void wfdRmtClrBreakPt() {
        try {
            outputWriter.driverPrintHeader("WFD Set Remote Breakpoint");
            int bpId = InputReader.getInt("Breakpoint to clear (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().wfdClearBreakpoint(bpId);
            this.endAPICall(this.getControlStructObject().getLastStatus());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    protected void wfdRmtListBreakPt() {
        try {
            outputWriter.driverPrintHeader("WFD List Remote Breakpoint");
            this.beginAPICall();
            List<WfdBreakpoint> bps = this.getControlStructObject().wfdListBreakpoints();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            for (WfdBreakpoint bp : bps) {
                outputWriter.printBreakpoint("", bp, false);
            }
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    protected void wfdRmtClearBpList() {
        try {
            outputWriter.driverPrintHeader("WFD Clear All Remote Breakpoints");
            this.beginAPICall();
            this.getControlStructObject().wfdClearAllBreakpoints();
            this.endAPICall(this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchThread(boolean flag) {
        block20: {
            ThreadStartInfo threadStartInfo = new ThreadStartInfo();
            try {
                SyncObject waitObject;
                ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
                String msg = flag ? "LAUNCH WAITING THREAD" : "LAUNCH THREAD";
                outputWriter.driverPrintHeader(msg);
                String inputValue = InputReader.getString("Filename of input file (): ", "");
                if (inputValue == null || inputValue.length() == 0) {
                    outputWriter.driverPrintError(" **** An input file is required to launch a thread\n");
                    return;
                }
                threadStartInfo.setInputFile(new InputFile(inputValue));
                String outputValue = InputReader.getString("Filename of output file (): ", "");
                boolean isStdout = false;
                if (outputValue == null || (quietMode & SUPPRESS_RESULTS) > 0) {
                    isStdout = true;
                } else if (outputValue.length() == 0) {
                    isStdout = true;
                }
                if (isStdout) {
                    threadStartInfo.setOutputToStdOut();
                } else {
                    String fileName = null;
                    fileName = JavaDriver.getResultDirectory() == null || JavaDriver.getResultDirectory().length() == 0 ? outputValue : JavaDriver.getResultDirectory() + "\\" + outputValue;
                    threadStartInfo.setOutputFile(new PrintWriter(new FileOutputStream(new File(fileName))));
                    threadStartInfo.setOutputFileName(fileName);
                }
                String authString = InputReader.getString("Authentication string (): ", "");
                threadStartInfo.setAuthentication(authString);
                String userName = InputReader.getString("User name (): ", "");
                threadStartInfo.setUser(userName);
                String password = InputReader.getString("Password (): ", "");
                threadStartInfo.setPassword(password);
                String locale = InputReader.getString("Locale[.charSet] (): ", "");
                LocaleCharSet localeCharSet = new LocaleCharSet(locale);
                threadStartInfo.setLocale(localeCharSet.getLocale());
                threadStartInfo.setCharset(localeCharSet.getCharSet());
                String timeZone = InputReader.getString("TimeZone () : ", "");
                threadStartInfo.setTimezone(timeZone);
                String server = InputReader.getString("Server (): ", "");
                threadStartInfo.setServer(server);
                long upperBound = InputReader.getLong("Thread startup sleep range (0): ", 0L);
                threadStartInfo.setUpperBound(upperBound);
                threadStartInfo.setWaitFlag(flag);
                if (flag) {
                    threadStartInfo.setWaitObject(threadControlBlockPtr.getWaitObject());
                    threadStartInfo.setReleaseObject(threadControlBlockPtr.getReleaseObject());
                }
                JavaDriver driver = this.instantiateJavaDriver();
                driver.setThreadStartInfo(threadStartInfo);
                driver.setPrimaryThread(false);
                driver.start();
                threadControlBlockPtr.addThreadHandle(driver);
                if (!flag) break block20;
                SyncObject syncObject = waitObject = threadControlBlockPtr.getWaitObject();
                synchronized (syncObject) {
                    try {
                        while (!waitObject.getFlag()) {
                            waitObject.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        waitObject.setFlag(true);
                        System.out.println("Interrupted Exception ...in simplethread run");
                    }
                }
            }
            catch (IOException e) {
                try {
                    threadStartInfo.cleanUp();
                    outputWriter.printString("Problem in getting the input...Driver problem..\n");
                }
                catch (IOException ex) {
                    outputWriter.printString("Problem in cleaning up the thread start info..\n");
                }
            }
            catch (NullPointerException e) {
                try {
                    threadStartInfo.cleanUp();
                    outputWriter.driverPrintException(e);
                }
                catch (IOException ex) {
                    outputWriter.printString("Problem in cleaning up the thread start info..\n");
                }
            }
        }
    }

    protected JavaDriver instantiateJavaDriver() {
        return new JavaDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadStartFunction() throws IOException {
        ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
        threadControlBlockObject.setCurrentInputFile(this.threadStartInfoObject.getInputFile());
        threadControlBlockObject.setOutputFile(this.threadStartInfoObject.getOutputFile(), this.threadStartInfoObject.getOutputFileName(), this.threadStartInfoObject.getIsStdOut());
        threadControlBlockObject.setAuthentication(this.threadStartInfoObject.getAuthentication());
        threadControlBlockObject.setUser(this.threadStartInfoObject.getUser());
        threadControlBlockObject.setPassword(this.threadStartInfoObject.getPassword());
        threadControlBlockObject.setLocale(this.threadStartInfoObject.getLocale());
        threadControlBlockObject.setTimeZone(this.threadStartInfoObject.getTimezone());
        threadControlBlockObject.setServer(this.threadStartInfoObject.getServer());
        threadControlBlockObject.setPrimaryThread(false);
        if (this.threadStartInfoObject.getWaitFlag()) {
            SyncObject releaseObject;
            SyncObject waitObject;
            SyncObject syncObject = waitObject = this.threadStartInfoObject.getWaitObject();
            synchronized (syncObject) {
                waitObject.flag = true;
                waitObject.notify();
            }
            SyncObject syncObject2 = releaseObject = this.threadStartInfoObject.getReleaseObject();
            synchronized (syncObject2) {
                try {
                    while (!releaseObject.getFlag()) {
                        releaseObject.wait();
                    }
                }
                catch (InterruptedException e) {
                    releaseObject.setFlag(true);
                    System.out.println("Interrupted Exception ...in simplethread run");
                }
            }
        }
        if (this.threadStartInfoObject.getUpperBound() > 0L) {
            threadControlBlockObject.setCurrentCommand("rst");
            this.beginAPICall();
            timerCommandProcessor.randomSleep(0L, this.threadStartInfoObject.getUpperBound());
            this.endAPICall(this.getControlStructObject().getLastStatus());
        }
        this.threadStartInfoObject.cleanUp();
        this.threadStartInfoObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void run() {
        boolean unexpectedError = false;
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        try {
            if (threadControlBlockPtr == null) {
                threadControlBlockPtr = this.initThreadControlBlockPtr();
            }
            if (this.isPrimaryThread()) {
                threadControlBlockPtr.setPrimaryThread(true);
                threadControlBlockPtr.setCurrentInputToStdIn();
                threadControlBlockPtr.setOutputToStdOut();
                if (!this.processCommandLine()) {
                    System.exit(1);
                }
                outputWriter.driverPrintHelp();
                this.initCommandProcessing();
            } else {
                this.threadStartFunction();
            }
            this.processCommands();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            outputWriter.printString("IOException caught\n");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            outputWriter.printString("Exception caught" + e.getLocalizedMessage() + "\n");
            System.out.println(e.getLocalizedMessage());
            unexpectedError = true;
            return;
        }
        finally {
            try {
                this.destroyThreadControlBlockPtr(unexpectedError);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.termCommandProcessing();
                if (this.isPrimaryThread()) {
                    this.cleanupThreadEnvironment();
                }
                if (this.isPrimaryThread()) {
                    System.exit(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyThreadControlBlockPtr(boolean noWait) throws IOException {
        ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
        try {
            threadControlBlockObject.closeOutputFile();
            threadControlBlockObject.closeInputFiles();
            threadControlBlockObject.closeRecordFile();
            Thread childThread = (Thread)threadControlBlockObject.getThreadHandle();
            while (childThread != null) {
                if (!noWait && childThread.isAlive()) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                threadControlBlockObject.deleteThreadHandle();
                childThread = (Thread)threadControlBlockObject.getThreadHandle();
            }
        }
        finally {
            threadControlBlockObject.setWaitObjectToNull();
            threadControlBlockObject.setReleaseObjectToNull();
        }
    }

    protected ThreadControlBlock initThreadControlBlockPtr() {
        localStorage = new ThreadControlLocalStorage();
        return (ThreadControlBlock)localStorage.get();
    }

    public static void main(String[] args) {
        try {
            ProxyManager.setUseConnectionPooling(false);
            JavaDriver driver = new JavaDriver();
            driver.setCommandLineArgs(args);
            driver.setPrimaryThread(true);
            driver.start();
        }
        catch (Exception e) {
            outputWriter.printString("Error in executing the command\n");
        }
    }

    void setGetEntry() {
        try {
            outputWriter.driverPrintHeader("SET GET ENTRY");
            EntryKey entryKey = InputReader.getEntryKey();
            int[] entryListFields = InputReader.getIntArray();
            outputWriter.driverPrintPrompt("Field/value pairs to set:\n");
            Entry entry = InputReader.getEntry();
            Timestamp getTime = new Timestamp(InputReader.getLong("Time of Get operation (0): ", 0L));
            int option = InputReader.getInt("SetEntry option ? (0): ", 0);
            this.beginAPICall();
            Entry result = this.getControlStructObject().setGetEntry(entryKey.getFormName(), entryKey.getEntryID(), entry, getTime, option, entryListFields);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printEntry("", "Entry Information:", result);
        }
        catch (IOException x) {
            outputWriter.printString("Problem in getting the input for set entry...\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARSetGetEntryException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARSetGetStatusException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
        }
    }

    void createOverlay() {
        try {
            outputWriter.driverPrintHeader("CREATE OVERLAY");
            OverlaidInfo object = new OverlaidInfo();
            int objType = InputReader.getInt("Object Type: form(1), filter(5), activelink(6), menu(8), \nescalation(9), container(12), view(14), field(15), image(17): ", 0);
            object.setObjType(objType);
            if (objType == 15 || objType == 14) {
                String formName = InputReader.getString("Form Name (for field/view objects): ");
                object.setFormName(formName);
                int inId = InputReader.getInt("Object Id: ", 0);
                object.setId(inId);
            } else {
                object.setFormName("");
                object.setId(0);
                String name = InputReader.getString("Object Name: ");
                object.setName(name);
            }
            int inheritMask = InputReader.getInt("Inherit bit mask (0): ", 0);
            object.setInheritMask(inheritMask);
            int appendMask = InputReader.getInt("Append    bit mask (0): ", 0);
            object.setAppendMask(appendMask);
            String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
            object.setObjectModificationLogLabel(omLabelAndTaskName[0]);
            this.beginAPICall();
            OverlayPropInfo overlayProps = this.getControlStructObject().createOverlay(object);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printOverlayPropInfo("", "Overlay Object Information: ", overlayProps);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Overlay Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void createOverlayFromObject() {
        try {
            outputWriter.driverPrintHeader("CREATE OVERLAY FROM OBJECT");
            OverlaidInfo baseObject = new OverlaidInfo();
            OverlaidInfo customObject = new OverlaidInfo();
            int operationType = InputReader.getInt("Type of operation - (Convert object to custom - 1, \n\t\t\t\tConvert custom object to overlay - 2, \n\t\t\t\tConvert custom object to base - 3) (1) :", 1);
            switch (operationType) {
                case 1: {
                    int inId;
                    String formName;
                    String name = InputReader.getString("Base Object Name: ");
                    customObject.setName(name);
                    int objType = InputReader.getInt("Base Object Type: form(1), filter(5), activelink(6), menu(8), \nescalation(9), container(12), view(14), field(15), image(17): ", 0);
                    customObject.setObjType(objType);
                    if (objType == 15 || objType == 14) {
                        formName = InputReader.getString("Form Name (for field/view objects): ");
                        customObject.setFormName(formName);
                        inId = InputReader.getInt("Base Object Id: ", 0);
                        customObject.setId(inId);
                        break;
                    }
                    customObject.setFormName("");
                    customObject.setId(0);
                    break;
                }
                case 2: {
                    int inId;
                    String formName;
                    String name = InputReader.getString("Base Object Name: ");
                    baseObject.setName(name);
                    int objType = InputReader.getInt("Base Object Type: form(1), filter(5), activelink(6), menu(8), \nescalation(9), container(12), view(14), field(15), image(17): ", 0);
                    baseObject.setObjType(objType);
                    if (objType == 15 || objType == 14) {
                        formName = InputReader.getString("Form Name (for field/view objects): ");
                        baseObject.setFormName(formName);
                        inId = InputReader.getInt("Base Object Id: ", 0);
                        baseObject.setId(inId);
                    } else {
                        baseObject.setFormName("");
                        baseObject.setId(0);
                    }
                    name = InputReader.getString("Custom Object Name: ");
                    customObject.setName(name);
                    objType = InputReader.getInt("Custom Object Type: form(1), filter(5), activelink(6), menu(8), \nescalation(9), container(12), view(14), field(15), image(17): ", 0);
                    customObject.setObjType(objType);
                    if (objType == 15 || objType == 14) {
                        formName = InputReader.getString("Form Name (for field/view objects): ");
                        customObject.setFormName(formName);
                        inId = InputReader.getInt("Custom Object Id: ", 0);
                        customObject.setId(inId);
                        break;
                    }
                    customObject.setFormName("");
                    customObject.setId(0);
                    break;
                }
                case 3: {
                    int inId;
                    String formName;
                    String name = InputReader.getString("Custom Object Name: ");
                    baseObject.setName(name);
                    int objType = InputReader.getInt("Custom Object Type: form(1), filter(5), activelink(6), menu(8), \nescalation(9), container(12), view(14), field(15), image(17): ", 0);
                    baseObject.setObjType(objType);
                    if (objType == 15 || objType == 14) {
                        formName = InputReader.getString("Form Name (for field/view objects): ");
                        baseObject.setFormName(formName);
                        inId = InputReader.getInt("Base Object Id: ", 0);
                        baseObject.setId(inId);
                        break;
                    }
                    baseObject.setFormName("");
                    baseObject.setId(0);
                    break;
                }
                default: {
                    outputWriter.printString("Wrong option specifid = " + operationType);
                }
            }
            if (operationType == 1 || operationType == 2 || operationType == 3) {
                String[] omLabelAndTaskName = InputReader.getObjectModificationLogLabelAndTaskName();
                customObject.setObjectModificationLogLabel(omLabelAndTaskName[0]);
                this.beginAPICall();
                OverlayPropInfo overlayProps = this.getControlStructObject().createOverlayFromObject(baseObject, customObject);
                this.endAPICall(this.getControlStructObject().getLastStatus());
                outputWriter.printOverlayPropInfo("", "Overlay Object Information: ", overlayProps);
                List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
                outputWriter.printStatusInfoList("", "Create Overlay Status", statusList);
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void getMultipleVUI() {
        try {
            long changedSince = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            String formName = InputReader.getString("Form Name:", "");
            outputWriter.driverPrintPrompt("Ids of Views:\n");
            int[] viewIds = InputReader.getInternalIDList();
            ViewCriteria criteria = new ViewCriteria();
            criteria.setRetrieveAll(true);
            this.beginAPICall();
            List<View> viewListObjects = this.getControlStructObject().getListViewObjects(formName, changedSince, viewIds, criteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "View List Objects: ", viewListObjects.toString());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListViewObjects Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void setOverlayGroup() {
        try {
            outputWriter.driverPrintHeader("SET OVERLAY GROUP FOR OBJECTS");
            String overlayGroup = InputReader.getString("Group Name: ", "");
            this.getControlStructObject().setOverlayGroup(overlayGroup);
            System.out.println("\nCall Returned OK");
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    void verifyUser2() {
        try {
            outputWriter.driverPrintHeader("VERIFY USER2");
            this.beginAPICall();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            ARServerUser u = this.getControlStructObject();
            outputWriter.print("", "Verify User2 Results:", u);
            outputWriter.printBoolean("", "Struct Admin Flag: ", u.isStructAdmin(), "\n");
            outputWriter.printBoolean("", "Struct SubAdmin Flag: ", u.isStructSubadmin(), "\n");
            outputWriter.printBoolean("", "Overlay Group Flag: ", u.isMemberOfOverlayGroup(), "\n");
            outputWriter.printBoolean("", "Base Overlay Group Flag: ", u.isMemberOfBaseOverlayGroup(), "\n");
            List<StatusInfo> statusList = u.getLastStatus();
            outputWriter.printStatusInfoList("", "Verify User2 Status", statusList);
        }
        catch (Exception e) {
            outputWriter.driverPrintException(e);
        }
    }

    private void addWebSocketConfig() {
        outputWriter.driverPrintHeader("ADD WEBSOCKET CONFIGURATION");
        try {
            String serverToTunneling = InputReader.getString("Name of Server for tunneling:", null);
            if (serverToTunneling == null || serverToTunneling != null && serverToTunneling.length() < 1) {
                return;
            }
            String webSocket_URL = InputReader.getString("WebSocket URL :", null);
            if (webSocket_URL == null || webSocket_URL != null && webSocket_URL.length() < 1) {
                return;
            }
            String webSocket_user = "";
            String webSocket_pswd = "";
            ARWebSocketConfig onDebmandConfig = new ARWebSocketConfig(serverToTunneling, webSocket_URL, webSocket_user, webSocket_pswd);
            HashMap<String, ARWebSocketConfig> updateConfig = new HashMap<String, ARWebSocketConfig>();
            updateConfig.put(serverToTunneling, onDebmandConfig);
            ARServerUser u = this.getControlStructObject();
            ProxyManager.setWebSocket(u, updateConfig);
        }
        catch (Exception e) {
            outputWriter.driverPrintException(e);
        }
    }

    static {
        commandLineArgs = null;
        maxConnectionPerServer = 250;
        idleConnectionsPerServer = 5;
        connectionTimeoutDefault = 0L;
        connectionLifespanDefault = 0L;
        connectionTimeUnit = "MINUTES";
        localStorage = null;
        randomNumberGenerator = null;
        timerCommandProcessor = new CommandProcessor();
        outputWriter = new OutputWriter();
        javaDriverOnly = true;
        SUPPRESS_RESULTS = 1;
        SUPPRESS_HEADERS = 2;
        SUPPRESS_PROMPTS = 4;
        SUPPRESS_MENU = 8;
        SUPPRESS_ERRORS = 16;
        SUPPRESS_WARNINGS = 32;
        MAX_NESTED_LOOP_DEPTH = 10;
        RAND_MAX = Short.MAX_VALUE;
    }
}

