/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.AREncEngineFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class ARFips {
    private static Logger logger = Logger.getLogger(ARFips.class);
    private static Class cryptoJClazz;
    private static boolean cryptoJClazzChecked;
    private static boolean fipsProviderInstalled;
    private static boolean fipsProviderChecked;
    static final int FIPSMode = 0;
    static final int NON_FIPSMode = 1;
    static int currentFipsMode;
    static boolean FIPSModeChecked;
    private static final ReentrantLock FIPSModeLock;
    static Object initFips;
    static List<Integer> enabledFipsSupportAlg;
    static List<Integer> fipsNotSupportAlg;

    ARFips() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkIfFIPSProviderRegistered() {
        if (!fipsProviderChecked) {
            FIPSModeLock.lock();
            try {
                if (!fipsProviderChecked) {
                    fipsProviderInstalled = AREncEngineFactory.isProviderRegistered(ARCryptoConstants.OTHER_PROVIDERS[ARCryptoConstants.RSA_JSAFE_PROVIDER_IDX]);
                    fipsProviderChecked = true;
                    cryptoJClazz = ARFips.getCryptoJClass();
                    logger.info((Object)("fipsProviderJsafeJCE installed = " + fipsProviderInstalled));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage());
            }
            finally {
                FIPSModeLock.unlock();
            }
        }
        return fipsProviderInstalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class getCryptoJClass() {
        block8: {
            if (!cryptoJClazzChecked && cryptoJClazz == null) {
                FIPSModeLock.lock();
                try {
                    String msg;
                    if (cryptoJClazzChecked) break block8;
                    cryptoJClazzChecked = true;
                    try {
                        cryptoJClazz = Class.forName("com.rsa.jsafe.crypto.CryptoJ");
                        msg = "JsafeJCE CryptoJ class is loaded";
                    }
                    catch (Throwable e) {
                        cryptoJClazz = null;
                        msg = "JsafeJCE is not in class path to be loaded " + e.getLocalizedMessage();
                    }
                    logger.debug((Object)msg);
                }
                catch (Exception e) {
                    logger.error((Object)e.getLocalizedMessage());
                }
                finally {
                    FIPSModeLock.unlock();
                }
            }
        }
        return cryptoJClazz;
    }

    static boolean checkFIPS140Compliant(StringBuilder rtnStrBuffer) {
        boolean flag = false;
        if (rtnStrBuffer == null) {
            rtnStrBuffer = new StringBuilder();
        }
        if (!ARFips.checkIfFIPSProviderRegistered()) {
            return flag;
        }
        Class clazz = ARFips.getCryptoJClass();
        if (clazz == null) {
            return flag;
        }
        Boolean fips140CompliantRtn = null;
        try {
            Method isFIPS140CompliantMethod = clazz.getDeclaredMethod("isFIPS140Compliant", null);
            assert (isFIPS140CompliantMethod != null);
            fips140CompliantRtn = (Boolean)isFIPS140CompliantMethod.invoke(null, (Object[])null);
        }
        catch (Throwable e) {
            String msg = "JsafeJCE isFIPS140Compliant() invoke failed";
            rtnStrBuffer.append("\n").append(msg);
            logger.debug((Object)msg);
        }
        if (fips140CompliantRtn == null || !fips140CompliantRtn.booleanValue()) {
            rtnStrBuffer.append("\n").append("Crypto-J is not FIPS140Compliant");
            logger.info((Object)rtnStrBuffer.toString());
            return false;
        }
        Boolean selfTestPassedRtn = null;
        try {
            Method selfTestPassedMethod = clazz.getDeclaredMethod("selfTestPassed", null);
            assert (selfTestPassedMethod != null);
            selfTestPassedRtn = (Boolean)selfTestPassedMethod.invoke(null, (Object[])null);
        }
        catch (Throwable e) {
            String msg = "JsafeJCE selfTestPassed() invoke failed";
            logger.debug((Object)msg);
            rtnStrBuffer.append("\n").append(msg);
        }
        if (selfTestPassedRtn == null || !selfTestPassedRtn.booleanValue()) {
            rtnStrBuffer.append("Crypto-J is disabled, power-up self-testing failed");
            flag = false;
        } else {
            rtnStrBuffer.append("Crypto-J is FIPS140Compliant, power-up self-testing succeed");
            flag = true;
        }
        logger.info((Object)rtnStrBuffer.toString());
        return flag;
    }

    static String setFIPSMode(int setToMode) {
        int providerMode;
        StringBuilder modeLogMsg = new StringBuilder();
        switch (setToMode) {
            case 2: {
                providerMode = 0;
                ARCryptoConstants.JCE_PROVIDER_IDX = ARCryptoConstants.JCE_FIPS_PROVIDER_IDX;
                modeLogMsg.append("FIPS140_MODE");
                break;
            }
            default: {
                providerMode = 1;
                ARCryptoConstants.JCE_PROVIDER_IDX = ARCryptoConstants.JRE_VENDER_IDX;
                modeLogMsg.append("NON_FIPS140_MODE");
            }
        }
        Class clazz = ARFips.getCryptoJClass();
        if (clazz == null) {
            modeLogMsg.append(" can not turned in Fips library. Will use different providers for different level of encrytion needs. ");
            return modeLogMsg.toString();
        }
        try {
            Method setModeMethod = clazz.getDeclaredMethod("setMode", Integer.TYPE);
            assert (setModeMethod != null);
            setModeMethod.invoke(null, new Integer(providerMode));
        }
        catch (Throwable e) {
            String msg = "JsafeJCE setMode() invoke failed. ";
            modeLogMsg.append("\n").append(msg);
            logger.debug((Object)msg);
        }
        currentFipsMode = setToMode;
        if (!FIPSModeChecked) {
            FIPSModeChecked = true;
        }
        return modeLogMsg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentModeSupportedAlg(int alg, boolean validFipsDataEncAlg) {
        boolean flag = true;
        if (!FIPSModeChecked) {
            FIPSModeLock.lock();
            try {
                if (!FIPSModeChecked && ARFips.checkIfFIPSProviderRegistered()) {
                    StringBuilder strB = new StringBuilder();
                    currentFipsMode = ARCryptoConstants.FIPS_ENABLED_MODE_AUTO_CHECK && validFipsDataEncAlg && ARFips.checkValidFipsEnabledDataEncAlgorithm(alg) ? 2 : 0;
                    String msg = ARFips.setFIPSMode(currentFipsMode);
                    strB.append(msg);
                    logger.info((Object)strB.toString());
                }
                FIPSModeChecked = true;
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage());
            }
            finally {
                FIPSModeLock.unlock();
            }
        }
        if (ARCryptoConstants.FIPS_ENABLED_MODE_AUTO_CHECK && ARFips.checkIfFIPSProviderRegistered()) {
            switch (currentFipsMode) {
                case 2: {
                    flag = enabledFipsSupportAlg.contains(alg);
                    break;
                }
                case 0: {
                    flag = fipsNotSupportAlg.contains(alg);
                    break;
                }
                default: {
                    flag = false;
                }
            }
        }
        return flag;
    }

    static boolean checkValidFipsEnabledDataEncAlgorithm(int alg) {
        boolean validFlag = false;
        for (int i = 0; i < ARCryptoConstants.AR_DATA_FIPS_ENABLED_ENC_VALID_RMOD.length; ++i) {
            if (ARCryptoConstants.AR_DATA_FIPS_ENABLED_ENC_VALID_RMOD[i] != alg) continue;
            validFlag = true;
            break;
        }
        return validFlag;
    }

    static {
        currentFipsMode = 0;
        FIPSModeChecked = false;
        FIPSModeLock = new ReentrantLock();
        initFips = new Object();
        enabledFipsSupportAlg = new ArrayList<Integer>();
        fipsNotSupportAlg = new ArrayList<Integer>();
        fipsNotSupportAlg.add(new Integer(1));
        fipsNotSupportAlg.add(new Integer(2));
        fipsNotSupportAlg.add(new Integer(3));
        fipsNotSupportAlg.add(new Integer(6));
        fipsNotSupportAlg.add(new Integer(7));
        enabledFipsSupportAlg.add(new Integer(8));
        enabledFipsSupportAlg.add(new Integer(9));
    }
}

