/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncEnginePool;
import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARKeyMask;
import com.bmc.arsys.arencrypt.ARSecretKeyFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.log4j.Logger;

class AREncEngineFactory {
    private static transient Map<String, AREncEnginePool> engineInstanceMap;
    private transient ARSecretKeyFactory secretKeyFactory;
    private static final transient AREncEngineFactory instance;
    private static Logger logger;
    protected boolean obfuscated = !"AREncEngineFactory".equals(AREncEngineFactory.class.getSimpleName());

    private AREncEngineFactory() {
        engineInstanceMap = new ConcurrentHashMap<String, AREncEnginePool>();
        this.secretKeyFactory = ARSecretKeyFactory.getInstance();
    }

    static AREncEngineFactory getInstance() {
        return instance;
    }

    Object getEncEngineInstance(String encType, AREncKeyBase encKey) throws AREncryptionException {
        Object engine;
        String instEntry = encKey.toString();
        if (encKey.isEngineCacheable()) {
            AREncEnginePool enginePool = this.getEnginePool(instEntry);
            engine = enginePool.borrowEngine(encType, encKey, this);
        } else {
            engine = this.generateEngineInstance(encType, encKey);
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AREncEnginePool getEnginePool(String instEntry) {
        AREncEnginePool enginePool;
        Map<String, AREncEnginePool> map = engineInstanceMap;
        synchronized (map) {
            enginePool = engineInstanceMap.get(instEntry);
            if (enginePool == null) {
                enginePool = new AREncEnginePool(instEntry);
                engineInstanceMap.put(instEntry, enginePool);
            }
        }
        return enginePool;
    }

    void releaseEncEngineInstance(AREncKeyBase encKey, Object engine) {
        String InstEntry = encKey.toString();
        if (engine != null && encKey.isEngineCacheable() && engineInstanceMap.containsKey(InstEntry)) {
            engineInstanceMap.get(InstEntry).returnEngine(engine);
        }
    }

    Object generateEngineInstance(String encType, AREncKeyBase encKey) throws AREncryptionException {
        Object rst;
        StringBuilder strB;
        String provider;
        block30: {
            String encAlg = encKey.getEncAlgorithmStr();
            provider = encKey.getProvider();
            if (!this.obfuscated && logger.isDebugEnabled()) {
                strB = new StringBuilder();
                strB.append("will call jdk calling for encType = ");
                if (encKey.getEncXForm() != null) {
                    strB.append(encType + ", encXForm = \"" + encKey.getEncXForm() + "\"");
                }
                strB.append(", provider = " + provider);
                logger.debug((Object)strB.toString());
            }
            try {
                if (encType.equals("Salt")) {
                    Cipher cipher;
                    if (provider != null) {
                        if (!this.obfuscated && logger.isDebugEnabled()) {
                            logger.debug((Object)("calling JDK javax.crypto.Cipher.getInstance(\"" + encKey.getEncXForm() + "\", " + provider + ")"));
                        }
                        cipher = Cipher.getInstance(encKey.getEncXForm(), provider);
                    } else {
                        if (!this.obfuscated && logger.isDebugEnabled()) {
                            logger.debug((Object)("calling JDK javax.crypto.Cipher.getInstance(\"" + encKey.getEncXForm() + "\")"));
                        }
                        cipher = Cipher.getInstance(encKey.getEncXForm());
                    }
                    rst = cipher;
                    break block30;
                }
                if (encType.equals("MacGen")) {
                    Mac mac;
                    if (provider != null) {
                        if (!this.obfuscated && logger.isDebugEnabled()) {
                            logger.debug((Object)("calling JDK javax.crypto.Mac.getInstance(\"" + encAlg + "\", " + provider + ")"));
                        }
                        mac = Mac.getInstance(encAlg, provider);
                    } else {
                        if (!this.obfuscated && logger.isDebugEnabled()) {
                            logger.debug((Object)("calling JDK javax.crypto.Mac.getInstance(\"" + encAlg + "\")"));
                        }
                        mac = Mac.getInstance(encAlg);
                    }
                    rst = mac;
                    break block30;
                }
                if (encType.equals("MD")) {
                    MessageDigest md;
                    if (provider != null) {
                        if (!this.obfuscated && logger.isDebugEnabled()) {
                            logger.debug((Object)("calling JDK java.security.MessageDigest.getInstance(\"" + encKey.getEncAlgorithmStr() + "\", " + provider + ")"));
                        }
                        md = MessageDigest.getInstance(encKey.getEncAlgorithmStr(), provider);
                    } else {
                        if (!this.obfuscated && logger.isDebugEnabled()) {
                            logger.debug((Object)("calling JDK java.security.MessageDigest.getInstance(\"" + encKey.getEncAlgorithmStr() + "\")"));
                        }
                        md = MessageDigest.getInstance(encKey.getEncAlgorithmStr());
                    }
                    rst = md;
                    break block30;
                }
                if (encType.equals("Enc") || encType.equals("PPKey") || encType.equals("PubKey") || encType.equals("PriKey")) {
                    Cipher cipher;
                    if (provider != null) {
                        if (!this.obfuscated && logger.isDebugEnabled()) {
                            logger.debug((Object)("calling JDK javax.crypto.Cipher.getInstance(\"" + encKey.getEncXForm() + "\", " + provider + ")"));
                        }
                        cipher = Cipher.getInstance(encKey.getEncXForm(), provider);
                    } else {
                        if (!this.obfuscated && logger.isDebugEnabled()) {
                            logger.debug((Object)("calling JDK javax.crypto.Cipher.getInstance(\"" + encKey.getEncXForm() + "\")"));
                        }
                        cipher = Cipher.getInstance(encKey.getEncXForm());
                    }
                    rst = cipher;
                    break block30;
                }
                throw new AREncryptionException(9007, "Engine for " + encType + " is not been supported by AR.");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AREncryptionException(e, 9007);
            }
            catch (NoSuchPaddingException e) {
                throw new AREncryptionException(e, 9005);
            }
            catch (NoSuchProviderException e) {
                throw new AREncryptionException(9010, "Need to install the encryption on the client");
            }
            catch (Throwable e) {
                StringBuilder strB2 = new StringBuilder();
                strB2.append("error on ");
                if (encKey.getEncXForm() != null) {
                    strB2.append(encType + ", encXForm = \"" + encKey.getEncXForm() + "\"");
                }
                strB2.append(", provider = " + provider);
                logger.error((Object)strB2.toString());
                logger.error((Object)("gets cipher error : " + e.getLocalizedMessage()));
                throw new AREncryptionException(e, 9010);
            }
        }
        if (!this.obfuscated && logger.isDebugEnabled()) {
            strB = new StringBuilder();
            strB.append("finished jdk calling for encType = ");
            if (encKey.getEncXForm() != null) {
                strB.append(encType + ", encXForm = \"" + encKey.getEncXForm() + "\"");
            }
            strB.append(", provider = " + provider);
            logger.debug((Object)strB.toString());
        }
        return rst;
    }

    void initEngine(Object engine, String encType, AREncKeyBase encKey) throws AREncryptionException {
        int cipherMode = encKey.getEncMode();
        SecretKey key = this.secretKeyFactory.getSecretKeyInstance(encType, encKey);
        try {
            if (encType.equals("Salt") && engine instanceof Cipher) {
                IvParameterSpec ips = new IvParameterSpec(ARKeyMask.getUnMaskedKeyBytes(encKey, ARKeyMask.Idx.S));
                ((Cipher)engine).init(cipherMode, (Key)key, ips);
            } else if (encType.equals("MacGen") && engine instanceof Mac) {
                ((Mac)engine).init(key);
            } else if (encType.equals("Enc") && engine instanceof Cipher) {
                byte[] ivb = ARKeyMask.getUnMaskedKeyBytes(encKey, ARKeyMask.Idx.I);
                if (ivb != null && key != null && !encKey.getEncAlgorithmStr().equals("RC4")) {
                    IvParameterSpec ips = new IvParameterSpec(ivb);
                    ((Cipher)engine).init(cipherMode, (Key)key, ips, null);
                } else if (key != null) {
                    ((Cipher)engine).init(cipherMode, key);
                }
            } else if (!encType.equals("MD") || !(engine instanceof MessageDigest)) {
                throw new AREncryptionException(new NoSuchAlgorithmException("Engine for " + encType + " not been supported by AR."), 9007);
            }
        }
        catch (InvalidKeyException e) {
            throw new AREncryptionException(e, 9005);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new AREncryptionException(e, 9005);
        }
    }

    static boolean isProviderRegistered(String provider) {
        boolean flag = false;
        if (provider == null) {
            return true;
        }
        try {
            Provider theProvider = Security.getProvider(provider);
            if (theProvider != null) {
                flag = true;
            }
        }
        catch (Throwable e) {
            flag = false;
            logger.info((Object)("provider " + provider + " is not registered."));
        }
        return flag;
    }

    static {
        instance = new AREncEngineFactory();
        logger = Logger.getLogger(AREncEngineFactory.class);
    }
}

