/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.AREncEnginePool;
import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARFips;
import com.bmc.arsys.arencrypt.ARKeyMask;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.utils.ARCommonConfig;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class ARDataKey
extends AREncKeyBase {
    private byte[] macKey;
    private byte[] saltIv;
    private int encBlockInfoSize = 16;
    private static Logger logger = Logger.getLogger(ARDataKey.class);
    private static boolean _DEBUG_CONFIG_ON = ARDataKey.isDebugEnabled();
    protected boolean macMasked = false;
    protected boolean saltIvMasked = false;
    private boolean logFlag = false;

    private static boolean isDebugEnabled() {
        return logger.isDebugEnabled() && ARCommonConfig.getInstance().getLogBytes();
    }

    public ARDataKey(String encType, String encAlgorithmStr) {
        super(encType, encAlgorithmStr);
        boolean macMasked = true;
        this.macKey = ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.M, macMasked);
        this.setMacMasked(macMasked);
    }

    public ARDataKey() {
        this.setMacKey(new byte[0]);
        this.logFlag = _DEBUG_CONFIG_ON;
    }

    public void setAlgorithmParam(int encAlgorithm) throws AREncryptionException {
        this.setEncAlgorithm(encAlgorithm);
        this.setEncAlgorithmStr(ARCryptoConstants.AR_DATA_ENC_ALG_STR[encAlgorithm - 1]);
        this.setEncType(ARCryptoConstants.AR_DATA_ENC_TYPE[encAlgorithm - 1]);
        this.setEncXForm(ARCryptoConstants.AR_DATA_ENC_XFORM[encAlgorithm - 1]);
        this.setEncMode(2);
        this.setKeySize(ARCryptoConstants.AR_DATA_ENC_ENC_BITS[encAlgorithm - 1]);
        this.setEncBlockInfoSize(this.isFIPSAlg() ? 20 : 16);
        this.setProvider(ARCryptoConstants.ENC_CIPHER_PROVIDERS[ARCryptoConstants.JCE_PROVIDER_IDX][encAlgorithm - 1]);
    }

    void setSeedType(int seedType) {
        boolean isKeyMasked = true;
        boolean isIvMasked = true;
        boolean isSaltIvMasked = true;
        this.setKeyMasked(isKeyMasked);
        this.setIvMasked(isIvMasked);
        this.setSaltIvMasked(isSaltIvMasked);
        switch (seedType) {
            case 1: {
                if (this.logFlag) {
                    logger.debug((Object)" JAVA_SEED ");
                }
                this.setKey(ARKeyMask.getMaskedKeyBytes(1, ARKeyMask.Idx.K, isKeyMasked));
                this.setIv(ARKeyMask.getMaskedKeyBytes(1, ARKeyMask.Idx.I, isIvMasked));
                this.setSaltIv(ARKeyMask.getMaskedKeyBytes(1, ARKeyMask.Idx.S, isSaltIvMasked));
                break;
            }
            case 2: {
                if (this.logFlag) {
                    logger.debug((Object)" ODBC_SEED ");
                }
                this.setKey(ARKeyMask.getMaskedKeyBytes(2, ARKeyMask.Idx.K, isKeyMasked));
                this.setIv(ARKeyMask.getMaskedKeyBytes(2, ARKeyMask.Idx.I, isIvMasked));
                this.setSaltIv(ARKeyMask.getMaskedKeyBytes(2, ARKeyMask.Idx.S, isSaltIvMasked));
                break;
            }
            case 3: {
                if (this.logFlag) {
                    logger.debug((Object)" EXPORT_SEED ");
                }
                this.setKey(ARKeyMask.getMaskedKeyBytes(3, ARKeyMask.Idx.K, isKeyMasked));
                this.setIv(ARKeyMask.getMaskedKeyBytes(3, ARKeyMask.Idx.I, isIvMasked));
                this.setSaltIv(ARKeyMask.getMaskedKeyBytes(3, ARKeyMask.Idx.S, isSaltIvMasked));
                break;
            }
            case 4: {
                if (this.logFlag) {
                    logger.debug((Object)" NETWORK_SEED ");
                }
                this.setKey(ARKeyMask.getMaskedKeyBytes(4, ARKeyMask.Idx.K, isKeyMasked));
                this.setIv(ARKeyMask.getMaskedKeyBytes(4, ARKeyMask.Idx.I, isIvMasked));
                this.setSaltIv(ARKeyMask.getMaskedKeyBytes(4, ARKeyMask.Idx.S, isSaltIvMasked));
                break;
            }
            default: {
                this.setKey(ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.K, isKeyMasked));
                this.setIv(ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.I, isIvMasked));
                this.setSaltIv(ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.S, isSaltIvMasked));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.macKey != null) {
            sb.append("_").append("mac");
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.macKey).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AREncEnginePool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ARDataKey rhs = (ARDataKey)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.macKey, rhs.macKey).isEquals();
    }

    byte[] getMacKey() {
        return this.macKey;
    }

    void setMacKey(byte[] macKey) {
        this.macKey = macKey;
    }

    byte[] getSaltIv() {
        return this.saltIv;
    }

    void setSaltIv(byte[] saltIv) {
        this.saltIv = saltIv;
    }

    int getEncBlockInfoSize() {
        return this.encBlockInfoSize;
    }

    private void setEncBlockInfoSize(int encBlockInfoSize) {
        this.encBlockInfoSize = encBlockInfoSize;
    }

    @Override
    protected boolean checkValidDataEncAlgorithm(int alg, int encryptPolicy) throws AREncryptionException {
        boolean flag = ARDataKey.checkValidNoneFipsDataEncAlgorithm(alg);
        if (-1 != encryptPolicy) {
            boolean validFipsDataEncAlg;
            boolean bl = validFipsDataEncAlg = 1 == encryptPolicy && ARDataKey.checkValidFipsDataEncAlgorithm(alg);
            if (validFipsDataEncAlg || flag) {
                flag = this.isCurrentModeSupportedAlg(alg, validFipsDataEncAlg);
            }
        }
        return flag;
    }

    private boolean isCurrentModeSupportedAlg(int alg, boolean validFipsDataEncAlg) {
        boolean flag = true;
        if (arFips != null) {
            flag = arFips.isCurrentModeSupportedAlg(alg, validFipsDataEncAlg);
        }
        return flag;
    }

    public int validateAlgAndPolicyForFipsModeCheck(int encAlgorithm, int encryptPolicy, String serverName) throws AREncryptionException {
        int newAlg = encAlgorithm;
        int algToCheck = encAlgorithm;
        if (encryptPolicy == 2) {
            algToCheck = 1;
        }
        if (!this.checkValidDataEncAlgorithm(algToCheck, encryptPolicy)) {
            String msg;
            int errorCode;
            String appendTxt = serverName;
            if (ARFips.enabledFipsSupportAlg.contains(algToCheck)) {
                errorCode = 9018;
                msg = "error:" + errorCode + " Client cannot connect to this server because it enforces FIPS and the client is connected to a server that does not enforce FIPS. Connection failed to" + appendTxt;
            } else {
                errorCode = 9019;
                msg = "error:" + errorCode + " Client cannot connect to this server because the server does not enforce FIPS and the client is connected to a server that requires its clients to enforce FIPS. Connection failed to" + appendTxt;
            }
            logger.debug((Object)msg);
            throw new AREncryptionException(errorCode, appendTxt);
        }
        return newAlg;
    }

    static boolean checkValidNoneFipsDataEncAlgorithm(int alg) {
        boolean validFlag = false;
        for (int i = 0; i < ARCryptoConstants.AR_DATA_ENC_NONE_FIPS_VALID_RMOD.length; ++i) {
            if (ARCryptoConstants.AR_DATA_ENC_NONE_FIPS_VALID_RMOD[i] != alg) continue;
            validFlag = true;
            break;
        }
        return validFlag;
    }

    boolean isFIPSAlg() {
        return ARDataKey.checkValidFipsDataEncAlgorithm(this.getEncAlgorithm());
    }

    static boolean checkValidFipsDataEncAlgorithm(int alg) {
        boolean validFlag = false;
        for (int i = 0; i < ARCryptoConstants.AR_DATA_FIPS_CAPABLE_ENC_RMOD.length; ++i) {
            if (ARCryptoConstants.AR_DATA_FIPS_CAPABLE_ENC_RMOD[i] != alg) continue;
            validFlag = true;
            break;
        }
        return validFlag;
    }

    public static int validateNetworkDataEncConfigSetting(int policy, int keyAlg, int dataAlg) throws AREncryptionException {
        String msg;
        int errorCode = 0;
        if (ARFips.checkValidFipsEnabledDataEncAlgorithm(dataAlg)) {
            if (policy == 0) {
                errorCode = 9020;
                String msg2 = "can not set encryption policy to =" + policy + " for FIPS. errorCode = " + errorCode;
                logger.error((Object)msg2);
                throw new AREncryptionException(errorCode, msg2);
            }
            if (policy < 0 || policy > 2) {
                policy = 1;
                msg = "encryptionPolicy will be enforced to required.";
                logger.info((Object)msg);
            }
        } else if (policy < 0 || policy > 2) {
            policy = 2;
            msg = "encryptionPolicy will be enforced to disallowed.";
            logger.info((Object)msg);
        }
        if (policy != 2) {
            if (!ARPPKey.isValidKeyAlg(keyAlg)) {
                errorCode = 9006;
                msg = "publicKeyAlg=" + keyAlg + " is not support. errorCode = " + errorCode;
                logger.error((Object)msg);
                throw new AREncryptionException(errorCode, msg);
            }
            if (!ARDataKey.checkValidNoneFipsDataEncAlgorithm(dataAlg) && !ARDataKey.checkValidFipsDataEncAlgorithm(dataAlg)) {
                errorCode = 9007;
                msg = "dataEncryptionAlg" + dataAlg + " is not support. errorCode = " + errorCode;
                logger.error((Object)msg);
                throw new AREncryptionException(errorCode, msg);
            }
        }
        return policy;
    }

    boolean isMacMasked() {
        return this.macMasked;
    }

    void setMacMasked(boolean macMasked) {
        this.macMasked = macMasked;
    }

    boolean isSaltIvMasked() {
        return this.saltIvMasked;
    }

    void setSaltIvMasked(boolean saltIvMasked) {
        this.saltIvMasked = saltIvMasked;
    }
}

