/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wsn;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.bridge.WebSocketNativeBridgeHandler;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeAuthenticationHandler;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeBalancingHandler;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeCodec;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeControlFrameHandler;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeHandshakeHandler;
import com.kaazing.gateway.client.html5.util.WSURI;
import java.util.logging.Logger;

public class WebSocketNativeHandler
extends WebSocketHandlerAdapter {
    private static final String CLASS_NAME = WebSocketNativeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private WebSocketNativeAuthenticationHandler authHandler = new WebSocketNativeAuthenticationHandler();
    private WebSocketNativeHandshakeHandler handshakeHandler = new WebSocketNativeHandshakeHandler();
    private WebSocketNativeControlFrameHandler controlFrameHandler = new WebSocketNativeControlFrameHandler();
    private WebSocketNativeBalancingHandler balancingHandler = new WebSocketNativeBalancingHandler();
    private WebSocketNativeCodec codec = new WebSocketNativeCodec();
    private WebSocketNativeBridgeHandler bridgeHandler = new WebSocketNativeBridgeHandler();

    public WebSocketNativeHandler() {
        LOG.entering(CLASS_NAME, "<init>");
        this.authHandler.setNextHandler(this.handshakeHandler);
        this.handshakeHandler.setNextHandler(this.controlFrameHandler);
        this.controlFrameHandler.setNextHandler(this.balancingHandler);
        this.balancingHandler.setNextHandler(this.codec);
        this.codec.setNextHandler(this.bridgeHandler);
        this.nextHandler = this.authHandler;
        this.nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketNativeHandler.this.listener.connectionOpened(channel, protocol);
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer buf) {
                WebSocketNativeHandler.this.listener.messageReceived(channel, buf);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                WebSocketNativeHandler.this.listener.connectionClosed(channel);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
                WebSocketNativeHandler.this.listener.connectionFailed(channel);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
            }
        });
    }

    @Override
    public synchronized void processConnect(WebSocketChannel channel, WSURI location, String protocol) {
        LOG.entering(CLASS_NAME, "connect", channel);
        if (channel.isBinary) {
            location = (WSURI)location.addQueryParameter("encoding=binary");
        }
        this.nextHandler.processConnect(channel, location, protocol);
    }

    public int getBufferedAmount() {
        return 0;
    }
}

