/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.annotation;

import com.bmc.thirdparty.org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanNameGenerator;
import com.bmc.thirdparty.org.springframework.context.annotation.AnnotationConfigUtils;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationAttributes;
import com.bmc.thirdparty.org.springframework.core.type.AnnotatedTypeMetadata;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.beans.Introspector;
import java.util.Map;
import java.util.Set;

public class AnnotationBeanNameGenerator
implements BeanNameGenerator {
    private static final String COMPONENT_ANNOTATION_CLASSNAME = "com.bmc.thirdparty.org.springframework.stereotype.Component";

    @Override
    public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        String beanName;
        if (definition instanceof AnnotatedBeanDefinition && StringUtils.hasText(beanName = this.determineBeanNameFromAnnotation((AnnotatedBeanDefinition)definition))) {
            return beanName;
        }
        return this.buildDefaultBeanName(definition, registry);
    }

    protected String determineBeanNameFromAnnotation(AnnotatedBeanDefinition annotatedDef) {
        AnnotationMetadata amd = annotatedDef.getMetadata();
        Set<String> types = amd.getAnnotationTypes();
        String beanName = null;
        for (String type : types) {
            String strVal;
            Object value;
            AnnotationAttributes attributes = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)amd, type);
            if (!this.isStereotypeWithNameValue(type, amd.getMetaAnnotationTypes(type), attributes) || !((value = attributes.get("value")) instanceof String) || !StringUtils.hasLength(strVal = (String)value)) continue;
            if (beanName != null && !strVal.equals(beanName)) {
                throw new IllegalStateException("Stereotype annotations suggest inconsistent component names: '" + beanName + "' versus '" + strVal + "'");
            }
            beanName = strVal;
        }
        return beanName;
    }

    protected boolean isStereotypeWithNameValue(String annotationType, Set<String> metaAnnotationTypes, Map<String, Object> attributes) {
        boolean isStereotype = annotationType.equals(COMPONENT_ANNOTATION_CLASSNAME) || metaAnnotationTypes != null && metaAnnotationTypes.contains(COMPONENT_ANNOTATION_CLASSNAME) || annotationType.equals("javax.annotation.ManagedBean") || annotationType.equals("javax.inject.Named");
        return isStereotype && attributes != null && attributes.containsKey("value");
    }

    protected String buildDefaultBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        return this.buildDefaultBeanName(definition);
    }

    protected String buildDefaultBeanName(BeanDefinition definition) {
        String shortClassName = ClassUtils.getShortName(definition.getBeanClassName());
        return Introspector.decapitalize(shortClassName);
    }
}

