/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.FuncCurrencyInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.List;

public class ARQualifierEncoder {
    private static final String SEPARATOR = "\\";
    private ARServerUser context;
    private QualifierInfo qualifier;
    private String _serverCharSet;

    public ARQualifierEncoder(QualifierInfo qualifier, ARServerUser context) throws ARException {
        this.context = context;
        this.qualifier = qualifier;
        this._serverCharSet = this.context.getServerCharSet();
    }

    public String encode() throws ARException {
        return this.encodeQualifierInfo(this.qualifier);
    }

    private String encodeQualifierInfo(QualifierInfo qf) throws ARException {
        String leftOprnd = "";
        String rightOprnd = "";
        int operationOfQualInfo = 0;
        if (qf != null) {
            operationOfQualInfo = qf.getOperation();
        }
        StringBuilder result = new StringBuilder();
        result.append(operationOfQualInfo + SEPARATOR);
        switch (operationOfQualInfo) {
            case 0: {
                return null;
            }
            case 1: {
                leftOprnd = this.encodeQualifierInfo(qf.getLeftOperand());
                rightOprnd = this.encodeQualifierInfo(qf.getRightOperand());
                result.append(leftOprnd);
                result.append(rightOprnd);
                break;
            }
            case 2: {
                leftOprnd = this.encodeQualifierInfo(qf.getLeftOperand());
                rightOprnd = this.encodeQualifierInfo(qf.getRightOperand());
                result.append(leftOprnd);
                result.append(rightOprnd);
                break;
            }
            case 3: {
                rightOprnd = this.encodeQualifierInfo(qf.getNotOperand());
                result.append(rightOprnd);
                break;
            }
            case 4: {
                RelationalOperationInfo roi = qf.getRelationalOperationInfo();
                String encodedRoi = this.encodeRelationalOperationInfo(roi, qf);
                result.append(encodedRoi);
                break;
            }
            case 5: {
                result.append(qf.getFromFieldInfo().getValue() + SEPARATOR);
                break;
            }
        }
        return result.toString();
    }

    private String encodeRelationalOperationInfo(RelationalOperationInfo relOprn, QualifierInfo qual) throws ARException {
        StringBuilder result = new StringBuilder();
        switch (relOprn.getOperation()) {
            case 1: {
                result.append("1\\");
                break;
            }
            case 2: {
                result.append("2\\");
                break;
            }
            case 3: {
                result.append(3);
                result.append(SEPARATOR);
                break;
            }
            case 8: {
                result.append(8);
                result.append(SEPARATOR);
                break;
            }
            case 4: {
                result.append(4);
                result.append(SEPARATOR);
                break;
            }
            case 5: {
                result.append(5);
                result.append(SEPARATOR);
                break;
            }
            case 7: {
                result.append(7);
                result.append(SEPARATOR);
                break;
            }
            case 6: {
                result.append(6);
                result.append(SEPARATOR);
                break;
            }
        }
        ArithmeticOrRelationalOperand arithmRelOprndLeft = relOprn.getLeftOperand();
        result.append(this.encodeArithmeticOrRelationalOperand(arithmRelOprndLeft, qual));
        ArithmeticOrRelationalOperand arithmRelOprndRight = relOprn.getRightOperand();
        result.append(this.encodeArithmeticOrRelationalOperand(arithmRelOprndRight, qual));
        return result.toString();
    }

    private String encodeArithmeticOrRelationalOperand(ArithmeticOrRelationalOperand arithmOrRelOprnd, QualifierInfo qf) throws ARException {
        StringBuilder result = new StringBuilder();
        if (arithmOrRelOprnd == null) {
            return result.toString();
        }
        int operand = arithmOrRelOprnd.getType().toInt();
        switch (operand) {
            default: {
                result.append(operand + SEPARATOR);
                result.append(arithmOrRelOprnd.getValue().toString() + SEPARATOR);
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                result.append(operand + SEPARATOR);
                CurrencyPartInfo currencyInfo = (CurrencyPartInfo)arithmOrRelOprnd.getValue();
                result.append(currencyInfo.getFieldId() + SEPARATOR);
                result.append(currencyInfo.getPartTag() + SEPARATOR);
                if (currencyInfo.getPartTag() != 4) break;
                result.append(currencyInfo.getCurrencyCode() + SEPARATOR);
                break;
            }
            case 2: {
                result.append("2\\");
                Value val = (Value)arithmOrRelOprnd.getValue();
                String encodedVal = this.encodeValue(val);
                result.append(encodedVal);
                break;
            }
            case 3: {
                result.append("3\\");
                ArithmeticOperationInfo aoi = (ArithmeticOperationInfo)arithmOrRelOprnd.getValue();
                String encodedAoi = this.encodeArithmeticOperationInfo(aoi, qf);
                result.append(encodedAoi);
                break;
            }
            case 4: {
                result.append("4\\");
                StatusHistoryValueIndicator statuHist = (StatusHistoryValueIndicator)arithmOrRelOprnd.getValue();
                result.append(statuHist.getEnumValue() + SEPARATOR);
                result.append(statuHist.getType() + SEPARATOR);
                break;
            }
            case 5: {
                result.append("5\\");
                List arrayCur = (List)arithmOrRelOprnd.getValue();
                int nLen = arrayCur.size();
                for (int i = 0; i < nLen; ++i) {
                    Value value = (Value)arrayCur.get(i);
                    result.append(this.encodeValue(value));
                }
                break;
            }
            case 52: {
                result.append("52\\");
                result.append((Integer)arithmOrRelOprnd.getValue() + SEPARATOR);
                break;
            }
            case 53: {
                result.append("53\\");
                QueryInfo queryInfo = (QueryInfo)arithmOrRelOprnd.getValue();
                result.append(queryInfo.getFormID().length() + SEPARATOR);
                result.append(queryInfo.getFormID() + SEPARATOR);
                result.append(queryInfo.getServerName().length() + SEPARATOR);
                result.append(queryInfo.getServerName() + SEPARATOR);
                result.append(queryInfo.getFieldID() + SEPARATOR);
                result.append(queryInfo.getMatchMode() + SEPARATOR);
                result.append(this.encodeQualifierInfo(queryInfo.getQualifierInfo()));
            }
        }
        return result.toString();
    }

    private String encodeArithmeticOperationInfo(ArithmeticOperationInfo aoi, QualifierInfo qf) throws ARException {
        StringBuilder result = new StringBuilder();
        result.append(aoi.getOperation() + SEPARATOR);
        result.append(this.encodeArithmeticOrRelationalOperand(aoi.getLeftOperand(), qf));
        result.append(this.encodeArithmeticOrRelationalOperand(aoi.getRightOperand(), qf));
        return result.toString();
    }

    private String encodeValue(Value obj) throws ARException {
        StringBuilder result = new StringBuilder();
        int dataType = 0;
        int len = 0;
        int dataTypeLoop = obj.getDataType().toInt();
        switch (dataTypeLoop) {
            case 0: {
                dataType = 0;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 1: {
                dataType = 1;
                result.append(dataType + SEPARATOR);
                Keyword kw = (Keyword)obj.getValue();
                result.append(kw.toInt() + SEPARATOR);
                break;
            }
            case 2: {
                if (obj.getDataType().toInt() == 2) {
                    result.append(this.encodeIntegerValue(obj));
                    break;
                }
                if (obj.getDataType().toInt() != 4) break;
                result.append(this.encodeCharValue(obj));
                break;
            }
            case 4: {
                if (obj.getDataType().toInt() == 4) {
                    result.append(this.encodeCharValue(obj));
                    break;
                }
                if (obj.getDataType().toInt() != 2) break;
                result.append(this.encodeIntegerValue(obj));
                break;
            }
            case 5: {
                String diaryVal;
                dataType = 5;
                result.append(dataType + SEPARATOR);
                if (obj.getValue() instanceof DiaryListValue) {
                    DiaryListValue dlv = (DiaryListValue)obj.getValue();
                    diaryVal = dlv.toString();
                } else {
                    diaryVal = obj.getValue().toString();
                }
                result.append(diaryVal.trim() + SEPARATOR);
                break;
            }
            case 6: {
                dataType = 6;
                result.append(dataType + SEPARATOR);
                Number nbe = (Number)obj.getValue();
                result.append(nbe.intValue() + SEPARATOR);
                break;
            }
            case 7: {
                dataType = 7;
                result.append(dataType + SEPARATOR);
                Timestamp tme = (Timestamp)obj.getValue();
                result.append(tme.getValue() + SEPARATOR);
                break;
            }
            case 8: {
                dataType = 8;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 9: {
                dataType = 9;
                result.append(dataType + SEPARATOR);
                ByteListValue blv = (ByteListValue)obj.getValue();
                result.append(blv.getValue() + SEPARATOR);
                break;
            }
            case 3: 
            case 10: {
                dataType = 10;
                result.append(dataType + SEPARATOR);
                len = obj.getValue().toString().trim().length();
                result.append(len + SEPARATOR);
                result.append(obj.getValue().toString() + SEPARATOR);
                break;
            }
            case 11: {
                dataType = 11;
                result.append(dataType + SEPARATOR);
                AttachmentValue atvl = (AttachmentValue)obj.getValue();
                result.append(atvl.getValue() + SEPARATOR);
                break;
            }
            case 12: {
                result.append(this.encodeCurrencyValue(obj));
                break;
            }
            case 13: {
                dataType = 13;
                result.append(dataType + SEPARATOR);
                DateInfo dti = (DateInfo)obj.getValue();
                result.append(dti.getValue() + SEPARATOR);
                break;
            }
            case 14: {
                if (obj.getValue() instanceof Time) {
                    Time tm = (Time)obj.getValue();
                    dataType = 14;
                    result.append(dataType + SEPARATOR);
                    result.append(tm.getValue() + SEPARATOR);
                    break;
                }
                dataType = 4;
                result.append(dataType + SEPARATOR);
                result.append(obj.getValue().toString().length() + SEPARATOR);
                result.append(obj.getValue() + SEPARATOR);
                break;
            }
            case 30: {
                dataType = 30;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 31: {
                dataType = 31;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 32: {
                dataType = 32;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 33: {
                dataType = 33;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 34: {
                dataType = 34;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 35: {
                dataType = 35;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 36: {
                dataType = 36;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 37: {
                dataType = 37;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 40: {
                dataType = 40;
                result.append(dataType + SEPARATOR);
                Long lg = (Long)obj.getValue();
                result.append(lg + SEPARATOR);
                break;
            }
            case 41: {
                dataType = 41;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 42: {
                dataType = 42;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 43: {
                dataType = 43;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 100: {
                dataType = 100;
                result.append(dataType + SEPARATOR);
                break;
            }
        }
        return result.toString();
    }

    private String encodeIntegerValue(Value obj) {
        StringBuilder sbVal = new StringBuilder();
        int dataType = 2;
        sbVal.append(dataType + SEPARATOR);
        Number nb = (Number)obj.getValue();
        sbVal.append(nb.intValue() + SEPARATOR);
        return sbVal.toString();
    }

    private String encodeCharValue(Value obj) throws ARException {
        StringBuilder sbVal = new StringBuilder();
        int dataType = 4;
        sbVal.append(dataType + SEPARATOR);
        int len = 0;
        try {
            len = obj.getValue().toString().getBytes(this._serverCharSet).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ARException(2, 9061, e.getLocalizedMessage());
        }
        sbVal.append(len + SEPARATOR);
        sbVal.append(obj.getValue().toString() + SEPARATOR);
        return sbVal.toString();
    }

    private String encodeCurrencyValue(Value obj) {
        StringBuilder sbVal = new StringBuilder();
        int dType = obj.getDataType().toInt();
        switch (dType) {
            case 12: {
                int dataType = 12;
                CurrencyValue cv = (CurrencyValue)obj.getValue();
                String valString = cv.getValueString();
                if (valString != null) {
                    sbVal.append(valString.length()).append(SEPARATOR);
                    sbVal.append(valString).append(SEPARATOR);
                } else {
                    sbVal.append(0).append(SEPARATOR);
                    sbVal.append(SEPARATOR);
                }
                if (cv.getCurrencyCode() != null) {
                    sbVal.append(cv.getCurrencyCode().length() + SEPARATOR);
                    sbVal.append(cv.getCurrencyCode() + SEPARATOR);
                } else {
                    sbVal.append("0\\").append(SEPARATOR);
                }
                if (cv.getConversionDate() != null) {
                    sbVal.append(cv.getConversionDate().getValue() + SEPARATOR);
                } else {
                    sbVal.append("0\\");
                }
                if (cv.getFuncCurrencyList() == null || cv.getFuncCurrencyList().isEmpty()) {
                    sbVal.append("0\\");
                    sbVal.append(SEPARATOR);
                } else {
                    List<FuncCurrencyInfo> currInfoList = cv.getFuncCurrencyList();
                    sbVal.append(currInfoList.size()).append(SEPARATOR);
                    for (FuncCurrencyInfo item : currInfoList) {
                        String value = item.getValueString();
                        String code = item.getCurrencyCode();
                        sbVal.append(value == null ? Integer.valueOf(0) : value.length() + SEPARATOR);
                        sbVal.append(value == null ? Integer.valueOf(0) : value + SEPARATOR);
                        sbVal.append(code == null ? Integer.valueOf(0) : code.length() + SEPARATOR);
                        sbVal.append(code == null ? Integer.valueOf(0) : code + SEPARATOR);
                    }
                }
                sbVal.insert(0, sbVal == null ? Integer.valueOf(0) : String.valueOf(sbVal.toString().getBytes().length - 1) + SEPARATOR);
                sbVal.insert(0, dataType + SEPARATOR);
                break;
            }
            case 7: {
                int dataType = 7;
                sbVal.append(dataType + SEPARATOR);
                Timestamp tme = (Timestamp)obj.getValue();
                sbVal.append(tme.getValue() + SEPARATOR);
                break;
            }
            case 2: {
                sbVal.append(this.encodeIntegerValue(obj));
                break;
            }
            case 10: {
                int dataType = 10;
                sbVal.append(dataType + SEPARATOR);
                int len = obj.getValue().toString().trim().length();
                sbVal.append(len + SEPARATOR);
                BigDecimal bd = (BigDecimal)obj.getValue();
                sbVal.append(bd.doubleValue() + SEPARATOR);
            }
        }
        return sbVal.toString();
    }
}

