/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.samples;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.AlertCallbackHandler;
import com.bmc.arsys.api.AlertMessageInfo;
import com.bmc.arsys.api.AlertReceiver;

public class TestAlert
implements AlertCallbackHandler {
    int alertReceived = 0;

    @Override
    public void onAlertRecieved(AlertMessageInfo alertMsg) {
        System.out.println(" Received alert message from server: " + alertMsg.getServerAddr());
        System.out.println(" AlertText : " + alertMsg.getAlertText());
        ++this.alertReceived;
    }

    public static void main(String[] args) {
        ARServerUser server1 = new ARServerUser("testuser", "", "", "server1");
        ARServerUser server2 = new ARServerUser("testuser", "", "", "server2");
        boolean rcv1 = false;
        boolean rcv2 = false;
        try {
            TestAlert callback = new TestAlert();
            AlertReceiver receiver = new AlertReceiver(callback, 4343);
            try {
                rcv1 = receiver.beginReceive(server1);
            }
            catch (ARException e) {
                rcv1 = false;
                e.printStackTrace();
            }
            try {
                rcv2 = receiver.beginReceive(server2);
            }
            catch (ARException e) {
                rcv2 = false;
                e.printStackTrace();
            }
            if (rcv1 || rcv2) {
                System.out.println("Waiting to receive alerts from Server1 " + rcv1 + " and Server2 " + rcv2);
                while (callback.alertReceived < 2) {
                    Thread.sleep(10000L);
                }
                System.out.println("Stopped receiving alerts from Server1 " + rcv1 + " and Server2 " + rcv2);
                if (rcv1) {
                    receiver.stopReceive(server1);
                }
                if (rcv2) {
                    receiver.stopReceive(server2);
                }
            }
            receiver.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

